/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards.exports;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJJarManifestWizardPage;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJJarOptionsPage;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackageData;
import org.eclipse.ajdt.internal.ui.wizards.exports.AJJarPackageWizardPage;
import org.eclipse.ajdt.internal.ui.wizards.exports.IJarPackageWizardPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.ProblemDialog;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class AJJarPackageWizard
extends Wizard
implements IExportWizard {
    private static String DIALOG_SETTINGS_KEY = "JarPackageWizard";
    private IStructuredSelection fSelection;
    private AJJarPackageData fJarPackage;
    private AJJarPackageWizardPage fJarPackageWizardPage;
    private boolean fHasNewDialogSettings;
    private boolean fInitializeFromJarPackage;

    public AJJarPackageWizard() {
        IDialogSettings workbenchSettings = JavaPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fHasNewDialogSettings = true;
        } else {
            this.fHasNewDialogSettings = false;
            this.setDialogSettings(section);
        }
    }

    public void addPages() {
        super.addPages();
        this.fJarPackageWizardPage = new AJJarPackageWizardPage(this.fJarPackage, this.fSelection);
        this.addPage(this.fJarPackageWizardPage);
        this.addPage(new AJJarOptionsPage(this.fJarPackage));
        this.addPage(new AJJarManifestWizardPage(this.fJarPackage));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = this.getValidSelection();
        this.fJarPackage = new AJJarPackageData();
        this.setInitializeFromJarPackage(false);
        this.setWindowTitle(JarPackagerMessages.getString((String)"JarPackageWizard.windowTitle"));
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_JAR_PACKAGER);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        this.fJarPackage.setElements(this.fJarPackageWizardPage.getSelectedElementsWithoutContainedChildren());
        if (!this.executeExportOperation(this.fJarPackage.createJarExportRunnable(this.getShell()))) {
            return false;
        }
        if (this.fHasNewDialogSettings) {
            IDialogSettings workbenchSettings = JavaPlugin.getDefault().getDialogSettings();
            IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < this.getPageCount()) {
            IWizardPage page = pages[i];
            if (page instanceof IJarPackageWizardPage) {
                ((IJarPackageWizardPage)page).finish();
            }
            ++i;
        }
        return true;
    }

    protected boolean executeExportOperation(IJarExportRunnable op) {
        block4: {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() == null) break block4;
                ExceptionHandler.handle((InvocationTargetException)ex, (Shell)this.getShell(), (String)JarPackagerMessages.getString((String)"JarPackageWizard.jarExportError.title"), (String)JarPackagerMessages.getString((String)"JarPackageWizard.jarExportError.message"));
                return false;
            }
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ProblemDialog.open((Shell)this.getShell(), (String)JarPackagerMessages.getString((String)"JarPackageWizard.jarExport.title"), null, (IStatus)status);
            return !status.matches(4);
        }
        return true;
    }

    protected IStructuredSelection getValidSelection() {
        ISelection currentSelection = JavaPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)currentSelection;
            ArrayList selectedElements = new ArrayList(structuredSelection.size());
            Iterator iter = structuredSelection.iterator();
            while (iter.hasNext()) {
                Object selectedElement = iter.next();
                if (selectedElement instanceof IProject) {
                    this.addProject(selectedElements, (IProject)selectedElement);
                    continue;
                }
                if (selectedElement instanceof IResource) {
                    this.addResource(selectedElements, (IResource)selectedElement);
                    continue;
                }
                if (!(selectedElement instanceof IJavaElement)) continue;
                this.addJavaElement(selectedElements, (IJavaElement)selectedElement);
            }
            return new StructuredSelection(selectedElements);
        }
        return StructuredSelection.EMPTY;
    }

    private void addResource(List selectedElements, IResource resource) {
        IJavaElement je = JavaCore.create((IResource)resource);
        if (je != null && je.exists() && je.getElementType() == 5) {
            selectedElements.add(je);
        } else {
            selectedElements.add(resource);
        }
    }

    private void addProject(List selectedElements, IProject project) {
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                selectedElements.add(JavaCore.create((IProject)project));
            }
        }
        catch (CoreException coreException) {}
    }

    private void addJavaElement(List selectedElements, IJavaElement je) {
        if (je.getElementType() == 5) {
            selectedElements.add(je);
        } else if (je.getElementType() == 6) {
            selectedElements.add(je);
        } else if (je.getElementType() == 2) {
            selectedElements.add(je);
        } else if (je.getElementType() == 4) {
            if (!JavaModelUtil.getPackageFragmentRoot((IJavaElement)je).isArchive()) {
                selectedElements.add(je);
            }
        } else if (je.getElementType() == 3) {
            if (!((IPackageFragmentRoot)je).isArchive()) {
                selectedElements.add(je);
            }
        } else {
            IOpenable openable = je.getOpenable();
            if (openable instanceof ICompilationUnit) {
                selectedElements.add(JavaModelUtil.toOriginal((ICompilationUnit)((ICompilationUnit)openable)));
            } else if (openable instanceof IClassFile && !JavaModelUtil.getPackageFragmentRoot((IJavaElement)je).isArchive()) {
                selectedElements.add(openable);
            }
        }
    }

    boolean isInitializingFromJarPackage() {
        return this.fInitializeFromJarPackage;
    }

    void setInitializeFromJarPackage(boolean state) {
        this.fInitializeFromJarPackage = state;
    }
}

