/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.javamodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.javamodel.FileFilter;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

public class AJCompilationUnitManager {
    public static final AJCompilationUnitManager INSTANCE = new AJCompilationUnitManager();
    private HashMap compilationUnitStore = new HashMap();

    public AJCompilationUnit getAJCompilationUnit(IFile file) {
        AJCompilationUnit unit = this.getAJCompilationUnitFromCache(file);
        if (unit != null) {
            return unit;
        }
        if (this.creatingCUisAllowedFor(file)) {
            unit = this.createCU(file);
        }
        return unit;
    }

    public AJCompilationUnit getAJCompilationUnitFromCache(IFile file) {
        return (AJCompilationUnit)this.compilationUnitStore.get(file);
    }

    public boolean ensureUnitIsInModel(AJCompilationUnit unit) throws JavaModelException {
        OpenableElementInfo info = (OpenableElementInfo)((JavaElement)unit.getParent()).getElementInfo();
        IJavaElement[] elems = info.getChildren();
        int i = 0;
        while (i < elems.length) {
            IJavaElement element = elems[i];
            if (element == unit) {
                return true;
            }
            ++i;
        }
        info.addChild((IJavaElement)unit);
        return false;
    }

    void removeFileFromModel(IFile file) {
        AJCompilationUnit unit = (AJCompilationUnit)this.compilationUnitStore.get(file);
        if (unit != null) {
            IEditorPart part;
            IWorkbenchPage page = JavaPlugin.getActivePage();
            if (page != null && (part = page.findEditor((IEditorInput)new FileEditorInput(file))) != null && !page.closeEditor(part, true)) {
                return;
            }
            try {
                OpenableElementInfo info = (OpenableElementInfo)((JavaElement)unit.getParent()).getElementInfo();
                info.removeChild((IJavaElement)unit);
                JavaModelManager.getJavaModelManager().removeInfoAndChildren((JavaElement)unit);
            }
            catch (JavaModelException e) {
                AspectJUIPlugin.logException(e);
            }
            this.compilationUnitStore.remove(file);
        }
    }

    private AJCompilationUnit createCU(IFile file) {
        AJCompilationUnit unit = new AJCompilationUnit(file);
        try {
            OpenableElementInfo info = (OpenableElementInfo)((JavaElement)unit.getParent()).getElementInfo();
            info.addChild((IJavaElement)unit);
            this.compilationUnitStore.put(file, unit);
        }
        catch (JavaModelException e) {
            AspectJUIPlugin.logException(e);
        }
        return unit;
    }

    private boolean creatingCUisAllowedFor(IFile file) {
        return ProjectProperties.ASPECTJ_SOURCE_ONLY_FILTER.accept(file.getName()) && BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(file.getProject()) != null && JavaCore.create((IProject)file.getProject()).isOnClasspath((IResource)file);
    }

    public void initCompilationUnits(IProject project) {
        ArrayList l = new ArrayList(30);
        this.addProjectToList(project, l);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            IFile ajfile = (IFile)iter.next();
            this.createCU(ajfile);
        }
    }

    public void removeCUsfromJavaModel(IProject project) {
        ArrayList l = new ArrayList(30);
        this.addProjectToList(project, l);
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            this.removeFileFromModel((IFile)iter.next());
        }
    }

    public void initCompilationUnits(IWorkspace workspace) {
        FileFilter.checkIfFileFilterEnabled();
        ArrayList l = new ArrayList(20);
        IProject[] projects = workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            this.addProjectToList(project, l);
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                IFile f = (IFile)iter.next();
                this.createCU(f);
            }
            l.clear();
            ++i;
        }
    }

    private void addProjectToList(IProject project, List l) {
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(project);
        if (pbc != null) {
            try {
                IJavaProject jp = JavaCore.create((IProject)project);
                IClasspathEntry[] cpes = jp.getRawClasspath();
                int i = 0;
                while (i < cpes.length) {
                    IClasspathEntry entry = cpes[i];
                    if (entry.getEntryKind() == 3) {
                        IPath p = entry.getPath();
                        if (p.segmentCount() == 1) {
                            this.addAllAJFilesInFolder((IContainer)project, l);
                        } else {
                            this.addAllAJFilesInFolder((IContainer)project.getFolder(p.removeFirstSegments(1)), l);
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                AspectJUIPlugin.logException(e);
            }
        }
    }

    private void addAllAJFilesInFolder(IContainer folder, List l) {
        if (folder == null || !folder.exists()) {
            return;
        }
        try {
            IResource[] children = folder.members();
            int i = 0;
            while (i < children.length) {
                IResource resource = children[i];
                if (resource.getType() == 2) {
                    this.addAllAJFilesInFolder((IContainer)((IFolder)resource), l);
                } else if (resource.getType() == 1 && ProjectProperties.ASPECTJ_SOURCE_ONLY_FILTER.accept(resource.getName())) {
                    l.add(resource);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            AspectJUIPlugin.logException(e);
        }
    }
}

