/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.javamodel;

import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.javamodel.AJCompilationUnitManager;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileFilter
extends ViewerFilter {
    public static final String ID = "org.eclipse.ajdt.javamodel.FileFilter";
    public static final String FILTER_DIALOG_ID = "DontInformUserAboutFileFilter";

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        AJCompilationUnit unit;
        if (element instanceof IFile && (unit = AJCompilationUnitManager.INSTANCE.getAJCompilationUnitFromCache((IFile)element)) != null) {
            try {
                if (!AJCompilationUnitManager.INSTANCE.ensureUnitIsInModel(unit)) {
                    AJDTUtils.refreshPackageExplorer();
                }
                return false;
            }
            catch (JavaModelException javaModelException) {}
        }
        return true;
    }

    public static void checkIfFileFilterEnabled() {
        IPreferenceStore store;
        IPreferenceStore javaStore = JavaPlugin.getDefault().getPreferenceStore();
        if (!(!FileFilter.isRelevant(javaStore) || javaStore.contains(ID) && javaStore.getBoolean(ID) || (store = AspectJUIPlugin.getDefault().getPreferenceStore()).contains(FILTER_DIALOG_ID) && store.getBoolean(FILTER_DIALOG_ID))) {
            Job job = new Job(AspectJUIPlugin.getResourceString("FileFilterDialog.JobTitle")){

                public IStatus run(IProgressMonitor m) {
                    Display display = AspectJUIPlugin.getDefault().getDisplay();
                    Runnable myRun = new Runnable(this, display, store){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ Display val$display;
                        private final /* synthetic */ IPreferenceStore val$store;
                        {
                            this.this$1 = var1_1;
                            this.val$display = display;
                            this.val$store = iPreferenceStore;
                        }

                        public void run() {
                            MessageDialogWithToggle md = MessageDialogWithToggle.openInformation((Shell)this.val$display.getActiveShell(), (String)AspectJUIPlugin.getResourceString("FileFilterDialog.Title"), (String)AspectJUIPlugin.getResourceString("FileFilterDialog.Message"), (String)AspectJUIPlugin.getResourceString("FileFilterDialog.CheckboxCaption"), (boolean)true, null, null);
                            this.val$store.setValue("DontInformUserAboutFileFilter", md.getToggleState());
                        }
                    };
                    display.asyncExec(myRun);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(50);
            job.setRule(null);
            job.schedule();
        }
    }

    private static boolean isRelevant(IPreferenceStore javaStore) {
        return javaStore.contains("CustomFiltersActionGroup.org.eclipse.jdt.ui.PackageExplorer.TAG_DUMMY_TO_TEST_EXISTENCE");
    }
}

