/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.asm.IProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.jdtimpl.JDTMember;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;

public class AJDTVisualiserUtils {
    private static IProject project;

    public static List getMarkupInfo(IMember member, IProject project, boolean showErrors, boolean showWarnings) {
        AJDTVisualiserUtils.project = project;
        LinkedList<Map> returningList = new LinkedList<Map>();
        List packages = StructureModelUtil.getPackagesInModel();
        String parent = member.getContainingGroup().getFullname();
        boolean defaultPackage = parent.startsWith("(default");
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            Object[] o = (Object[])it.next();
            if (!parent.equals(o[1]) && (!defaultPackage || !o[1].equals("<default>"))) continue;
            IProgramElement packageNode = (IProgramElement)o[0];
            List files = StructureModelUtil.getFilesInPackage(packageNode);
            Iterator it2 = files.iterator();
            while (it2.hasNext()) {
                IProgramElement file = (IProgramElement)it2.next();
                ISourceLocation isl = file.getSourceLocation();
                String testpath = isl.getSourceFile().getAbsolutePath();
                if (testpath.endsWith(".java")) {
                    testpath = testpath.substring(0, testpath.length() - 5);
                } else if (testpath.endsWith(".aj")) {
                    testpath = testpath.substring(0, testpath.length() - 3);
                }
                if (!testpath.endsWith(String.valueOf(File.separator) + member.getName())) continue;
                try {
                    String fullpath = isl.getSourceFile().getAbsolutePath();
                    Map lineAdviceMap = StructureModelUtil.getLinesToAspectMap(fullpath);
                    Map map = AJDTVisualiserUtils.changeMap(lineAdviceMap, 0);
                    map = AJDTVisualiserUtils.addErrorsAndWarnings(map, member, showErrors, showWarnings);
                    returningList.add(map);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        return returningList;
    }

    private static Map addErrorsAndWarnings(Map map, IMember member, boolean showErrors, boolean showWarnings) {
        IJavaElement jEl;
        if ((showErrors || showWarnings) && member instanceof JDTMember && (jEl = ((JDTMember)member).getResource()) != null) {
            try {
                IResource res = jEl.getUnderlyingResource();
                IMarker[] ajdtProblems = res.findMarkers("org.eclipse.ajdt.ui.problemmarker", true, 1);
                int i = 0;
                while (i < ajdtProblems.length) {
                    List<String> kinds;
                    Integer lineNumber;
                    String aspectName;
                    Integer severity = (Integer)ajdtProblems[i].getAttribute("severity");
                    if (severity != null && severity == 2 && showErrors) {
                        aspectName = AJDTVisualiserUtils.getDeclaringAspect(ajdtProblems[i]);
                        lineNumber = (Integer)ajdtProblems[i].getAttribute("lineNumber");
                        kinds = (ArrayList<String>)map.get(lineNumber);
                        if (kinds != null) {
                            kinds.add("AspectJ Error:::" + aspectName);
                        } else {
                            kinds = new ArrayList<String>();
                            kinds.add("AspectJ Error:::" + aspectName);
                            map.put(lineNumber, kinds);
                        }
                    } else if (severity != null && severity == 1 && showWarnings) {
                        aspectName = AJDTVisualiserUtils.getDeclaringAspect(ajdtProblems[i]);
                        lineNumber = (Integer)ajdtProblems[i].getAttribute("lineNumber");
                        kinds = (List)map.get(lineNumber);
                        if (kinds != null) {
                            kinds.add("AspectJ Warning:::" + aspectName);
                        } else {
                            kinds = new ArrayList();
                            kinds.add("AspectJ Warning:::" + aspectName);
                            map.put(lineNumber, kinds);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException cEx) {
                AJDTEventTrace.generalEvent("Exception finding errors and warnings: " + cEx.getMessage());
            }
        }
        return map;
    }

    private static String getDeclaringAspect(IMarker marker) throws CoreException {
        String[] parts;
        String aspectName = "";
        String relatedLoc = (String)marker.getAttribute("relatedLocations-0");
        if (relatedLoc != null && (parts = relatedLoc.split(":::")).length > 0) {
            aspectName = parts[0];
            if (aspectName.endsWith(".java")) {
                aspectName = aspectName.substring(0, aspectName.length() - 5);
            } else if (aspectName.endsWith(".aj")) {
                aspectName = aspectName.substring(0, aspectName.length() - 3);
            }
            int lastSeparator = aspectName.lastIndexOf(File.separator);
            if (lastSeparator != -1) {
                aspectName = aspectName.substring(lastSeparator + File.separator.length(), aspectName.length());
            }
        }
        return aspectName;
    }

    private static Map changeMap(Map oldmap, int startline) {
        HashMap newmap = new HashMap();
        Set keys = oldmap.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Integer line = (Integer)it.next();
            Object o = oldmap.get(line);
            List oldaspects = (List)o;
            LinkedList<String> newaspects = new LinkedList<String>();
            Iterator iterator2 = oldaspects.iterator();
            while (iterator2.hasNext()) {
                IProgramElement theaspect = (IProgramElement)iterator2.next();
                String fullpath = theaspect.getSourceLocation().getSourceFile().getAbsolutePath();
                Path path = new Path(fullpath);
                String aspectname = path.removeFileExtension().lastSegment();
                newaspects.add(aspectname);
            }
            if (newaspects.isEmpty()) continue;
            line = new Integer(line + startline);
            newmap.put(line, newaspects);
        }
        return newmap;
    }

    public static Set getAllAspects(IJavaProject JP, boolean stringRepresentation) {
        project = JP.getProject();
        StructureModelUtil.initialiseAJDE(project);
        List packages = StructureModelUtil.getPackagesInModel();
        HashSet aspects = new HashSet();
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            Object[] progNodes = (Object[])it.next();
            IProgramElement packageNode = (IProgramElement)progNodes[0];
            Set temp = StructureModelUtil.getAspectsAffectingPackage(packageNode);
            aspects.addAll(temp);
        }
        return AJDTVisualiserUtils.changeSet(aspects, stringRepresentation);
    }

    public static List getAllClasses(IPackageFragment pf) {
        IJavaProject JP = pf.getJavaProject();
        project = JP.getProject();
        LinkedList<Object[]> returningClasses = new LinkedList<Object[]>();
        StructureModelUtil.initialiseAJDE(project);
        try {
            ICompilationUnit[] packageFragmentChildren = pf.getCompilationUnits();
            List packages = StructureModelUtil.getPackagesInModel();
            String pf_string = pf.toString();
            boolean defaultPackage = false;
            String test = "";
            if (pf_string.startsWith("<default>")) {
                defaultPackage = true;
            } else {
                int end = pf_string.indexOf("[");
                test = pf.toString().substring(0, end - 1);
                if (test.indexOf("(not open)") != -1) {
                    test = test.substring(0, test.length() - 10).trim();
                }
            }
            Iterator it = packages.iterator();
            while (it.hasNext()) {
                Object[] o = (Object[])it.next();
                if ((!defaultPackage || !o[1].equals("<default>")) && !test.equals(o[1])) continue;
                IProgramElement packageNode = (IProgramElement)o[0];
                List unsortedFiles = StructureModelUtil.getFilesInPackage(packageNode);
                List files = AJDTVisualiserUtils.sortElements(unsortedFiles);
                int j = 0;
                while (j < files.size()) {
                    try {
                        IProgramElement fileNode = (IProgramElement)files.get(j);
                        if (AJDTVisualiserUtils.containsFile(packageFragmentChildren, fileNode)) {
                            ISourceLocation isl = fileNode.getSourceLocation();
                            String fullpath = isl.getSourceFile().getAbsolutePath();
                            Map lineAdviceMap = StructureModelUtil.getLinesToAspectMap(fullpath);
                            Object[] entry = new Object[3];
                            IResource res = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(fullpath, project);
                            int endLine = isl.getEndLine();
                            entry[0] = res;
                            entry[1] = new Integer(endLine);
                            entry[2] = AJDTVisualiserUtils.changeMap(lineAdviceMap, 0);
                            returningClasses.add(entry);
                        }
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
                break;
            }
        }
        catch (JavaModelException jme) {
            AJDTEventTrace.generalEvent("Exception finding files in a package. " + jme.getMessage());
        }
        return returningClasses;
    }

    private static boolean containsFile(ICompilationUnit[] packageFragmentChildren, IProgramElement fileNode) {
        int i = 0;
        while (i < packageFragmentChildren.length) {
            if (packageFragmentChildren[i].getElementName().equals(fileNode.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static List getAllClasses(ICompilationUnit CU) {
        project = CU.getJavaProject().getProject();
        StructureModelUtil.initialiseAJDE(project);
        LinkedList<Object[]> returningClasses = new LinkedList<Object[]>();
        List packages = StructureModelUtil.getPackagesInModel();
        String cu_parent = CU.getParent().toString();
        int end = cu_parent.startsWith("<default>") ? cu_parent.substring(1).indexOf("[") + 1 : cu_parent.indexOf("[");
        String test = cu_parent.substring(0, end - 1);
        if (test.indexOf("(not open)") != -1) {
            test = test.substring(0, test.length() - 10).trim();
        }
        String path = CU.getPath().toString();
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            Object[] o = (Object[])it.next();
            if (!test.equals(o[1])) continue;
            IProgramElement packageNode = (IProgramElement)o[0];
            List files = StructureModelUtil.getFilesInPackage(packageNode);
            Iterator it2 = files.iterator();
            while (it2.hasNext()) {
                IProgramElement file = (IProgramElement)it2.next();
                ISourceLocation isl = file.getSourceLocation();
                String testpath = isl.getSourceFile().getAbsolutePath();
                if (!(testpath = testpath.replace('\\', '/')).endsWith(path)) continue;
                try {
                    String fullpath = isl.getSourceFile().getAbsolutePath();
                    Map lineAdviceMap = StructureModelUtil.getLinesToAspectMap(fullpath);
                    Object[] entry = new Object[3];
                    IResource res = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(fullpath, project);
                    int endLine = isl.getEndLine();
                    entry[0] = res;
                    entry[1] = new Integer(endLine);
                    entry[2] = AJDTVisualiserUtils.changeMap(lineAdviceMap, 0);
                    returningClasses.add(entry);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        return returningClasses;
    }

    private static List sortElements(List oldElements) {
        Object[] temp = oldElements.toArray();
        SortingComparator comparator = new SortingComparator();
        Arrays.sort(temp, comparator);
        List<Object> newResources = Arrays.asList(temp);
        return newResources;
    }

    private static Set changeSet(Set oldset, boolean stringRepresentation) {
        HashSet<String> newset = new HashSet<String>();
        Iterator it = oldset.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            List aspects = (List)obj;
            Iterator iterator2 = aspects.iterator();
            while (iterator2.hasNext()) {
                Object progNodes = iterator2.next();
                IProgramElement progNode = (IProgramElement)progNodes;
                String path = progNode.getSourceLocation().getSourceFile().getAbsolutePath();
                if (stringRepresentation) {
                    newset.add(path);
                    continue;
                }
                IResource resource = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(path, project);
                if (resource == null) {
                    resource = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(path);
                }
                newset.add((String)resource);
            }
        }
        return newset;
    }

    private static class SortingComparator
    implements Comparator {
        SortingComparator() {
        }

        public int compare(Object o1, Object o2) {
            IProgramElement p1 = (IProgramElement)o1;
            IProgramElement p2 = (IProgramElement)o2;
            String name1 = p1.getName();
            String name2 = p2.getName();
            return name1.compareTo(name2);
        }
    }
}

