/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.aspectj.org.eclipse.jdt.internal.compiler.parser;
 
/**
 * IMPORTANT NOTE: These constants are dedicated to the internal Scanner implementation. 
 * It is mirrored in org.aspectj.org.eclipse.jdt.core.compiler public package where it is API. 
 * The mirror implementation is using the backward compatible ITerminalSymbols constant 
 * definitions (stable with 2.0), whereas the internal implementation uses TerminalTokens 
 * which constant values reflect the latest parser generation state.
 */
 
/**
 * Maps each terminal symbol in the java-grammar into a unique integer. 
 * This integer is used to represent the terminal when computing a parsing action. 
 * 
 * Disclaimer : These constant values are generated automatically using a Java 
 * grammar, therefore their actual values are subject to change if new keywords 
 * were added to the language (for instance, 'assert' is a keyword in 1.4).
 */
public interface TerminalTokens {

	// special tokens not part of grammar - not autogenerated
	int 
		TokenNameWHITESPACE = 1000,
		TokenNameCOMMENT_LINE = 1001,
		TokenNameCOMMENT_BLOCK = 1002,
		TokenNameCOMMENT_JAVADOC = 1003;
	
	// AspectJ Extension (generated)
	public final static int
	   TokenNameIdentifier = 24,
	   TokenNameabstract = 63,
	   TokenNameassert = 78,
	   TokenNameboolean = 38,
	   TokenNamebreak = 79,
	   TokenNamebyte = 39,
	   TokenNamecase = 89,
	   TokenNamecatch = 91,
	   TokenNamechar = 40,
	   TokenNameclass = 92,
	   TokenNamecontinue = 80,
	   TokenNamedefault = 99,
	   TokenNamedo = 81,
	   TokenNamedouble = 41,
	   TokenNameelse = 93,
	   TokenNameextends = 95,
	   TokenNamefalse = 52,
	   TokenNamefinal = 64,
	   TokenNamefinally = 94,
	   TokenNamefloat = 42,
	   TokenNamefor = 82,
	   TokenNameif = 83,
	   TokenNameimplements = 96,
	   TokenNameimport = 88,
	   TokenNameinstanceof = 13,
	   TokenNameint = 43,
	   TokenNameinterface = 98,
	   TokenNamelong = 44,
	   TokenNamenative = 65,
	   TokenNamenew = 47,
	   TokenNamenull = 53,
	   TokenNamepackage = 90,
	   TokenNameprivate = 66,
	   TokenNameprotected = 67,
	   TokenNamepublic = 68,
	   TokenNamereturn = 84,
	   TokenNameshort = 45,
	   TokenNamestatic = 62,
	   TokenNamestrictfp = 69,
	   TokenNamesuper = 49,
	   TokenNameswitch = 85,
	   TokenNamesynchronized = 61,
	   TokenNamethis = 50,
	   TokenNamethrow = 86,
	   TokenNamethrows = 97,
	   TokenNametransient = 70,
	   TokenNametrue = 54,
	   TokenNametry = 87,
	   TokenNamevoid = 46,
	   TokenNamevolatile = 71,
	   TokenNamewhile = 77,
	   TokenNameaspect = 30,
	   TokenNamepointcut = 34,
	   TokenNamearound = 37,
	   TokenNamebefore = 35,
	   TokenNameafter = 36,
	   TokenNamedeclare = 31,
	   TokenNameprivileged = 32,
	   TokenNameIntegerLiteral = 55,
	   TokenNameLongLiteral = 56,
	   TokenNameFloatingPointLiteral = 57,
	   TokenNameDoubleLiteral = 58,
	   TokenNameCharacterLiteral = 59,
	   TokenNameStringLiteral = 60,
	   TokenNamePLUS_PLUS = 8,
	   TokenNameMINUS_MINUS = 9,
	   TokenNameEQUAL_EQUAL = 18,
	   TokenNameLESS_EQUAL = 14,
	   TokenNameGREATER_EQUAL = 15,
	   TokenNameNOT_EQUAL = 19,
	   TokenNameLEFT_SHIFT = 12,
	   TokenNameRIGHT_SHIFT = 10,
	   TokenNameUNSIGNED_RIGHT_SHIFT = 11,
	   TokenNamePLUS_EQUAL = 101,
	   TokenNameMINUS_EQUAL = 102,
	   TokenNameMULTIPLY_EQUAL = 103,
	   TokenNameDIVIDE_EQUAL = 104,
	   TokenNameAND_EQUAL = 105,
	   TokenNameOR_EQUAL = 106,
	   TokenNameXOR_EQUAL = 107,
	   TokenNameREMAINDER_EQUAL = 108,
	   TokenNameLEFT_SHIFT_EQUAL = 109,
	   TokenNameRIGHT_SHIFT_EQUAL = 110,
	   TokenNameUNSIGNED_RIGHT_SHIFT_EQUAL = 111,
	   TokenNameOR_OR = 26,
	   TokenNameAND_AND = 27,
	   TokenNamePLUS = 2,
	   TokenNameMINUS = 3,
	   TokenNameNOT = 72,
	   TokenNameREMAINDER = 5,
	   TokenNameXOR = 22,
	   TokenNameAND = 20,
	   TokenNameMULTIPLY = 4,
	   TokenNameOR = 25,
	   TokenNameTWIDDLE = 76,
	   TokenNameDIVIDE = 6,
	   TokenNameGREATER = 16,
	   TokenNameLESS = 17,
	   TokenNameLPAREN = 21,
	   TokenNameRPAREN = 29,
	   TokenNameLBRACE = 74,
	   TokenNameRBRACE = 48,
	   TokenNameLBRACKET = 7,
	   TokenNameRBRACKET = 73,
	   TokenNameSEMICOLON = 23,
	   TokenNameQUESTION = 28,
	   TokenNameCOLON = 51,
	   TokenNameCOMMA = 33,
	   TokenNameDOT = 1,
	   TokenNameEQUAL = 100,
	TokenNameEOF = 75,
	TokenNameERROR = 112;
}
