/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.jdtImpl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.jdtImpl.JDTMember;
import org.eclipse.contribution.visualiser.jdtImpl.JDTSearchResultsContentProvider;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMarkupKind;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMarkupProvider;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.contribution.visualiser.utils.MarkupUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.ui.IPropertyListener;

public class JDTSearchResultsMarkupProvider
extends SimpleMarkupProvider {
    private static Hashtable markupCache = new Hashtable();
    private static boolean isJavaSearch = false;
    private static JavaSearchResult javaSearchResult = null;

    public static void resetCache() {
        markupCache.clear();
    }

    public List getMemberMarkups(IMember member) {
        IJavaProject jp;
        if (javaSearchResult == null) {
            return null;
        }
        List cachedValue = (List)markupCache.get(member);
        if (cachedValue != null) {
            return cachedValue;
        }
        List markupList = super.getMemberMarkups(member);
        if (markupList != null) {
            return markupList;
        }
        ArrayList<Stripe> stripeList = new ArrayList<Stripe>();
        if (ProviderManager.getContentProvider() instanceof JDTSearchResultsContentProvider && (jp = ((JDTSearchResultsContentProvider)ProviderManager.getContentProvider()).getCurrentProject()) != null) {
            List list = this.getMarkupInfo(member);
            if (list == null) {
                return null;
            }
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Integer number = (Integer)iter.next();
                if (javaSearchResult == null) continue;
                Stripe stripe = new Stripe(new SimpleMarkupKind(javaSearchResult.getLabel()), number);
                stripeList.add(stripe);
                this.addMarkup(member.getFullname(), stripe);
            }
        }
        MarkupUtils.processStripes(stripeList);
        markupCache.put(member, stripeList);
        return stripeList;
    }

    private List getMarkupInfo(IMember member) {
        if (javaSearchResult == null) {
            return null;
        }
        ArrayList<Integer> lineNumbers = new ArrayList<Integer>();
        ICompilationUnit cu = null;
        IResource r = null;
        if (member instanceof JDTMember) {
            JDTMember jdtMember = (JDTMember)member;
            IJavaElement je = jdtMember.getResource();
            if (je.getElementType() == 5) {
                cu = (ICompilationUnit)je;
                try {
                    r = cu.getUnderlyingResource();
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        } else {
            return null;
        }
        Object[] elementsWhichMatch = javaSearchResult.getElements();
        int i = 0;
        while (i < elementsWhichMatch.length) {
            IFile file = javaSearchResult.getFile(elementsWhichMatch[i]);
            if (file != null && file.getFullPath().equals((Object)r.getFullPath())) {
                Match[] matches = javaSearchResult.computeContainedMatches((AbstractTextSearchResult)javaSearchResult, file);
                int j = 0;
                while (j < matches.length) {
                    int lineNumber = JDTUtils.getLineNumber(cu, matches[j].getOffset());
                    lineNumbers.add(new Integer(lineNumber));
                    ++j;
                }
            }
            ++i;
        }
        return lineNumbers;
    }

    public SortedSet getAllMarkupKinds() {
        TreeSet<SimpleMarkupKind> kinds = new TreeSet<SimpleMarkupKind>();
        if (ProviderManager.getContentProvider() instanceof JDTSearchResultsContentProvider && javaSearchResult != null) {
            kinds.add(new SimpleMarkupKind(javaSearchResult.getLabel()));
        }
        if (kinds.size() > 0) {
            return kinds;
        }
        return null;
    }

    public boolean processMouseclick(IMember member, Stripe stripe, String exactKind, int buttonClicked) {
        if (buttonClicked == 1) {
            IJavaElement jEl;
            if (member instanceof JDTMember && (jEl = ((JDTMember)member).getResource()) != null) {
                JDTUtils.openInEditor(jEl.getResource(), stripe.getOffset());
            }
            return false;
        }
        return true;
    }

    public boolean isJavaSearch() {
        return isJavaSearch;
    }

    public void setJavaSearch(boolean isJavaSearch) {
        JDTSearchResultsMarkupProvider.isJavaSearch = isJavaSearch;
    }

    public void setJavaSearchResult(JavaSearchResult javaSearchResult) {
        JDTSearchResultsMarkupProvider.javaSearchResult = javaSearchResult;
    }

    static class VisualiserPropertyListener
    implements IPropertyListener {
        VisualiserPropertyListener() {
        }

        public void propertyChanged(Object source, int propId) {
            if (source instanceof SearchView) {
                SearchView searchView = (SearchView)source;
                ISearchResult searchResult = searchView.getCurrentSearchResult();
                if (searchResult instanceof JavaSearchResult) {
                    isJavaSearch = true;
                    if (!((JavaSearchResult)searchResult).equals(javaSearchResult)) {
                        JDTSearchResultsMarkupProvider.resetCache();
                    }
                    JDTSearchResultsMarkupProvider.javaSearchResult = (JavaSearchResult)searchResult;
                } else {
                    isJavaSearch = false;
                    JDTSearchResultsMarkupProvider.javaSearchResult = null;
                }
                VisualiserPlugin.refresh();
            }
        }
    }
}

