/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser.utils;

import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class JDTUtils {
    public static void openInEditor(IResource res, int lineNumber) {
        try {
            IMarker marker = res.createMarker("org.eclipse.core.resources.marker");
            if (lineNumber >= 0) {
                marker.setAttribute("lineNumber", lineNumber);
            }
            JDTUtils.openInEditor(marker);
            marker.delete();
        }
        catch (CoreException coreEx) {
            VisualiserPlugin.logException(coreEx);
        }
    }

    public static void openInEditor(IMarker marker) {
        IWorkbenchPage page = VisualiserPlugin.getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
        }
        catch (PartInitException e) {
            VisualiserPlugin.logException(e);
        }
    }

    public static int getClassDeclLineNum(IJavaElement jElem) {
        if (jElem instanceof ICompilationUnit) {
            try {
                ICompilationUnit cUnit = (ICompilationUnit)jElem;
                cUnit.getSource();
                IType type = cUnit.findPrimaryType();
                if (type != null) {
                    return JDTUtils.getLineNumFromOffset(cUnit, type.getNameRange().getOffset());
                }
            }
            catch (JavaModelException jme) {
                jme.printStackTrace();
            }
        }
        return 0;
    }

    private static int getLineNumFromOffset(ICompilationUnit cUnit, int offSet) {
        try {
            String source = cUnit.getSource();
            IType type = cUnit.findPrimaryType();
            if (type != null) {
                String sourcetodeclaration = source.substring(0, offSet);
                int lines = 0;
                char[] chars = new char[sourcetodeclaration.length()];
                sourcetodeclaration.getChars(0, sourcetodeclaration.length(), chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if (chars[i] == '\n') {
                        ++lines;
                    }
                    ++i;
                }
                return lines + 1;
            }
        }
        catch (JavaModelException jme) {
            jme.printStackTrace();
        }
        return 0;
    }

    public static int getLineNumber(ICompilationUnit cUnit, int offSet) {
        return JDTUtils.getLineNumFromOffset(cUnit, offSet);
    }
}

