/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class Util {
    private static String OS_INDEPENDENT_LINE_SEPARATOR;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;

    static {
        Factory factory = new Factory("Util.java", Class.forName("org.eclipse.ajdt.buildconfigurator.Util"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.Util-java.io.IOException-<missing>-"), 94);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-getPathList-org.eclipse.ajdt.buildconfigurator.Util-java.io.File:-f:--java.util.List-"), 86);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.Util-java.io.IOException-<missing>-"), 168);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getInlinedLstFile-org.eclipse.ajdt.buildconfigurator.Util-org.eclipse.core.runtime.IPath:-lstFile:-java.io.FileNotFoundException:-org.eclipse.core.runtime.IPath-"), 147);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.Util-java.io.IOException-<missing>-"), 229);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-writeInlinedLstFileToBuffer-org.eclipse.ajdt.buildconfigurator.Util-java.io.File:java.io.BufferedWriter:-file:bw:-java.io.FileNotFoundException:-void-"), 195);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.Util-java.io.IOException-<missing>-"), 251);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-lstFileContainsLinks-org.eclipse.ajdt.buildconfigurator.Util-org.eclipse.core.runtime.IPath:-lstFile:-java.io.FileNotFoundException:-boolean-"), 239);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.buildconfigurator.Util-java.io.IOException-<missing>-"), 311);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getLstFileContents-org.eclipse.ajdt.buildconfigurator.Util-org.eclipse.core.runtime.IPath:java.util.List:java.util.List:java.util.List:-file:files:options:links:-java.io.FileNotFoundException:-void-"), 270);
        OS_INDEPENDENT_LINE_SEPARATOR = System.getProperty("line.separator");
    }

    public static String getRelativePathString(IPath file, IPath fromDir) {
        String result = null;
        if (file != null && fromDir != null) {
            if (file.equals((Object)fromDir)) {
                result = ".";
            } else {
                List fromList = Util.getPathList(fromDir.toFile());
                List fileList = Util.getPathList(file.toFile());
                result = Util.matchPathLists(fromList, fileList);
            }
        }
        return result;
    }

    public static String getRelativePathString(String file, String fromDir) {
        String result = null;
        if (file != null && fromDir != null) {
            return Util.getRelativePathString((IPath)new Path(file), (IPath)new Path(fromDir));
        }
        return result;
    }

    private static List getPathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            File r = f.getCanonicalFile();
            while (r != null) {
                l.add(r.getName());
                r = r.getParentFile();
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(iOException2, ajc$tjp_0, ajc$tjp_1);
            l = null;
        }
        return l;
    }

    private static String matchPathLists(List fromList, List toList) {
        String result = "";
        int i = fromList.size() - 1;
        int j = toList.size() - 1;
        while (i >= 0 && j >= 0 && fromList.get(i).equals(toList.get(j))) {
            --i;
            --j;
        }
        while (i >= 0) {
            result = String.valueOf(result) + "../";
            --i;
        }
        while (j >= 1) {
            result = String.valueOf(result) + toList.get(j) + "/";
            --j;
        }
        result = String.valueOf(result) + toList.get(j);
        return result;
    }

    public static IPath getInlinedLstFile(IPath lstFile) throws FileNotFoundException {
        IPath result = lstFile;
        if (lstFile != null) {
            if (!lstFile.toFile().exists()) {
                throw new FileNotFoundException(String.valueOf(lstFile.toOSString()) + " not found!");
            }
            if (Util.lstFileContainsLinks(lstFile)) {
                File resultFile = new File(Util.getInlinedFileName(lstFile.toOSString()));
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(resultFile));
                    Util.writeInlinedLstFileToBuffer(lstFile.toFile(), bw);
                    bw.close();
                    result = new Path(resultFile.getAbsolutePath());
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(iOException2, ajc$tjp_2, ajc$tjp_3);
                }
            }
        }
        return result;
    }

    public static String getInlinedFileName(String originalName) {
        String result = originalName;
        if (originalName != null) {
            String tmp1 = originalName.substring(0, originalName.lastIndexOf(46));
            String tmp2 = originalName.substring(originalName.lastIndexOf(46));
            result = String.valueOf(tmp1) + ".inlined" + tmp2;
        }
        return result;
    }

    private static void writeInlinedLstFileToBuffer(File file, BufferedWriter bw) throws FileNotFoundException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = null;
        try {
            while ((line = in.readLine()) != null) {
                if (!(line = line.trim()).startsWith("@")) {
                    bw.write(line);
                    bw.newLine();
                    continue;
                }
                String linkedFilePath = line.substring(1);
                File linkedFile = new File(linkedFilePath);
                if (linkedFile.isAbsolute()) {
                    if (!linkedFile.exists()) continue;
                    Util.writeInlinedLstFileToBuffer(linkedFile, bw);
                    continue;
                }
                linkedFile = new File(String.valueOf(file.getParentFile().getAbsolutePath()) + "/" + linkedFilePath);
                if (!linkedFile.exists()) continue;
                Util.writeInlinedLstFileToBuffer(linkedFile, bw);
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(iOException2, ajc$tjp_4, ajc$tjp_5);
        }
    }

    private static boolean lstFileContainsLinks(IPath lstFile) throws FileNotFoundException {
        boolean result = false;
        String path = lstFile.toOSString();
        BufferedReader in = new BufferedReader(new FileReader(path));
        String line = null;
        try {
            while ((line = in.readLine()) != null) {
                if (!(line = line.trim()).startsWith("@")) continue;
                result = true;
                break;
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(iOException2, ajc$tjp_6, ajc$tjp_7);
        }
        return result;
    }

    public static void getLstFileContents(IPath file, List files, List options, List links) throws FileNotFoundException {
        if (file != null && files != null && options != null && links != null) {
            String path = file.toOSString();
            BufferedReader in = new BufferedReader(new FileReader(path));
            String line = null;
            try {
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).startsWith("@")) {
                        links.add(line);
                        continue;
                    }
                    if (line.startsWith("-")) {
                        if (AjcOptionsChecker.optionWithArg(line)) {
                            String nextLine = in.readLine();
                            if (nextLine != null) {
                                options.add(String.valueOf(line) + OS_INDEPENDENT_LINE_SEPARATOR + nextLine.trim());
                                continue;
                            }
                            options.add(line);
                            continue;
                        }
                        options.add(line);
                        continue;
                    }
                    if (line.equals("")) continue;
                    files.add(line);
                }
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(iOException2, ajc$tjp_8, ajc$tjp_9);
            }
        }
    }

    static class AjcOptionsChecker {
        private static Set optionsWithArgs;

        static {
            AjcOptionsChecker.initialiseOptionsWithArgs();
        }

        AjcOptionsChecker() {
        }

        public static boolean optionWithArg(String option) {
            boolean result = false;
            if (optionsWithArgs.contains(option)) {
                result = true;
            }
            return result;
        }

        private static void initialiseOptionsWithArgs() {
            optionsWithArgs = new HashSet();
            optionsWithArgs.add("-inpath");
            optionsWithArgs.add("-injars");
            optionsWithArgs.add("-aspectpath");
            optionsWithArgs.add("-outjar");
            optionsWithArgs.add("-argfile");
            optionsWithArgs.add("-sourceroots");
            optionsWithArgs.add("-Xlintfile");
            optionsWithArgs.add("-cp");
            optionsWithArgs.add("-classpath");
            optionsWithArgs.add("-bootclasspath");
            optionsWithArgs.add("-d");
            optionsWithArgs.add("-encoding");
            optionsWithArgs.add("-source");
            optionsWithArgs.add("-target");
            optionsWithArgs.add("-log");
            optionsWithArgs.add("-repeat");
            optionsWithArgs.add("-inpath");
        }
    }
}

