/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.buildconfigurator.editor.model;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.ajdt.buildconfigurator.editor.PropertiesUtil;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildEntry;
import org.eclipse.ajdt.buildconfigurator.editor.model.IBuildModel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.ui.model.IDocumentKey;

public class BuildEntry
implements IBuildEntry,
IDocumentKey {
    private int fLength = -1;
    private int fOffset = -1;
    private IBuildModel fModel;
    private String fName;
    private ArrayList fTokens = new ArrayList();

    public void addToken(String token) throws CoreException {
        this.fTokens.add(token);
        this.getModel().fireModelObjectChanged(this, this.getName(), null, token);
    }

    public void addTokenWithoutNotify(String token) {
        this.fTokens.add(token);
    }

    public String getName() {
        return this.fName;
    }

    public String[] getTokens() {
        return this.fTokens.toArray(new String[this.fTokens.size()]);
    }

    public boolean contains(String token) {
        return this.fTokens.contains(token);
    }

    public void removeToken(String token) throws CoreException {
        this.fTokens.remove(token);
        this.getModel().fireModelObjectChanged(this, this.getName(), token, null);
    }

    public void removeTokenWithoutNotify(String token) {
        this.fTokens.remove(token);
    }

    public void renameToken(String oldToken, String newToken) throws CoreException {
        int index = this.fTokens.indexOf(oldToken);
        if (index != -1) {
            this.fTokens.set(index, newToken);
            this.getModel().fireModelObjectChanged(this, this.getName(), oldToken, newToken);
        }
    }

    public void setName(String name) {
        String oldName = this.fName;
        this.fName = name;
        if (this.getModel() != null) {
            this.getModel().fireModelObjectChanged(this, this.getName(), oldName, name);
        }
    }

    public int getOffset() {
        return this.fOffset;
    }

    public void setOffset(int offset) {
        this.fOffset = offset;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setLength(int length) {
        this.fLength = length;
    }

    public void write(String indent, PrintWriter writer) {
    }

    public void setModel(IBuildModel model) {
        this.fModel = model;
    }

    public IBuildModel getModel() {
        return this.fModel;
    }

    public void processEntry(String value) {
        StringTokenizer stok = new StringTokenizer(value, ",");
        while (stok.hasMoreTokens()) {
            this.fTokens.add(stok.nextToken().trim());
        }
    }

    public String write() {
        return PropertiesUtil.writeKeyValuePair(this.getName(), this.getTokens());
    }
}

