/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.builder.AJProjectModel;
import org.eclipse.ajdt.internal.builder.AJRelationship;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;

public class AJModel {
    private static AJModel instance;
    private IProject beingBuilt = null;
    private Map projectModelMap = new HashMap();
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;

    private AJModel() {
    }

    public static AJModel getInstance() {
        if (instance == null) {
            instance = new AJModel();
        }
        return instance;
    }

    private AJProjectModel getModelForProject(IProject project) {
        AJProjectModel pm = (AJProjectModel)this.projectModelMap.get(project);
        if (pm == null) {
            AJDTEventTrace.generalEvent("No current AJ model for project " + project.getName());
            StructureModelUtil.initialiseAJDE(project);
            this.createMap(project);
            pm = (AJProjectModel)this.projectModelMap.get(project);
        }
        return pm;
    }

    public List getRelatedElements(AJRelationship rel, IJavaElement je) {
        if (je == null) {
            return null;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return null;
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return null;
        }
        return pm.getRelatedElements(rel, je);
    }

    public boolean isAdvised(IJavaElement je) {
        if (je == null) {
            return false;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return false;
        }
        IProject project = jp.getProject();
        if (project == null) {
            return false;
        }
        if (!project.isAccessible()) {
            return false;
        }
        AJProjectModel pm = this.getModelForProject(project);
        if (pm == null) {
            return false;
        }
        return pm.isAdvised(je);
    }

    public IJavaElement[] getExtraChildren(IJavaElement je) {
        if (je == null) {
            return null;
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return null;
        }
        IProject project = jp.getProject();
        if (project == null) {
            return null;
        }
        if (!project.isAccessible()) {
            return null;
        }
        AJProjectModel pm = this.getModelForProject(project);
        if (pm == null) {
            return null;
        }
        return pm.getExtraChildren(je);
    }

    public void createMap(final IProject project) {
        final long start = System.currentTimeMillis();
        final AJProjectModel projectModel = new AJProjectModel(project);
        this.projectModelMap.put(project, projectModel);
        try {
            AspectJUIPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) {
                    projectModel.createProjectMap();
                    long elapsed = System.currentTimeMillis() - start;
                    AJDTEventTrace.generalEvent("Created AJ model for project " + project.getName() + " in " + elapsed + "ms");
                }
            }, null);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public void clearMap(IProject project) {
        this.projectModelMap.remove(project);
    }

    public void aboutToBuild(IProject project) {
        this.beingBuilt = project;
    }

    public String getJavaElementLinkName(IJavaElement je) {
        if (je == null) {
            return "";
        }
        IJavaProject jp = je.getJavaProject();
        if (jp == null) {
            return je.getElementName();
        }
        AJProjectModel pm = this.getModelForProject(jp.getProject());
        if (pm == null) {
            return je.getElementName();
        }
        return pm.getJavaElementLinkName(je);
    }

    public IJavaElement getCorrespondingJavaElement(IProgramElement ipe) {
        IResource res = this.programElementToResource(ipe);
        if (res != null && res instanceof IFile) {
            IFile file = (IFile)res;
            System.out.println("ipe=" + ipe + " (" + ipe.hashCode() + ")");
            System.out.println("project=" + file.getProject());
            AJProjectModel pm = this.getModelForProject(file.getProject());
            if (pm == null) {
                return null;
            }
            return pm.getCorrespondingJavaElement(ipe);
        }
        return null;
    }

    private IResource programElementToResource(IProgramElement ipe) {
        try {
            String fileString = ipe.getSourceLocation().getSourceFile().getCanonicalPath();
            IProject[] projects = AspectJUIPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                try {
                    String root;
                    if (projects[i].isOpen() && projects[i].hasNature("org.eclipse.ajdt.ui.ajnature") && fileString.startsWith(root = AJDTUtils.getProjectRootDirectory(projects[i]))) {
                        String path = fileString.substring(root.length());
                        Path ipath = new Path(path);
                        IResource res = projects[i].findMember((IPath)ipath);
                        return res;
                    }
                }
                catch (CoreException coreException) {
                    CoreException coreException2 = coreException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_2, ajc$tjp_3);
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException2, this, ajc$tjp_4, ajc$tjp_3);
        }
        return null;
    }

    static {
        Factory factory = new Factory("AJModel.java", Class.forName("org.eclipse.ajdt.internal.builder.AJModel"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.AJModel-org.eclipse.core.runtime.CoreException-<missing>-"), 187);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-createMap-org.eclipse.ajdt.internal.builder.AJModel-org.eclipse.core.resources.IProject:-project:--void-"), 175);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.AJModel-org.eclipse.core.runtime.CoreException-<missing>-"), 312);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-programElementToResource-org.eclipse.ajdt.internal.builder.AJModel-org.aspectj.asm.IProgramElement:-ipe:--org.eclipse.core.resources.IResource-"), 289);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.AJModel-java.io.IOException-<missing>-"), 315);
    }
}

