/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.asm.internal.Relationship;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.AJCodeElement;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.internal.builder.AJRelationship;
import org.eclipse.ajdt.internal.builder.AJRelationshipManager;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.javamodel.AJCompilationUnitManager;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;

public class AJProjectModel {
    IProject project;
    private Map ipeToije = new HashMap();
    private Map jeLinkNames = new HashMap();
    private Map perRelMap = new HashMap();
    private Map kindMap = new HashMap();
    private Map extraChildren = new HashMap();
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;

    public AJProjectModel(IProject project) {
        this.project = project;
        this.kindMap.put("advises", AJRelationshipManager.ADVISES);
        this.kindMap.put("advised by", AJRelationshipManager.ADVISED_BY);
        this.kindMap.put("declared on", AJRelationshipManager.DECLARED_ON);
        this.kindMap.put("aspect declarations", AJRelationshipManager.ASPECT_DECLARATIONS);
        this.kindMap.put("matched by", AJRelationshipManager.MATCHED_BY);
        this.kindMap.put("matches declare", AJRelationshipManager.MATCHES_DECLARE);
    }

    public IJavaElement getCorrespondingJavaElement(IProgramElement ipe) {
        return (IJavaElement)this.ipeToije.get(ipe);
    }

    public List getRelatedElements(AJRelationship rel, IJavaElement je) {
        Map relMap = (Map)this.perRelMap.get(rel);
        if (relMap == null) {
            return null;
        }
        return (List)relMap.get(je);
    }

    public boolean isAdvised(IJavaElement je) {
        if (je.getElementType() == 9) {
            List advisedBy = this.getRelatedElements(AJRelationshipManager.ADVISED_BY, je);
            if (advisedBy != null && advisedBy.size() > 0) {
                return true;
            }
            IJavaElement[] extras = this.getExtraChildren(je);
            if (extras != null) {
                int i = 0;
                while (i < extras.length) {
                    advisedBy = this.getRelatedElements(AJRelationshipManager.ADVISED_BY, extras[i]);
                    if (advisedBy != null && advisedBy.size() > 0) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public String getJavaElementLinkName(IJavaElement je) {
        return (String)this.jeLinkNames.get(je);
    }

    public IJavaElement[] getExtraChildren(IJavaElement je) {
        List l = (List)this.extraChildren.get(je);
        if (l == null) {
            return null;
        }
        return l.toArray(new IJavaElement[0]);
    }

    public void createProjectMap() {
        try {
            this.project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) {
                    if (resource instanceof IFolder) {
                        return true;
                    }
                    if (resource instanceof IFile) {
                        IFile f = (IFile)resource;
                        if (ProjectProperties.ASPECTJ_SOURCE_FILTER.accept(f.getName())) {
                            AJProjectModel.this.createMapForFile(f);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
        }
        this.processRelationships();
    }

    private void processRelationships() {
        IRelationshipMap asmRelMap = AsmManager.getDefault().getRelationshipMap();
        Iterator iter = asmRelMap.getEntries().iterator();
        while (iter.hasNext()) {
            String sourceOfRelationship = (String)iter.next();
            IProgramElement ipe = AsmManager.getDefault().getHierarchy().findElementForHandle(sourceOfRelationship);
            List relationships = asmRelMap.get(ipe);
            if (relationships == null) continue;
            Iterator iterator = relationships.iterator();
            while (iterator.hasNext()) {
                Relationship rel = (Relationship)iterator.next();
                List targets = rel.getTargets();
                Iterator iterator2 = targets.iterator();
                while (iterator2.hasNext()) {
                    ArrayList<IJavaElement> l;
                    String t = (String)iterator2.next();
                    IProgramElement link = AsmManager.getDefault().getHierarchy().findElementForHandle(t);
                    IJavaElement sourceEl = (IJavaElement)this.ipeToije.get(ipe);
                    IJavaElement targetEl = (IJavaElement)this.ipeToije.get(link);
                    AJRelationship ajRel = (AJRelationship)this.kindMap.get(rel.getName());
                    if (ajRel == null || sourceEl == null || targetEl == null) continue;
                    HashMap relMap = (HashMap)this.perRelMap.get(ajRel);
                    if (relMap == null) {
                        relMap = new HashMap();
                        this.perRelMap.put(ajRel, relMap);
                    }
                    if ((l = (ArrayList<IJavaElement>)relMap.get(sourceEl)) == null) {
                        l = new ArrayList<IJavaElement>();
                        relMap.put(sourceEl, l);
                    }
                    if (l.contains(targetEl)) continue;
                    l.add(targetEl);
                }
            }
        }
    }

    private void createMapForFile(IFile file) {
        IProject project = file.getProject();
        try {
            if (project == null || !project.isOpen() || !project.hasNature("org.eclipse.ajdt.ui.ajnature")) {
                return;
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_2, ajc$tjp_3);
        }
        String path = file.getRawLocation().toOSString();
        HashMap annotationsMap = AsmManager.getDefault().getInlineAnnotations(path, true, true);
        if (annotationsMap == null) {
            return;
        }
        AJCompilationUnit unit = AJCompilationUnitManager.INSTANCE.getAJCompilationUnit(file);
        if (unit == null && file.getName().endsWith(".java")) {
            unit = JavaCore.createCompilationUnitFrom((IFile)file);
        }
        if (unit == null) {
            return;
        }
        Set keys = annotationsMap.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            List annotations = (List)annotationsMap.get(key);
            Iterator it2 = annotations.iterator();
            while (it2.hasNext()) {
                IProgramElement node = (IProgramElement)it2.next();
                ISourceLocation sl = node.getSourceLocation();
                int fff = 0;
                if (node.toLinkLabelString().indexOf("declare parents") >= 0) {
                    fff = 10;
                }
                if (node.toLinkLabelString().indexOf("declare warning") >= 0) {
                    fff = 10;
                }
                boolean subElement = false;
                int offset = sl.getOffset();
                if (offset == 0) {
                    subElement = true;
                    offset = node.getParent().getSourceLocation().getOffset();
                }
                try {
                    IJavaElement el = unit.getElementAt(offset + fff);
                    if (subElement) {
                        IJavaElement parent = el;
                        el = new AJCodeElement((JavaElement)parent, sl.getLine(), node.toLabelString());
                        ArrayList<IJavaElement> l = (ArrayList<IJavaElement>)this.extraChildren.get(parent);
                        if (l == null) {
                            l = new ArrayList<IJavaElement>();
                            this.extraChildren.put(parent, l);
                        }
                        l.add(el);
                    }
                    if (el == null) continue;
                    this.ipeToije.put(node, el);
                    this.jeLinkNames.put(el, node.toLinkLabelString());
                }
                catch (JavaModelException javaModelException) {
                    JavaModelException javaModelException2 = javaModelException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_4, ajc$tjp_3);
                }
            }
        }
    }

    static {
        Factory factory = new Factory("AJProjectModel.java", Class.forName("org.eclipse.ajdt.internal.builder.AJProjectModel"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.AJProjectModel-org.eclipse.core.runtime.CoreException-<missing>-"), 144);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-createProjectMap-org.eclipse.ajdt.internal.builder.AJProjectModel----void-"), 128);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.AJProjectModel-org.eclipse.core.runtime.CoreException-<missing>-"), 214);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-createMapForFile-org.eclipse.ajdt.internal.builder.AJProjectModel-org.eclipse.core.resources.IFile:-file:--void-"), 207);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.builder.AJProjectModel-org.eclipse.jdt.core.JavaModelException-<missing>-"), 296);
    }
}

