/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.util.ArrayList;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.launching.AJClasspathModel;
import org.eclipse.ajdt.internal.launching.LaunchConfigurationClasspathUtils;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaClasspathTab;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.classpath.BootpathFilter;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathContentProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathLabelProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathModel;
import org.eclipse.jdt.internal.debug.ui.classpath.RuntimeClasspathViewer;
import org.eclipse.jdt.internal.debug.ui.launcher.IEntriesChangedListener;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class AJClasspathTab
extends JavaClasspathTab {
    private AJClasspathModel fModel;
    protected static final String DIALOG_SETTINGS_PREFIX = "JavaClasspathTab";
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_CLASSPATH_TAB);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        Label label = new Label(comp, 0);
        label.setText(LauncherMessages.getString((String)"JavaClasspathTab.0"));
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fClasspathViewer = new RuntimeClasspathViewer(comp);
        this.fClasspathViewer.addEntriesChangedListener((IEntriesChangedListener)this);
        this.fClasspathViewer.getControl().setFont(font);
        this.fClasspathViewer.setLabelProvider((IBaseLabelProvider)new ClasspathLabelProvider());
        this.fClasspathViewer.setContentProvider((IContentProvider)new ClasspathContentProvider((JavaClasspathTab)this));
        if (!this.isShowBootpath()) {
            this.fClasspathViewer.addFilter((ViewerFilter)new BootpathFilter());
        }
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.createPathButtons(pathButtonComp);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        try {
            this.fModel = LaunchConfigurationClasspathUtils.createClasspathModel((ILaunchConfiguration)configuration);
            this.updateClassPathWithAspectPath((ILaunchConfiguration)configuration);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
            CoreException e = coreException2;
            AJDTEventTrace.generalEvent(e.getMessage());
        }
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        boolean useDefault = true;
        this.setErrorMessage(null);
        try {
            useDefault = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            if (useDefault && !LaunchConfigurationClasspathUtils.isDefaultClasspath(LaunchConfigurationClasspathUtils.getCurrentClasspath(this.fModel), (ILaunchConfiguration)workingCopy)) {
                this.initializeFrom((ILaunchConfiguration)workingCopy);
                return;
            }
            this.fClasspathViewer.refresh();
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_2, ajc$tjp_3);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.refresh(configuration);
        this.fClasspathViewer.expandToLevel(2);
    }

    private void updateClassPathWithAspectPath(ILaunchConfiguration configuration) {
        block6: {
            try {
                ILaunchConfigurationWorkingCopy wc = configuration instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
                IRuntimeClasspathEntry[] classpath = LaunchConfigurationClasspathUtils.getCurrentClasspath(this.fModel);
                boolean def = LaunchConfigurationClasspathUtils.isDefaultClasspath(classpath, (ILaunchConfiguration)wc);
                if (def) {
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, null);
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, null);
                    break block6;
                }
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                try {
                    ArrayList<String> mementos = new ArrayList<String>(classpath.length);
                    int i = 0;
                    while (i < classpath.length) {
                        IRuntimeClasspathEntry entry = classpath[i];
                        mementos.add(entry.getMemento());
                        ++i;
                    }
                    wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
                }
                catch (CoreException coreException) {
                    CoreException coreException2 = coreException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_4, ajc$tjp_5);
                    CoreException e = coreException2;
                    AJDTEventTrace.generalEvent(e.getMessage());
                }
                wc.doSave();
            }
            catch (CoreException coreException) {
                CoreException coreException3 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException3, (Object)this, ajc$tjp_6, ajc$tjp_5);
                CoreException e1 = coreException3;
                AJDTEventTrace.generalEvent(e1.getMessage());
            }
        }
    }

    private void refresh(ILaunchConfiguration configuration) {
        CoreException e;
        boolean useDefault = true;
        this.setErrorMessage(null);
        try {
            useDefault = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_7, ajc$tjp_8);
            e = coreException2;
            AJDTEventTrace.generalEvent(e.getMessage());
        }
        if (configuration == this.getLaunchConfiguration() && !useDefault) {
            this.setDirty(false);
            return;
        }
        this.setLaunchConfiguration(configuration);
        try {
            this.fModel = LaunchConfigurationClasspathUtils.createClasspathModel(configuration);
        }
        catch (CoreException coreException) {
            CoreException coreException3 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException3, (Object)this, ajc$tjp_9, ajc$tjp_8);
            e = coreException3;
            this.setErrorMessage(e.getMessage());
        }
        this.fClasspathViewer.setLaunchConfiguration(configuration);
        this.fClasspathViewer.setInput((Object)this.fModel);
        this.setDirty(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isDirty()) {
            IRuntimeClasspathEntry[] classpath = LaunchConfigurationClasspathUtils.getCurrentClasspath(this.fModel);
            boolean def = LaunchConfigurationClasspathUtils.isDefaultClasspath(classpath, (ILaunchConfiguration)configuration);
            if (def) {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, null);
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, null);
            } else {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                try {
                    ArrayList<String> mementos = new ArrayList<String>(classpath.length);
                    int i = 0;
                    while (i < classpath.length) {
                        IRuntimeClasspathEntry entry = classpath[i];
                        mementos.add(entry.getMemento());
                        ++i;
                    }
                    configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
                }
                catch (CoreException coreException) {
                    CoreException coreException2 = coreException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_10, ajc$tjp_11);
                    CoreException e = coreException2;
                    AJDTEventTrace.generalEvent(e.getMessage());
                }
            }
        }
    }

    private void setLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected ClasspathModel getModel() {
        return this.fModel;
    }

    static {
        Factory factory = new Factory("AJClasspathTab.java", Class.forName("org.eclipse.ajdt.internal.launching.AJClasspathTab"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-e-"), 108);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setDefaults-org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.debug.core.ILaunchConfigurationWorkingCopy:-configuration:--void-"), 105);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-e-"), 271);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-performApply-org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.debug.core.ILaunchConfigurationWorkingCopy:-configuration:--void-"), 244);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-<missing>-"), 136);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-activated-org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.debug.core.ILaunchConfigurationWorkingCopy:-workingCopy:--void-"), 121);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-e-"), 190);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-updateClassPathWithAspectPath-org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.debug.core.ILaunchConfiguration:-configuration:--void-"), 158);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-e1-"), 195);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-e-"), 211);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-refresh-org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.debug.core.ILaunchConfiguration:-configuration:--void-"), 205);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AJClasspathTab-org.eclipse.core.runtime.CoreException-e-"), 229);
    }
}

