/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.launching;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aspectj.ajde.Ajde;
import org.aspectj.asm.IProgramElement;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.launching.AJMainMethodSearchEngine;
import org.eclipse.ajdt.internal.launching.AJMainTypeSelectionDialog;
import org.eclipse.ajdt.internal.launching.LaunchConfigurationClasspathUtils;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.ajdt.ui.visualiser.StructureModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaApplicationLaunchShortcut;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class AspectJApplicationLaunchShortcut
extends JavaApplicationLaunchShortcut {
    public static final String ASPECTJ_LAUNCH_ID = "org.eclipse.ajdt.launching.AspectJApplication";
    public static final String AJ_FILE_EXTENSION = "aj";
    public static final String JAVA_FILE_EXTENSION = "java";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;

    public void searchAndLaunch(Object[] search, String mode, boolean editor) {
        Object[] types = null;
        if (search != null) {
            try {
                IJavaElement[] elements = this.getJavaElements(search);
                if (elements.length > 0) {
                    AJMainMethodSearchEngine engine = new AJMainMethodSearchEngine();
                    IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (boolean)false);
                    types = engine.searchMainMethodsIncludingAspects((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), scope, 24, true);
                } else {
                    types = search;
                }
            }
            catch (InterruptedException interruptedException) {
                InterruptedException interruptedException2 = interruptedException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                InvocationTargetException invocationTargetException2 = invocationTargetException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException2, (Object)this, ajc$tjp_2, ajc$tjp_1);
                InvocationTargetException e = invocationTargetException2;
                MessageDialog.openError((Shell)this.getShell(), (String)"Launch Failed", (String)e.getMessage());
                return;
            }
            Object type = null;
            if (types.length == 0) {
                String message = null;
                message = editor ? LauncherMessages.getString((String)"JavaApplicationLaunchShortcut.The_active_editor_does_not_contain_a_main_type._1") : LauncherMessages.getString((String)"JavaApplicationLaunchShortcut.The_selection_does_not_contain_a_main_type._2");
                MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.getString((String)"JavaApplicationAction.Launch_failed_7"), (String)message);
            } else {
                type = types.length > 1 ? this.chooseType(types, mode) : types[0];
            }
            if (type != null) {
                this.launch(type, mode);
            }
        }
    }

    private IJavaElement[] getJavaElements(Object[] objects) {
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>(objects.length);
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof IAdaptable) {
                IJavaElement element;
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ClassNotFoundException classNotFoundException2 = classNotFoundException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException2, (Object)this, ajc$tjp_3, ajc$tjp_4);
                        throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                    }
                }
                if ((element = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null) {
                    IType type;
                    if (element instanceof IMember && (type = ((IMember)element).getDeclaringType()) != null) {
                        element = type;
                    }
                    list.add(element);
                }
            }
            ++i;
        }
        return list.toArray(new IJavaElement[list.size()]);
    }

    protected void launch(Object type, String mode) {
        ILaunchConfiguration config = this.findLaunchConfiguration(type, mode);
        if (config != null) {
            LaunchConfigurationClasspathUtils.addAspectPathToClasspath(config);
            DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(Object type, String mode) {
        ILaunchConfigurationType configType = AspectJApplicationLaunchShortcut.getAJLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                String fullyQualifiedName = null;
                String projectName = null;
                if (type instanceof IType) {
                    fullyQualifiedName = ((IType)type).getFullyQualifiedName();
                    projectName = ((IType)type).getJavaProject().getElementName();
                } else if (type instanceof Object[]) {
                    IProgramElement element = (IProgramElement)((Object[])type)[0];
                    IProject project = (IProject)((Object[])type)[1];
                    IJavaProject jp = JavaCore.create((IProject)project);
                    fullyQualifiedName = String.valueOf(element.getPackageName()) + "." + element.getName();
                    if (jp != null) {
                        projectName = jp.getElementName();
                    }
                }
                if (config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "").equals(fullyQualifiedName) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(projectName)) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_5, ajc$tjp_6);
            CoreException e = coreException2;
            JDIDebugUIPlugin.log((Throwable)e);
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            return this.createConfiguration(type);
        }
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidateConfigs.get(0);
        }
        ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
        if (config != null) {
            return config;
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(Object type) {
        ILaunchConfiguration config = null;
        if (type instanceof IType) {
            config = this.createConfigurationForIType((IType)type);
        } else if (type instanceof Object[]) {
            IProgramElement aspectElement = (IProgramElement)((Object[])type)[0];
            IJavaProject jp = JavaCore.create((IProject)((IProject)((Object[])type)[1]));
            ILaunchConfigurationWorkingCopy wc = null;
            try {
                ILaunchConfigurationType configType = AspectJApplicationLaunchShortcut.getAJLaunchConfigType();
                wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(aspectElement.getName()));
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_7, ajc$tjp_8);
                CoreException exception = coreException2;
                this.reportCreatingConfiguration(exception);
                return null;
            }
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, String.valueOf(aspectElement.getPackageName()) + "." + aspectElement.getName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, jp.getElementName());
            try {
                config = wc.doSave();
            }
            catch (CoreException coreException) {
                CoreException coreException3 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException3, (Object)this, ajc$tjp_9, ajc$tjp_8);
                CoreException exception = coreException3;
                this.reportCreatingConfiguration(exception);
            }
        }
        return config;
    }

    private ILaunchConfiguration createConfigurationForIType(IType type) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = AspectJApplicationLaunchShortcut.getAJLaunchConfigType();
            wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName()));
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_10, ajc$tjp_11);
            CoreException exception = coreException2;
            this.reportCreatingConfiguration(exception);
            return null;
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, type.getFullyQualifiedName());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
        try {
            config = wc.doSave();
        }
        catch (CoreException coreException) {
            CoreException coreException3 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException3, (Object)this, ajc$tjp_12, ajc$tjp_11);
            CoreException exception = coreException3;
            this.reportCreatingConfiguration(exception);
        }
        return config;
    }

    protected static ILaunchConfigurationType getAJLaunchConfigType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(ASPECTJ_LAUNCH_ID);
    }

    protected Object chooseType(Object[] types, String mode) {
        AJMainTypeSelectionDialog dialog = new AJMainTypeSelectionDialog(this.getShell(), types);
        if (mode.equals("debug")) {
            dialog.setTitle(LauncherMessages.getString((String)"JavaApplicationAction.Type_Selection_Debug"));
        } else {
            dialog.setTitle(LauncherMessages.getString((String)"JavaApplicationAction.Type_Selection_Run"));
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            return dialog.getFirstResult();
        }
        return null;
    }

    public void launch(IEditorPart editor, String mode) {
        IJavaElement je;
        boolean error = true;
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException2 = classNotFoundException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException2, (Object)this, ajc$tjp_13, ajc$tjp_14);
                throw new NoClassDefFoundError(classNotFoundException2.getMessage());
            }
        }
        if ((je = (IJavaElement)input.getAdapter((Class)clazz)) != null) {
            this.searchAndLaunch(new Object[]{je}, mode, true);
            error = false;
        } else if (input instanceof IFileEditorInput) {
            IProgramElement aspectElement;
            IFile file;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClassNotFoundException classNotFoundException3 = classNotFoundException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException3, (Object)this, ajc$tjp_15, ajc$tjp_14);
                    throw new NoClassDefFoundError(classNotFoundException3.getMessage());
                }
            }
            if ((file = (IFile)input.getAdapter((Class)clazz2)).getFileExtension().equals(AJ_FILE_EXTENSION) && (aspectElement = this.getAspectForFile(file)).isRunnable()) {
                this.searchAndLaunch(new Object[]{new Object[]{aspectElement, file.getProject()}}, mode, true);
                error = false;
            }
        }
        if (error) {
            MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.getString((String)"JavaApplicationAction.Launch_failed_7"), (String)LauncherMessages.getString((String)"JavaApplicationLaunchShortcut.The_active_editor_does_not_contain_a_main_type._1"));
        }
    }

    private IProgramElement getAspectForFile(IFile file) {
        IProject project = file.getProject();
        String configFile = AspectJUIPlugin.getBuildConfigurationFile(project);
        if (!configFile.equals(Ajde.getDefault().getConfigurationManager().getActiveConfigFile())) {
            Ajde.getDefault().getConfigurationManager().setActiveConfigFile(configFile);
        }
        List packages = StructureModelUtil.getPackagesInModel();
        IPath path = file.getProjectRelativePath();
        String pathStr = path.toString();
        if (pathStr.endsWith(".aj")) {
            pathStr = pathStr.substring(0, pathStr.length() - 3);
        } else if (pathStr.endsWith(".java")) {
            pathStr = pathStr.substring(0, pathStr.length() - 5);
        }
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            Object[] progNodes = (Object[])it.next();
            IProgramElement packageNode = (IProgramElement)progNodes[0];
            if (pathStr.indexOf(packageNode.getName().replace('.', '/')) == -1) continue;
            Set temp = this.getAspectsInPackage(packageNode, project);
            Iterator iter = temp.iterator();
            while (iter.hasNext()) {
                IProgramElement element = (IProgramElement)iter.next();
                String pathString = String.valueOf(element.getPackageName()) + "." + element.getName();
                if (!pathStr.endsWith(pathString = pathString.replace('.', '/'))) continue;
                return element;
            }
        }
        return null;
    }

    private Set getAspectsInPackage(IProgramElement packageNode, IProject project) {
        List files = StructureModelUtil.getFilesInPackage(packageNode);
        HashSet<IProgramElement> aspects = new HashSet<IProgramElement>();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            IProgramElement fileNode = (IProgramElement)it.next();
            if (!fileNode.getKind().equals(IProgramElement.Kind.FILE_JAVA) && !fileNode.getKind().equals(IProgramElement.Kind.FILE_ASPECTJ)) continue;
            List children = fileNode.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                IProgramElement child = (IProgramElement)iter.next();
                if (child == null || !child.getKind().equals(IProgramElement.Kind.ASPECT) || !child.isRunnable()) continue;
                aspects.add(child);
            }
        }
        return aspects;
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection struct = (IStructuredSelection)selection;
            ArrayList<Object> elements = new ArrayList<Object>();
            Iterator iter = struct.iterator();
            while (iter.hasNext()) {
                IProgramElement aspectElement;
                IFile file;
                Object element = iter.next();
                if (element instanceof IJavaElement) {
                    elements.add(element);
                    continue;
                }
                if (!(element instanceof IFile) || !(file = (IFile)element).getFileExtension().equals(AJ_FILE_EXTENSION) && !file.getFileExtension().equals(JAVA_FILE_EXTENSION) || !(aspectElement = this.getAspectForFile(file)).isRunnable()) continue;
                elements.add(new Object[]{aspectElement, file.getProject()});
            }
            this.searchAndLaunch(elements.toArray(), mode, false);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)LauncherMessages.getString((String)"JavaApplicationAction.Launch_failed_7"), (String)LauncherMessages.getString((String)"JavaApplicationLaunchShortcut.The_selection_does_not_contain_a_main_type._2"));
        }
    }

    static {
        Factory factory = new Factory("AspectJApplicationLaunchShortcut.java", Class.forName("org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-java.lang.InterruptedException-<missing>-"), 101);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-searchAndLaunch-org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-[Ljava.lang.Object;:java.lang.String:boolean:-search:mode:editor:--void-"), 82);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.core.runtime.CoreException-exception-"), 298);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-createConfigurationForIType-org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.jdt.core.IType:-type:--org.eclipse.debug.core.ILaunchConfiguration-"), 293);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.core.runtime.CoreException-exception-"), 306);
        ajc$tjp_13 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-java.lang.ClassNotFoundException-<missing>-"), 347);
        ajc$tjp_14 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-launch-org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.ui.IEditorPart:java.lang.String:-editor:mode:--void-"), 345);
        ajc$tjp_15 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-java.lang.ClassNotFoundException-<missing>-"), 352);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-java.lang.reflect.InvocationTargetException-e-"), 103);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-java.lang.ClassNotFoundException-<missing>-"), 148);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getJavaElements-org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-[Ljava.lang.Object;:-objects:--[Lorg.eclipse.jdt.core.IJavaElement;-"), 143);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.core.runtime.CoreException-e-"), 220);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-findLaunchConfiguration-org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-java.lang.Object:java.lang.String:-type:mode:--org.eclipse.debug.core.ILaunchConfiguration-"), 184);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.core.runtime.CoreException-exception-"), 267);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-createConfiguration-org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-java.lang.Object:-type:--org.eclipse.debug.core.ILaunchConfiguration-"), 255);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.launching.AspectJApplicationLaunchShortcut-org.eclipse.core.runtime.CoreException-exception-"), 280);
    }
}

