/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui;

import java.io.File;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter;
import org.eclipse.ajdt.internal.ui.preferences.PreferencePageBuilder;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class AspectJProjectPropertiesPage
extends PropertyPage {
    private StringFieldEditor outputJarEditor;
    private StringFieldEditor nonStandardOptionsEditor;
    private IProject thisProject;
    private static int BROWSE_FOR_CLASSJARS;
    private static int BROWSE_FOR_ASPECTJARS;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;

    static {
        Factory factory = new Factory("AspectJProjectPropertiesPage.java", Class.forName("org.eclipse.ajdt.internal.ui.AspectJProjectPropertiesPage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.AspectJProjectPropertiesPage-org.eclipse.core.runtime.CoreException-ce-"), 229);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-retrieveSettingString-org.eclipse.ajdt.internal.ui.AspectJProjectPropertiesPage-org.eclipse.core.runtime.QualifiedName:-key:--java.lang.String-"), 224);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.AspectJProjectPropertiesPage-org.eclipse.core.runtime.CoreException-ce-"), 250);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-retrieveSettingBoolean-org.eclipse.ajdt.internal.ui.AspectJProjectPropertiesPage-org.eclipse.core.runtime.QualifiedName:-key:--boolean-"), 245);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.AspectJProjectPropertiesPage-org.eclipse.jdt.core.JavaModelException-<missing>-"), 357);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-performOk-org.eclipse.ajdt.internal.ui.AspectJProjectPropertiesPage----boolean-"), 348);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.AspectJProjectPropertiesPage-org.eclipse.core.runtime.CoreException-ce-"), 367);
        BROWSE_FOR_CLASSJARS = 0;
        BROWSE_FOR_ASPECTJARS = 1;
    }

    /*
     * WARNING - void declaration
     */
    protected Control createContents(Composite composite) {
        void parent;
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$1$ce66e616(this);
        this.thisProject = (IProject)this.getElement();
        BuildOptionsAdapter.ensurePropertiesInitialized(this.thisProject);
        Composite pageComposite = this.createPageComposite((Composite)parent, 3);
        Composite row0Composite = this.createRowComposite(pageComposite, 1);
        this.createLabel(row0Composite, AspectJUIPlugin.getResourceString("compilerPropsPage.description"));
        Composite row3Comp = this.createRowComposite(pageComposite, 2);
        this.outputJarEditor = new StringFieldEditor("", AspectJUIPlugin.getResourceString("compilerPropsPage.outputJar"), row3Comp);
        this.nonStandardOptionsEditor = new StringFieldEditor("", AspectJUIPlugin.getResourceString("compilerPropsPage.nonStandardOptions"), StringFieldEditor.UNLIMITED, pageComposite);
        this.createLabel(pageComposite, "");
        this.createLabel(pageComposite, "");
        this.updatePageContents();
        return pageComposite;
    }

    private Button buildButton(Composite container, String label) {
        Button btn = new Button(container, 32);
        btn.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        data.horizontalAlignment = 4;
        btn.setLayoutData((Object)data);
        return btn;
    }

    private Button buildPushButton(Composite container, String label) {
        Button btn = new Button(container, 8);
        btn.setText(label);
        return btn;
    }

    private Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        button.setLayoutData((Object)data);
        return button;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        data.horizontalAlignment = 1;
        label.setLayoutData((Object)data);
        return label;
    }

    private Composite createPageComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private Composite createRowComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.horizontalSpan = 3;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private void preserveSetting(QualifiedName key, boolean flag) throws CoreException {
        this.preserveSetting(key, new Boolean(flag).toString());
    }

    private void preserveSetting(QualifiedName key, String value) throws CoreException {
        this.thisProject.setPersistentProperty(key, value);
    }

    private String retrieveSettingString(QualifiedName key) {
        try {
            String value = this.thisProject.getPersistentProperty(key);
            if (value == null) {
                return "";
            }
            return value;
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
            CoreException ce = coreException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("projectProperties.exceptionDuringRetrieve"), ce);
            return "";
        }
    }

    private boolean retrieveSettingBoolean(QualifiedName key) {
        try {
            String value = this.thisProject.getPersistentProperty(key);
            if (value == null) {
                return false;
            }
            boolean valueB = new Boolean(value);
            return valueB;
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_2, ajc$tjp_3);
            CoreException ce = coreException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("projectProperties.exceptionDuringRetrieve"), ce);
            return false;
        }
    }

    private String findInvalidJars(String setOfJars) {
        if (setOfJars.length() == 0) {
            return null;
        }
        String inputCopy = setOfJars;
        StringBuffer invalidEntries = new StringBuffer();
        String projectBaseDirectory = this.thisProject.getLocation().toOSString();
        while (inputCopy.indexOf(File.pathSeparator) != -1) {
            int idx = inputCopy.indexOf(File.pathSeparator);
            String path = inputCopy.substring(0, idx);
            File f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + path);
            }
            if (!f.exists()) {
                invalidEntries.append(f + "\n");
            }
            inputCopy = inputCopy.substring(idx + 1);
        }
        if (inputCopy.length() != 0) {
            File f = new File(inputCopy);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + inputCopy);
            }
            if (!f.exists()) {
                invalidEntries.append(f + "\n");
            }
        }
        if (invalidEntries.length() == 0) {
            return null;
        }
        return invalidEntries.toString();
    }

    private String findInvalidDirs(String setOfDirs) {
        if (setOfDirs.length() == 0) {
            return null;
        }
        String inputCopy = setOfDirs;
        StringBuffer invalidEntries = new StringBuffer();
        String projectBaseDirectory = AspectJUIPlugin.getDefault().getCurrentProject().getLocation().toOSString();
        while (inputCopy.indexOf(File.pathSeparator) != -1) {
            int idx = inputCopy.indexOf(File.pathSeparator);
            String path = inputCopy.substring(0, idx);
            File f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + path);
            }
            if (!f.isDirectory()) {
                invalidEntries.append(f + "\n");
            }
            inputCopy = inputCopy.substring(idx + 1);
        }
        if (inputCopy.length() != 0) {
            File f = new File(inputCopy);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + inputCopy);
            }
            if (!f.isDirectory()) {
                invalidEntries.append(f + "\n");
            }
        }
        if (invalidEntries.length() == 0) {
            return null;
        }
        return invalidEntries.toString();
    }

    public void performApply() {
        Object[] objectArray = new Object[]{};
        PreferencePageBuilder.ajc$cflowStack$1.push(objectArray);
        try {
            Object[] objectArray2 = new Object[]{};
            PreferencePageBuilder.ajc$cflowStack$0.push(objectArray2);
            try {
                this.performOk();
            }
            finally {
                PreferencePageBuilder.ajc$cflowStack$0.pop();
            }
        }
        finally {
            PreferencePageBuilder.ajc$cflowStack$1.pop();
        }
    }

    public boolean performOk() {
        boolean bl;
        block8: {
            String outJar = this.outputJarEditor.getStringValue();
            if (outJar != null) {
                try {
                    if (!outJar.startsWith(File.separator)) {
                        IJavaProject jp = JavaCore.create((IProject)this.thisProject);
                        IPath workspaceRelativeOutpath = jp.getOutputLocation();
                        IPath full = AspectJUIPlugin.getWorkspace().getRoot().getLocation().append(workspaceRelativeOutpath);
                        outJar = full.toOSString();
                    }
                }
                catch (JavaModelException javaModelException) {
                    JavaModelException javaModelException2 = javaModelException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_4, ajc$tjp_5);
                }
            }
            AJDTEventTrace.projectPropertiesChanged(this.thisProject);
            try {
                this.preserveSetting(BuildOptionsAdapter.OUTPUTJAR, this.outputJarEditor.getStringValue());
                this.preserveSetting(BuildOptionsAdapter.CHAR_ENC, "");
                this.preserveSetting(BuildOptionsAdapter.NON_STANDARD_OPTS, this.nonStandardOptionsEditor.getStringValue());
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_6, ajc$tjp_5);
                CoreException ce = coreException2;
                AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("projectProperties.exceptionDuringStore"), ce);
                bl = false;
                break block8;
            }
            bl = true;
        }
        if (!PreferencePageBuilder.ajc$cflowStack$0.isValid()) {
            PreferencePageBuilder.aspectOf().ajc$afterReturning$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$7$d61cf77c(this);
        }
        if (PreferencePageBuilder.ajc$cflowStack$1.isValid()) {
            PreferencePageBuilder.aspectOf().ajc$afterReturning$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$8$a1481a1f(this);
        }
        return bl;
    }

    public void performDefaults() {
        AJDTEventTrace.projectPropertiesDefaulted(this.thisProject);
        String string = "";
        StringFieldEditor stringFieldEditor = this.outputJarEditor;
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$4$2f71f9b9(stringFieldEditor, string, this);
        stringFieldEditor.setStringValue(string);
        String string2 = "";
        StringFieldEditor stringFieldEditor2 = this.nonStandardOptionsEditor;
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$4$2f71f9b9(stringFieldEditor2, string2, this);
        stringFieldEditor2.setStringValue(string2);
    }

    public String calculateStrictnessFromButtons() {
        return null;
    }

    public void updatePageContents() {
        String string = this.retrieveSettingString(BuildOptionsAdapter.OUTPUTJAR);
        StringFieldEditor stringFieldEditor = this.outputJarEditor;
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$4$2f71f9b9(stringFieldEditor, string, this);
        stringFieldEditor.setStringValue(string);
        String string2 = this.retrieveSettingString(BuildOptionsAdapter.NON_STANDARD_OPTS);
        StringFieldEditor stringFieldEditor2 = this.nonStandardOptionsEditor;
        PreferencePageBuilder.aspectOf().ajc$before$org_eclipse_ajdt_internal_ui_preferences_PreferencePageBuilder$4$2f71f9b9(stringFieldEditor2, string2, this);
        stringFieldEditor2.setStringValue(string2);
    }

    public IProject getThisProject() {
        return this.thisProject;
    }
}

