/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.IBuildConfigurationChangedListener;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.builder.Builder;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

public class PulldownBuildselectorMenu
implements IWorkbenchWindowPulldownDelegate,
SelectionListener,
IBuildConfigurationChangedListener {
    private IAction buildAction;
    private ProjectBuildConfigurator currentPbc;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;

    public PulldownBuildselectorMenu() {
        BuildConfigurator.getBuildConfigurator().addBuildConfigurationChangedListener(this);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public String getWorkspaceDirectory() {
        IProject currentProject = AspectJUIPlugin.getDefault().getCurrentProject();
        if (currentProject == null) {
            return null;
        }
        IPath trimPath = currentProject.getLocation();
        trimPath = trimPath.removeLastSegments(1);
        return new String(String.valueOf(trimPath.toOSString()) + File.separator);
    }

    public Menu getMenu(Control c) {
        Menu m = new Menu(c);
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getActiveProjectBuildConfigurator();
        if (pbc == null) {
            MenuItem defaultLstItem = new MenuItem(m, 32);
            defaultLstItem.setText("No open AspectJ project selected");
            defaultLstItem.setData(null);
            return m;
        }
        Util.Comparable[] bcs = pbc.getBuildConfigurations().toArray(new BuildConfiguration[0]);
        Util.sort((Util.Comparable[])bcs);
        MenuItem mi = null;
        BuildConfiguration activeBC = pbc.getActiveBuildConfiguration();
        int i = 0;
        while (i < bcs.length) {
            Util.Comparable bc = bcs[i];
            mi = new MenuItem(m, 32);
            mi.setText(bc.getName());
            mi.addSelectionListener((SelectionListener)this);
            mi.setData((Object)bc);
            if (bc == activeBC) {
                mi.setSelection(true);
            }
            ++i;
        }
        return m;
    }

    public void run(IAction action) {
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getActiveProjectBuildConfigurator();
        if (pbc != null) {
            this.build(pbc.getJavaProject().getProject());
        }
    }

    public void buildConfigurationChanged(ProjectBuildConfigurator pbc) {
        this.currentPbc = pbc;
        if (pbc == null) {
            this.buildAction.setEnabled(false);
        } else {
            this.buildAction.setEnabled(true);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.buildAction == null) {
            this.buildAction = action;
        }
    }

    public void widgetDefaultSelected(SelectionEvent se) {
        this.chooseBuild(se);
    }

    public void widgetSelected(SelectionEvent se) {
        this.chooseBuild(se);
    }

    public void chooseBuild(SelectionEvent se) {
        Object src = se.getSource();
        if (src instanceof MenuItem) {
            MenuItem w = (MenuItem)src;
            BuildConfiguration bc = (BuildConfiguration)w.getData();
            ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getActiveProjectBuildConfigurator();
            if (pbc != null) {
                pbc.setActiveBuildConfiguration(bc);
            }
        }
    }

    private void build(final IProject project) {
        Shell activeShell = AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress op = new IRunnableWithProgress(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.StaticPart ajc$tjp_1;
            private static final JoinPoint.StaticPart ajc$tjp_2;
            private static final JoinPoint.StaticPart ajc$tjp_3;

            void doLocalBuild(int buildType, IProgressMonitor pm) throws CoreException {
                Builder.isLocalBuild = true;
                project.build(6, pm);
                Builder.isLocalBuild = false;
            }

            public void run(IProgressMonitor pm) {
                try {
                    this.doLocalBuild(6, pm);
                }
                catch (CoreException coreException) {
                    CoreException coreException2 = coreException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
                    CoreException cEx = coreException2;
                    AspectJUIPlugin.getDefault().getErrorHandler().handleError("Build pulldown error", cEx);
                }
                catch (NullPointerException nullPointerException) {
                    NullPointerException nullPointerException2 = nullPointerException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(nullPointerException2, this, ajc$tjp_2, ajc$tjp_1);
                    NullPointerException npe = nullPointerException2;
                    AJDTEventTrace.generalEvent("Unexpected NullPointerException during build processing (eclipse bug?): Your task view will be temporarily out of step with compilation:" + npe);
                }
                catch (OperationCanceledException operationCanceledException) {
                    OperationCanceledException operationCanceledException2 = operationCanceledException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(operationCanceledException2, this, ajc$tjp_3, ajc$tjp_1);
                    AJDTEventTrace.generalEvent("Build was cancelled.");
                }
            }

            static {
                Factory factory = new Factory("PulldownBuildselectorMenu.java", Class.forName("org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu$1-org.eclipse.core.runtime.CoreException-cEx-"), 300);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu$1-org.eclipse.core.runtime.IProgressMonitor:-pm:--void-"), 299);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu$1-java.lang.NullPointerException-npe-"), 304);
                ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu$1-org.eclipse.core.runtime.OperationCanceledException-<missing>-"), 308);
            }
        };
        try {
            new ProgressMonitorDialog(activeShell).run(true, true, op);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(invocationTargetException2, this, ajc$tjp_0, ajc$tjp_1);
            InvocationTargetException e = invocationTargetException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Auto build on select failed", e);
        }
        catch (InterruptedException interruptedException) {
            InterruptedException interruptedException2 = interruptedException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(interruptedException2, this, ajc$tjp_2, ajc$tjp_1);
            InterruptedException e = interruptedException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Auto build on select failed", e);
        }
    }

    static {
        Factory factory = new Factory("PulldownBuildselectorMenu.java", Class.forName("org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu-java.lang.reflect.InvocationTargetException-e-"), 317);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-build-org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu-org.eclipse.core.resources.IProject:-project:--void-"), 284);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.PulldownBuildselectorMenu-java.lang.InterruptedException-e-"), 320);
    }
}

