/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaProject;

public class BuildOptionsAdapter
implements org.aspectj.ajde.BuildOptionsAdapter {
    public static final QualifiedName INPUTJARS;
    public static final QualifiedName INPUTJARSBROWSEDIR;
    public static final QualifiedName ASPECTJARSBROWSEDIR;
    public static final QualifiedName INPATH;
    public static final QualifiedName INPATH_CON_KINDS;
    public static final QualifiedName INPATH_ENT_KINDS;
    public static final QualifiedName ASPECTPATH;
    public static final QualifiedName ASPECTPATH_CON_KINDS;
    public static final QualifiedName ASPECTPATH_ENT_KINDS;
    public static final QualifiedName OUTPUTJAR;
    public static final QualifiedName SOURCEROOTS;
    public static final QualifiedName ASPECTJARS;
    public static final QualifiedName CHAR_ENC;
    public static final QualifiedName NON_STANDARD_OPTS;
    public static final QualifiedName COMPILATION_STRICTNESS;
    public static final boolean INCREMENTAL_COMPILATION_DEFAULT = false;
    public static final boolean WEAVE_MESSAGES_DEFAULT = false;
    public static final boolean BUILD_ASM_DEFAULT = true;
    public static final String NON_STANDARD_OPTS_DEFAULT = "-Xlint";
    public static final String CHAR_ENC_DEFAULT;
    public static final boolean JAVA_OR_AJ_EXT_DEFAULT = false;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;

    static {
        Factory factory = new Factory("BuildOptionsAdapter.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter-org.eclipse.core.runtime.CoreException-<missing>-"), 114);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getJavaOptionsMap-org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter----java.util.Map-"), 108);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter-org.eclipse.core.runtime.CoreException-ce-"), 156);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-retrieveSettingBoolean-org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter-org.eclipse.core.runtime.QualifiedName:-key:--boolean-"), 149);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter-org.eclipse.core.runtime.CoreException-ce-"), 173);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-retrieveSettingString-org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter-org.eclipse.core.runtime.QualifiedName:-key:--java.lang.String-"), 166);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter-org.eclipse.core.runtime.CoreException-ce-"), 519);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-ensurePropertiesInitialized-org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter-org.eclipse.core.resources.IProject:-project:--void-"), 456);
        INPUTJARS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inputJars");
        INPUTJARSBROWSEDIR = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inputJarsBrowseDir");
        ASPECTJARSBROWSEDIR = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectJarsBrowseDir");
        INPATH = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inpath");
        INPATH_CON_KINDS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inpathConKinds");
        INPATH_ENT_KINDS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.inpathEntKinds");
        ASPECTPATH = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectpath");
        ASPECTPATH_CON_KINDS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectpathConKinds");
        ASPECTPATH_ENT_KINDS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectpathEntKinds");
        OUTPUTJAR = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.outputJar");
        SOURCEROOTS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.sourceRoots");
        ASPECTJARS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.aspectJars");
        CHAR_ENC = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.characterEncoding");
        NON_STANDARD_OPTS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.nonStandardOptions");
        COMPILATION_STRICTNESS = new QualifiedName("org.eclipse.ajdt.ui", "BuildOptions.compilationStrictness");
        CHAR_ENC_DEFAULT = System.getProperty("file.encoding");
    }

    public Map getJavaOptionsMap() {
        Map optionsMap = null;
        try {
            JavaProject project = (JavaProject)AspectJUIPlugin.getDefault().getCurrentProject().getNature("org.eclipse.jdt.core.javanature");
            optionsMap = project.getOptions(true);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
        }
        if (optionsMap == null) {
            return JavaCore.getOptions();
        }
        return optionsMap;
    }

    public String toString() {
        StringBuffer formattedOptions = new StringBuffer();
        formattedOptions.append("Current Compiler options set:");
        formattedOptions.append("[Incremental compilation=" + this.getIncrementalMode() + "]");
        formattedOptions.append("[NonStandard options='" + this.getNonStandardOptions() + "']");
        return formattedOptions.toString();
    }

    private boolean retrieveSettingBoolean(QualifiedName key) {
        IProject thisProject = AspectJUIPlugin.getDefault().getCurrentProject();
        try {
            String value = thisProject.getPersistentProperty(key);
            boolean valueB = new Boolean(value);
            return valueB;
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_2, ajc$tjp_3);
            CoreException ce = coreException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("buildOptionsAdapter.exceptionDuringRetrieve"), ce);
            return false;
        }
    }

    private String retrieveSettingString(QualifiedName key) {
        IProject thisProject = AspectJUIPlugin.getDefault().getCurrentProject();
        try {
            String value = thisProject.getPersistentProperty(key);
            if (value == null) {
                return "";
            }
            return value;
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_4, ajc$tjp_5);
            CoreException ce = coreException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("buildOptionsAdapter.exceptionDuringRetrieve"), ce);
            return "";
        }
    }

    public boolean getLenientSpecMode() {
        return false;
    }

    public String getNonStandardOptions() {
        this.ensurePropertiesInitialized();
        IProject currentProject = AspectJUIPlugin.getDefault().getCurrentProject();
        String nonStandardOptions = this.retrieveSettingString(NON_STANDARD_OPTS);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getNonStandardOptions called, returning :" + nonStandardOptions);
        }
        nonStandardOptions = String.valueOf(nonStandardOptions) + AspectJPreferences.getLintOptions(currentProject);
        nonStandardOptions = String.valueOf(nonStandardOptions) + AspectJPreferences.getAdvancedOptions(currentProject);
        if (AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getShowWeaveMessages()) {
            nonStandardOptions = String.valueOf(nonStandardOptions) + " -showWeaveInfo";
        }
        return nonStandardOptions;
    }

    public boolean getPortingMode() {
        return false;
    }

    public boolean getPreprocessMode() {
        return false;
    }

    public boolean getSourceOnePointFourMode() {
        return false;
    }

    public boolean getStrictSpecMode() {
        return false;
    }

    public boolean getIncrementalMode() {
        this.ensurePropertiesInitialized();
        IProject currentProject = AspectJUIPlugin.getDefault().getCurrentProject();
        boolean incrementalMode = AspectJPreferences.getIncrementalOption(currentProject);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getIncrementalMode called, returning :" + new Boolean(incrementalMode));
        }
        return incrementalMode;
    }

    public boolean getBuildAsm() {
        this.ensurePropertiesInitialized();
        IProject currentProject = AspectJUIPlugin.getDefault().getCurrentProject();
        boolean buildAsm = AspectJPreferences.getBuildASMOption(currentProject);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getBuildAsm called, returning :" + new Boolean(buildAsm));
        }
        return buildAsm;
    }

    public boolean getShowWeaveMessages() {
        this.ensurePropertiesInitialized();
        IProject currentProject = AspectJUIPlugin.getDefault().getCurrentProject();
        boolean showweavemessages = AspectJPreferences.getShowWeaveMessagesOption(currentProject);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getShowWeaveMessages called, returning :" + new Boolean(showweavemessages));
        }
        return showweavemessages;
    }

    public String getWorkingOutputPath() {
        return "";
    }

    public String getComplianceLevel() {
        return null;
    }

    public Set getDebugLevel() {
        return null;
    }

    public boolean getNoImportError() {
        return false;
    }

    public boolean getPreserveAllLocals() {
        return false;
    }

    public String getSourceCompatibilityLevel() {
        return null;
    }

    public Set getWarnings() {
        return null;
    }

    public boolean getUseJavacMode() {
        return false;
    }

    public String getCharacterEncoding() {
        return null;
    }

    private static void preserveSetting(IProject project, QualifiedName key, boolean flag) throws CoreException {
        BuildOptionsAdapter.preserveSetting(project, key, new Boolean(flag).toString());
    }

    private static void preserveSetting(IProject project, QualifiedName key, String value) throws CoreException {
        project.setPersistentProperty(key, value);
    }

    private void ensurePropertiesInitialized() {
        BuildOptionsAdapter.ensurePropertiesInitialized(AspectJUIPlugin.getDefault().getCurrentProject());
    }

    public static void ensurePropertiesInitialized(IProject project) {
        try {
            if (project.getPersistentProperty(INPUTJARSBROWSEDIR) == null) {
                BuildOptionsAdapter.preserveSetting(project, INPUTJARSBROWSEDIR, project.getLocation().toOSString());
            }
            if (project.getPersistentProperty(ASPECTJARSBROWSEDIR) == null) {
                BuildOptionsAdapter.preserveSetting(project, ASPECTJARSBROWSEDIR, project.getLocation().toOSString());
            }
            if (project.getPersistentProperty(INPATH) == null) {
                BuildOptionsAdapter.preserveSetting(project, INPATH, "");
            }
            if (project.getPersistentProperty(INPATH_CON_KINDS) == null) {
                BuildOptionsAdapter.preserveSetting(project, INPATH_CON_KINDS, "");
            }
            if (project.getPersistentProperty(INPATH_ENT_KINDS) == null) {
                BuildOptionsAdapter.preserveSetting(project, INPATH_ENT_KINDS, "");
            }
            if (project.getPersistentProperty(ASPECTPATH) == null) {
                BuildOptionsAdapter.preserveSetting(project, ASPECTPATH, "");
            }
            if (project.getPersistentProperty(ASPECTPATH_CON_KINDS) == null) {
                BuildOptionsAdapter.preserveSetting(project, ASPECTPATH_CON_KINDS, "");
            }
            if (project.getPersistentProperty(ASPECTPATH_ENT_KINDS) == null) {
                BuildOptionsAdapter.preserveSetting(project, ASPECTPATH_ENT_KINDS, "");
            }
            if (project.getPersistentProperty(INPUTJARS) == null) {
                BuildOptionsAdapter.preserveSetting(project, INPUTJARS, "");
            }
            if (project.getPersistentProperty(OUTPUTJAR) == null) {
                BuildOptionsAdapter.preserveSetting(project, OUTPUTJAR, "");
            }
            if (project.getPersistentProperty(ASPECTJARS) == null) {
                BuildOptionsAdapter.preserveSetting(project, ASPECTJARS, "");
            }
            if (project.getPersistentProperty(SOURCEROOTS) == null) {
                BuildOptionsAdapter.preserveSetting(project, SOURCEROOTS, "");
            }
            if (project.getPersistentProperty(CHAR_ENC) == null) {
                BuildOptionsAdapter.preserveSetting(project, CHAR_ENC, CHAR_ENC_DEFAULT);
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_6, ajc$tjp_7);
            CoreException ce = coreException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("buildOptionsAdapter.exceptionInitializingProperties"), ce);
        }
    }

    public String getOutJar() {
        this.ensurePropertiesInitialized();
        String outputJar = this.retrieveSettingString(OUTPUTJAR);
        if (outputJar.trim().length() > 0 && !outputJar.startsWith("\\") && !outputJar.startsWith("/")) {
            String trimmedName = outputJar.trim();
            boolean prependProject = true;
            if (trimmedName.length() > 1 && trimmedName.charAt(1) == ':') {
                prependProject = false;
            }
            if (prependProject) {
                IProject thisProject = AspectJUIPlugin.getDefault().getCurrentProject();
                String projectBaseDirectory = thisProject.getLocation().toOSString();
                outputJar = new String(String.valueOf(projectBaseDirectory) + File.separator + outputJar.trim());
            }
        }
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getOutJar called, returning :" + outputJar);
        }
        return outputJar;
    }

    public Set getInJars() {
        this.ensurePropertiesInitialized();
        String inputJars = this.retrieveSettingString(INPUTJARS);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getInJars called, returning :" + inputJars);
        }
        if (inputJars.length() == 0) {
            return null;
        }
        return this.mapStringToSet(inputJars, false);
    }

    public Set getInPath() {
        this.ensurePropertiesInitialized();
        String inpath = this.retrieveSettingString(INPATH);
        inpath = this.fullyQualifyPathEntries(inpath);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getInPath called, returning :" + inpath);
        }
        if (inpath.length() == 0) {
            return null;
        }
        return this.mapStringToSet(inpath, false);
    }

    private String fullyQualifyPathEntries(String inputPath) {
        StringBuffer resultBuffer = new StringBuffer();
        StringTokenizer strTok = new StringTokenizer(inputPath, File.pathSeparator);
        while (strTok.hasMoreTokens()) {
            String current = strTok.nextToken();
            File f = new File(current);
            if (f.exists() && f.isAbsolute()) {
                resultBuffer.append(current);
            } else {
                String projectName = null;
                int slashPos = current.indexOf("/", 1);
                projectName = slashPos != -1 ? current.substring(1, slashPos) : current.substring(1);
                IProject project = AspectJUIPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null && project.getLocation() != null) {
                    String projectPath = project.getLocation().toString();
                    if (slashPos != -1) {
                        resultBuffer.append(String.valueOf(projectPath) + "/" + current.substring(slashPos + 1));
                    } else {
                        resultBuffer.append(projectPath);
                    }
                } else {
                    AJDTEventTrace.generalEvent("AspectJ path entry " + current + " does not exist. Ignoring.");
                    if (AspectJUIPlugin.DEBUG_BUILDER) {
                        System.out.println("BuildOptionsAdapter.fullyQualifyPathEntries detected path entry " + current + " does not exist");
                    }
                }
            }
            resultBuffer.append(File.pathSeparator);
        }
        String result = resultBuffer.toString();
        if (result.endsWith(File.pathSeparator)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public Set getAspectPath() {
        this.ensurePropertiesInitialized();
        String aspectpath = this.retrieveSettingString(ASPECTPATH);
        aspectpath = this.fullyQualifyPathEntries(aspectpath);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getAspectPath called, returning :" + aspectpath);
        }
        if (aspectpath.length() == 0) {
            return null;
        }
        return this.mapStringToSet(aspectpath, false);
    }

    private Set mapStringToSet(String input, boolean validateFiles) {
        if (input.length() == 0) {
            return null;
        }
        String inputCopy = input;
        StringBuffer invalidEntries = new StringBuffer();
        String projectBaseDirectory = AspectJUIPlugin.getDefault().getCurrentProject().getLocation().toOSString();
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("Converting ]" + input + "[");
        }
        HashSet<File> fileSet = new HashSet<File>();
        while (inputCopy.indexOf(File.pathSeparator) != -1) {
            int idx = inputCopy.indexOf(File.pathSeparator);
            String path = inputCopy.substring(0, idx);
            File f = new File(path);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + path);
            }
            if (validateFiles && !f.exists()) {
                invalidEntries.append(f + "\n");
                if (AspectJUIPlugin.DEBUG_BUILDER) {
                    System.out.println("Skipping file ]" + f.toString() + "[");
                }
            } else {
                fileSet.add(f);
                if (AspectJUIPlugin.DEBUG_BUILDER) {
                    System.out.println("Adding file ]" + f.toString() + "[");
                }
            }
            inputCopy = inputCopy.substring(idx + 1);
        }
        if (inputCopy.length() != 0) {
            File f = new File(inputCopy);
            if (!f.isAbsolute()) {
                f = new File(String.valueOf(projectBaseDirectory) + File.separator + inputCopy);
            }
            if (validateFiles && !f.exists()) {
                invalidEntries.append(f + "\n");
                if (AspectJUIPlugin.DEBUG_BUILDER) {
                    System.out.println("Skipping file ]" + f.toString() + "[");
                }
            } else {
                fileSet.add(f);
                if (AspectJUIPlugin.DEBUG_BUILDER) {
                    System.out.println("Adding file ]" + f.toString() + "[");
                }
            }
        }
        if (validateFiles && invalidEntries.length() != 0) {
            AspectJUIPlugin.getDefault().getErrorHandler().handleWarning("The following jar files do not exist and are being ignored:\n" + invalidEntries.toString());
        }
        return fileSet;
    }

    public Set getSourceRoots() {
        this.ensurePropertiesInitialized();
        String sourceRoots = this.retrieveSettingString(SOURCEROOTS);
        if (AspectJUIPlugin.DEBUG_BUILDER) {
            System.out.println("BuildOptionsAdapter.getSourceRoots called, returning :" + sourceRoots);
        }
        return this.mapStringToSet(sourceRoots, false);
    }
}

