/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.aspectj.weaver.WeaverMetrics;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.builder.Builder;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class CompilerMonitor
implements TaskListManager,
BuildProgressMonitor {
    private long compileStartTime;
    private boolean reportedCompiledMessages;
    private boolean reportedWovenMessages;
    private IProgressMonitor monitor = null;
    private boolean compilationInProgress = false;
    private static List affectedResources;
    private static List problems;
    private static Map otherProjectMarkers;
    private float ajdeMonitorMaxRatio = 1.0f;
    private int currentAjdeProgress;
    private boolean linked;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;

    static {
        Factory factory = new Factory("CompilerMonitor.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor-org.eclipse.core.runtime.CoreException-<missing>-"), 124);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-prepare-org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor-org.eclipse.core.resources.IProject:java.util.List:org.eclipse.core.runtime.IProgressMonitor:-project:buildList:eclipseMonitor:--void-"), 119);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor-org.eclipse.core.runtime.CoreException-cEx-"), 651);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-showMessages-org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor----void-"), 526);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor-org.eclipse.jdt.core.JavaModelException-jmEx-"), 837);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-tryToFindResource-org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor-java.lang.String:-fileName:--org.eclipse.core.resources.IResource-"), 808);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor-java.lang.Exception-<missing>-"), 863);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-findFile-org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor-[Lorg.eclipse.core.resources.IResource;:java.lang.String:-srcContainer:name:--org.eclipse.core.resources.IResource-"), 849);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor-org.eclipse.core.runtime.CoreException-<missing>-"), 884);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-clearOtherProjectMarkers-org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor-org.eclipse.core.resources.IProject:-p:--void-"), 877);
        affectedResources = new ArrayList();
        problems = new ArrayList();
        otherProjectMarkers = new HashMap();
    }

    public void prepare(IProject project, List buildList, IProgressMonitor eclipseMonitor) {
        this.linked = false;
        IResource[] res = null;
        try {
            res = project.members();
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
        }
        int i = 0;
        while (!this.linked && i < res.length) {
            if (res[i].getType() == 2) {
                this.linked = res[i].isLinked();
            }
            ++i;
        }
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.out.println("CompilerMonitor.prepare called: IPM is " + (eclipseMonitor == null ? "Null" : "Not-Null"));
        }
        this.monitor = eclipseMonitor;
        if (this.monitor != null) {
            this.monitor.beginTask(AspectJUIPlugin.getResourceString("ajCompilation"), 100);
        }
        this.compileStartTime = System.currentTimeMillis();
        this.reportedCompiledMessages = false;
        this.reportedWovenMessages = false;
        this.compilationInProgress = true;
    }

    public void start(String configFile) {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: CompileProgressMonitor.start() called");
        }
        this.currentAjdeProgress = 0;
        if (this.monitor != null) {
            AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ProjectBuildConfigurator pbc;
                    if (CompilerMonitor.this.monitor != null && Builder.isLocalBuild && (pbc = BuildConfigurator.getBuildConfigurator().getActiveProjectBuildConfigurator()) != null) {
                        String configName = pbc.getActiveBuildConfiguration().getName();
                        CompilerMonitor.this.monitor.setTaskName("Building project with '" + configName + "' configuration");
                    }
                }
            });
        }
    }

    public void setProgressText(String text) {
        if (text.startsWith("compiled: ") && !this.reportedCompiledMessages) {
            this.reportedCompiledMessages = true;
            AJDTEventTrace.generalEvent("Time to first 'compiled:' message: " + (System.currentTimeMillis() - this.compileStartTime) + "ms");
        }
        if (text.startsWith("woven: ") && !this.reportedWovenMessages) {
            this.reportedWovenMessages = true;
            AJDTEventTrace.generalEvent("Time to first 'woven:' message: " + (System.currentTimeMillis() - this.compileStartTime) + "ms");
        }
        if (text.startsWith("compiled: ")) {
            Path resourcePath = new Path(text.substring(10));
            IWorkspaceRoot workspaceRoot = AspectJUIPlugin.getWorkspace().getRoot();
            if (this.linked) {
                IFile[] files = workspaceRoot.findFilesForLocation((IPath)resourcePath);
                int i = 0;
                while (i < files.length) {
                    affectedResources.add(files[i]);
                    ++i;
                }
            } else {
                IFile file = workspaceRoot.getFileForLocation((IPath)resourcePath);
                if (file == null) {
                    AJDTEventTrace.generalEvent("Processing progress message: Can't find eclipse resource for file with path " + text);
                } else {
                    affectedResources.add(file);
                }
            }
        }
        final String amendedText = this.removePrefix(text);
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: setProgressText(" + text + ")");
        }
        if (this.monitor != null) {
            AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (CompilerMonitor.this.monitor != null) {
                        CompilerMonitor.this.monitor.subTask(amendedText);
                    }
                }
            });
        }
    }

    public void setProgressBarVal(int newVal) {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: setProgressBarVal(" + newVal + ")");
        }
        if (newVal >= this.currentAjdeProgress) {
            this.incrementProgressBarVal("setProgressBarVal() delegating to ");
        }
    }

    public void setProgressBarMax(int maxVal) {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: setProgressBarMax(" + maxVal + ")");
        }
        this.ajdeMonitorMaxRatio = (float)maxVal / 100.0f;
    }

    public void incrementProgressBarVal() {
        this.incrementProgressBarVal("AJDE Callback:");
    }

    public void incrementProgressBarVal(String caller) {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println(String.valueOf(caller) + " incrementProgressBarVal():" + this.currentAjdeProgress);
        }
        ++this.currentAjdeProgress;
        if (this.monitor != null) {
            AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (CompilerMonitor.this.monitor != null) {
                        CompilerMonitor.this.monitor.worked(1);
                    }
                }
            });
        }
    }

    public int getProgressBarMax() {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: getProgressBarMax()");
        }
        return 100;
    }

    public synchronized void finish() {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("AJDE Callback: finish()");
        }
        this.compilationInProgress = false;
        AJDTEventTrace.generalEvent("Weaver stress level: ");
        int fastMatchOnTypeMaybe = WeaverMetrics.fastMatchOnTypeAttempted - WeaverMetrics.fastMatchOnTypeTrue - WeaverMetrics.fastMatchOnTypeFalse;
        AJDTEventTrace.generalEvent("Fast fast matching (type level) of #" + WeaverMetrics.fastMatchOnTypeAttempted + " types " + "resulting in us dismissing " + WeaverMetrics.fastMatchOnTypeFalse);
        AJDTEventTrace.generalEvent("Fast matching within the remaining #" + (WeaverMetrics.fastMatchOnTypeTrue + fastMatchOnTypeMaybe) + " types, " + "we fast matched on #" + WeaverMetrics.fastMatchOnShadowsAttempted + " shadows and dismissed #" + WeaverMetrics.fastMatchOnShadowsFalse);
        AJDTEventTrace.generalEvent("Slow match then attempted on #" + WeaverMetrics.matchAttempted + " shadows of which " + WeaverMetrics.matchTrue + " successful");
        WeaverMetrics.reset();
        if (AspectJUIPlugin.getDefault().getDisplay().isDisposed()) {
            System.err.println("Not finishing with bpm, display is disposed!");
        } else {
            AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (CompilerMonitor.this.monitor != null) {
                        if (CompilerMonitor.this.monitor != null) {
                            CompilerMonitor.this.monitor.worked(100);
                        }
                        if (CompilerMonitor.this.monitor != null) {
                            CompilerMonitor.this.monitor.done();
                        }
                        CompilerMonitor.this.monitor = null;
                    }
                }
            });
        }
    }

    public boolean finished() {
        return !this.compilationInProgress;
    }

    private String removePrefix(String msg) {
        int loc;
        String ret = msg;
        IProject p = AspectJUIPlugin.getDefault().getCurrentProject();
        String projectLocation = String.valueOf(p.getLocation().toOSString()) + "\\";
        if (msg.indexOf(projectLocation) != -1) {
            ret = String.valueOf(msg.substring(0, msg.indexOf(projectLocation))) + msg.substring(msg.indexOf(projectLocation) + projectLocation.length());
        } else if (msg.indexOf(projectLocation = projectLocation.replace('\\', '/')) != -1) {
            ret = String.valueOf(msg.substring(0, msg.indexOf(projectLocation))) + msg.substring(msg.indexOf(projectLocation) + projectLocation.length());
        }
        if (ret.startsWith("might need to weave")) {
            ret = "weaving ...";
        }
        if (ret.startsWith("directory classpath entry does not exist: null")) {
            ret = "";
        }
        if (ret.startsWith("woven") && ret.indexOf("(from") != -1 && (loc = ret.indexOf("(from")) != -1) {
            String fromPiece = ret.substring(loc);
            int lastSlash = fromPiece.lastIndexOf("/");
            if (lastSlash == -1) {
                lastSlash = fromPiece.lastIndexOf("\\");
            }
            if (lastSlash != -1) {
                fromPiece = fromPiece.substring(lastSlash + 1);
                ret = String.valueOf(ret.substring(0, loc)) + " (" + fromPiece;
            } else {
                int space = fromPiece.indexOf(" ");
                if (space != -1) {
                    ret = String.valueOf(ret.substring(0, loc)) + " (" + fromPiece.substring(space + 1);
                }
            }
        }
        return ret;
    }

    public void addSourcelineTask(String message, ISourceLocation location, IMessage.Kind kind) {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("CompilerMessage received ]" + message + "[");
        }
        problems.add(new ProblemTracker(message, location, kind));
    }

    public void addProjectTask(String message, IMessage.Kind kind) {
        problems.add(new ProblemTracker(message, null, kind));
    }

    public void clearTasks() {
        if (AspectJUIPlugin.DEBUG_COMPILER) {
            System.err.println("clearTasks() called");
        }
        affectedResources = new ArrayList();
        problems = new ArrayList();
    }

    public static void showOutstandingProblems() {
        if (problems.size() > 0 || affectedResources.size() > 0) {
            new CompilerMonitor().showMessages();
        }
    }

    private void showMessages() {
        IWorkspaceRunnable r = new IWorkspaceRunnable(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.StaticPart ajc$tjp_1;
            private static final JoinPoint.StaticPart ajc$tjp_2;
            private static final JoinPoint.StaticPart ajc$tjp_3;

            public void run(IProgressMonitor monitor) {
                try {
                    Iterator affectedResourceIterator = affectedResources.iterator();
                    IResource ir = null;
                    while (affectedResourceIterator.hasNext()) {
                        ir = (IResource)affectedResourceIterator.next();
                        try {
                            if (!ir.exists()) continue;
                            ir.deleteMarkers("org.eclipse.jdt.core.problem", false, 2);
                            ir.deleteMarkers("org.eclipse.ajdt.ui.problemmarker", true, 2);
                            ir.deleteMarkers("org.eclipse.core.resources.taskmarker", true, 2);
                        }
                        catch (ResourceException resourceException) {
                            ResourceException resourceException2 = resourceException;
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(resourceException2, this, ajc$tjp_0, ajc$tjp_1);
                            ResourceException re = resourceException2;
                            AJDTEventTrace.generalEvent("Failed marker deletion: resource=" + ir.getLocation());
                            throw re;
                        }
                    }
                    IProject project = Builder.getLastBuildTarget();
                    Iterator problemIterator = problems.iterator();
                    ProblemTracker p = null;
                    while (problemIterator.hasNext()) {
                        p = (ProblemTracker)problemIterator.next();
                        ir = null;
                        IMarker marker = null;
                        try {
                            if (p.location != null) {
                                ir = CompilerMonitor.this.locationToResource(p.location, project);
                                int prio = CompilerMonitor.this.getTaskPriority(p);
                                if (prio != -1) {
                                    marker = ir.createMarker("org.eclipse.core.resources.taskmarker");
                                    marker.setAttribute("priority", prio);
                                } else if (p.declaredErrorOrWarning) {
                                    marker = ir.createMarker("org.eclipse.ajdt.ui.problemmarker");
                                } else {
                                    marker = ir.createMarker("org.eclipse.jdt.core.problem");
                                    marker.setAttribute("id", p.id);
                                    if (p.start >= 0 && p.end >= 0) {
                                        marker.setAttribute("charStart", (Object)new Integer(p.start));
                                        marker.setAttribute("charEnd", (Object)new Integer(p.end + 1));
                                    }
                                }
                                if (!ir.getProject().equals((Object)project)) {
                                    CompilerMonitor.this.addOtherProjectMarker(project, marker);
                                }
                                if (p.location.getLine() > 0) {
                                    marker.setAttribute("lineNumber", (Object)new Integer(p.location.getLine()));
                                }
                            } else {
                                marker = project.createMarker("org.eclipse.jdt.core.problem");
                            }
                            CompilerMonitor.this.setSeverity(marker, p.kind);
                            if (p.extraLocs != null && p.extraLocs.size() > 0) {
                                int relCount = 0;
                                Iterator iter = p.extraLocs.iterator();
                                while (iter.hasNext()) {
                                    ISourceLocation sLoc = (ISourceLocation)iter.next();
                                    marker.setAttribute("relatedLocations-" + relCount++, (Object)(String.valueOf(sLoc.getSourceFile().getAbsolutePath()) + ":::" + sLoc.getLine() + ":::" + sLoc.getEndLine() + ":::" + sLoc.getColumn()));
                                }
                            }
                            CompilerMonitor.this.setMessage(marker, p.message);
                        }
                        catch (ResourceException resourceException) {
                            ResourceException resourceException3 = resourceException;
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(resourceException3, this, ajc$tjp_2, ajc$tjp_1);
                            ResourceException re = resourceException3;
                            AJDTEventTrace.generalEvent("Failed marker creation: resource=" + p.location.getSourceFile().getPath() + " line=" + p.location.getLine() + " message=" + p.message);
                            throw re;
                        }
                    }
                    CompilerMonitor.this.clearTasks();
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, this, ajc$tjp_3, ajc$tjp_1);
                    Exception e = exception2;
                    AspectJUIPlugin.getDefault().getErrorHandler().handleError("Error creating marker", e);
                }
            }

            static {
                Factory factory = new Factory("CompilerMonitor.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor$5"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor$5-org.eclipse.core.internal.resources.ResourceException-re-"), 545);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor$5-org.eclipse.core.runtime.IProgressMonitor:-monitor:--void-"), 530);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor$5-org.eclipse.core.internal.resources.ResourceException-re-"), 630);
                ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor$5-java.lang.Exception-e-"), 642);
            }
        };
        try {
            AspectJUIPlugin.getWorkspace().run(r, null);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_2, ajc$tjp_3);
            CoreException cEx = coreException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError("AJDT Error adding problem markers", cEx);
        }
    }

    private void setSeverity(IMarker marker, IMessage.Kind kind) throws CoreException {
        if (kind == IMessage.ERROR) {
            marker.setAttribute("severity", (Object)new Integer(2));
        } else if (kind == IMessage.WARNING) {
            marker.setAttribute("severity", (Object)new Integer(1));
        } else {
            marker.setAttribute("severity", (Object)new Integer(0));
        }
    }

    private void setMessage(IMarker marker, String message) throws CoreException {
        if (message.indexOf("\":") != -1 && message.indexOf(", at line") != -1) {
            String hackedMessage = message.substring(message.indexOf("\":") + 2);
            message = hackedMessage.substring(0, hackedMessage.indexOf(", at line"));
        }
        marker.setAttribute("message", (Object)message);
    }

    private int getTaskPriority(ProblemTracker p) {
        if (p == null) {
            return -1;
        }
        String message = p.message;
        Preferences pref = JavaCore.getPlugin().getPluginPreferences();
        String tags = pref.getString("org.eclipse.jdt.core.compiler.taskTags");
        String caseSens = pref.getString("org.eclipse.jdt.core.compiler.taskCaseSensitive");
        String priorities = pref.getString("org.eclipse.jdt.core.compiler.taskPriorities");
        boolean caseSensitive = !caseSens.equals("disabled");
        StringTokenizer tagTokens = new StringTokenizer(tags, ",");
        StringTokenizer priorityTokens = new StringTokenizer(priorities, ",");
        while (tagTokens.hasMoreTokens()) {
            String temp;
            String prio = priorityTokens.nextToken();
            String token = tagTokens.nextToken();
            if (!(caseSensitive ? message.startsWith(token) : token.length() <= message.length() && token.compareToIgnoreCase(temp = message.substring(0, token.length())) == 0)) continue;
            return this.getPrioritiyFlag(prio);
        }
        return -1;
    }

    private int getPrioritiyFlag(String prio) {
        if (prio.equals("NORMAL")) {
            return 1;
        }
        if (prio.equals("HIGH")) {
            return 2;
        }
        return 0;
    }

    private IResource locationToResource(ISourceLocation isl, IProject project) {
        IResource ir = null;
        String loc = isl.getSourceFile().getPath();
        ir = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(loc, project);
        if (ir == null) {
            ir = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(loc);
            if (ir == null) {
                ir = this.tryToFindResource(loc);
            }
            if (ir == null) {
                AJDTEventTrace.generalEvent("Whilst adding post compilation markers to resources, cannot locate valid eclipse resource for file " + loc);
            }
        }
        return ir;
    }

    private IResource tryToFindResource(String fileName) {
        IProject ret = null;
        String toFind = fileName.replace('\\', '/');
        IProject project = AspectJUIPlugin.getDefault().getCurrentProject();
        IJavaProject jProject = JavaCore.create((IProject)project);
        try {
            IClasspathEntry[] classpathEntries = jProject.getResolvedClasspath(false);
            int i = 0;
            while (i < classpathEntries.length) {
                IClasspathEntry cpEntry = classpathEntries[i];
                if (cpEntry.getEntryKind() == 3) {
                    IPath sourcePath = cpEntry.getPath();
                    sourcePath = sourcePath.removeFirstSegments(1);
                    IResource[] srcContainer = new IResource[]{project.findMember(sourcePath)};
                    ret = this.findFile(srcContainer, toFind);
                    if (ret != null) {
                        break;
                    }
                } else if (cpEntry.getEntryKind() == 2) {
                    IPath projPath = cpEntry.getPath();
                    IResource projResource = AspectJUIPlugin.getWorkspace().getRoot().findMember(projPath);
                    ret = this.findFile(new IResource[]{projResource}, toFind);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_4, ajc$tjp_5);
            JavaModelException jmEx = javaModelException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("ajErrorDialogTitle"), AspectJUIPlugin.getResourceString("jmCoreException"), jmEx);
        }
        if (ret == null) {
            ret = project;
        }
        return ret;
    }

    private IResource findFile(IResource[] srcContainer, String name) {
        IResource ret = null;
        try {
            int i = 0;
            while (i < srcContainer.length) {
                IResource ir = srcContainer[i];
                if (ir.getFullPath().toString().endsWith(name)) {
                    ret = ir;
                } else if (!(ir instanceof IContainer) || (ret = this.findFile(((IContainer)ir).members(), name)) == null) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, this, ajc$tjp_6, ajc$tjp_7);
        }
        return ret;
    }

    private void addOtherProjectMarker(IProject p, IMarker m) {
        if (!otherProjectMarkers.containsKey(p.getName())) {
            otherProjectMarkers.put(p.getName(), new ArrayList());
        }
        List l = (List)otherProjectMarkers.get(p.getName());
        l.add(m);
    }

    public static void clearOtherProjectMarkers(IProject p) {
        List l = (List)otherProjectMarkers.get(p.getName());
        if (l != null) {
            ListIterator li = l.listIterator();
            while (li.hasNext()) {
                IMarker m = (IMarker)li.next();
                try {
                    m.delete();
                }
                catch (CoreException coreException) {
                    CoreException coreException2 = coreException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_8, ajc$tjp_9);
                }
            }
            l.clear();
        }
    }

    public void addSourcelineTask(IMessage msg) {
        if (msg.getSourceLocation() == null) {
            this.addProjectTask(msg.getMessage(), msg.getKind());
        } else {
            problems.add(new ProblemTracker(msg.getMessage(), msg.getSourceLocation(), msg.getKind(), msg.getDeclared(), msg.getExtraSourceLocations(), msg.getID(), msg.getSourceStart(), msg.getSourceEnd()));
        }
    }

    public boolean hasWarning() {
        return false;
    }

    class ProblemAdder
    implements IWorkspaceRunnable {
        private Iterator problemIterator;
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.StaticPart ajc$tjp_1;

        public ProblemAdder(Iterator it) {
            this.problemIterator = it;
        }

        public void run(IProgressMonitor monitor) {
            while (this.problemIterator.hasNext()) {
                ProblemTracker p = (ProblemTracker)this.problemIterator.next();
                IResource ir = null;
                if (p.location == null) continue;
                String loc = p.location.getSourceFile().getAbsolutePath();
                ir = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(loc);
                if (ir == null) {
                    ir = AspectJUIPlugin.getDefault().getCurrentProject();
                }
                try {
                    IMarker im = ir.createMarker("org.eclipse.jdt.core.problem");
                    if (p.location.getLine() > 0) {
                        im.setAttribute("lineNumber", p.location.getLine());
                    }
                    p.location.getColumn();
                    if (p.kind == IMessage.ERROR) {
                        im.setAttribute("severity", 2);
                    } else if (p.kind == IMessage.WARNING) {
                        im.setAttribute("severity", 1);
                    } else {
                        im.setAttribute("severity", 0);
                    }
                    if (p.message.indexOf("\":") != -1 && p.message.indexOf(", at line") != -1) {
                        String hackedMessage = p.message.substring(p.message.indexOf("\":") + 2);
                        hackedMessage = hackedMessage.substring(0, hackedMessage.indexOf(", at line"));
                        im.setAttribute("message", (Object)hackedMessage);
                        continue;
                    }
                    im.setAttribute("message", (Object)p.message);
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, this, ajc$tjp_0, ajc$tjp_1);
                    Exception e = exception2;
                    AspectJUIPlugin.getDefault().getErrorHandler().handleError("Error creating marker", e);
                }
            }
            CompilerMonitor.this.clearTasks();
        }

        static {
            Factory factory = new Factory("CompilerMonitor.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor$ProblemAdder"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor$ProblemAdder-java.lang.Exception-e-"), 951);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor$ProblemAdder-org.eclipse.core.runtime.IProgressMonitor:-monitor:--void-"), 905);
        }
    }

    class ProblemTracker {
        public ISourceLocation location;
        public String message;
        public IMessage.Kind kind;
        public boolean declaredErrorOrWarning = false;
        public List extraLocs;
        public int id;
        public int start;
        public int end;

        public ProblemTracker(String m, ISourceLocation l, IMessage.Kind k) {
            this(m, l, k, false, null, -1, -1, -1);
        }

        public ProblemTracker(String m, ISourceLocation l, IMessage.Kind k, boolean deow, List extraLocs, int id, int start, int end) {
            this.location = l;
            this.message = m;
            this.kind = k;
            this.declaredErrorOrWarning = deow;
            this.extraLocs = extraLocs;
            this.id = id;
            this.start = start;
            this.end = end;
        }
    }
}

