/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.BuildConfiguration;
import org.eclipse.ajdt.buildconfigurator.BuildConfigurator;
import org.eclipse.ajdt.buildconfigurator.ProjectBuildConfigurator;
import org.eclipse.ajdt.internal.core.builder.BuildClasspathResolver;
import org.eclipse.ajdt.internal.ui.ajde.RuntimeClasspathCalculator;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.osgi.framework.Bundle;

public class ProjectProperties
implements ProjectPropertiesAdapter {
    private static final String AJDE_VERSION_KEY = "ajde.version";
    private static final String AJDE_DEV = "@AJDEVERSION@";
    private static final String AJDE_VERSION_DEV = "9.9.9";
    private Hashtable fileToResourceHt = null;
    private String aspectjrtPath = null;
    public static final FilenameFilter ASPECTJ_SOURCE_ONLY_FILTER;
    public static final FilenameFilter ASPECTJ_SOURCE_FILTER;
    public static final FilenameFilter RESOURCE_FILTER;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;
    private static final JoinPoint.StaticPart ajc$tjp_14;
    private static final JoinPoint.StaticPart ajc$tjp_15;
    private static final JoinPoint.StaticPart ajc$tjp_16;
    private static final JoinPoint.StaticPart ajc$tjp_17;

    static {
        Factory factory = new Factory("ProjectProperties.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.ProjectProperties"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.core.runtime.CoreException-ce-"), 133);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getOutputPath-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties----java.lang.String-"), 97);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-java.lang.Exception-<missing>-"), 672);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getAllFiles-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-[Lorg.eclipse.core.resources.IResource;:java.util.List:java.util.Hashtable:org.eclipse.ajdt.internal.ui.ajde.ProjectProperties$FilenameFilter:org.eclipse.ajdt.buildconfigurator.BuildConfiguration:-resource_list:allProjectFiles:fileToResourceHt:filter:bc:--void-"), 647);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-java.lang.Exception-<missing>-"), 695);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getProjectRelativePaths-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-[Lorg.eclipse.core.resources.IResource;:java.util.List:org.eclipse.ajdt.internal.ui.ajde.ProjectProperties$FilenameFilter:int:-resource_list:allProjectFiles:filter:trimSegments:--void-"), 679);
        ajc$tjp_14 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.jdt.core.JavaModelException-jmEx-"), 822);
        ajc$tjp_15 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getSourcePathResources-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties----java.util.Map-"), 767);
        ajc$tjp_16 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.core.runtime.CoreException-<missing>-"), 906);
        ajc$tjp_17 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getLinkedChildFolders-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.core.resources.IResource:-resource:--java.util.ArrayList-"), 896);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.core.runtime.CoreException-<missing>-"), 239);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getOldClasspath-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties----java.lang.String-"), 219);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-java.lang.Exception-<missing>-"), 457);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-clearMarkers-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-boolean:-recurse:--void-"), 443);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-org.eclipse.jdt.core.JavaModelException-<missing>-"), 522);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-findResource-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-java.lang.String:org.eclipse.core.resources.IProject:-fullPath:p:--org.eclipse.core.resources.IResource-"), 478);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.ajde.ProjectProperties-java.io.IOException-<missing>-"), 592);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getAspectjrtClasspath-org.eclipse.ajdt.internal.ui.ajde.ProjectProperties----java.lang.String-"), 541);
        ASPECTJ_SOURCE_ONLY_FILTER = new FilenameFilter(){

            public boolean accept(String name) {
                return name.endsWith(".aj");
            }
        };
        ASPECTJ_SOURCE_FILTER = new FilenameFilter(){

            public boolean accept(String name) {
                return name.endsWith(".java") || name.endsWith(".aj");
            }
        };
        RESOURCE_FILTER = new FilenameFilter(){

            public boolean accept(String name) {
                return !name.endsWith(".java") && !name.endsWith(".aj") && !name.endsWith(".class");
            }
        };
    }

    public String getAjcWorkingDir() {
        return AspectJUIPlugin.getWorkspace().getRoot().getLocation().toOSString();
    }

    public String getOutputPath() {
        try {
            IProject currProject = AspectJUIPlugin.getDefault().getCurrentProject();
            IJavaProject jProject = JavaCore.create((IProject)currProject);
            IPath workspaceRelativeOutputPath = jProject.getOutputLocation();
            if (workspaceRelativeOutputPath.segmentCount() == 1) {
                return jProject.getResource().getLocation().toOSString();
            }
            IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
            return out.getLocation().toOSString();
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_0, ajc$tjp_1);
            CoreException ce = coreException2;
            Ajde.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("noOutputDir"), (Throwable)ce);
            return null;
        }
    }

    public String getProjectName() {
        return AspectJUIPlugin.getDefault().getCurrentProject().getName();
    }

    public String getClassToExecute() {
        System.err.println("*** AJ Plugin: ProjectProperties.getClassToExecute NOT IMPLEMENTED ***");
        return null;
    }

    public String getRootProjectDir() {
        IProject project = AspectJUIPlugin.getDefault().getCurrentProject();
        return project.getLocation().toOSString();
    }

    public List getProjectSourceFiles() {
        IProject activeProject = AspectJUIPlugin.getDefault().getCurrentProject();
        return this.getProjectSourceFiles(activeProject, ASPECTJ_SOURCE_FILTER);
    }

    public List getProjectSourceFiles(IProject project, FilenameFilter filter) {
        ProjectBuildConfigurator pbc = BuildConfigurator.getBuildConfigurator().getProjectBuildConfigurator(project);
        if (pbc != null) {
            return pbc.getActiveBuildConfiguration().getIncludedJavaFiles(filter);
        }
        return new ArrayList(0);
    }

    public String getProjectSourcePath() {
        IProject p = AspectJUIPlugin.getDefault().getCurrentProject();
        return p.getLocation().toOSString();
    }

    public String getClasspath() {
        IProject proj = AspectJUIPlugin.getDefault().getCurrentProject();
        IJavaProject jp = JavaCore.create((IProject)proj);
        return new BuildClasspathResolver().getClasspath(AspectJUIPlugin.getWorkspace().getRoot(), jp);
    }

    public String getOldClasspath() {
        StringBuffer classpath = new StringBuffer();
        try {
            IProject proj = AspectJUIPlugin.getDefault().getCurrentProject();
            IJavaProject jp = JavaCore.create((IProject)proj);
            IRuntimeClasspathEntry[] rtcp = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)jp);
            HashSet<String> cp = new HashSet<String>();
            int i = 0;
            while (i < rtcp.length) {
                IRuntimeClasspathEntry[] resolved = RuntimeClasspathCalculator.resolveRuntimeClasspathEntry(rtcp[i], jp);
                int j = 0;
                while (j < resolved.length) {
                    cp.add(resolved[j].getLocation());
                    ++j;
                }
                ++i;
            }
            Iterator it = cp.iterator();
            while (it.hasNext()) {
                classpath.append(it.next());
                classpath.append(File.pathSeparator);
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_2, ajc$tjp_3);
        }
        if (AspectJUIPlugin.isDebugging) {
            System.out.println("Using classpath: " + classpath);
        }
        return classpath.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getJavaProjectClasspath(IProject project, Set projectClasspathSet, Set circularDependencyPreventer, boolean processingDependantProjects) throws CoreException {
        String projectLocalPrefix = String.valueOf(File.separator) + project.getName();
        String prependPath = project.getLocation().removeLastSegments(1).toOSString();
        IJavaProject jProject = JavaCore.create((IProject)project);
        String outputLocation = jProject.getOutputLocation().toOSString();
        if (processingDependantProjects) {
            projectClasspathSet.add(String.valueOf(prependPath) + outputLocation);
        }
        IClasspathEntry[] classpathEntries = jProject.getResolvedClasspath(false);
        int i = 0;
        while (i < classpathEntries.length) {
            block9: {
                String cpstring = classpathEntries[i].getPath().toOSString();
                if (!processingDependantProjects || classpathEntries[i].isExported()) {
                    switch (classpathEntries[i].getEntryKind()) {
                        case 1: {
                            if (cpstring == null || !cpstring.startsWith(projectLocalPrefix)) break;
                            cpstring = String.valueOf(prependPath) + cpstring;
                            break;
                        }
                        case 2: {
                            String name = classpathEntries[i].getPath().lastSegment();
                            IProject projectDependancy = AspectJUIPlugin.getWorkspace().getRoot().getProject(name);
                            if (projectDependancy.exists() && projectDependancy.isOpen() && projectDependancy.hasNature("org.eclipse.jdt.core.javanature") && !circularDependencyPreventer.contains(projectDependancy)) {
                                circularDependencyPreventer.add(projectDependancy);
                                this.getJavaProjectClasspath(projectDependancy, projectClasspathSet, circularDependencyPreventer, true);
                            }
                            break block9;
                        }
                        case 3: {
                            cpstring = String.valueOf(prependPath) + cpstring;
                        }
                    }
                    projectClasspathSet.add(cpstring);
                }
            }
            ++i;
        }
    }

    public String getBootClasspath() {
        return null;
    }

    public String getExecutionArgs() {
        String options = AspectJPreferences.getCompilerOptions();
        return options;
    }

    public String getVmArgs() {
        return null;
    }

    public void clearMarkers(boolean recurse) {
        IProject currProject = AspectJUIPlugin.getDefault().getCurrentProject();
        try {
            currProject.deleteMarkers("org.eclipse.jdt.core.problem", false, recurse ? 2 : 0);
            currProject.deleteMarkers("org.eclipse.ajdt.ui.problemmarker", true, recurse ? 2 : 0);
            currProject.deleteMarkers("org.eclipse.core.resources.taskmarker", true, recurse ? 2 : 0);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, this, ajc$tjp_4, ajc$tjp_5);
        }
    }

    public IResource findResource(String fullPath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(fullPath);
        return root.getFileForLocation((IPath)path);
    }

    public IResource findResource(String fullPath, IProject p) {
        String toMatch = fullPath.replace('\\', '/');
        try {
            IJavaProject jp = JavaCore.create((IProject)p);
            IClasspathEntry[] cpes = jp.getRawClasspath();
            int i = 0;
            while (i < cpes.length) {
                IPath pe;
                IClasspathEntry e = cpes[i];
                if (e.getEntryKind() == 3 && (pe = e.getPath()).segment(0).equals(p.getName())) {
                    IProject iproj;
                    String postfix;
                    Path postfixPath;
                    IResource ires = p.findMember(pe.removeFirstSegments(1));
                    if (ires instanceof IFolder) {
                        IFolder f = (IFolder)ires;
                        if (toMatch.startsWith(f.getLocation().toString()) && f.exists((IPath)(postfixPath = new Path(postfix = toMatch.substring(f.getLocation().toString().length()))))) {
                            return f.findMember((IPath)postfixPath);
                        }
                    } else if (ires instanceof IProject && toMatch.startsWith((iproj = (IProject)ires).getLocation().toString()) && iproj.exists((IPath)(postfixPath = new Path(postfix = toMatch.substring(iproj.getLocation().toString().length()))))) {
                        return iproj.findMember((IPath)postfixPath);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_6, ajc$tjp_7);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath rootPath = root.getLocation();
        Path path = new Path(fullPath);
        if (rootPath.isPrefixOf((IPath)path)) {
            path = path.removeFirstSegments(rootPath.segmentCount());
        }
        IResource ret = p.findMember((IPath)path);
        return ret;
    }

    public String getAspectjrtClasspath() {
        if (this.aspectjrtPath == null) {
            StringBuffer cpath = new StringBuffer();
            Bundle ajdeBundle = Platform.getBundle((String)"org.aspectj.runtime");
            String pluginLoc = null;
            if (ajdeBundle != null) {
                URL installLoc = ajdeBundle.getEntry("/");
                URL resolved = null;
                try {
                    resolved = Platform.resolve((URL)installLoc);
                    pluginLoc = resolved.toExternalForm();
                }
                catch (IOException iOException) {
                    IOException iOException2 = iOException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException2, this, ajc$tjp_8, ajc$tjp_9);
                }
            }
            if (pluginLoc != null && pluginLoc.startsWith("file:")) {
                cpath.append(pluginLoc.substring("file:".length()));
                cpath.append("aspectjrt.jar");
            }
            if (new File(cpath.toString()).exists()) {
                this.aspectjrtPath = cpath.toString();
            } else {
                IPath rootPath = AspectJUIPlugin.getWorkspace().getRoot().getLocation();
                IPath installPath = rootPath.removeLastSegments(1);
                cpath = new StringBuffer().append(installPath.toOSString());
                cpath.append(File.separator);
                cpath.append("workspace");
                cpath.append(File.separator);
                cpath.append("org.aspectj.runtime");
                cpath.append(File.separator);
                cpath.append("aspectjrt.jar");
                if (new File(cpath.toString()).exists()) {
                    this.aspectjrtPath = cpath.toString();
                }
            }
        }
        return this.aspectjrtPath;
    }

    private void getAllFiles(IResource[] resource_list, List allProjectFiles, Hashtable fileToResourceHt, FilenameFilter filter, BuildConfiguration bc) {
        try {
            int i = 0;
            while (i < resource_list.length) {
                IResource ir = resource_list[i];
                if (ir instanceof IContainer) {
                    this.getAllFiles(((IContainer)ir).members(), allProjectFiles, fileToResourceHt, filter, bc);
                } else if (filter.accept(ir.getName()) && bc.isIncluded(ir)) {
                    allProjectFiles.add(new File(ir.getLocation().toOSString()));
                    if (fileToResourceHt != null) {
                        fileToResourceHt.put(new File(ir.getLocation().toOSString()), ir);
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, this, ajc$tjp_10, ajc$tjp_11);
        }
    }

    private void getProjectRelativePaths(IResource[] resource_list, List allProjectFiles, FilenameFilter filter, int trimSegments) {
        try {
            int i = 0;
            while (i < resource_list.length) {
                IResource ir = resource_list[i];
                if (ir instanceof IContainer) {
                    this.getProjectRelativePaths(((IContainer)ir).members(), allProjectFiles, filter, trimSegments);
                } else if (filter.accept(ir.getName())) {
                    String[] segments = ir.getProjectRelativePath().segments();
                    String path = "";
                    int j = trimSegments;
                    while (j < segments.length) {
                        path = String.valueOf(path) + segments[j];
                        if (j < segments.length - 1) {
                            path = String.valueOf(path) + '/';
                        }
                        ++j;
                    }
                    allProjectFiles.add(path);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, this, ajc$tjp_12, ajc$tjp_13);
        }
    }

    public List getBuildConfigFiles() {
        ArrayList<String> lstFiles_Strings = new ArrayList<String>();
        List lstFiles_IResources = AspectJUIPlugin.getDefault().getListOfConfigFilesForCurrentProject();
        Iterator iter = lstFiles_IResources.iterator();
        while (iter.hasNext()) {
            IResource ir = (IResource)iter.next();
            lstFiles_Strings.add(ir.getFullPath().toOSString());
        }
        return lstFiles_Strings;
    }

    public String getDefaultBuildConfigFile() {
        String defaultLstFile = String.valueOf(AspectJUIPlugin.getDefault().getCurrentProject().getLocation().toOSString()) + File.separator + ".generated.lst";
        return defaultLstFile;
    }

    public String getLastActiveBuildConfigFile() {
        String currentLstFile = AspectJUIPlugin.getBuildConfigurationFile(AspectJUIPlugin.getDefault().getCurrentProject());
        return currentLstFile;
    }

    public Set getInJars() {
        return AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getInJars();
    }

    public Map getSourcePathResources() {
        IProject project = AspectJUIPlugin.getDefault().getCurrentProject();
        IJavaProject jProject = JavaCore.create((IProject)project);
        HashMap<String, File> map = new HashMap<String, File>();
        try {
            String realOutputLocation;
            IClasspathEntry[] classpathEntries = jProject.getResolvedClasspath(false);
            IPath workspaceRelativeOutputPath = jProject.getOutputLocation();
            if (workspaceRelativeOutputPath.segmentCount() == 1) {
                realOutputLocation = jProject.getResource().getLocation().toOSString();
            } else {
                IFolder out = ResourcesPlugin.getWorkspace().getRoot().getFolder(workspaceRelativeOutputPath);
                realOutputLocation = out.getLocation().toOSString();
            }
            int i = 0;
            while (i < classpathEntries.length) {
                if (classpathEntries[i].getEntryKind() == 3) {
                    IClasspathEntry sourceEntry = classpathEntries[i];
                    IPath sourcePath = sourceEntry.getPath();
                    ArrayList files = new ArrayList();
                    sourcePath = sourcePath.removeFirstSegments(1);
                    IResource[] srcContainer = new IResource[]{project.findMember(sourcePath)};
                    this.getProjectRelativePaths(srcContainer, files, RESOURCE_FILTER, srcContainer[0].getFullPath().segmentCount() - 1);
                    ArrayList linkedSrcFolders = this.getLinkedChildFolders(srcContainer[0]);
                    Iterator it = files.iterator();
                    while (it.hasNext()) {
                        String relPath = (String)it.next();
                        String fullPath = this.getResourceFullPath(srcContainer[0], relPath, linkedSrcFolders);
                        if (fullPath.startsWith(realOutputLocation) || relPath.endsWith(".classpath") || relPath.endsWith(".project") || relPath.endsWith(".ajsym") || relPath.endsWith(".lst")) continue;
                        File file = new File(fullPath);
                        map.put(relPath, file);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_14, ajc$tjp_15);
            JavaModelException jmEx = javaModelException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError(AspectJUIPlugin.getResourceString("ajErrorDialogTitle"), AspectJUIPlugin.getResourceString("jmCoreException"), jmEx);
        }
        return map;
    }

    public boolean getIncrementalMode() {
        return AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getIncrementalMode();
    }

    public String getOutJar() {
        return AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getOutJar();
    }

    public Set getSourceRoots() {
        return AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getSourceRoots();
    }

    public Set getAspectPath() {
        return AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getAspectPath();
    }

    private ArrayList getLinkedChildFolders(IResource resource) {
        ArrayList<IResource> resultList = new ArrayList<IResource>();
        if (resource instanceof IContainer) {
            try {
                IResource[] children = ((IContainer)resource).members();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof IFolder && children[i].isLinked()) {
                        resultList.add(children[i]);
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, this, ajc$tjp_16, ajc$tjp_17);
            }
        }
        return resultList;
    }

    private String getResourceFullPath(IResource srcContainer, String relPath, ArrayList linkedFolders) {
        String result = null;
        if (relPath.lastIndexOf(47) != -1) {
            Iterator it = linkedFolders.iterator();
            while (it.hasNext()) {
                IFolder folder = (IFolder)it.next();
                String linkedFolderName = folder.getName();
                if (relPath.indexOf(String.valueOf(linkedFolderName) + "/") != 0) continue;
                result = String.valueOf(folder.getLocation().toString()) + relPath.substring(linkedFolderName.length());
                result = result.replace('/', File.separatorChar);
                break;
            }
        }
        if (result == null) {
            result = String.valueOf(srcContainer.getLocation().toOSString()) + File.separator + relPath;
        }
        return result;
    }

    public Set getInpath() {
        return AspectJUIPlugin.getDefault().getAjdtBuildOptionsAdapter().getInPath();
    }

    public static interface FilenameFilter {
        public boolean accept(String var1);
    }
}

