/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.ajde.Ajde;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.internal.ui.editor.AJSourceViewerConfiguration;
import org.eclipse.ajdt.internal.ui.editor.AspectJContentOutlinePage;
import org.eclipse.ajdt.internal.ui.editor.AspectJTextTools;
import org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionAssistant;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences;
import org.eclipse.ajdt.javamodel.AJCompilationUnitManager;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.IWorkingCopyManagerExtension;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AspectJEditor
extends CompilationUnitEditor {
    public static final String ASPECTJ_EDITOR_ID = "org.eclipse.ajdt.internal.ui.editor.CompilationUnitEditor";
    private AspectJContentOutlinePage contentOutlinePage;
    private AnnotationAccessWrapper annotationAccessWrapper;
    private static Set activeEditorList;
    static Set modifiedAspectToClass;
    private AJSourceViewerConfiguration fAJSourceViewerConfiguration;
    private boolean isEditingAjFile = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;

    static {
        Factory factory = new Factory("AspectJEditor.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AspectJEditor"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AspectJEditor-java.lang.ClassNotFoundException-<missing>-"), 159);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getAdapter-org.eclipse.ajdt.internal.ui.editor.AspectJEditor-java.lang.Class:-key:--java.lang.Object-"), 159);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AspectJEditor-java.lang.ClassNotFoundException-<missing>-"), 164);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AspectJEditor-java.lang.ClassNotFoundException-<missing>-"), 167);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AspectJEditor-java.lang.ClassNotFoundException-<missing>-"), 281);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-doSave-org.eclipse.ajdt.internal.ui.editor.AspectJEditor-org.eclipse.core.runtime.IProgressMonitor:-progressMonitor:--void-"), 236);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AspectJEditor-org.eclipse.core.runtime.CoreException-<missing>-"), 314);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getContentOutlinePage-org.eclipse.ajdt.internal.ui.editor.AspectJEditor-java.lang.Class:-key:--java.lang.Object-"), 299);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AspectJEditor-org.eclipse.jdt.core.JavaModelException-<missing>-"), 421);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-dispose-org.eclipse.ajdt.internal.ui.editor.AspectJEditor----void-"), 410);
        activeEditorList = new HashSet();
        modifiedAspectToClass = new HashSet();
    }

    public AspectJEditor() {
        this.setRulerContextMenuId("#AJCompilationUnitRulerContext");
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException2 = classNotFoundException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
                throw new NoClassDefFoundError(classNotFoundException2.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return new AJTextOperationTarget((ITextOperationTarget)super.getAdapter(key));
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException3 = classNotFoundException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException3, (Object)this, ajc$tjp_2, ajc$tjp_1);
                throw new NoClassDefFoundError(classNotFoundException3.getMessage());
            }
        }
        if (key.equals(clazz2)) {
            return this.getContentOutlinePage(key);
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.jface.text.source.IAnnotationAccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClassNotFoundException classNotFoundException4 = classNotFoundException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException4, (Object)this, ajc$tjp_3, ajc$tjp_1);
                throw new NoClassDefFoundError(classNotFoundException4.getMessage());
            }
        }
        if (key.equals(clazz3)) {
            Object o = super.getAdapter(key);
            if (o instanceof IAnnotationAccessExtension) {
                if (this.annotationAccessWrapper == null) {
                    this.annotationAccessWrapper = new AnnotationAccessWrapper();
                }
                this.annotationAccessWrapper.setWrapped((IAnnotationAccessExtension)o);
                return this.annotationAccessWrapper;
            }
            return o;
        }
        return super.getAdapter(key);
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p.isDeleted((Object)this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                MessageDialog.openError((Shell)shell, (String)"CompilationUnitEditor.error.saving.title1", (String)"CompilationUnitEditor.error.saving.message1");
            }
        } else {
            IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            ICompilationUnit unit = manager.getWorkingCopy(this.getEditorInput());
            if (unit != null) {
                ICompilationUnit iCompilationUnit = unit;
                synchronized (iCompilationUnit) {
                    this.performSave(false, progressMonitor);
                }
            } else {
                this.performSave(false, progressMonitor);
            }
        }
        if (this.contentOutlinePage == null) {
            Object outlinePage;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClassNotFoundException classNotFoundException2 = classNotFoundException;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(classNotFoundException2, (Object)this, ajc$tjp_4, ajc$tjp_5);
                    throw new NoClassDefFoundError(classNotFoundException2.getMessage());
                }
            }
            if ((outlinePage = this.getContentOutlinePage(clazz)) instanceof AspectJContentOutlinePage) {
                this.contentOutlinePage = (AspectJContentOutlinePage)((Object)outlinePage);
            }
        }
    }

    private Object getContentOutlinePage(Class key) {
        Object outlinePage;
        block7: {
            outlinePage = null;
            if (AspectJPreferences.isAspectJOutlineEnabled()) {
                IEditorInput input = this.getEditorInput();
                if (input instanceof IFileEditorInput) {
                    IFile f = ((IFileEditorInput)input).getFile();
                    IProject p = f.getProject();
                    try {
                        if (p.hasNature("org.eclipse.ajdt.ui.ajnature")) {
                            this.contentOutlinePage = new AspectJContentOutlinePage((AbstractTextEditor)this, f);
                            outlinePage = this.contentOutlinePage;
                            break block7;
                        }
                        outlinePage = super.getAdapter(key);
                    }
                    catch (CoreException coreException) {
                        CoreException coreException2 = coreException;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_6, ajc$tjp_7);
                        outlinePage = super.getAdapter(key);
                    }
                } else {
                    outlinePage = super.getAdapter(key);
                }
            } else {
                outlinePage = super.getAdapter(key);
            }
        }
        return outlinePage;
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        SourceViewerConfiguration myConf = this.getSourceViewerConfiguration();
        if (myConf != null && myConf instanceof AJSourceViewerConfiguration && !(configuration instanceof AJSourceViewerConfiguration)) {
            return;
        }
        super.setSourceViewerConfiguration(configuration);
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (input instanceof IFileEditorInput) {
            AJCompilationUnit unit;
            IFileEditorInput fInput = (IFileEditorInput)input;
            if (ProjectProperties.ASPECTJ_SOURCE_ONLY_FILTER.accept(fInput.getFile().getName()) && (unit = AJCompilationUnitManager.INSTANCE.getAJCompilationUnitFromCache(fInput.getFile())) != null) {
                this.isEditingAjFile = true;
                unit.becomeWorkingCopy(null, null);
                ((IWorkingCopyManagerExtension)JavaPlugin.getDefault().getWorkingCopyManager()).setWorkingCopy(input, (ICompilationUnit)unit);
            }
            AJDTEventTrace.editorOpened(fInput.getFile());
            this.updateActiveConfig(fInput);
            activeEditorList.add(this);
            IDocument document = this.getDocumentProvider().getDocument((Object)fInput);
            AspectJTextTools textTools = AspectJUIPlugin.getDefault().getAspectJTextTools();
            textTools.setupJavaDocumentPartitioner(document, "___java_partitioning");
            if (this.contentOutlinePage != null) {
                this.contentOutlinePage.setInput(fInput.getFile());
                this.contentOutlinePage.update();
            }
            if ("aj".equals(fInput.getFile().getFileExtension())) {
                JavaPlugin.getDefault().getWorkingCopyManager().connect(input);
            }
        }
    }

    private void updateActiveConfig(IFileEditorInput fInput) {
        IProject project = fInput.getFile().getProject();
        String configFile = AspectJUIPlugin.getBuildConfigurationFile(project);
        if (!configFile.equals(Ajde.getDefault().getConfigurationManager().getActiveConfigFile())) {
            AJDTEventTrace.buildConfigSelected(configFile, project);
            Ajde.getDefault().getConfigurationManager().setActiveConfigFile(configFile);
        }
    }

    public void dispose() {
        AJDTEventTrace.generalEvent("Disposing editor for:" + this.getTitle());
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fInput = (IFileEditorInput)input;
            AJDTEventTrace.editorClosed(fInput.getFile());
            activeEditorList.remove((Object)this);
            try {
                AJCompilationUnit unit = AJCompilationUnitManager.INSTANCE.getAJCompilationUnitFromCache(fInput.getFile());
                if (unit != null) {
                    unit.discardWorkingCopy();
                }
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_8, ajc$tjp_9);
            }
        }
        super.dispose();
    }

    public static void forceEditorUpdates(final IProject project) {
        final Iterator editorIter = activeEditorList.iterator();
        AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){
            private static final JoinPoint.StaticPart ajc$tjp_0;
            private static final JoinPoint.StaticPart ajc$tjp_1;
            private static final JoinPoint.StaticPart ajc$tjp_2;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    while (true) {
                        IFileEditorInput ifei;
                        if (!editorIter.hasNext()) {
                            return;
                        }
                        AspectJEditor ajed = (AspectJEditor)((Object)editorIter.next());
                        IEditorInput iei = ajed.getEditorInput();
                        boolean updateThisEditor = true;
                        if (project != null && iei instanceof IFileEditorInput && !(ifei = (IFileEditorInput)iei).getFile().getProject().getName().equals(project.getName())) {
                            updateThisEditor = false;
                        }
                        if (!updateThisEditor) continue;
                        AJDTEventTrace.generalEvent("Forcing update of outline page for editor: " + ajed.getEditorInput().getName());
                        try {
                            ajed.contentOutlinePage.update();
                        }
                        catch (Exception exception) {
                            Exception exception2 = exception;
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception2, this, ajc$tjp_0, ajc$tjp_1);
                            Exception e = exception2;
                            AJDTEventTrace.generalEvent("Unexpected exception updating editor outline " + e.toString());
                        }
                    }
                }
                catch (Exception exception) {
                    Exception exception3 = exception;
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(exception3, this, ajc$tjp_2, ajc$tjp_1);
                }
            }

            static {
                Factory factory = new Factory("AspectJEditor.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.AspectJEditor$1"));
                ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AspectJEditor$1-java.lang.Exception-e-"), 462);
                ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.internal.ui.editor.AspectJEditor$1----void-"), 445);
                ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.AspectJEditor$1-java.lang.Exception-<missing>-"), 469);
            }
        });
    }

    public void setFocus() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fInput = (IFileEditorInput)input;
            AspectJUIPlugin.getDefault().setCurrentProject(fInput.getFile().getProject());
        }
        super.setFocus();
    }

    public void gotoMarker(IMarker marker) {
        super.gotoMarker(marker);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        IPreferenceStore store = this.getPreferenceStore();
        AspectJTextTools textTools = new AspectJTextTools(store);
        this.fAJSourceViewerConfiguration = new AJSourceViewerConfiguration(textTools, this, "___java_partitioning");
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.fAJSourceViewerConfiguration);
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        if (this.isEditingAjFile) {
            menu.remove("org.eclipse.jdt.ui.refactoring.menu");
            IContributionItem[] items = menu.getItems();
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                if ("group.open".equals(item.getId())) {
                    menu.remove(items[i + 2]);
                    menu.remove(items[i + 3]);
                    break;
                }
                ++i;
            }
        }
    }

    public static Set getActiveEditorList() {
        return activeEditorList;
    }

    private class AJTextOperationTarget
    implements ITextOperationTarget {
        private ITextOperationTarget parent;
        private JavaCorrectionAssistant fCorrectionAssistant;
        private IInformationPresenter fOutlinePresenter;

        public AJTextOperationTarget(ITextOperationTarget parent) {
            this.parent = parent;
        }

        public boolean canDoOperation(int operation) {
            return this.parent.canDoOperation(operation);
        }

        public void doOperation(int operation) {
            if (operation == 50) {
                if (this.fCorrectionAssistant == null) {
                    this.fCorrectionAssistant = new JavaCorrectionAssistant((ITextEditor)AspectJEditor.this);
                    this.fCorrectionAssistant.install((ITextViewer)AspectJEditor.this.getSourceViewer());
                }
                String msg = this.fCorrectionAssistant.showPossibleCompletions();
                AspectJEditor.this.setStatusLineErrorMessage(msg);
            } else if (operation == 51) {
                if (this.fOutlinePresenter == null) {
                    this.fOutlinePresenter = AspectJEditor.this.fAJSourceViewerConfiguration.getOutlinePresenter(AspectJEditor.this.getSourceViewer(), false);
                    this.fOutlinePresenter.install((ITextViewer)AspectJEditor.this.getSourceViewer());
                }
                this.fOutlinePresenter.showInformation();
            } else {
                this.parent.doOperation(operation);
            }
        }
    }

    class AnnotationAccessWrapper
    implements IAnnotationAccessExtension {
        private IAnnotationAccessExtension wrapped;

        AnnotationAccessWrapper() {
        }

        public void setWrapped(IAnnotationAccessExtension w) {
            this.wrapped = w;
        }

        public String getTypeLabel(Annotation annotation) {
            return this.wrapped.getTypeLabel(annotation);
        }

        public int getLayer(Annotation annotation) {
            int x = this.wrapped.getLayer(annotation);
            if ("org.eclipse.jdt.ui.overrideIndicator".equals(annotation.getType())) {
                x += 2;
            }
            return x;
        }

        public void paint(Annotation annotation, GC gc, Canvas canvas, Rectangle bounds) {
            this.wrapped.paint(annotation, gc, canvas, bounds);
        }

        public boolean isPaintable(Annotation annotation) {
            return this.wrapped.isPaintable(annotation);
        }

        public boolean isSubtype(Object annotationType, Object potentialSupertype) {
            return this.wrapped.isSubtype(annotationType, potentialSupertype);
        }

        public Object[] getSupertypes(Object annotationType) {
            return this.wrapped.getSupertypes(annotationType);
        }
    }
}

