/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor.contentassist;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class WorkingCopyManagerForCompletionProcessor
implements IWorkingCopyManager {
    IWorkingCopyManager wrapped;
    IDocumentProvider provider;
    private ICompilationUnit workingCopy = null;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;

    WorkingCopyManagerForCompletionProcessor(IWorkingCopyManager w, IDocumentProvider prov) {
        this.wrapped = w;
        this.provider = prov;
    }

    public void connect(IEditorInput input) throws CoreException {
        this.wrapped.connect(input);
    }

    public void disconnect(IEditorInput input) {
        this.wrapped.disconnect(input);
    }

    public ICompilationUnit getWorkingCopy(IEditorInput input) {
        ICompilationUnit unit = this.wrapped.getWorkingCopy(input);
        if (unit instanceof AJCompilationUnit) {
            return unit;
        }
        try {
            IBuffer buff = unit.getBuffer();
            String documentContents = buff.getContents();
            int aspectindex = this.locateKeyword(documentContents, "aspect ");
            int bracketindex = documentContents.indexOf("{");
            if (aspectindex != -1 && aspectindex < bracketindex) {
                this.workingCopy = unit.getWorkingCopy(null);
                buff = this.workingCopy.getBuffer();
                buff.replace(aspectindex, 7, "class  ");
                return this.workingCopy;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_0, ajc$tjp_1);
        }
        return unit;
    }

    public void discardWorkingCopy() {
        if (this.workingCopy != null) {
            try {
                this.workingCopy.discardWorkingCopy();
                this.workingCopy = null;
            }
            catch (JavaModelException javaModelException) {
                JavaModelException javaModelException2 = javaModelException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_2, ajc$tjp_3);
            }
        }
    }

    private int locateKeyword(String where, String what) {
        int location = -1;
        int offset = 0;
        String whereCopy = where;
        boolean cont = true;
        while (cont) {
            int whatIndex = whereCopy.indexOf(what);
            int multiLineCommentStart = whereCopy.indexOf("/*");
            int multiLineCommentEnd = whereCopy.indexOf("*/");
            if (whatIndex == -1) {
                cont = false;
                break;
            }
            if (multiLineCommentStart == -1 || whatIndex < multiLineCommentStart) {
                location = whatIndex + offset;
                cont = false;
            }
            if (multiLineCommentStart == -1) continue;
            if (multiLineCommentEnd == -1) {
                cont = false;
                continue;
            }
            offset = offset + multiLineCommentEnd - multiLineCommentStart + 2;
            whereCopy = String.valueOf(whereCopy.substring(0, multiLineCommentStart)) + whereCopy.substring(multiLineCommentEnd + 2);
        }
        return location;
    }

    public void shutdown() {
        this.wrapped.shutdown();
    }

    static {
        Factory factory = new Factory("WorkingCopyManagerForCompletionProcessor.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.contentassist.WorkingCopyManagerForCompletionProcessor"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.contentassist.WorkingCopyManagerForCompletionProcessor-org.eclipse.jdt.core.JavaModelException-<missing>-"), 76);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getWorkingCopy-org.eclipse.ajdt.internal.ui.editor.contentassist.WorkingCopyManagerForCompletionProcessor-org.eclipse.ui.IEditorInput:-input:--org.eclipse.jdt.core.ICompilationUnit-"), 57);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.contentassist.WorkingCopyManagerForCompletionProcessor-org.eclipse.jdt.core.JavaModelException-<missing>-"), 88);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-discardWorkingCopy-org.eclipse.ajdt.internal.ui.editor.contentassist.WorkingCopyManagerForCompletionProcessor----void-"), 84);
    }
}

