/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionAssistant;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ContributedProcessorDescriptor;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.MarkerResolutionProposal;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComparator;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickAssistProcessor;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class JavaCorrectionProcessor
implements IContentAssistProcessor {
    private static final String QUICKFIX_PROCESSOR_CONTRIBUTION_ID = "quickFixProcessors";
    private static final String QUICKASSIST_PROCESSOR_CONTRIBUTION_ID = "quickAssistProcessors";
    private static ContributedProcessorDescriptor[] fContributedAssistProcessors;
    private static ContributedProcessorDescriptor[] fContributedCorrectionProcessors;
    private static String fErrorMessage;
    private JavaCorrectionAssistant fAssistant;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;

    static {
        Factory factory = new Factory("JavaCorrectionProcessor.java", Class.forName("org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionProcessor"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionProcessor-org.eclipse.core.runtime.CoreException-<missing>-"), 119);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-hasCorrections-org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionProcessor-org.eclipse.jdt.core.ICompilationUnit:int:-cu:problemId:--boolean-"), 112);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionProcessor-java.lang.Exception-<missing>-"), 163);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-hasAssists-org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionProcessor-org.eclipse.jdt.ui.text.java.IInvocationContext:-context:--boolean-"), 156);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionProcessor-java.lang.Exception-<missing>-"), 263);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-collectCorrections-org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionProcessor-org.eclipse.jdt.ui.text.java.IInvocationContext:[Lorg.eclipse.jdt.ui.text.java.IProblemLocation;:java.util.ArrayList:-context:locations:proposals:--void-"), 251);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionProcessor-java.lang.Exception-<missing>-"), 282);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-collectAssists-org.eclipse.ajdt.internal.ui.editor.quickfix.JavaCorrectionProcessor-org.eclipse.jdt.ui.text.java.IInvocationContext:[Lorg.eclipse.jdt.ui.text.java.IProblemLocation;:java.util.ArrayList:-context:locations:proposals:--void-"), 270);
        fContributedAssistProcessors = null;
        fContributedCorrectionProcessors = null;
    }

    private static ContributedProcessorDescriptor[] getProcessorDescriptors(String contributionId) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.jdt.ui", contributionId);
        ArrayList<ContributedProcessorDescriptor> res = new ArrayList<ContributedProcessorDescriptor>(elements.length);
        int i = 0;
        while (i < elements.length) {
            if (!elements[i].getAttribute("class").equals("org.eclipse.jdt.internal.ui.text.correction.QuickFixProcessor")) {
                ContributedProcessorDescriptor desc = new ContributedProcessorDescriptor(elements[i]);
                IStatus status = desc.checkSyntax();
                if (status.isOK()) {
                    res.add(desc);
                } else {
                    JavaPlugin.log((IStatus)status);
                }
            }
            ++i;
        }
        return res.toArray(new ContributedProcessorDescriptor[res.size()]);
    }

    private static ContributedProcessorDescriptor[] getCorrectionProcessors() {
        if (fContributedCorrectionProcessors == null) {
            fContributedCorrectionProcessors = JavaCorrectionProcessor.getProcessorDescriptors(QUICKFIX_PROCESSOR_CONTRIBUTION_ID);
        }
        return fContributedCorrectionProcessors;
    }

    private static ContributedProcessorDescriptor[] getAssistProcessors() {
        if (fContributedAssistProcessors == null) {
            fContributedAssistProcessors = JavaCorrectionProcessor.getProcessorDescriptors(QUICKASSIST_PROCESSOR_CONTRIBUTION_ID);
        }
        return fContributedAssistProcessors;
    }

    public static boolean hasCorrections(ICompilationUnit cu, int problemId) {
        ContributedProcessorDescriptor[] processors = JavaCorrectionProcessor.getCorrectionProcessors();
        int i = 0;
        while (i < processors.length) {
            try {
                IQuickFixProcessor processor = (IQuickFixProcessor)processors[i].getProcessor(cu);
                if (processor != null && processor.hasCorrections(cu, problemId)) {
                    return true;
                }
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(coreException2, ajc$tjp_0, ajc$tjp_1);
            }
            ++i;
        }
        return false;
    }

    public static boolean isQuickFixableType(Annotation annotation) {
        return (annotation instanceof IJavaAnnotation || annotation instanceof SimpleMarkerAnnotation) && !annotation.isMarkedDeleted();
    }

    public static boolean hasCorrections(Annotation annotation) {
        ICompilationUnit cu;
        IJavaAnnotation javaAnnotation;
        int problemId;
        if (annotation instanceof IJavaAnnotation && (problemId = (javaAnnotation = (IJavaAnnotation)annotation).getId()) != -1 && (cu = javaAnnotation.getCompilationUnit()) != null) {
            return JavaCorrectionProcessor.hasCorrections(cu, problemId);
        }
        if (annotation instanceof SimpleMarkerAnnotation) {
            return JavaCorrectionProcessor.hasCorrections(((SimpleMarkerAnnotation)annotation).getMarker());
        }
        return false;
    }

    private static boolean hasCorrections(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return false;
        }
        IMarkerHelpRegistry registry = IDE.getMarkerHelpRegistry();
        return registry != null && registry.hasResolutions(marker);
    }

    public static boolean hasAssists(IInvocationContext context) {
        ContributedProcessorDescriptor[] processors = JavaCorrectionProcessor.getAssistProcessors();
        int i = 0;
        while (i < processors.length) {
            try {
                IQuickAssistProcessor processor = (IQuickAssistProcessor)processors[i].getProcessor(context.getCompilationUnit());
                if (processor != null && processor.hasAssists(context)) {
                    return true;
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(exception2, ajc$tjp_2, ajc$tjp_3);
            }
            ++i;
        }
        return false;
    }

    public JavaCorrectionProcessor(JavaCorrectionAssistant assistant) {
        this.fAssistant = assistant;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        IEditorPart part = this.fAssistant.getEditor();
        ICompilationUnit cu = JavaUI.getWorkingCopyManager().getWorkingCopy(part.getEditorInput());
        IAnnotationModel model = JavaUI.getDocumentProvider().getAnnotationModel((Object)part.getEditorInput());
        int length = viewer != null ? viewer.getSelectedRange().y : 0;
        AssistContext context = new AssistContext(cu, documentOffset, length);
        fErrorMessage = null;
        ArrayList<ChangeCorrectionProposal> proposals = new ArrayList<ChangeCorrectionProposal>();
        if (model != null) {
            this.processAnnotations((IInvocationContext)context, model, proposals);
        }
        if (proposals.isEmpty()) {
            proposals.add(new ChangeCorrectionProposal(CorrectionMessages.getString((String)"NoCorrectionProposal.description"), null, 0, null));
        }
        ICompletionProposal[] res = proposals.toArray(new ICompletionProposal[proposals.size()]);
        Arrays.sort(res, JavaCompletionProposalComparator.getInstance());
        return res;
    }

    private boolean isAtPosition(int offset, Position pos) {
        return pos != null && offset >= pos.getOffset() && offset <= pos.getOffset() + pos.getLength();
    }

    private void processAnnotations(IInvocationContext context, IAnnotationModel model, ArrayList proposals) {
        int offset = context.getSelectionOffset();
        ArrayList problems = new ArrayList();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Position pos;
            Annotation annotation = (Annotation)iter.next();
            if (!JavaCorrectionProcessor.isQuickFixableType(annotation) || !this.isAtPosition(offset, pos = model.getPosition(annotation))) continue;
            this.processAnnotation(annotation, pos, problems, proposals);
        }
        IProblemLocation[] problemLocations = problems.toArray(new IProblemLocation[problems.size()]);
        JavaCorrectionProcessor.collectCorrections(context, problemLocations, proposals);
        if (!this.fAssistant.isUpdatedOffset()) {
            JavaCorrectionProcessor.collectAssists(context, problemLocations, proposals);
        }
    }

    private void processAnnotation(Annotation curr, Position pos, List problems, List proposals) {
        IJavaAnnotation javaAnnotation;
        int problemId;
        if (curr instanceof IJavaAnnotation && (problemId = (javaAnnotation = (IJavaAnnotation)curr).getId()) != -1) {
            problems.add(new ProblemLocation(pos.getOffset(), pos.getLength(), javaAnnotation));
            return;
        }
        if (curr instanceof SimpleMarkerAnnotation) {
            IMarker marker = ((SimpleMarkerAnnotation)curr).getMarker();
            IMarkerResolution[] res = IDE.getMarkerHelpRegistry().getResolutions(marker);
            if (res.length > 0) {
                int i = 0;
                while (i < res.length) {
                    proposals.add(new MarkerResolutionProposal(res[i], marker));
                    ++i;
                }
            }
        }
    }

    public static void collectCorrections(IInvocationContext context, IProblemLocation[] locations, ArrayList proposals) {
        ContributedProcessorDescriptor[] processors = JavaCorrectionProcessor.getCorrectionProcessors();
        int i = 0;
        while (i < processors.length) {
            try {
                IJavaCompletionProposal[] res;
                IQuickFixProcessor curr = (IQuickFixProcessor)processors[i].getProcessor(context.getCompilationUnit());
                if (curr != null && (res = curr.getCorrections(context, locations)) != null) {
                    int k = 0;
                    while (k < res.length) {
                        proposals.add(res[k]);
                        ++k;
                    }
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(exception2, ajc$tjp_4, ajc$tjp_5);
                fErrorMessage = CorrectionMessages.getString((String)"JavaCorrectionProcessor.error.quickfix.message");
            }
            ++i;
        }
    }

    public static void collectAssists(IInvocationContext context, IProblemLocation[] locations, ArrayList proposals) {
        ContributedProcessorDescriptor[] processors = JavaCorrectionProcessor.getAssistProcessors();
        int i = 0;
        while (i < processors.length) {
            try {
                IJavaCompletionProposal[] res;
                IQuickAssistProcessor curr = (IQuickAssistProcessor)processors[i].getProcessor(context.getCompilationUnit());
                if (curr != null && (res = curr.getAssists(context, locations)) != null) {
                    int k = 0;
                    while (k < res.length) {
                        proposals.add(res[k]);
                        ++k;
                    }
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(exception2, ajc$tjp_6, ajc$tjp_7);
                fErrorMessage = CorrectionMessages.getString((String)"JavaCorrectionProcessor.error.quickassist.message");
            }
            ++i;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return fErrorMessage;
    }
}

