/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.preferences;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;

public class AspectJPreferences {
    public static final String COMPILER_OPTIONS = "aspectj.compiler.options.flags";
    public static final String AJDE_JAR = "ajde.jar";
    public static final String HAS_SET_AJPLUGIN_DEPENDENCY = "Has_Set_AJPlugin_Dependency";
    public static final String JAVA_OR_AJ_EXT = "aspectjPreferences.fileExt";
    public static final String ADVICE_DECORATOR = "aspectjPreferences.adviceDec";
    public static final String ASPECTJ_OUTLINE = "org.eclipse.ajdt.ui.ajoutline2";
    public static final String AUTOBUILD_SUPPRESSED = "org.eclipse.ajdt.ui.preferences.autobuildSuppressed";
    public static final String AJDT_PREF_CONFIG_DONE = "org.eclipse.ajdt.ui.preferences.ajdtPrefConfigDone";
    public static final String PREF_RUN_FOR_AJDT_VERSION = "org.eclipse.ajdt.ui.preferences.prefRunForAjdtVersion";
    public static final String PDE_AUTO_IMPORT_CONFIG_DONE = "org.eclipse.ajdt.ui.preferences.pdeAutoImportConfigDone";
    public static final String ASK_PDE_AUTO_IMPORT = "org.eclipse.ajdt.ui.preferences.askPdeAutoImport";
    public static final String DO_PDE_AUTO_IMPORT = "org.eclipse.ajdt.ui.preferences.doPdeAutoImport";
    private static final String WARNING = "warning";
    public static final String OPTION_ReportInvalidAbsoluteTypeName = "org.aspectj.ajdt.core.compiler.lint.InvalidAbsoluteTypeName";
    public static final String OPTION_ReportInvalidWildcardTypeName = "org.aspectj.ajdt.core.compiler.lint.WildcardTypeName";
    public static final String OPTION_ReportUnresolvableMember = "org.aspectj.ajdt.core.compiler.lint.UnresolvableMember";
    public static final String OPTION_ReportTypeNotExposedToWeaver = "org.aspectj.ajdt.core.compiler.lint.TypeNotExposedToWeaver";
    public static final String OPTION_ReportShadowNotInStructure = "org.aspectj.ajdt.core.compiler.lint.ShadowNotInStructure";
    public static final String OPTION_ReportUnmatchedSuperTypeInCall = "org.aspectj.ajdt.core.compiler.list.UnmatchedSuperTypeInCall";
    public static final String OPTION_ReportCannotImplementLazyTJP = "org.aspectj.ajdt.core.compiler.lint.CannotImplementLazyTJP";
    public static final String OPTION_ReportNeedSerialVersionUIDField = "org.aspectj.ajdt.core.compiler.lint.NeedSerialVersionUIDField";
    public static final String OPTION_ReportIncompatibleSerialVersion = "org.aspectj.ajdt.core.compiler.lint.BrokeSerialVersionCompatibility";
    public static final String OPTION_ReportNoInterfaceCtorJoinpoint = "org.aspectj.ajdt.core.compiler.lint.NoInterfaceCtorJoinpoint";
    public static final String OPTION_1_5 = "org.aspectj.ajdt.core.compiler.aj5";
    public static final String OPTION_noJoinpointsForBridgeMethods = "org.aspectj.ajdt.core.compiler.lint.noJoinpointsForBridgeMethods";
    public static final String OPTION_cantMatchArrayTypeOnVarargs = "org.aspectj.ajdt.core.compiler.lint.cantMatchArrayTypeOnVarargs";
    public static final String OPTION_enumAsTargetForDecpIgnored = "org.aspectj.ajdt.core.compiler.lint.enumAsTargetForDecpIgnored";
    public static final String OPTION_annotationAsTargetForDecpIgnored = "org.aspectj.ajdt.core.compiler.lint.annotationAsTargetForDecpIgnored";
    public static final String OPTION_NoWeave = "org.aspectj.ajdt.core.compiler.weaver.NoWeave";
    public static final String OPTION_XSerializableAspects = "org.aspectj.ajdt.core.compiler.weaver.XSerializableAspects";
    public static final String OPTION_XLazyThisJoinPoint = "org.aspectj.ajdt.core.compiler.weaver.XLazyThisJoinPoint";
    public static final String OPTION_XNoInline = "org.aspectj.ajdt.core.compiler.weaver.XNoInline";
    public static final String OPTION_XReweavable = "org.aspectj.ajdt.core.compiler.weaver.XReweavable";
    public static final String OPTION_XReweavableCompress = "org.aspectj.ajdt.core.compiler.weaver.XReweavableCompress";
    public static final String OPTION_Incremental = "org.aspectj.ajdt.core.compiler.BuildOptions.incrementalMode";
    public static final String OPTION_BuildASM = "org.aspectj.ajdt.core.compiler.BuildOptions.buildAsm";
    public static final String OPTION_WeaveMessages = "org.aspectj.ajdt.core.compiler.BuildOptions.showweavemessages";
    private static String[][] lintKeysName;
    private static String XlintProperties;
    private static boolean isShowing;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;

    static {
        Factory factory = new Factory("AspectJPreferences.java", Class.forName("org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-java.io.IOException-<missing>-"), 220);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a-writeLintOptionsFile-org.eclipse.ajdt.internal.ui.preferences.AspectJPreferences-org.eclipse.core.resources.IProject:-thisProject:--void-"), 200);
        lintKeysName = new String[][]{{OPTION_ReportInvalidAbsoluteTypeName, "invalidAbsoluteTypeName"}, {OPTION_ReportInvalidWildcardTypeName, "invalidWildcardTypeName"}, {OPTION_ReportUnresolvableMember, "unresolvableMember"}, {OPTION_ReportTypeNotExposedToWeaver, "typeNotExposedToWeaver"}, {OPTION_ReportShadowNotInStructure, "shadowNotInStructure"}, {OPTION_ReportUnmatchedSuperTypeInCall, "unmatchedSuperTypeInCall"}, {OPTION_ReportCannotImplementLazyTJP, "canNotImplementLazyTjp"}, {OPTION_ReportNeedSerialVersionUIDField, "needsSerialVersionUIDField"}, {OPTION_ReportIncompatibleSerialVersion, "brokeSerialVersionCompatibility"}, {OPTION_ReportNoInterfaceCtorJoinpoint, "noInterfaceCtorJoinpoint"}, {OPTION_noJoinpointsForBridgeMethods, "noJoinpointsForBridgeMethods"}, {OPTION_cantMatchArrayTypeOnVarargs, "cantMatchArrayTypeOnVarargs"}, {OPTION_enumAsTargetForDecpIgnored, "enumAsTargetForDecpIgnored"}, {OPTION_annotationAsTargetForDecpIgnored, "annotationAsTargetForDecpIgnored"}};
        XlintProperties = "Xlint.properties";
        isShowing = false;
    }

    public static String getCompilerOptions() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getString(COMPILER_OPTIONS);
    }

    public static String getFileExt() {
        boolean javaOrAjExt = AspectJPreferences.getJavaOrAjExt();
        return javaOrAjExt ? ".java" : ".aj";
    }

    private static boolean getJavaOrAjExt() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(JAVA_OR_AJ_EXT);
    }

    public static void setCompilerOptions(String value) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(COMPILER_OPTIONS, value);
    }

    public static String getLintOptions(IProject thisProject) {
        File optsFile = AspectJUIPlugin.getDefault().getStateLocation().append(XlintProperties).toFile();
        AspectJPreferences.writeLintOptionsFile(thisProject);
        String opts = " -Xlintfile \"" + optsFile + "\" ";
        return opts;
    }

    public static boolean getShowWeaveMessagesOption(IProject thisProject) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        String prefix = store.getBoolean(thisProject + "useProjectSettings") ? thisProject.toString() : "";
        return store.getBoolean(String.valueOf(prefix) + OPTION_WeaveMessages);
    }

    public static boolean getBuildASMOption(IProject thisProject) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        String prefix = store.getBoolean(thisProject + "useProjectSettings") ? thisProject.toString() : "";
        return store.getBoolean(String.valueOf(prefix) + OPTION_BuildASM);
    }

    public static boolean getIncrementalOption(IProject thisProject) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        String prefix = store.getBoolean(thisProject + "useProjectSettings") ? thisProject.toString() : "";
        return store.getBoolean(String.valueOf(prefix) + OPTION_Incremental);
    }

    private static void writeLintOptionsFile(IProject thisProject) {
        File optsFile = AspectJUIPlugin.getDefault().getStateLocation().append(XlintProperties).toFile();
        try {
            FileWriter writer = new FileWriter(optsFile);
            IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
            String prefix = store.getBoolean(thisProject + "useProjectSettings") ? thisProject.toString() : "";
            int i = 0;
            while (i < lintKeysName.length) {
                String value = store.getString(String.valueOf(prefix) + lintKeysName[i][0]);
                if (value.equals("")) {
                    store.setDefault(String.valueOf(prefix) + lintKeysName[i][0], WARNING);
                    value = store.getString(String.valueOf(prefix) + lintKeysName[i][0]);
                }
                writer.write(String.valueOf(lintKeysName[i][1]) + " = " + value);
                writer.write(System.getProperty("line.separator"));
                ++i;
            }
            writer.close();
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(iOException2, ajc$tjp_0, ajc$tjp_1);
        }
    }

    public static String getAdvancedOptions(IProject thisProject) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        String opts = " ";
        String prefix = store.getBoolean(thisProject + "useProjectSettings") ? thisProject.toString() : "";
        if (store.getBoolean(String.valueOf(prefix) + OPTION_NoWeave)) {
            opts = String.valueOf(opts) + "-XnoWeave ";
        }
        if (store.getBoolean(String.valueOf(prefix) + OPTION_XSerializableAspects)) {
            opts = String.valueOf(opts) + "-XserializableAspects ";
        }
        if (store.getBoolean(String.valueOf(prefix) + OPTION_XLazyThisJoinPoint)) {
            opts = String.valueOf(opts) + "-XlazyTjp ";
        }
        if (store.getBoolean(String.valueOf(prefix) + OPTION_XNoInline)) {
            opts = String.valueOf(opts) + "-XnoInline ";
        }
        if (store.getBoolean(String.valueOf(prefix) + OPTION_XReweavable)) {
            opts = String.valueOf(opts) + "-Xreweavable ";
        }
        if (store.getBoolean(String.valueOf(prefix) + OPTION_XReweavableCompress)) {
            opts = String.valueOf(opts) + "-Xreweavable:compress ";
        }
        if (store.getBoolean(String.valueOf(prefix) + OPTION_1_5)) {
            opts = String.valueOf(opts) + "-1.5 ";
        }
        return opts;
    }

    public static boolean isAspectJOutlineEnabled() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(ASPECTJ_OUTLINE);
    }

    public static boolean isAdviceDecoratorActive() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(ADVICE_DECORATOR);
    }

    public static boolean isAutobuildSuppressed() {
        return false;
    }

    public static void setAJDTPrefConfigDone(boolean done, String version) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(AJDT_PREF_CONFIG_DONE, done);
        store.setValue(PREF_RUN_FOR_AJDT_VERSION, version);
    }

    public static boolean isAJDTPrefConfigDone(String version) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        String prefsAJDTVersion = store.getString(PREF_RUN_FOR_AJDT_VERSION);
        return version.equals(prefsAJDTVersion) ? store.getBoolean(AJDT_PREF_CONFIG_DONE) : false;
    }

    public static boolean isAJDTPrefConfigShowing() {
        return isShowing;
    }

    public static void setAJDTPrefConfigShowing(boolean showing) {
        isShowing = showing;
    }

    public static void setAskPDEAutoImport(boolean ask) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(ASK_PDE_AUTO_IMPORT, ask);
    }

    public static boolean askPDEAutoImport() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(ASK_PDE_AUTO_IMPORT);
    }

    public static void setPDEAutoImportConfigDone(boolean done) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(PDE_AUTO_IMPORT_CONFIG_DONE, done);
    }

    public static boolean isPDEAutoImportConfigDone() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(PDE_AUTO_IMPORT_CONFIG_DONE);
    }

    public static void setDoPDEAutoImport(boolean doImport) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        store.setValue(DO_PDE_AUTO_IMPORT, doImport);
    }

    public static boolean doPDEAutoImport() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(DO_PDE_AUTO_IMPORT);
    }
}

