/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.File;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class AspectJWizardNewProjectCreationPage
extends WizardNewProjectCreationPage {
    private boolean exactProjectMatch = false;
    private boolean reconstructProject = false;
    private String correctCapitalization;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;

    public AspectJWizardNewProjectCreationPage(String pageName) {
        super(pageName);
    }

    protected boolean validatePage() {
        String projectName;
        IPath projectSource = this.getLocationPath();
        IWorkspaceRoot wRoot = AspectJUIPlugin.getWorkspace().getRoot();
        wRoot.getLocation();
        this.exactProjectMatch = false;
        this.reconstructProject = false;
        if (!projectSource.toString().equals(wRoot.getRawLocation().toString())) {
            return super.validatePage();
        }
        this.correctCapitalization = projectName = this.getProjectName();
        File projectFile = wRoot.getLocation().append(projectName).toFile();
        File classpath = wRoot.getLocation().append(String.valueOf(projectName) + '/' + ".classpath").toFile();
        File projectDetailsFile = wRoot.getLocation().append(String.valueOf(projectName) + '/' + ".project").toFile();
        File projectDirectory = wRoot.getLocation().toFile();
        boolean projectFolderExists = projectFile.isDirectory();
        boolean classpathExists = classpath.isFile();
        boolean projectFileExists = projectDetailsFile.isFile();
        boolean ProjectInWorkspace = false;
        if (this.OpSystemIsCaseSensitive()) {
            ProjectInWorkspace = wRoot.findMember(projectName) != null;
        } else {
            IResource[] workspaceMembers = null;
            try {
                workspaceMembers = wRoot.members();
            }
            catch (CoreException coreException) {
                CoreException coreException2 = coreException;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_0, ajc$tjp_1);
            }
            int i = 0;
            while (i < workspaceMembers.length) {
                if (workspaceMembers[i].getName().equalsIgnoreCase(projectName)) {
                    ProjectInWorkspace = true;
                }
                ++i;
            }
        }
        if (projectFolderExists && classpathExists && projectFileExists && !ProjectInWorkspace) {
            this.reconstructProject = true;
            this.setErrorMessage(null);
            this.setMessage(AspectJUIPlugin.getResourceString("NewAspectjProjectCreationWizard.MainPage.project_exists"), 2);
            File nonExactProjectFile = null;
            File[] workspaceProjects = projectDirectory.listFiles();
            int i = 0;
            while (i < workspaceProjects.length && !this.exactProjectMatch) {
                if (workspaceProjects[i].getName().equals(projectName) && workspaceProjects[i].isDirectory()) {
                    this.exactProjectMatch = true;
                    return this.exactProjectMatch;
                }
                if (workspaceProjects[i].equals(projectFile) && workspaceProjects[i].isDirectory()) {
                    nonExactProjectFile = workspaceProjects[i];
                    this.correctCapitalization = nonExactProjectFile.getName();
                }
                ++i;
            }
            this.setErrorMessage(null);
            this.setMessage(AspectJUIPlugin.getResourceString("NewAspectjProjectCreationWizard.MainPage.project_exists.capitalization"), 2);
            return true;
        }
        if (ProjectInWorkspace && !projectName.equals("")) {
            this.setErrorMessage(null);
            this.setErrorMessage(IDEWorkbenchMessages.getString((String)"WizardNewProjectCreationPage.projectExistsMessage"));
            return false;
        }
        return super.validatePage();
    }

    public boolean hasCorrectCapitalisation() {
        return this.exactProjectMatch;
    }

    public boolean useExistingProjectStructure() {
        return this.reconstructProject;
    }

    public String getCorrectCapitalization() {
        return this.correctCapitalization;
    }

    private boolean OpSystemIsCaseSensitive() {
        File testFile2;
        File testFile1 = AspectJUIPlugin.getWorkspace().getRoot().getLocation().append("testlocation").toFile();
        return !testFile1.equals(testFile2 = AspectJUIPlugin.getWorkspace().getRoot().getLocation().append("TESTLOCATION").toFile());
    }

    static {
        Factory factory = new Factory("AspectJWizardNewProjectCreationPage.java", Class.forName("org.eclipse.ajdt.internal.ui.wizards.AspectJWizardNewProjectCreationPage"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.internal.ui.wizards.AspectJWizardNewProjectCreationPage-org.eclipse.core.runtime.CoreException-<missing>-"), 73);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4-validatePage-org.eclipse.ajdt.internal.ui.wizards.AspectJWizardNewProjectCreationPage----boolean-"), 44);
    }
}

