/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;

public class ResourceAddedPage
extends WizardPage
implements SelectionListener {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private List newResourcesList;
    private Tree newResourcesTree;
    private List buildConfigFiles;
    private Tree buildConfigFilesTree;
    private IProject project;
    private Composite topLevel;

    public ResourceAddedPage(IWorkbench workbench, IStructuredSelection selection, List newResources) {
        super("ResourceAddedPage1", "", null);
        this.workbench = workbench;
        this.newResourcesList = newResources;
        if (newResources == null) {
            newResources = new ArrayList();
        }
        this.project = ((IResource)this.newResourcesList.get(0)).getProject();
        AspectJUIPlugin.getDefault().setCurrentProject(this.project);
        this.setDescription(AspectJUIPlugin.getResourceString("newResourcesWizard.pageDescription"));
        this.setTitle(String.valueOf(AspectJUIPlugin.getResourceString("newResourcesWizard.pageTitle")) + this.project.getName().toString());
        this.buildConfigFiles = AspectJUIPlugin.getDefault().getListOfConfigFilesForCurrentProject();
        int i = 0;
        while (i < this.buildConfigFiles.size()) {
            if (newResources.contains(this.buildConfigFiles.get(i))) {
                this.buildConfigFiles.remove(i);
            }
            ++i;
        }
    }

    public boolean finish() {
        return true;
    }

    public void createControl(Composite composite) {
        this.topLevel = new Composite(composite, 0);
        this.topLevel.setLayout((Layout)new GridLayout());
        Label l = new Label(this.topLevel, 0);
        l.setText(AspectJUIPlugin.getResourceString("newResourcesWizard.instructions"));
        GridLayout glayout = new GridLayout();
        Group group = new Group(this.topLevel, 32);
        group.setLayoutData((Object)new GridData(1808));
        glayout.numColumns = 2;
        group.setLayout((Layout)glayout);
        IPath trimPath = AspectJUIPlugin.getDefault().getCurrentProject().getLocation();
        trimPath = trimPath.removeLastSegments(1);
        String trimPathString = new String(String.valueOf(trimPath.toOSString()) + File.separator);
        Group resGroup = new Group((Composite)group, 0);
        GridLayout resLayout = new GridLayout();
        resLayout.numColumns = 1;
        resGroup.setLayout((Layout)resLayout);
        resGroup.setLayoutData((Object)new GridData(1808));
        this.newResourcesTree = new Tree((Composite)resGroup, 34);
        this.newResourcesTree.setLayoutData((Object)new GridData(1808));
        ListIterator resIterator = this.newResourcesList.listIterator();
        while (resIterator.hasNext()) {
            IResource iresource = (IResource)resIterator.next();
            String absolutePath = iresource.getLocation().toOSString();
            TreeItem titem = new TreeItem(this.newResourcesTree, 0);
            titem.setText(absolutePath.substring(trimPathString.length()));
            titem.setData((Object)iresource);
            titem.setChecked(true);
        }
        Group bcfgGroup = new Group((Composite)group, 0);
        GridLayout bcfgLayout = new GridLayout();
        bcfgLayout.numColumns = 1;
        bcfgGroup.setLayout((Layout)bcfgLayout);
        bcfgGroup.setLayoutData((Object)new GridData(1808));
        this.buildConfigFilesTree = new Tree((Composite)bcfgGroup, 34);
        this.buildConfigFilesTree.setLayoutData((Object)new GridData(1808));
        ListIterator iterator = this.buildConfigFiles.listIterator();
        while (iterator.hasNext()) {
            IResource iresource = (IResource)iterator.next();
            String absolutePath = iresource.getLocation().toOSString();
            TreeItem titem = new TreeItem(this.buildConfigFilesTree, 0);
            titem.setText(absolutePath.substring(trimPathString.length()));
            titem.setData((Object)iresource);
            titem.setChecked(true);
        }
        Button resSelectAllButton = new Button((Composite)group, 0);
        resSelectAllButton.setText(AspectJUIPlugin.getResourceString("newResourcesWizard.selectAllResources"));
        resSelectAllButton.setLayoutData((Object)new GridData(64));
        resSelectAllButton.addSelectionListener((SelectionListener)this);
        Button bcfgSelectAllButton = new Button((Composite)group, 0);
        bcfgSelectAllButton.setText(AspectJUIPlugin.getResourceString("newResourcesWizard.selectAllConfigurations"));
        bcfgSelectAllButton.setLayoutData((Object)new GridData(64));
        bcfgSelectAllButton.addSelectionListener((SelectionListener)this);
        Button resSelectNoneButton = new Button((Composite)group, 0);
        resSelectNoneButton.setText(AspectJUIPlugin.getResourceString("newResourcesWizard.deselectAllResources"));
        resSelectNoneButton.setLayoutData((Object)new GridData(64));
        resSelectNoneButton.addSelectionListener((SelectionListener)this);
        Button bcfgSelectNoneButton = new Button((Composite)group, 0);
        bcfgSelectNoneButton.setText(AspectJUIPlugin.getResourceString("newResourcesWizard.deselectAllConfigurations"));
        bcfgSelectNoneButton.setLayoutData((Object)new GridData(64));
        bcfgSelectNoneButton.addSelectionListener((SelectionListener)this);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)this.topLevel);
        this.setPageComplete(true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Tree treeToAffect = null;
            boolean select = false;
            Button b = (Button)e.getSource();
            String button_text = b.getText();
            if (button_text.equals(AspectJUIPlugin.getResourceString("newResourcesWizard.selectAllResources"))) {
                treeToAffect = this.newResourcesTree;
                select = true;
            } else if (button_text.equals(AspectJUIPlugin.getResourceString("newResourcesWizard.selectAllConfigurations"))) {
                treeToAffect = this.buildConfigFilesTree;
                select = true;
            } else if (button_text.equals(AspectJUIPlugin.getResourceString("newResourcesWizard.deselectAllResources"))) {
                treeToAffect = this.newResourcesTree;
                select = false;
            } else if (button_text.equals(AspectJUIPlugin.getResourceString("newResourcesWizard.deselectAllConfigurations"))) {
                treeToAffect = this.buildConfigFilesTree;
                select = false;
            }
            if (treeToAffect != null) {
                TreeItem[] items = treeToAffect.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].setChecked(select);
                    ++i;
                }
            }
        }
    }

    protected List getSelectedResources() {
        ArrayList<IResource> results = new ArrayList<IResource>();
        TreeItem[] items = this.newResourcesTree.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                results.add((IResource)items[i].getData());
            }
            ++i;
        }
        return results;
    }

    protected List getSelectedBuildConfigFiles() {
        ArrayList<IResource> results = new ArrayList<IResource>();
        TreeItem[] items = this.buildConfigFilesTree.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                results.add((IResource)items[i].getData());
            }
            ++i;
        }
        return results;
    }
}

