/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildOptionsAdapter;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.ui.StructureViewNodeFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.buildconfigurator.BCResourceChangeListener;
import org.eclipse.ajdt.internal.core.AJDTEventTrace;
import org.eclipse.ajdt.internal.core.AJDTStructureViewNodeFactory;
import org.eclipse.ajdt.internal.core.AJDTUtils;
import org.eclipse.ajdt.internal.ui.ajde.CompilerMonitor;
import org.eclipse.ajdt.internal.ui.ajde.EditorAdapter;
import org.eclipse.ajdt.internal.ui.ajde.ErrorHandler;
import org.eclipse.ajdt.internal.ui.ajde.IdeUIAdapter;
import org.eclipse.ajdt.internal.ui.ajde.ProjectProperties;
import org.eclipse.ajdt.internal.ui.editor.AspectJTextTools;
import org.eclipse.ajdt.internal.ui.preferences.AJCompilerPreferencePage;
import org.eclipse.ajdt.internal.ui.preferences.AspectJPreferencePage;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.javamodel.AJCompilationUnitManager;
import org.eclipse.ajdt.javamodel.ResourceChangeListener;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.UIPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AspectJUIPlugin
extends AbstractUIPlugin
implements ISelectionListener {
    public static String VERSION;
    public static final String PLUGIN_ID = "org.eclipse.ajdt.ui";
    public static final String ID_BUILDER = "org.eclipse.ajdt.ui.ajbuilder";
    public static final String ID_OUTLINE = "org.eclipse.ajdt.ui.ajoutlineview";
    public static final String ID_NATURE = "org.eclipse.ajdt.ui.ajnature";
    public static final String RUNTIME_PLUGIN_ID = "org.aspectj.runtime";
    private static final String AJDE_VERSION_KEY_CURRENT = "ajde.version";
    private static final String AJDE_VERSION_KEY_PREVIOUS = "ajde.version.at.previous.startup";
    public static final String NON_OS_SPECIFIC_SEPARATOR = "/";
    public static boolean isDebugging;
    public static boolean DEBUG_BUILDER;
    public static boolean DEBUG_COMPILER;
    public static boolean DEBUG_OUTLINE;
    private static AspectJUIPlugin plugin;
    private ResourceBundle resourceBundle;
    private ProjectProperties ajdtProjectProperties;
    private CompilerMonitor ajdtCompilerMonitor;
    private EditorAdapter ajdtEditorAdapter;
    private org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter ajdtBuildOptions;
    private AspectJImages ajdtImages;
    private AJDTStructureViewNodeFactory ajdtStructureFactory;
    private IdeUIAdapter ajdtUIAdapter;
    private ErrorHandler ajdtErrorHandler;
    private AspectJTextTools aspectJTextTools;
    private IProject currentProject;
    private IResource currentResource;
    private Display display;
    IResourceChangeListener resourceChangeListener;
    public static final String SOURCE_LOCATION_ATTRIBUTE = "sourceLocationOfAdvice";
    public static final String RELATED_LOCATIONS_ATTRIBUTE_PREFIX = "relatedLocations-";
    public static final String ACCKIND_ATTRIBUTE = "acckind";
    private static final String defaultLstShouldBeUsed = "org.eclipse.ajdt.ui.buildConfig.useDefaultLst";
    public static final int PROGRESS_MONITOR_MAX = 100;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;
    private static final JoinPoint.StaticPart ajc$tjp_12;
    private static final JoinPoint.StaticPart ajc$tjp_13;

    static {
        Factory factory = new Factory("AspectJUIPlugin.java", Class.forName("org.eclipse.ajdt.ui.AspectJUIPlugin"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.AspectJUIPlugin-java.util.MissingResourceException-<missing>-"), 317);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-getResourceString-org.eclipse.ajdt.ui.AspectJUIPlugin-java.lang.String:-key:--java.lang.String-"), 314);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.AspectJUIPlugin-org.eclipse.core.runtime.CoreException-ce-"), 915);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getListOfConfigFilesForCurrentProject-org.eclipse.ajdt.ui.AspectJUIPlugin----java.util.List-"), 910);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.AspectJUIPlugin-org.eclipse.core.runtime.CoreException-ce-"), 937);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-getLstFiles-org.eclipse.ajdt.ui.AspectJUIPlugin-[Lorg.eclipse.core.resources.IResource;:java.util.List:-resource_list:allLstFiles:--void-"), 929);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.AspectJUIPlugin-java.util.MissingResourceException-<missing>-"), 481);
        ajc$tjp_3 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1--org.eclipse.ajdt.ui.AspectJUIPlugin----"), 475);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.AspectJUIPlugin-org.eclipse.core.runtime.CoreException-<missing>-"), 528);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkAspectJVersion-org.eclipse.ajdt.ui.AspectJUIPlugin----void-"), 498);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.AspectJUIPlugin-java.io.IOException-<missing>-"), 569);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-checkTemplatesInstalled-org.eclipse.ajdt.ui.AspectJUIPlugin----void-"), 556);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.AspectJUIPlugin-org.eclipse.jdt.core.JavaModelException-jme-"), 893);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-selectionChanged-org.eclipse.ajdt.ui.AspectJUIPlugin-org.eclipse.ui.IWorkbenchPart:org.eclipse.jface.viewers.ISelection:-iwp:is:--void-"), 867);
        VERSION = "unset";
        isDebugging = false;
        DEBUG_BUILDER = false;
        DEBUG_COMPILER = false;
        DEBUG_OUTLINE = false;
    }

    public static AspectJUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = AspectJUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            MissingResourceException missingResourceException2 = missingResourceException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$1$31280822(missingResourceException2, ajc$tjp_0, ajc$tjp_1);
            return key;
        }
    }

    public static String getFormattedResourceString(String key, String arg) {
        return AspectJUIPlugin.getFormattedResourceString(key, new String[]{arg});
    }

    public static String getFormattedResourceString(String key, String[] args) {
        return MessageFormat.format(AspectJUIPlugin.getResourceString(key), args);
    }

    public static void setBuildConfigurationFile(IProject project, IFile buildfile) {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        String propertyName = "org.eclipse.ajdt.ui." + project.getName() + ".lst";
        if (buildfile == null) {
            store.setValue(propertyName, defaultLstShouldBeUsed);
        } else {
            store.setValue(propertyName, buildfile.getLocation().toOSString());
        }
        String cfg = AspectJUIPlugin.getBuildConfigurationFile(project);
        Ajde.getDefault().getConfigurationManager().setActiveConfigFile(cfg);
        AJDTEventTrace.buildConfigSelected(cfg, project);
    }

    public static void setBuildConfigurationFile(IProject project, IResource buildfile) {
        if (buildfile == null) {
            AspectJUIPlugin.setBuildConfigurationFile(project, null);
        } else if (buildfile instanceof IFile) {
            AspectJUIPlugin.setBuildConfigurationFile(project, (IFile)buildfile);
        }
    }

    public static String getBuildConfigurationFile(IProject project) {
        String configFile = String.valueOf(AJDTUtils.getProjectRootDirectory(project)) + File.separator + ".generated.lst";
        return configFile;
    }

    public AspectJUIPlugin() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.eclipse.ajdt.internal.ui.resources.AspectJPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            MissingResourceException missingResourceException2 = missingResourceException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(missingResourceException2, (Object)this, ajc$tjp_2, ajc$tjp_3);
            this.resourceBundle = null;
        }
    }

    private void checkAspectJVersion() {
        IPreferenceStore store = AspectJUIPlugin.getDefault().getPreferenceStore();
        String currentAjdeVersion = AspectJUIPlugin.getResourceString(AJDE_VERSION_KEY_CURRENT);
        String previousAjdeVersion = store.getString(AJDE_VERSION_KEY_PREVIOUS);
        try {
            if (previousAjdeVersion == null || !currentAjdeVersion.equals(previousAjdeVersion)) {
                AJDTEventTrace.generalEvent("New version of AJDE detected (now:" + currentAjdeVersion + ") - checking aspectjrt.jar for each project.");
                IProject[] projects = AspectJUIPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    IProject current;
                    if (projects[i].isOpen() && (current = projects[i]).hasNature(ID_NATURE)) {
                        AJDTUtils.verifyAjrtVersion(current);
                    }
                    ++i;
                }
                this.checkTemplatesInstalled();
                this.checkProblemMarkersVisible();
                store.putValue(AJDE_VERSION_KEY_PREVIOUS, currentAjdeVersion);
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_4, ajc$tjp_5);
            AJDTEventTrace.generalEvent("Problem attempting to check aspectjrt.jar for");
        }
    }

    private void checkProblemMarkersVisible() {
        IDialogSettings filterSettings;
        String enabledMarkers;
        String TAG_DIALOG_SECTION = "org.eclipse.ui.views.problem";
        String problemMarker = "org.eclipse.ajdt.ui.problemmarker:";
        UIPlugin plugin = UIPlugin.getDefault();
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(TAG_DIALOG_SECTION);
        if (settings != null && (enabledMarkers = (filterSettings = settings.getSection("filter")).get("selectedType")).indexOf(problemMarker) == -1) {
            enabledMarkers = String.valueOf(enabledMarkers) + problemMarker;
            filterSettings.put("selectedType", enabledMarkers);
        }
    }

    private void checkTemplatesInstalled() {
        TemplateStore codeTemplates = JavaPlugin.getDefault().getTemplateStore();
        try {
            URL loc = this.getBundle().getEntry("/aspectj_code_templates.xml");
            TemplateReaderWriter trw = new TemplateReaderWriter();
            TemplatePersistenceData[] templates = trw.read(loc.openStream(), null);
            if (templates == null || templates.length == 0) {
                AJDTEventTrace.generalEvent(AspectJUIPlugin.getResourceString("codeTemplates.couldNotLoad"));
            } else {
                int i = 0;
                while (i < templates.length) {
                    codeTemplates.add(templates[i]);
                    ++i;
                }
                codeTemplates.save();
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(iOException2, (Object)this, ajc$tjp_6, ajc$tjp_7);
            AJDTEventTrace.generalEvent(AspectJUIPlugin.getResourceString("codeTemplates.couldNotLoad"));
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.ajdtErrorHandler;
    }

    public CompilerMonitor getCompilerMonitor() {
        return this.ajdtCompilerMonitor;
    }

    public ProjectProperties getAjdtProjectProperties() {
        return this.ajdtProjectProperties;
    }

    public org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter getAjdtBuildOptionsAdapter() {
        return this.ajdtBuildOptions;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.display = Display.getDefault();
        if (this.resourceChangeListener == null) {
            this.resourceChangeListener = new BCResourceChangeListener();
            this.enableBuildConfiguratorResourceChangeListener();
            AspectJUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener(), 15);
        }
        Bundle bundle = AspectJUIPlugin.getDefault().getBundle();
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        PluginVersionIdentifier pvi = new PluginVersionIdentifier(version);
        VERSION = String.valueOf(pvi.getMajorComponent()) + "." + pvi.getMinorComponent() + "." + pvi.getServiceComponent();
        this.initDebugging();
        this.ajdtProjectProperties = new ProjectProperties();
        this.ajdtCompilerMonitor = new CompilerMonitor();
        this.ajdtEditorAdapter = new EditorAdapter();
        this.ajdtErrorHandler = new ErrorHandler();
        this.ajdtBuildOptions = new org.eclipse.ajdt.internal.ui.ajde.BuildOptionsAdapter();
        this.ajdtImages = AspectJImages.registry();
        this.ajdtUIAdapter = new IdeUIAdapter();
        this.ajdtStructureFactory = new AJDTStructureViewNodeFactory(this.ajdtImages);
        Ajde.init((org.aspectj.ajde.EditorAdapter)this.ajdtEditorAdapter, (TaskListManager)this.ajdtCompilerMonitor, (BuildProgressMonitor)this.ajdtCompilerMonitor, (ProjectPropertiesAdapter)this.ajdtProjectProperties, (BuildOptionsAdapter)this.ajdtBuildOptions, (StructureViewNodeFactory)this.ajdtStructureFactory, (org.aspectj.ajde.ui.IdeUIAdapter)this.ajdtUIAdapter, (org.aspectj.ajde.ErrorHandler)this.ajdtErrorHandler);
        AJDTEventTrace.startup();
        this.checkAspectJVersion();
        AJCompilationUnitManager.INSTANCE.initCompilationUnits(AspectJUIPlugin.getWorkspace());
        AJDTUtils.refreshPackageExplorer();
    }

    public IWorkbenchWindow getActiveWorkbenchWindow() {
        return plugin.getWorkbench().getActiveWorkbenchWindow();
    }

    public Display getDisplay() {
        return this.display;
    }

    public AspectJTextTools getAspectJTextTools() {
        if (this.aspectJTextTools == null) {
            IPreferenceStore textToolPreferences = JavaPlugin.getDefault().getPreferenceStore();
            this.aspectJTextTools = new AspectJTextTools(textToolPreferences);
        }
        return this.aspectJTextTools;
    }

    public IProject getCurrentProject() {
        IProject current = null;
        if (this.currentProject != null) {
            current = this.currentProject;
        } else {
            IProject[] projects = AspectJUIPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isOpen()) {
                    current = projects[i];
                    break;
                }
                ++i;
            }
        }
        return current;
    }

    public IResource getCurrentResource() {
        return this.currentResource;
    }

    public void setCurrentProject(IProject project) {
        this.currentProject = project;
    }

    public void setCurrentProject(String projectName) {
        boolean matched = false;
        IProject[] projects = AspectJUIPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getName().equals(projectName)) {
                this.currentProject = projects[i];
                matched = true;
                break;
            }
            ++i;
        }
        if (!matched) {
            this.getErrorHandler().handleWarning(String.valueOf(AspectJUIPlugin.getResourceString("bad.project")) + " " + projectName);
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        AspectJPreferencePage.initDefaults(store);
        AJCompilerPreferencePage.initDefaults(store);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
    }

    private void initDebugging() {
        if (this.isDebugging()) {
            System.out.println("AJP START: org.eclipse.ajdt.ui " + VERSION);
            isDebugging = true;
            String option = Platform.getDebugOption((String)"org.eclipse.ajdt.ui/builderDebug");
            if (option != null && option.equals("true")) {
                System.out.println("AJP builderDebug ON");
                DEBUG_BUILDER = true;
            } else {
                System.out.println("AJP builderDebug OFF");
            }
            option = Platform.getDebugOption((String)"org.eclipse.ajdt.ui/compilerDebug");
            if (option != null && option.equals("true")) {
                System.out.println("AJP compilerDebug ON");
                DEBUG_COMPILER = true;
            } else {
                System.out.println("AJP compilerDebug OFF");
            }
            option = Platform.getDebugOption((String)"org.eclipse.ajdt.ui/outlineDebug");
            if (option != null && option.equals("true")) {
                System.out.println("AJP outlineDebug ON");
                DEBUG_OUTLINE = true;
            } else {
                System.out.println("AJP outlineDebug OFF");
            }
        }
    }

    public void selectionChanged(IWorkbenchPart iwp, ISelection is) {
        try {
            if (is instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)is;
                Object o = structuredSelection.getFirstElement();
                if (o != null) {
                    IJavaElement je;
                    if (o instanceof IResource) {
                        this.currentResource = (IResource)o;
                        this.currentProject = this.currentResource.getProject();
                    } else if (o instanceof IJavaElement && (je = (IJavaElement)o).getJavaProject() != null) {
                        this.currentResource = je.getUnderlyingResource();
                        this.currentProject = je.getJavaProject().getProject();
                    }
                }
            } else {
                boolean cfr_ignored_0 = is instanceof ITextSelection;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaModelException javaModelException2 = javaModelException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(javaModelException2, (Object)this, ajc$tjp_8, ajc$tjp_9);
            JavaModelException jme = javaModelException2;
            this.getErrorHandler().handleError("Exception in AspectJPlugin.selectionChanged processing", jme);
        }
    }

    public List getListOfConfigFilesForCurrentProject() {
        if (this.currentProject == null) {
            return null;
        }
        ArrayList allLstFiles = new ArrayList();
        try {
            IResource[] files = this.currentProject.members();
            this.getLstFiles(files, allLstFiles);
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_10, ajc$tjp_11);
            CoreException ce = coreException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Exception occurred whilst retrieving all .lst files in a project", ce);
        }
        return allLstFiles;
    }

    private void getLstFiles(IResource[] resource_list, List allLstFiles) {
        try {
            int i = 0;
            while (i < resource_list.length) {
                IResource ir = resource_list[i];
                if (ir.getName().endsWith(".lst") && !ir.getName().equals("default.lst")) {
                    allLstFiles.add(ir);
                }
                if (ir instanceof IContainer) {
                    this.getLstFiles(((IContainer)ir).members(), allLstFiles);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            CoreException coreException2 = coreException;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(coreException2, (Object)this, ajc$tjp_12, ajc$tjp_13);
            CoreException ce = coreException2;
            AspectJUIPlugin.getDefault().getErrorHandler().handleError("Exception occurred whilst retrieiving all .lst files in a project", ce);
        }
    }

    public void disableBuildConfiguratorResourceChangeListener() {
        AspectJUIPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
    }

    public void enableBuildConfiguratorResourceChangeListener() {
        AspectJUIPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 15);
    }
}

