/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.HierarchyWalker;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IHierarchyListener;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.ui.editor.AspectJEditor;
import org.eclipse.ajdt.internal.ui.resources.AJDTIcon;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.ras.UIFFDC;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class PointcutNavigatorView
extends ViewPart {
    private HashMap targetHistory = new HashMap();
    private boolean structureModelLocked = false;
    public final IHierarchyListener VIEW_LISTENER = new IHierarchyListener(){

        public void elementsUpdated(IHierarchy model) {
            Workbench.getInstance().getDisplay().asyncExec(new Runnable(this){
                final /* synthetic */ 1 this$1;
                private static final JoinPoint.StaticPart ajc$tjp_0;
                private static final JoinPoint.StaticPart ajc$tjp_1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    try {
                        if (PointcutNavigatorView.access$0(1.access$0(this.this$1)) != null) {
                            PointcutNavigatorView.access$0(1.access$0(this.this$1)).refresh();
                            PointcutNavigatorView.access$0(1.access$0(this.this$1)).expandAll();
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(throwable2, this, ajc$tjp_0, ajc$tjp_1);
                        Throwable t = throwable2;
                        t.printStackTrace();
                    }
                }

                static {
                    Factory factory = new Factory("PointcutNavigatorView.java", Class.forName("org.eclipse.ajdt.ui.navigator.PointcutNavigatorView$2"));
                    ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.navigator.PointcutNavigatorView$2-java.lang.Throwable-t-"), 59);
                    ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-run-org.eclipse.ajdt.ui.navigator.PointcutNavigatorView$2----void-"), 55);
                }
            });
        }

        static /* synthetic */ PointcutNavigatorView access$0(1 var0) {
            return var0.PointcutNavigatorView.this;
        }
    };
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action pinStructureModel;
    private Action action2;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;

    public void createPartControl(Composite parent) {
        try {
            this.viewer = new TreeViewer(parent, 770);
            this.drillDownAdapter = new DrillDownAdapter(this.viewer);
            this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
            this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
            this.viewer.setSorter((ViewerSorter)new NameSorter());
            this.viewer.setInput((Object)this.getViewSite());
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){
                private static final JoinPoint.StaticPart ajc$tjp_0;
                private static final JoinPoint.StaticPart ajc$tjp_1;
                private static final JoinPoint.StaticPart ajc$tjp_2;

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection selection = (StructuredSelection)PointcutNavigatorView.this.viewer.getSelection();
                    if (selection.getFirstElement() != null && selection.getFirstElement() instanceof TreeParent) {
                        TreeParent parent = (TreeParent)selection.getFirstElement();
                        if (parent.getElement() == null) {
                            return;
                        }
                        IResource resource = AspectJUIPlugin.getDefault().getAjdtProjectProperties().findResource(parent.getElement().getSourceLocation().getSourceFile().getAbsolutePath(), AspectJUIPlugin.getDefault().getCurrentProject());
                        try {
                            IEditorPart part = IDE.openEditor((IWorkbenchPage)AspectJUIPlugin.getDefault().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)resource), (boolean)true);
                            if (part instanceof AspectJEditor) {
                                AspectJEditor editor = (AspectJEditor)part;
                                IDocumentProvider provider = editor.getDocumentProvider();
                                IDocument document = provider.getDocument((Object)editor.getEditorInput());
                                try {
                                    int start = document.getLineOffset(parent.getElement().getSourceLocation().getLine());
                                    editor.selectAndReveal(start - 2, 0);
                                    IWorkbenchPage page = editor.getSite().getPage();
                                    page.activate((IWorkbenchPart)editor);
                                }
                                catch (BadLocationException badLocationException) {
                                    BadLocationException badLocationException2 = badLocationException;
                                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(badLocationException2, this, ajc$tjp_0, ajc$tjp_1);
                                }
                            }
                        }
                        catch (PartInitException partInitException) {
                            PartInitException partInitException2 = partInitException;
                            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(partInitException2, this, ajc$tjp_2, ajc$tjp_1);
                            PartInitException e = partInitException2;
                            e.printStackTrace();
                        }
                    }
                }

                static {
                    Factory factory = new Factory("PointcutNavigatorView.java", Class.forName("org.eclipse.ajdt.ui.navigator.PointcutNavigatorView$4"));
                    ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.navigator.PointcutNavigatorView$4-org.eclipse.jface.text.BadLocationException-<missing>-"), 390);
                    ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-selectionChanged-org.eclipse.ajdt.ui.navigator.PointcutNavigatorView$4-org.eclipse.jface.viewers.SelectionChangedEvent:-event:--void-"), 367);
                    ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.navigator.PointcutNavigatorView$4-org.eclipse.ui.PartInitException-e-"), 394);
                }
            });
            this.makeActions();
            this.hookContextMenu();
            this.hookDoubleClickAction();
            this.contributeToActionBars();
            AsmManager.getDefault().addListener(this.VIEW_LISTENER);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(throwable2, (Object)this, ajc$tjp_0, ajc$tjp_1);
            Throwable t = throwable2;
            t.printStackTrace();
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PointcutNavigatorView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.pinStructureModel);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.action2);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.pinStructureModel);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.pinStructureModel);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.pinStructureModel = new TogglePushpinAction();
        this.pinStructureModel.setText("Pin structure model");
        this.pinStructureModel.setToolTipText("Pin structure model");
        this.action2 = new Action(){

            public void run() {
            }
        };
        this.action2.setText("Action 2");
        this.action2.setToolTipText("Action 2 tooltip");
        this.action2.setImageDescriptor(AspectJImages.HIDE_DECLARATIONS.getImageDescriptor());
    }

    private void hookDoubleClickAction() {
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Sample View", (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    static {
        Factory factory = new Factory("PointcutNavigatorView.java", Class.forName("org.eclipse.ajdt.ui.navigator.PointcutNavigatorView"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.navigator.PointcutNavigatorView-java.lang.Throwable-t-"), 407);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-createPartControl-org.eclipse.ajdt.ui.navigator.PointcutNavigatorView-org.eclipse.swt.widgets.Composite:-parent:--void-"), 359);
    }

    private final class TogglePushpinAction
    extends Action {
        public TogglePushpinAction() {
            this.setChecked(false);
        }

        public void run() {
            PointcutNavigatorView.this.structureModelLocked = !PointcutNavigatorView.this.structureModelLocked;
            this.setChecked(PointcutNavigatorView.this.structureModelLocked);
        }
    }

    class TreeObject
    implements IAdaptable {
        private IProgramElement element;
        private TreeParent parent;

        public TreeObject(IProgramElement element) {
            this.element = element;
        }

        public String getName() {
            return this.element.toLabelString();
        }

        public void setParent(TreeParent parent) {
            this.parent = parent;
        }

        public TreeParent getParent() {
            return this.parent;
        }

        public String toString() {
            return this.getName();
        }

        public Object getAdapter(Class key) {
            return null;
        }

        public IProgramElement getElement() {
            return this.element;
        }
    }

    class TreeParent
    extends TreeObject {
        private ArrayList children;
        private String relationshipName;
        boolean isLink = false;
        boolean isMissing = false;
        boolean isNew = false;

        public TreeParent(String relationshipName) {
            super(null);
            this.relationshipName = relationshipName;
            this.children = new ArrayList();
        }

        public String toString() {
            if (((TreeObject)this).element == null) {
                return this.relationshipName;
            }
            return this.getName();
        }

        public TreeParent(IProgramElement element) {
            super(element);
            this.children = new ArrayList();
        }

        public void addChild(TreeObject child) {
            this.children.add(child);
            child.setParent(this);
        }

        public void removeChild(TreeObject child) {
            this.children.remove(child);
            child.setParent(null);
        }

        public TreeObject[] getChildren() {
            return this.children.toArray(new TreeObject[this.children.size()]);
        }

        public boolean hasChildren() {
            return this.children.size() > 0;
        }

        public boolean isLink() {
            return this.isLink;
        }

        public void setLink(boolean isLink) {
            this.isLink = isLink;
        }

        public boolean isMissing() {
            return this.isMissing;
        }

        public void setMissing(boolean isMissing) {
            this.isMissing = isMissing;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public void setNew(boolean isNew) {
            this.isNew = isNew;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private TreeParent invisibleRoot;
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.StaticPart ajc$tjp_1;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (AsmManager.getDefault().getHierarchy().getRoot() == null) {
                return new TreeParent[]{new TreeParent("<rebuild to view structure>")};
            }
            ArrayList pointcutsAndAdvice = new ArrayList();
            AsmManager.getDefault().getHierarchy().getRoot().walk(new HierarchyWalker(this, pointcutsAndAdvice){
                final /* synthetic */ ViewContentProvider this$1;
                private final /* synthetic */ List val$pointcutsAndAdvice;
                {
                    this.this$1 = viewContentProvider;
                    this.val$pointcutsAndAdvice = list;
                }

                public void preProcess(IProgramElement node) {
                    if (node.getKind().equals(IProgramElement.Kind.POINTCUT) || node.getKind().equals(IProgramElement.Kind.ADVICE)) {
                        this.val$pointcutsAndAdvice.add(node);
                    }
                }
            });
            return this.buildPointcutTree(pointcutsAndAdvice);
        }

        private Object[] buildPointcutTree(List pointcutsAndAdvice) {
            ArrayList<TreeParent> topLevel = new ArrayList<TreeParent>();
            Iterator it = pointcutsAndAdvice.iterator();
            while (it.hasNext()) {
                IProgramElement element = (IProgramElement)it.next();
                IRelationship relationship = AsmManager.getDefault().getRelationshipMap().get(element, IRelationship.Kind.USES_POINTCUT, "uses pointcut");
                if (relationship != null && relationship.getTargets().size() != 0) continue;
                TreeParent adviceOrPointcutNode = new TreeParent(element);
                topLevel.add(adviceOrPointcutNode);
                this.addAllReferencingAsChildren(adviceOrPointcutNode);
                this.addTargets(adviceOrPointcutNode);
            }
            return topLevel.toArray();
        }

        private void addTargets(TreeParent node) {
            try {
                IRelationship advice;
                if (node.getElement() == null) {
                    return;
                }
                if (node.getElement().getKind() == IProgramElement.Kind.ADVICE && (advice = AsmManager.getDefault().getRelationshipMap().get(node.getElement(), IRelationship.Kind.ADVICE, "advises")).getTargets().size() != 0) {
                    TreeParent adviceNode = new TreeParent("advises");
                    List newTargets = advice.getTargets();
                    List oldTargets = (List)PointcutNavigatorView.this.targetHistory.get(node.getElement().getHandleIdentifier());
                    ArrayList allTargets = new ArrayList();
                    allTargets.addAll(newTargets);
                    if (oldTargets != null) {
                        Iterator it3 = oldTargets.iterator();
                        while (it3.hasNext()) {
                            Object next = it3.next();
                            if (allTargets.contains(next)) continue;
                            allTargets.add(next);
                        }
                    }
                    Iterator it2 = allTargets.iterator();
                    while (it2.hasNext()) {
                        String handle = (String)it2.next();
                        IProgramElement target = AsmManager.getDefault().getHierarchy().getElement(handle);
                        if (target == null) continue;
                        TreeParent targetNode = new TreeParent(target);
                        targetNode.setLink(true);
                        if (oldTargets != null) {
                            if (!newTargets.contains(target.getHandleIdentifier())) {
                                targetNode.setMissing(true);
                            }
                            if (!oldTargets.contains(target.getHandleIdentifier())) {
                                targetNode.setNew(true);
                            }
                        }
                        adviceNode.addChild(targetNode);
                    }
                    node.addChild(adviceNode);
                    if (!PointcutNavigatorView.this.structureModelLocked) {
                        PointcutNavigatorView.this.targetHistory.put(node.getElement().getHandleIdentifier(), newTargets);
                    }
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_ras_FFDC$2$7ced305e(throwable2, this, ajc$tjp_0, ajc$tjp_1);
                Throwable t = throwable2;
                t.printStackTrace();
            }
        }

        private void addAllReferencingAsChildren(TreeParent node) {
            IRelationship relationship = AsmManager.getDefault().getRelationshipMap().get(node.getElement(), IRelationship.Kind.USES_POINTCUT, "pointcut used by");
            if (relationship != null && relationship.getTargets().size() != 0) {
                Iterator it = relationship.getTargets().iterator();
                while (it.hasNext()) {
                    String handle = (String)it.next();
                    IProgramElement child = AsmManager.getDefault().getHierarchy().getElement(handle);
                    TreeParent childNode = new TreeParent(child);
                    node.addChild(childNode);
                    this.addAllReferencingAsChildren(childNode);
                    this.addTargets(childNode);
                }
            }
        }

        public Object getParent(Object child) {
            if (child instanceof TreeObject) {
                return ((TreeObject)child).getParent();
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).getChildren();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            if (parent instanceof TreeParent) {
                return ((TreeParent)parent).hasChildren();
            }
            return false;
        }

        private void initialize() {
            this.invisibleRoot.addChild(new TreeParent(AsmManager.getDefault().getHierarchy().getRoot()));
        }

        static {
            Factory factory = new Factory("PointcutNavigatorView.java", Class.forName("org.eclipse.ajdt.ui.navigator.PointcutNavigatorView$ViewContentProvider"));
            ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("0--org.eclipse.ajdt.ui.navigator.PointcutNavigatorView$ViewContentProvider-java.lang.Throwable-t-"), 247);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-addTargets-org.eclipse.ajdt.ui.navigator.PointcutNavigatorView$ViewContentProvider-org.eclipse.ajdt.ui.navigator.PointcutNavigatorView$TreeParent:-node:--void-"), 208);
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements IColorProvider,
    IFontProvider {
        ViewLabelProvider() {
        }

        public Font getFont(Object element) {
            if (!(element instanceof TreeParent)) {
                return null;
            }
            TreeParent node = (TreeParent)element;
            if (node.isNew() || node.isMissing()) {
                return new Font(null, "Tahoma", 8, 1);
            }
            return null;
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            if (obj instanceof TreeParent) {
                IProgramElement element = ((TreeParent)obj).getElement();
                if (element == null) {
                    return AspectJImages.ADVICE.getImageDescriptor().createImage();
                }
                if (element.getKind() == IProgramElement.Kind.ADVICE) {
                    AJDTIcon icon = (AJDTIcon)AspectJImages.registry().getIcon(element.getKind());
                    return icon.getImageDescriptor().createImage();
                }
                AJDTIcon icon = (AJDTIcon)AspectJImages.registry().getStructureIcon(element.getKind(), element.getAccessibility());
                return icon.getImageDescriptor().createImage();
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (!(element instanceof TreeParent)) {
                return null;
            }
            TreeParent node = (TreeParent)element;
            if (node.isMissing()) {
                return new Color((Device)Workbench.getInstance().getDisplay(), 120, 120, 120);
            }
            if (node.isLink()) {
                return new Color((Device)Workbench.getInstance().getDisplay(), 0, 0, 255);
            }
            return new Color((Device)Workbench.getInstance().getDisplay(), 0, 0, 0);
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

