/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.ui.visualiser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.ajdt.internal.ui.resources.AspectJImages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.ajdt.ui.visualiser.AJDTContentProvider;
import org.eclipse.ajdt.ui.visualiser.AJDTVisualiserUtils;
import org.eclipse.contribution.visualiser.VisualiserPlugin;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.core.Stripe;
import org.eclipse.contribution.visualiser.interfaces.IMarkupKind;
import org.eclipse.contribution.visualiser.interfaces.IMember;
import org.eclipse.contribution.visualiser.jdtImpl.JDTMember;
import org.eclipse.contribution.visualiser.markerImpl.ResourceMember;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMarkupKind;
import org.eclipse.contribution.visualiser.simpleImpl.SimpleMarkupProvider;
import org.eclipse.contribution.visualiser.simpleImpl.StealthMarkupKind;
import org.eclipse.contribution.visualiser.utils.JDTUtils;
import org.eclipse.contribution.visualiser.utils.MarkupUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IActionBars;

public class AJDTMarkupProvider
extends SimpleMarkupProvider {
    private IAction hideErrorsAction;
    private Action hideWarningsAction;
    private boolean hideErrors;
    private boolean hideWarnings;
    private Map kindMap;
    protected static final String aspectJErrorKind = "AspectJ Error";
    protected static final String aspectJWarningKind = "AspectJ Warning";
    protected Map savedColours;
    private static Color aspectJErrorColor = new Color(null, new RGB(228, 5, 64));
    private static Color aspectJWarningColor = new Color(null, new RGB(255, 206, 90));
    private Action resetColorMemoryAction;
    private static String resetColorMemoryID = "ResetColorMemoryUniqueID32dfnio239";
    private IPreferenceStore prefs = AspectJUIPlugin.getDefault().getPreferenceStore();
    private static final String allPrefereceKeys = "AJDTVisualiserMarkupProvider.allPrefereceKeys";

    public List getMemberMarkups(IMember member) {
        IJavaProject jp;
        List markupList = super.getMemberMarkups(member);
        if (markupList != null) {
            return this.checkErrorsAndWarnings(markupList);
        }
        System.currentTimeMillis();
        ArrayList<Stripe> stripeList = new ArrayList<Stripe>();
        if (ProviderManager.getContentProvider() instanceof AJDTContentProvider && (jp = ((AJDTContentProvider)ProviderManager.getContentProvider()).getCurrentProject()) != null) {
            List list = AJDTVisualiserUtils.getMarkupInfo(member, jp.getProject(), !this.hideErrors, !this.hideWarnings);
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Map map = (Map)iter.next();
                Iterator iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    Integer lineNum = (Integer)iterator.next();
                    List aspects = (List)map.get(lineNum);
                    ArrayList<IMarkupKind> kinds = new ArrayList<IMarkupKind>();
                    Iterator it = aspects.iterator();
                    while (it.hasNext()) {
                        boolean errorKind;
                        String name = (String)it.next();
                        Object markupKind = null;
                        if (this.kindMap == null) {
                            this.kindMap = new HashMap();
                        }
                        if ((errorKind = name.startsWith(aspectJErrorKind)) || name.startsWith(aspectJWarningKind)) {
                            if (this.kindMap.get(name) instanceof IMarkupKind) {
                                markupKind = (IMarkupKind)this.kindMap.get(name);
                            } else {
                                markupKind = new ErrorOrWarningMarkupKind(name, errorKind);
                                this.kindMap.put(name, markupKind);
                            }
                        } else if (this.kindMap.get(name) instanceof IMarkupKind) {
                            markupKind = (IMarkupKind)this.kindMap.get(name);
                        } else {
                            markupKind = new SimpleMarkupKind(name);
                            this.kindMap.put(name, markupKind);
                        }
                        kinds.add((IMarkupKind)markupKind);
                    }
                    Stripe stripe = new Stripe(kinds, lineNum.intValue(), 1);
                    stripeList.add(stripe);
                    this.addMarkup(member.getFullname(), stripe);
                }
            }
        }
        System.currentTimeMillis();
        MarkupUtils.processStripes(stripeList);
        System.currentTimeMillis();
        return this.checkErrorsAndWarnings(stripeList);
    }

    private List checkErrorsAndWarnings(List stripes) {
        ArrayList<Stripe> returningStripes = new ArrayList<Stripe>();
        Iterator iter = stripes.iterator();
        while (iter.hasNext()) {
            Stripe stripe = (Stripe)iter.next();
            ArrayList kinds = new ArrayList(stripe.getKinds());
            Iterator iterator = kinds.iterator();
            while (iterator.hasNext()) {
                String name;
                String[] parts;
                IMarkupKind kind = (IMarkupKind)iterator.next();
                if (!(kind instanceof StealthMarkupKind) || (parts = (name = kind.getName()).split(":::")).length <= 1) continue;
                String aspectName = parts[1];
                if (VisualiserPlugin.menu == null || VisualiserPlugin.menu.getActive(aspectName)) continue;
                iterator.remove();
            }
            Stripe newStripe = new Stripe(kinds, stripe.getOffset(), stripe.getDepth());
            returningStripes.add(newStripe);
        }
        return returningStripes;
    }

    public Color getColorFor(IMarkupKind id) {
        if (id.getName().startsWith(aspectJErrorKind)) {
            return aspectJErrorColor;
        }
        if (id.getName().startsWith(aspectJWarningKind)) {
            return aspectJWarningColor;
        }
        Color savedColor = this.getSavedColour(id.getName());
        if (savedColor == null) {
            return super.getColorFor(id);
        }
        return savedColor;
    }

    public void setColorFor(IMarkupKind kind, Color color) {
        super.setColorFor(kind, color);
        this.saveColourForAspect(kind.getName(), color.getRed(), color.getGreen(), color.getBlue());
    }

    public SortedSet getAllMarkupKinds() {
        IJavaProject jp;
        TreeSet<Object> kinds = new TreeSet<Object>();
        if (ProviderManager.getContentProvider() instanceof AJDTContentProvider && (jp = ((AJDTContentProvider)ProviderManager.getContentProvider()).getCurrentProject()) != null) {
            if (this.kindMap == null) {
                this.kindMap = new HashMap();
            }
            Set aspects = AJDTVisualiserUtils.getAllAspects(jp, true);
            Iterator iter = aspects.iterator();
            while (iter.hasNext()) {
                SimpleMarkupKind markupKind;
                String name = (String)iter.next();
                int lastSlash = name.lastIndexOf("/");
                if (lastSlash == -1) {
                    lastSlash = name.lastIndexOf("\\");
                }
                name = name.substring(lastSlash + 1);
                if (this.kindMap.get(name = name.substring(0, name.lastIndexOf("."))) instanceof IMarkupKind) {
                    markupKind = (IMarkupKind)this.kindMap.get(name);
                } else {
                    markupKind = new SimpleMarkupKind(name);
                    this.kindMap.put(name, markupKind);
                }
                kinds.add(markupKind);
            }
            if (!this.hideErrors) {
                if (this.kindMap.get(aspectJErrorKind) instanceof IMarkupKind) {
                    kinds.add((IMarkupKind)this.kindMap.get(aspectJErrorKind));
                } else {
                    StealthMarkupKind errorKind = new StealthMarkupKind(aspectJErrorKind);
                    kinds.add(errorKind);
                    this.kindMap.put(aspectJErrorKind, errorKind);
                }
            }
            if (!this.hideWarnings) {
                if (this.kindMap.get(aspectJWarningKind) instanceof IMarkupKind) {
                    kinds.add((IMarkupKind)this.kindMap.get(aspectJWarningKind));
                } else {
                    StealthMarkupKind warningKind = new StealthMarkupKind(aspectJWarningKind);
                    kinds.add(warningKind);
                    this.kindMap.put(aspectJWarningKind, warningKind);
                }
            }
        }
        if (kinds.size() > 0) {
            return kinds;
        }
        return null;
    }

    public boolean processMouseclick(IMember member, Stripe stripe, int buttonClicked) {
        if (buttonClicked == 1) {
            IResource res;
            if (member instanceof JDTMember) {
                IJavaElement jEl = ((JDTMember)member).getResource();
                if (jEl != null) {
                    JDTUtils.openInEditor((IResource)jEl.getResource(), (int)stripe.getOffset());
                }
            } else if (member instanceof ResourceMember && (res = ((ResourceMember)member).getResource()) != null) {
                JDTUtils.openInEditor((IResource)res, (int)stripe.getOffset());
            }
            return false;
        }
        return true;
    }

    protected void saveColourForAspect(String aspectName, int r, int g, int b) {
        if (ProviderManager.getContentProvider() instanceof AJDTContentProvider) {
            String allColourKeys;
            IProject currentProject = ((AJDTContentProvider)ProviderManager.getContentProvider()).getCurrentProject().getProject();
            String key = currentProject + ":::" + aspectName;
            if (this.prefs.getString(key) == null) {
                this.prefs.setDefault(key, "");
            }
            if ((allColourKeys = this.prefs.getString(allPrefereceKeys)) == null) {
                this.prefs.putValue(allPrefereceKeys, key);
                this.prefs.setDefault(allPrefereceKeys, "");
            } else {
                allColourKeys = String.valueOf(allColourKeys) + "," + key;
                this.prefs.putValue(allPrefereceKeys, allColourKeys);
            }
            String value = String.valueOf(r) + "," + g + "," + b;
            this.prefs.setValue(key, value);
            if (this.savedColours == null) {
                this.savedColours = new HashMap();
            }
            this.savedColours.remove(key);
            this.savedColours.put(key, value);
        }
    }

    protected Color getSavedColour(String aspectName) {
        if (ProviderManager.getContentProvider() instanceof AJDTContentProvider) {
            String value;
            IProject currentProject = ((AJDTContentProvider)ProviderManager.getContentProvider()).getCurrentProject().getProject();
            String key = currentProject + ":::" + aspectName;
            if (this.savedColours == null) {
                this.savedColours = new HashMap();
            }
            if ((value = (String)this.savedColours.get(key)) == null) {
                IPreferenceStore prefs = AspectJUIPlugin.getDefault().getPreferenceStore();
                value = prefs.getString(key);
                this.savedColours.put(key, value);
            }
            if (value != null && value != "") {
                String[] rgb = value.split(",");
                if (rgb.length != 3) {
                    return null;
                }
                int r = Integer.parseInt(rgb[0]);
                int g = Integer.parseInt(rgb[1]);
                int b = Integer.parseInt(rgb[2]);
                return new Color(null, new RGB(r, g, b));
            }
        }
        return null;
    }

    public void activate() {
        if (VisualiserPlugin.menu != null) {
            this.resetColorMemoryAction = new Action(){

                public void run() {
                    AJDTMarkupProvider.this.resetSavedColours();
                    VisualiserPlugin.refresh();
                }
            };
            this.resetColorMemoryAction.setImageDescriptor(AspectJImages.RESET_COLOURS.getImageDescriptor());
            this.resetColorMemoryAction.setText(AspectJUIPlugin.getResourceString("ResetColorMemory"));
            this.resetColorMemoryAction.setId(resetColorMemoryID);
            this.hideErrorsAction = new Action(){

                public int getStyle() {
                    return 2;
                }

                public void run() {
                    AJDTMarkupProvider.this.hideErrors = AJDTMarkupProvider.this.hideErrorsAction.isChecked();
                    AJDTMarkupProvider.this.resetMarkupsAndKinds();
                    VisualiserPlugin.refresh();
                }
            };
            this.hideErrorsAction.setImageDescriptor(AspectJImages.HIDE_ERRORS.getImageDescriptor());
            this.hideErrorsAction.setToolTipText(AspectJUIPlugin.getResourceString("HideErrors"));
            this.hideWarningsAction = new Action(){

                public int getStyle() {
                    return 2;
                }

                public void run() {
                    AJDTMarkupProvider.this.hideWarnings = AJDTMarkupProvider.this.hideWarningsAction.isChecked();
                    AJDTMarkupProvider.this.resetMarkupsAndKinds();
                    VisualiserPlugin.refresh();
                }
            };
            this.hideWarningsAction.setImageDescriptor(AspectJImages.HIDE_WARNINGS.getImageDescriptor());
            this.hideWarningsAction.setToolTipText(AspectJUIPlugin.getResourceString("HideWarnings"));
            IActionBars menuActionBars = VisualiserPlugin.menu.getViewSite().getActionBars();
            IToolBarManager toolBarManager = menuActionBars.getToolBarManager();
            toolBarManager.add(this.hideErrorsAction);
            toolBarManager.add((IAction)this.hideWarningsAction);
            toolBarManager.update(true);
            IMenuManager menuManager = menuActionBars.getMenuManager();
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IAction)this.resetColorMemoryAction);
        }
    }

    protected void resetSavedColours() {
        String colourKeys = this.prefs.getString(allPrefereceKeys);
        if (colourKeys != null && colourKeys != "") {
            String[] keys = colourKeys.split(",");
            int i = 0;
            while (i < keys.length) {
                this.prefs.setToDefault(keys[i]);
                ++i;
            }
            this.prefs.setToDefault(allPrefereceKeys);
        }
        this.savedColours = new HashMap();
        super.resetColours();
    }

    public void deactivate() {
        super.deactivate();
        if (VisualiserPlugin.menu != null) {
            IActionBars menuActionBars = VisualiserPlugin.menu.getViewSite().getActionBars();
            IToolBarManager toolBarManager = menuActionBars.getToolBarManager();
            toolBarManager.removeAll();
            toolBarManager.update(true);
            IMenuManager menuManager = menuActionBars.getMenuManager();
            menuManager.remove(resetColorMemoryID);
            menuManager.update(true);
        }
    }

    private class ErrorOrWarningMarkupKind
    extends StealthMarkupKind {
        private boolean errorKind;
        private String declaringAspect;

        public ErrorOrWarningMarkupKind(String name, boolean errorKind) {
            super(name);
            this.errorKind = errorKind;
            String[] nameParts = name.split(":::");
            if (nameParts.length > 1) {
                this.declaringAspect = nameParts[1];
            }
        }

        public String toString() {
            if (this.errorKind) {
                return String.valueOf(AspectJUIPlugin.getResourceString("AspectJError")) + ": " + this.declaringAspect;
            }
            return String.valueOf(AspectJUIPlugin.getResourceString("AspectJWarning")) + ": " + this.declaringAspect;
        }
    }
}

