/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.contribution.xref.core.IDeferredXReference;
import org.eclipse.contribution.xref.core.IXReferenceNode;
import org.eclipse.contribution.xref.internal.ui.XReferenceUIPlugin;
import org.eclipse.contribution.xref.internal.ui.inplace.XReferenceInformationControl;
import org.eclipse.contribution.xref.internal.ui.providers.TreeObject;
import org.eclipse.contribution.xref.internal.ui.providers.XReferenceContentProvider;
import org.eclipse.contribution.xref.ui.views.XReferenceView;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;

public class DoubleClickAction
extends Action {
    private Shell shell;
    private TreeViewer viewer;
    private Object typeOfView;
    private XReferenceInformationControl infoControl;
    private XReferenceView view;

    public DoubleClickAction(Shell shell, TreeViewer viewer, Object typeOfView) {
        this.shell = shell;
        this.viewer = viewer;
        this.typeOfView = typeOfView;
        if (typeOfView instanceof XReferenceInformationControl) {
            this.infoControl = (XReferenceInformationControl)typeOfView;
        } else if (typeOfView instanceof XReferenceView) {
            this.view = (XReferenceView)((Object)typeOfView);
        }
    }

    public void run() {
        Object sel;
        Object data;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && (data = ((TreeObject)(sel = ((IStructuredSelection)selection).getFirstElement())).getData()) != null) {
            if (data instanceof IXReferenceNode) {
                this.revealInEditor(((IXReferenceNode)data).getJavaElement());
            } else if (data instanceof IJavaElement) {
                this.revealInEditor((IJavaElement)data);
            } else if (data instanceof IDeferredXReference) {
                this.evaluateXReferences((IDeferredXReference)data);
            } else if (data instanceof IResource) {
                this.revealInEditor((IResource)data);
            }
        }
    }

    private void revealInEditor(IJavaElement j) {
        try {
            IEditorPart p = JavaUI.openInEditor((IJavaElement)j);
            JavaUI.revealInEditor((IEditorPart)p, (IJavaElement)j);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void revealInEditor(IResource r) {
        try {
            IMarker m = r.createMarker("org.eclipse.core.resources.marker");
            IDE.openEditor((IWorkbenchPage)this.getActiveWorkbenchWindow().getActivePage(), (IMarker)m, (boolean)true);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void evaluateXReferences(IDeferredXReference xr) {
        try {
            new ProgressMonitorDialog(this.shell).run(true, true, (IRunnableWithProgress)xr);
            if (!(this.viewer.getContentProvider() instanceof XReferenceContentProvider)) {
                return;
            }
            ((XReferenceContentProvider)this.viewer.getContentProvider()).refresh();
            this.viewer.refresh();
            this.viewer.expandToLevel(3);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invEx) {
            System.err.println("Something nasty here, " + xr + " could not be evaluated: " + invEx);
        }
    }

    private IWorkbenchWindow getActiveWorkbenchWindow() {
        return XReferenceUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }
}

