/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.internal.ui.actions;

import org.eclipse.contribution.xref.internal.ui.XReferenceUIPlugin;
import org.eclipse.contribution.xref.internal.ui.actions.NavigationHistoryManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class NavigationHistoryActionGroup
extends NavigationHistoryManager {
    private Viewer viewer;
    private Action backAction;
    private Action forwardAction;

    public NavigationHistoryActionGroup(Viewer viewer) {
        this.viewer = viewer;
    }

    public void addNavigationActions(IMenuManager manager) {
        this.createActions();
        manager.add((IAction)this.backAction);
        manager.add((IAction)this.forwardAction);
        this.updateNavigationButtons();
    }

    public void addNavigationActions(IToolBarManager toolBar) {
        this.createActions();
        toolBar.add((IAction)this.backAction);
        toolBar.add((IAction)this.forwardAction);
        this.updateNavigationButtons();
    }

    private void createActions() {
        if (this.backAction != null) {
            return;
        }
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.backAction = new Action(XReferenceUIPlugin.getResourceString("GoBack.text")){

            public void run() {
                NavigationHistoryActionGroup.this.goBack(NavigationHistoryActionGroup.this.viewer.getInput());
            }
        };
        this.backAction.setToolTipText(XReferenceUIPlugin.getResourceString("GoBack.toolTip"));
        this.backAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
        this.backAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
        this.forwardAction = new Action(XReferenceUIPlugin.getResourceString("GoForward.text")){

            public void run() {
                NavigationHistoryActionGroup.this.goForward(NavigationHistoryActionGroup.this.viewer.getInput());
            }
        };
        this.forwardAction.setToolTipText(XReferenceUIPlugin.getResourceString("GoForward.toolTip"));
        this.forwardAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
        this.forwardAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
    }

    private void updateNavigationButtons() {
        if (this.backAction != null) {
            this.backAction.setEnabled(this.hasBack());
            this.forwardAction.setEnabled(this.hasForward());
        }
    }

    public Object goBack(Object o) {
        Object back = super.goBack(o);
        this.viewer.setInput(back);
        this.updateNavigationButtons();
        return back;
    }

    public Object goForward(Object o) {
        Object fwd = super.goForward(o);
        this.viewer.setInput(fwd);
        this.updateNavigationButtons();
        return fwd;
    }

    public void nowLeaving(Object o) {
        super.nowLeaving(o);
        this.updateNavigationButtons();
    }
}

