/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.internal.ui.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.contribution.xref.core.IDeferredXReference;
import org.eclipse.contribution.xref.core.IXReference;
import org.eclipse.contribution.xref.core.IXReferenceAdapter;
import org.eclipse.contribution.xref.internal.ui.XReferenceUIPlugin;
import org.eclipse.contribution.xref.internal.ui.providers.TreeObject;
import org.eclipse.contribution.xref.internal.ui.providers.TreeParent;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class XReferenceContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private TreeParent invisibleRoot;
    private Object input = null;
    static /* synthetic */ Class class$0;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput != null) {
            this.input = newInput;
            this.initialize();
            if (v != null) {
                v.refresh();
            }
        }
    }

    public void refresh() {
        this.initialize();
    }

    public void dispose() {
        this.input = null;
        this.invisibleRoot = null;
    }

    public Object[] getElements(Object parent) {
        if (parent == null) {
            return new Object[0];
        }
        if (parent.equals(this.input)) {
            return this.getChildren(this.invisibleRoot);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof TreeObject) {
            return ((TreeObject)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof TreeParent) {
            return ((TreeParent)parent).getChildren();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof TreeParent) {
            return ((TreeParent)parent).hasChildren();
        }
        return false;
    }

    private void initialize() {
        this.invisibleRoot = new TreeParent("");
        if (this.input != null && this.input instanceof IXReferenceAdapter) {
            IXReferenceAdapter xreferenceAdapter = (IXReferenceAdapter)this.input;
            TreeParent root = new TreeParent(xreferenceAdapter.toString());
            root.setData(xreferenceAdapter.getReferenceSource());
            this.invisibleRoot.addChild(root);
            this.addXReferencesToTree(root, xreferenceAdapter.getXReferences());
            Object o = xreferenceAdapter.getReferenceSource();
            JavaElement je = null;
            if (o instanceof IJavaElement) {
                je = (JavaElement)o;
            }
            IJavaElement[] extra = xreferenceAdapter.getExtraChildren((IJavaElement)je);
            IJavaElement[] children = null;
            if (je != null) {
                try {
                    ArrayList<IJavaElement> l = new ArrayList<IJavaElement>();
                    children = je.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        l.add(children[i]);
                        ++i;
                    }
                    if (extra != null) {
                        i = 0;
                        while (i < extra.length) {
                            l.add(extra[i]);
                            ++i;
                        }
                    }
                    children = l.toArray(new IJavaElement[0]);
                    i = 0;
                    while (i < children.length) {
                        IJavaElement child = children[i];
                        IAdaptable a = (IAdaptable)child;
                        Object xrefAdapterChild = null;
                        if (a != null) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.contribution.xref.core.IXReferenceAdapter");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            xrefAdapterChild = (IXReferenceAdapter)a.getAdapter((Class)clazz);
                        }
                        if (xrefAdapterChild != null) {
                            TreeParent childNode = new TreeParent(xrefAdapterChild.toString());
                            childNode.setData(xrefAdapterChild.getReferenceSource());
                            Collection xrc = xrefAdapterChild.getXReferences();
                            if (!xrc.isEmpty()) {
                                root.addChild(childNode);
                                this.addXReferencesToTree(childNode, xrc);
                            }
                        }
                        ++i;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        } else if (this.input != null) {
            TreeParent root = new TreeParent(this.input.getClass().getName());
            root.setData(this.input);
            this.invisibleRoot.addChild(root);
        }
    }

    private void addXReferencesToTree(TreeParent parent, Collection xreferences) {
        Iterator xri = xreferences.iterator();
        while (xri.hasNext()) {
            IXReference xr = (IXReference)xri.next();
            TreeParent relName = new TreeParent(xr.getName());
            if (xr instanceof IDeferredXReference) {
                this.addEvaluateChild(relName, (IDeferredXReference)xr);
            }
            Iterator li = xr.getAssociates();
            while (li.hasNext()) {
                Object associate = li.next();
                TreeObject leaf = new TreeObject(associate.toString());
                leaf.setData(associate);
                relName.addChild(leaf);
            }
            parent.addChild(relName);
        }
    }

    private void addEvaluateChild(TreeParent parent, IDeferredXReference r) {
        TreeObject t = new TreeObject(XReferenceUIPlugin.getResourceString("EvaluateLabel"));
        t.setData(r);
        parent.addChild(t);
    }
}

