/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.xref.ui.views;

import org.eclipse.contribution.xref.core.IXReferenceAdapter;
import org.eclipse.contribution.xref.internal.ui.XReferenceUIPlugin;
import org.eclipse.contribution.xref.internal.ui.actions.CollapseAllAction;
import org.eclipse.contribution.xref.internal.ui.actions.DoubleClickAction;
import org.eclipse.contribution.xref.internal.ui.actions.NavigationHistoryActionGroup;
import org.eclipse.contribution.xref.internal.ui.actions.ToggleLinkingAction;
import org.eclipse.contribution.xref.internal.ui.providers.XReferenceContentProvider;
import org.eclipse.contribution.xref.internal.ui.providers.XReferenceLabelProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class XReferenceView
extends ViewPart
implements ISelectionListener {
    public static final String ID = "org.eclipse.contribution.xref.ui.views.XReferenceView";
    private static final String LINK_ID = "org.eclipse.contribution.xref.ui.views.XReferenceView.link";
    private static final String SELECTION_ID = "org.eclipse.contribution.xref.ui.views.XReferenceView.selection";
    private Action doubleClickAction;
    private Action collapseAllAction;
    private Action toggleLinkingAction;
    private boolean linkingEnabled = true;
    private IXReferenceAdapter lastSelection;
    private NavigationHistoryActionGroup navigationHistoryGroup;
    private TreeViewer viewer;
    private XReferenceContentProvider contentProvider;
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.navigationHistoryGroup = new NavigationHistoryActionGroup((Viewer)this.viewer);
        this.contentProvider = new XReferenceContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new XReferenceLabelProvider());
        this.viewer.setAutoExpandLevel(3);
        this.restorePersistedSettings();
        this.makeActions();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        IWorkbenchWindow window = this.getActiveWorkbenchWindow();
        if (window != null) {
            window.getSelectionService().addSelectionListener((ISelectionListener)this);
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IAdaptable a = null;
        IXReferenceAdapter xra = null;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object first = structuredSelection.getFirstElement();
            if (first instanceof IAdaptable) {
                a = (IAdaptable)first;
            }
        } else if (part instanceof IEditorPart && selection instanceof ITextSelection && part instanceof JavaEditor) {
            JavaEditor je = (JavaEditor)part;
            a = (IAdaptable)((IJavaElement)this.computeHighlightRangeSourceReference(je));
        }
        if (a != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.contribution.xref.core.IXReferenceAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            xra = (IXReferenceAdapter)a.getAdapter((Class)clazz);
        }
        if (xra != null) {
            this.lastSelection = xra;
            if (this.linkingEnabled) {
                this.viewer.setInput((Object)xra);
            }
        }
    }

    public void dispose() {
        super.dispose();
        IWorkbenchWindow window = this.getActiveWorkbenchWindow();
        if (window != null) {
            window.getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
        this.persistSettings();
    }

    private IWorkbenchWindow getActiveWorkbenchWindow() {
        return XReferenceUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void setLinkingEnabled(boolean isOn) {
        this.linkingEnabled = isOn;
        if (this.linkingEnabled && this.lastSelection != null) {
            this.viewer.setInput((Object)this.lastSelection);
        }
    }

    public NavigationHistoryActionGroup getNavigationHistoryActionGroup() {
        return this.navigationHistoryGroup;
    }

    public void collapseAll() {
        this.viewer.collapseAll();
    }

    private void persistSettings() {
        IPreferenceStore pstore = XReferenceUIPlugin.getDefault().getPreferenceStore();
        if (!pstore.contains(LINK_ID)) {
            pstore.setDefault(LINK_ID, true);
        }
        pstore.setValue(LINK_ID, this.linkingEnabled);
        IXReferenceAdapter xra = (IXReferenceAdapter)this.viewer.getInput();
        if (xra != null) {
            Object input = xra.getReferenceSource();
            String handle = null;
            if (input instanceof IResource) {
                handle = "R" + ((IResource)input).getFullPath().toString();
            } else if (input instanceof IJavaElement) {
                handle = "J" + ((IJavaElement)input).getHandleIdentifier();
            }
            if (handle != null) {
                pstore.setValue(SELECTION_ID, handle);
            }
        }
        XReferenceUIPlugin.getDefault().savePluginPreferences();
    }

    private void restorePersistedSettings() {
        IPreferenceStore pstore = XReferenceUIPlugin.getDefault().getPreferenceStore();
        if (pstore.contains(LINK_ID)) {
            this.linkingEnabled = pstore.getBoolean(LINK_ID);
        }
        if (pstore.contains(SELECTION_ID)) {
            IJavaElement j;
            String sel = pstore.getString(SELECTION_ID);
            String handle = sel.substring(1);
            IXReferenceAdapter xra = null;
            if (sel.startsWith("R")) {
                new Path(handle);
                IResource r = XReferenceUIPlugin.getWorkspace().getRoot().findMember(handle);
                if (r != null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.contribution.xref.core.IXReferenceAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    xra = (IXReferenceAdapter)r.getAdapter((Class)clazz);
                }
            } else if (sel.startsWith("J") && (j = JavaCore.create((String)handle)) != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.contribution.xref.core.IXReferenceAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                xra = (IXReferenceAdapter)j.getAdapter((Class)clazz);
            }
            if (xra != null) {
                this.viewer.setInput(xra);
            }
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.toggleLinkingAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        this.navigationHistoryGroup.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.collapseAllAction);
        manager.add((IAction)this.toggleLinkingAction);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                XReferenceView.this.doubleClickAction.run();
            }
        });
    }

    private void makeActions() {
        this.toggleLinkingAction = new ToggleLinkingAction(this);
        this.collapseAllAction = new CollapseAllAction(this);
        this.doubleClickAction = new DoubleClickAction(this.getViewSite().getShell(), this.viewer, (Object)this);
    }

    private ISourceReference computeHighlightRangeSourceReference(JavaEditor editor) {
        ISourceViewer sourceViewer = editor.getViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getCaretOffset();
        }
        IJavaElement element = this.getElementAt(editor, caret, true);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        if (element.getElementType() == 13) {
            IImportDeclaration declaration = (IImportDeclaration)element;
            IImportContainer container = (IImportContainer)declaration.getParent();
            ISourceRange srcRange = null;
            try {
                srcRange = container.getSourceRange();
            }
            catch (JavaModelException javaModelException) {}
            if (srcRange != null && srcRange.getOffset() == caret) {
                return container;
            }
        }
        return (ISourceReference)element;
    }

    private IJavaElement getElementAt(JavaEditor editor, int offset, boolean reconcile) {
        block8: {
            IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
            ICompilationUnit unit = manager.getWorkingCopy(editor.getEditorInput());
            if (unit != null) {
                try {
                    if (reconcile) {
                        ICompilationUnit iCompilationUnit = unit;
                        synchronized (iCompilationUnit) {
                            unit.reconcile(0, false, null, null);
                        }
                        return unit.getElementAt(offset);
                    }
                    if (unit.isConsistent()) {
                        return unit.getElementAt(offset);
                    }
                }
                catch (JavaModelException x) {
                    if (x.isDoesNotExist()) break block8;
                    JavaPlugin.log((IStatus)x.getStatus());
                }
            }
        }
        return null;
    }
}

