/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantDouble;
import org.aspectj.apache.bcel.classfile.ConstantFloat;
import org.aspectj.apache.bcel.classfile.ConstantInteger;
import org.aspectj.apache.bcel.classfile.ConstantLong;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;

public class SimpleElementValue
extends ElementValue {
    private int idx;

    protected SimpleElementValue(int type, int idx, ConstantPool cpool) {
        super(type, cpool);
        this.idx = idx;
    }

    public int getIndex() {
        return this.idx;
    }

    public String getValueString() {
        if (this.type != 115) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantUtf8 c = (ConstantUtf8)this.cpool.getConstant(this.idx, (byte)1);
        return c.getBytes();
    }

    public int getValueInt() {
        if (this.type != 73) {
            throw new RuntimeException("Dont call getValueString() on a non STRING ElementValue");
        }
        ConstantInteger c = (ConstantInteger)this.cpool.getConstant(this.idx, (byte)3);
        return c.getBytes();
    }

    public String toString() {
        return this.stringifyValue();
    }

    public String stringifyValue() {
        switch (this.type) {
            case 73: {
                ConstantInteger c = (ConstantInteger)this.cpool.getConstant(this.idx, (byte)3);
                return Integer.toString(c.getBytes());
            }
            case 74: {
                ConstantLong j = (ConstantLong)this.cpool.getConstant(this.idx, (byte)5);
                return Long.toString(j.getBytes());
            }
            case 68: {
                ConstantDouble d = (ConstantDouble)this.cpool.getConstant(this.idx, (byte)6);
                return Double.toString(d.getBytes());
            }
            case 70: {
                ConstantFloat f = (ConstantFloat)this.cpool.getConstant(this.idx, (byte)4);
                return Float.toString(f.getBytes());
            }
            case 83: {
                ConstantInteger s = (ConstantInteger)this.cpool.getConstant(this.idx, (byte)3);
                return Integer.toString(s.getBytes());
            }
            case 66: {
                ConstantInteger b = (ConstantInteger)this.cpool.getConstant(this.idx, (byte)3);
                return Integer.toString(b.getBytes());
            }
            case 67: {
                ConstantInteger ch = (ConstantInteger)this.cpool.getConstant(this.idx, (byte)3);
                return Integer.toString(ch.getBytes());
            }
            case 90: {
                ConstantInteger bo = (ConstantInteger)this.cpool.getConstant(this.idx, (byte)3);
                if (bo.getBytes() == 0) {
                    return "false";
                }
                if (bo.getBytes() != 0) {
                    return "true";
                }
            }
            case 115: {
                ConstantUtf8 cu8 = (ConstantUtf8)this.cpool.getConstant(this.idx, (byte)1);
                return cu8.getBytes();
            }
        }
        throw new RuntimeException("SimpleElementValue class does not know how to stringify type " + this.type);
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        switch (this.type) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                dos.writeShort(this.idx);
                break;
            }
            default: {
                throw new RuntimeException("SimpleElementValue doesnt know how to write out type " + this.type);
            }
        }
    }
}

