/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantObject;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantValue;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeAnnotations;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.FieldGenOrMethodGen;
import org.aspectj.apache.bcel.generic.FieldObserver;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.generic.annotation.AnnotationGen;

public class FieldGen
extends FieldGenOrMethodGen {
    private Object value = null;
    private ArrayList observers;

    public FieldGen(int access_flags, Type type, String name, ConstantPoolGen cp) {
        this.setAccessFlags(access_flags);
        this.setType(type);
        this.setName(name);
        this.setConstantPool(cp);
    }

    public FieldGen(Field field, ConstantPoolGen cp) {
        this(field.getAccessFlags(), Type.getType(field.getSignature()), field.getName(), cp);
        Attribute[] attrs = field.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i] instanceof ConstantValue) {
                this.setValue(((ConstantValue)attrs[i]).getConstantValueIndex());
            } else if (attrs[i] instanceof RuntimeAnnotations) {
                RuntimeAnnotations runtimeAnnotations = (RuntimeAnnotations)attrs[i];
                List l = runtimeAnnotations.getAnnotations();
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    Annotation element = (Annotation)it.next();
                    this.addAnnotation(new AnnotationGen(element, cp));
                }
            } else {
                this.addAttribute(attrs[i]);
            }
            ++i;
        }
    }

    private void setValue(int index) {
        ConstantPool cp = this.cp.getConstantPool();
        Constant c = cp.getConstant(index);
        this.value = ((ConstantObject)((Object)c)).getConstantValue(cp);
    }

    public void setInitValue(String str) {
        this.checkType(new ObjectType("java.lang.String"));
        if (str != null) {
            this.value = str;
        }
    }

    public void setInitValue(long l) {
        this.checkType(Type.LONG);
        if (l != 0L) {
            this.value = new Long(l);
        }
    }

    public void setInitValue(int i) {
        this.checkType(Type.INT);
        if (i != 0) {
            this.value = new Integer(i);
        }
    }

    public void setInitValue(short s) {
        this.checkType(Type.SHORT);
        if (s != 0) {
            this.value = new Integer(s);
        }
    }

    public void setInitValue(char c) {
        this.checkType(Type.CHAR);
        if (c != '\u0000') {
            this.value = new Integer(c);
        }
    }

    public void setInitValue(byte b) {
        this.checkType(Type.BYTE);
        if (b != 0) {
            this.value = new Integer(b);
        }
    }

    public void setInitValue(boolean b) {
        this.checkType(Type.BOOLEAN);
        if (b) {
            this.value = new Integer(1);
        }
    }

    public void setInitValue(float f) {
        this.checkType(Type.FLOAT);
        if ((double)f != 0.0) {
            this.value = new Float(f);
        }
    }

    public void setInitValue(double d) {
        this.checkType(Type.DOUBLE);
        if (d != 0.0) {
            this.value = new Double(d);
        }
    }

    public void cancelInitValue() {
        this.value = null;
    }

    private void checkType(Type atype) {
        if (this.type == null) {
            throw new ClassGenException("You haven't defined the type of the field yet");
        }
        if (!this.isFinal()) {
            throw new ClassGenException("Only final fields may have an initial value!");
        }
        if (!this.type.equals(atype)) {
            throw new ClassGenException("Types are not compatible: " + this.type + " vs. " + atype);
        }
    }

    public Field getField() {
        String signature = this.getSignature();
        int name_index = this.cp.addUtf8(this.name);
        int signature_index = this.cp.addUtf8(signature);
        if (this.value != null) {
            this.checkType(this.type);
            int index = this.addConstant();
            this.addAttribute(new ConstantValue(this.cp.addUtf8("ConstantValue"), 2, index, this.cp.getConstantPool()));
        }
        this.addAnnotationsAsAttribute(this.cp);
        return new Field(this.access_flags, name_index, signature_index, this.getAttributes(), this.cp.getConstantPool());
    }

    private void addAnnotationsAsAttribute(ConstantPoolGen cp) {
        Attribute[] attrs = Utility.getAnnotationAttributes(cp, this.annotation_vec);
        if (attrs != null) {
            int i = 0;
            while (i < attrs.length) {
                this.addAttribute(attrs[i]);
                ++i;
            }
        }
    }

    private int addConstant() {
        switch (this.type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return this.cp.addInteger((Integer)this.value);
            }
            case 6: {
                return this.cp.addFloat(((Float)this.value).floatValue());
            }
            case 7: {
                return this.cp.addDouble((Double)this.value);
            }
            case 11: {
                return this.cp.addLong((Long)this.value);
            }
            case 14: {
                return this.cp.addString((String)this.value);
            }
        }
        throw new RuntimeException("Oops: Unhandled : " + this.type.getType());
    }

    public String getSignature() {
        return this.type.getSignature();
    }

    public void addObserver(FieldObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList();
        }
        this.observers.add(o);
    }

    public void removeObserver(FieldObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            Iterator e = this.observers.iterator();
            while (e.hasNext()) {
                ((FieldObserver)e.next()).notify(this);
            }
        }
    }

    public String getInitValue() {
        if (this.value != null) {
            return this.value.toString();
        }
        return null;
    }

    public final String toString() {
        String access = Utility.accessToString(this.access_flags);
        access = access.equals("") ? "" : String.valueOf(access) + " ";
        String signature = this.type.toString();
        String name = this.getName();
        StringBuffer buf = new StringBuffer(String.valueOf(access) + signature + " " + name);
        String value = this.getInitValue();
        if (value != null) {
            buf.append(" = " + value);
        }
        return buf.toString();
    }

    public FieldGen copy(ConstantPoolGen cp) {
        FieldGen fg = (FieldGen)this.clone();
        fg.setConstantPool(cp);
        return fg;
    }
}

