/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantClass;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.annotation.ElementValueGen;

public class ClassElementValueGen
extends ElementValueGen {
    private int idx;

    protected ClassElementValueGen(int typeIdx, ConstantPoolGen cpool) {
        super(99, cpool);
        this.idx = typeIdx;
    }

    public ClassElementValueGen(ObjectType t, ConstantPoolGen cpool) {
        super(99, cpool);
        this.idx = cpool.addClass(t);
    }

    public int getIndex() {
        return this.idx;
    }

    public String getClassString() {
        ConstantClass c = (ConstantClass)this.getConstantPool().getConstant(this.idx);
        ConstantUtf8 utf8 = (ConstantUtf8)this.getConstantPool().getConstant(c.getNameIndex());
        return utf8.getBytes();
    }

    public String stringifyValue() {
        return this.getClassString();
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        dos.writeShort(this.idx);
    }
}

