/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantClass;
import org.aspectj.apache.bcel.classfile.ConstantString;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.annotation.EnumElementValue;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.annotation.ElementValueGen;

public class EnumElementValueGen
extends ElementValueGen {
    private int typeIdx;
    private int valueIdx;

    protected EnumElementValueGen(int typeIdx, int valueIdx, ConstantPoolGen cpool) {
        super(101, cpool);
        if (this.type != 101) {
            throw new RuntimeException("Only element values of type enum can be built with this ctor");
        }
        this.typeIdx = typeIdx;
        this.valueIdx = valueIdx;
    }

    public EnumElementValueGen(ObjectType t, String value, ConstantPoolGen cpool) {
        super(101, cpool);
        this.typeIdx = cpool.addClass(t);
        this.valueIdx = cpool.addString(value);
    }

    public EnumElementValueGen(EnumElementValue value, ConstantPoolGen cpool) {
        super(101, cpool);
        this.typeIdx = value.getTypeIndex();
        this.valueIdx = value.getValueIndex();
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeByte(this.type);
        dos.writeShort(this.typeIdx);
        dos.writeShort(this.valueIdx);
    }

    public String stringifyValue() {
        ConstantString cu8 = (ConstantString)this.getConstantPool().getConstant(this.valueIdx);
        return ((ConstantUtf8)this.getConstantPool().getConstant(cu8.getStringIndex())).getBytes();
    }

    public String getEnumTypeString() {
        ConstantClass cu8 = (ConstantClass)this.getConstantPool().getConstant(this.typeIdx);
        return ((ConstantUtf8)this.getConstantPool().getConstant(cu8.getNameIndex())).getBytes();
    }

    public String getEnumValueString() {
        ConstantString cu8 = (ConstantString)this.getConstantPool().getConstant(this.valueIdx);
        return ((ConstantUtf8)this.getConstantPool().getConstant(cu8.getStringIndex())).getBytes();
    }

    public int getValueIndex() {
        return this.valueIdx;
    }

    public int getTypeIndex() {
        return this.typeIdx;
    }
}

