/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Literal;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.TheOriginalJDTParserClass;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class Parser
extends TheOriginalJDTParserClass {
    private static final String ASPECTJ_DECLARATION_FACTORY = "org.aspectj.ajdt.internal.compiler.parser.DeclarationFactory";
    private static final IDeclarationFactory declarationFactory;
    private static final boolean AJ_DEBUG = false;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.aspectj.org.eclipse.jdt.internal.compiler.parser.Parser");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            TheOriginalJDTParserClass.initTables(clazz);
            declarationFactory = (IDeclarationFactory)Class.forName(ASPECTJ_DECLARATION_FACTORY).newInstance();
        }
        catch (IOException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
    }

    public void initializeScanner() {
        this.scanner = new Scanner(false, false, this.options.getSeverity(256L) != -1, this.options.sourceLevel, this.options.taskTags, this.options.taskPriorites, this.options.isTaskCaseSensitive);
    }

    void println(Object o) {
    }

    private void printStack(Object[] s, int p) {
        List<Object> list = Arrays.asList(s);
        System.out.println("  " + list.subList(0, p + 1));
    }

    private void printStack(int[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Integer.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(long[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Long.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(char[][] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(new String(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    public void display() {
    }

    protected MethodDeclaration createMethodDeclaration(CompilationResult result) {
        return declarationFactory.createMethodDeclaration(result);
    }

    protected ConstructorDeclaration createConstructorDeclaration(CompilationResult result) {
        return declarationFactory.createConstructorDeclaration(result);
    }

    protected void consumeMethodInvocationName() {
        super.consumeMethodInvocationName();
        MessageSend m = (MessageSend)this.expressionStack[this.expressionPtr];
        if (CharOperation.equals(m.selector, "proceed".toCharArray())) {
            this.expressionStack[this.expressionPtr] = declarationFactory.createProceed(m);
        }
    }

    protected void consumeToken(int type) {
        this.currentTokenStart = this.scanner.startPosition;
        super.consumeToken(type);
        switch (type) {
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.pushIdentifier();
                this.scanner.commentPtr = -1;
            }
        }
    }

    protected void consumeAspectDeclaration() {
        this.consumeClassDeclaration();
    }

    protected void consumeAspectHeader() {
        this.consumeClassHeader();
    }

    protected void consumeAspectHeaderName(boolean isPrivileged) {
        TypeDeclaration aspectDecl = declarationFactory.createAspect(this.compilationUnit.compilationResult);
        this.println("aspect header name: ");
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        aspectDecl.sourceEnd = (int)pos;
        aspectDecl.sourceStart = (int)(pos >>> 32);
        aspectDecl.name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        this.eatIdentifier();
        if (isPrivileged) {
            pos = this.eatIdentifier();
            declarationFactory.setPrivileged(aspectDecl, true);
        }
        aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
        aspectDecl.modifiers = this.intStack[this.intPtr--];
        if (isPrivileged) {
            aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
            aspectDecl.modifiers |= this.intStack[this.intPtr--];
        }
        if (aspectDecl.modifiersSourceStart >= 0) {
            aspectDecl.declarationSourceStart = aspectDecl.modifiersSourceStart;
        }
        this.println("modifiers: " + aspectDecl.modifiers);
        aspectDecl.bodyStart = aspectDecl.sourceEnd + 1;
        this.pushOnAstStack(aspectDecl);
        this.listLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = aspectDecl.bodyStart;
            this.currentElement = this.currentElement.add(aspectDecl, 0);
            this.lastIgnoredToken = -1;
        }
        aspectDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.display();
    }

    private long eatIdentifier() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        --this.identifierPtr;
        --this.identifierLengthPtr;
        return pos;
    }

    protected void consumeAspectHeaderRest() {
        this.concatNodeLists();
        this.display();
        ASTNode pseudoTokens = this.popPseudoTokens("{");
        this.println("pseudo: " + pseudoTokens);
        TypeDeclaration aspectDecl = (TypeDeclaration)this.astStack[this.astPtr];
        declarationFactory.setDominatesPatternFrom(aspectDecl, pseudoTokens, this);
        declarationFactory.setPerClauseFrom(aspectDecl, pseudoTokens, this);
    }

    protected void consumePointcutDeclaration() {
        this.consumePointcutDesignatorOnDeclaration();
    }

    protected void consumeEmptyPointcutDeclaration() {
    }

    protected void consumePointcutHeader() {
        MethodDeclaration ret = declarationFactory.createPointcutDeclaration(this.compilationUnit.compilationResult);
        long pos = this.identifierPositionStack[this.identifierPtr];
        ret.sourceStart = (int)(pos >>> 32);
        ret.selector = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ret.javadoc = this.javadoc;
        this.javadoc = null;
        this.eatIdentifier();
        ret.declarationSourceStart = this.intStack[this.intPtr--];
        ret.modifiers = this.intStack[this.intPtr--];
        this.pushOnAstStack(ret);
    }

    protected void consumeAroundDeclaration() {
        this.consumeMethodDeclaration(true);
    }

    protected void consumeAroundHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.consumeMethodHeader();
    }

    protected void consumeAroundHeaderName() {
        MethodDeclaration adviceDecl = declarationFactory.createAroundAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        adviceDecl.returnType = returnType;
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
    }

    protected void consumePointcutDesignatorOnAdvice() {
        ASTNode des = this.popPointcutDesignator("{");
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnAdvice(adviceDecl, des);
        adviceDecl.sourceEnd = des.sourceEnd;
        adviceDecl.bodyStart = des.sourceEnd + 1;
    }

    protected void consumePointcutDesignatorOnDeclaration() {
        ASTNode des = this.popPointcutDesignator(";");
        MethodDeclaration pcutDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnPointcut(pcutDecl, des);
        pcutDecl.sourceEnd = des.sourceEnd;
        pcutDecl.bodyStart = des.sourceEnd + 1;
        pcutDecl.bodyEnd = this.endPosition;
        pcutDecl.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
    }

    protected void consumeBasicAdviceDeclaration() {
        this.consumeMethodDeclaration(true);
    }

    protected void consumeBasicAdviceHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.consumeMethodHeader();
    }

    protected void consumeBasicAdviceHeaderName(boolean isAfter) {
        MethodDeclaration adviceDecl = isAfter ? declarationFactory.createAfterAdviceDeclaration(this.compilationUnit.compilationResult) : declarationFactory.createBeforeAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
    }

    protected void consumeExtraParameterWithFormal() {
        Argument arg = (Argument)this.astStack[this.astPtr--];
        --this.astLengthPtr;
        declarationFactory.setExtraArgument((MethodDeclaration)this.astStack[this.astPtr], arg);
        this.consumeExtraParameterNoFormal();
    }

    protected void consumeExtraParameterNoFormal() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.isAfterAdvice(adviceDecl);
        if (CharOperation.equals(name, "throwing".toCharArray())) {
            declarationFactory.setAfterThrowingAdviceKind(adviceDecl);
        } else if (CharOperation.equals(name, "returning".toCharArray())) {
            declarationFactory.setAfterReturningAdviceKind(adviceDecl);
        } else {
            this.problemReporter().parseError(start, end, this.currentToken, name, String.valueOf(name), new String[]{"throwing", "returning", ":"});
        }
    }

    protected void consumeClassBodyDeclarationInAspect() {
    }

    protected void consumeDeclareDeclaration() {
        this.concatNodeLists();
        ASTNode tokens = this.popPseudoTokens(";");
        MethodDeclaration declareDecl = declarationFactory.createDeclareDeclaration(this.compilationUnit.compilationResult, tokens, this);
        this.display();
        this.pushOnAstStack(declareDecl);
    }

    protected void consumeDeclareHeader() {
        this.consumePseudoTokenIdentifier();
        this.consumePseudoTokenIdentifier();
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken(":", 0, false);
        this.consumePseudoTokens();
        this.println(">>>>>>>>>>>>>>>>>>>>>>>declare header");
        this.display();
    }

    protected void consumeInterTypeFieldDeclaration() {
        this.println("about to consume field");
        this.display();
        Expression initialization = null;
        if (this.expressionPtr >= 0) {
            --this.expressionLengthPtr;
            initialization = this.expressionStack[this.expressionPtr--];
        }
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        TypeReference onType = this.getTypeReference(0);
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        this.display();
        int decSourceStart = this.intStack[this.intPtr--];
        int modifiers = this.intStack[this.intPtr--];
        MethodDeclaration dec = declarationFactory.createInterTypeFieldDeclaration(this.compilationUnit.compilationResult, onType);
        dec.returnType = returnType;
        dec.sourceStart = start;
        dec.sourceEnd = end;
        declarationFactory.setSelector(dec, name);
        dec.declarationSourceStart = decSourceStart;
        declarationFactory.setDeclaredModifiers(dec, modifiers);
        declarationFactory.setInitialization(dec, initialization);
        dec.bodyEnd = this.endPosition;
        dec.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
        dec.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(dec);
        this.println("consumed field: " + dec);
        this.display();
    }

    protected void consumeInterTypeMethodDeclaration(boolean isNotAbstract) {
        this.consumeMethodDeclaration(isNotAbstract);
    }

    protected void consumeInterTypeMethodHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeConstructorDeclaration() {
        this.consumeMethodDeclaration(true);
    }

    protected void consumeInterTypeConstructorHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeMethodHeaderName() {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeMethodDeclaration(this.compilationUnit.compilationResult);
        char[] name = this.identifierStack[this.identifierPtr];
        long selectorSource = this.identifierPositionStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(md, onType);
        md.returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        md.sourceStart = (int)(selectorSource >>> 32);
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        declarationFactory.setSelector(md, name);
        this.listLength = 0;
        md.javadoc = this.javadoc;
        this.javadoc = null;
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType || this.scanner.getLineNumber(md.returnType.sourceStart) == this.scanner.getLineNumber(md.sourceStart)) {
                this.lastCheckPoint = md.bodyStart;
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumeInterTypeConstructorHeaderName() {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeConstructorDeclaration(this.compilationUnit.compilationResult);
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(md, onType);
        this.println("got onType: " + onType);
        this.display();
        --this.intPtr;
        md.returnType = TypeReference.baseTypeReference(6, 0);
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        md.sourceStart = onType.sourceStart;
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        this.listLength = 0;
        declarationFactory.setSelector(md, (String.valueOf(new String(CharOperation.concatWith(onType.getTypeName(), '_'))) + "_new").toCharArray());
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType) {
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumePseudoToken(String value) {
        this.consumePseudoToken(value, 0, false);
    }

    protected void consumePseudoToken(String value, int popFromIntStack, boolean isIdentifier) {
        this.intPtr -= popFromIntStack;
        int start = this.currentTokenStart;
        int end = start + value.length() - 1;
        ASTNode tok = declarationFactory.createPseudoToken(this, value, isIdentifier);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIdentifier() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(name), true);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIf() {
        Expression expr = this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        this.println("expr: " + expr);
        int start = this.intStack[this.intPtr--];
        ASTNode tok = declarationFactory.createIfPseudoToken(this, expr);
        tok.sourceStart = start;
        tok.sourceEnd = this.rParenPos;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenLiteral() {
        Literal literal = (Literal)this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(literal.source()), false);
        declarationFactory.setLiteralKind(tok, "string");
        tok.sourceStart = literal.sourceStart;
        tok.sourceEnd = literal.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenModifier() {
        this.consumePseudoToken(Modifier.toString(this.modifiers), 0, true);
        this.modifiers = 0;
    }

    protected void consumePseudoTokenPrimitiveType() {
        TypeReference type = this.getTypeReference(0);
        ASTNode tok = declarationFactory.createPseudoToken(this, type.toString(), true);
        tok.sourceStart = type.sourceStart;
        tok.sourceEnd = type.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokens() {
        this.optimizedConcatNodeLists();
    }

    protected ASTNode popPointcutDesignator(String terminator) {
        ASTNode tokens = this.popPseudoTokens(terminator);
        return declarationFactory.createPointcutDesignator(this, tokens);
    }

    protected ASTNode popPseudoTokens(String terminator) {
        this.consumePseudoToken(terminator);
        this.consumePseudoTokens();
        int length = this.astLengthStack[this.astLengthPtr--];
        this.astPtr -= length;
        ASTNode[] tokens = new ASTNode[length];
        System.arraycopy(this.astStack, this.astPtr + 1, tokens, 0, length);
        this.listLength = 0;
        return declarationFactory.createPseudoTokensFrom(tokens, this.compilationUnit.compilationResult());
    }

    private void swapAstStack() {
        ASTNode next;
        ASTNode top = this.astStack[this.astPtr];
        this.astStack[this.astPtr] = next = this.astStack[this.astPtr - 1];
        this.astStack[this.astPtr - 1] = top;
    }

    protected void consumeRule(int act) {
        switch (act) {
            case 30: {
                this.consumePrimitiveType();
                break;
            }
            case 44: {
                this.consumeReferenceType();
                break;
            }
            case 62: {
                this.consumeQualifiedName();
                break;
            }
            case 66: {
                this.consumeQualifiedName();
                break;
            }
            case 67: {
                this.consumeCompilationUnit();
                break;
            }
            case 68: {
                this.consumeEnterCompilationUnit();
                break;
            }
            case 81: {
                this.consumeCatchHeader();
                break;
            }
            case 83: {
                this.consumeImportDeclarations();
                break;
            }
            case 85: {
                this.consumeTypeDeclarations();
                break;
            }
            case 86: {
                this.consumePackageDeclaration();
                break;
            }
            case 87: {
                this.consumePackageDeclarationName();
                break;
            }
            case 90: {
                this.consumeSingleTypeImportDeclaration();
                break;
            }
            case 91: {
                this.consumeSingleTypeImportDeclarationName();
                break;
            }
            case 92: {
                this.consumeTypeImportOnDemandDeclaration();
                break;
            }
            case 93: {
                this.consumeTypeImportOnDemandDeclarationName();
                break;
            }
            case 96: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 122: {
                this.consumeAspectDeclaration();
                break;
            }
            case 123: {
                this.consumeAspectHeader();
                break;
            }
            case 124: {
                this.consumeAspectHeaderName(false);
                break;
            }
            case 125: {
                this.consumeAspectHeaderName(true);
                break;
            }
            case 127: {
                this.consumeAspectHeaderRest();
                break;
            }
            case 128: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 131: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 132: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 133: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 134: {
                this.consumeClassBodyDeclarationInAspect();
                break;
            }
            case 135: {
                this.consumeEmptyPointcutDeclaration();
                break;
            }
            case 136: {
                this.consumePointcutDeclaration();
                break;
            }
            case 137: {
                this.consumePointcutHeader();
                break;
            }
            case 140: {
                this.consumeAroundDeclaration();
                break;
            }
            case 141: {
                this.consumeAroundHeader();
                break;
            }
            case 142: {
                this.consumeAroundHeaderName();
                break;
            }
            case 143: {
                this.consumeBasicAdviceDeclaration();
                break;
            }
            case 144: {
                this.consumeBasicAdviceHeader();
                break;
            }
            case 145: {
                this.consumeBasicAdviceHeaderName(false);
                break;
            }
            case 146: {
                this.consumeBasicAdviceHeaderName(true);
                break;
            }
            case 147: {
                this.consumeExtraParameterWithFormal();
                break;
            }
            case 148: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 149: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 152: {
                this.consumeQualifiedName();
                break;
            }
            case 157: {
                this.consumeInterTypeMethodDeclaration(true);
                break;
            }
            case 158: {
                this.consumeInterTypeMethodHeader();
                break;
            }
            case 159: {
                this.consumeInterTypeMethodHeaderName();
                break;
            }
            case 160: {
                this.consumeInterTypeMethodDeclaration(false);
                break;
            }
            case 161: {
                this.consumeInterTypeConstructorDeclaration();
                break;
            }
            case 162: {
                this.consumeInterTypeConstructorHeader();
                break;
            }
            case 163: {
                this.consumeInterTypeConstructorHeaderName();
                break;
            }
            case 164: {
                this.consumeInterTypeFieldDeclaration();
                break;
            }
            case 168: {
                this.consumeDeclareDeclaration();
                break;
            }
            case 169: {
                this.consumeDeclareHeader();
                break;
            }
            case 171: {
                this.consumePseudoTokens();
                break;
            }
            case 172: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 173: {
                this.consumePseudoToken("(");
                break;
            }
            case 174: {
                this.consumePseudoToken(")");
                break;
            }
            case 175: {
                this.consumePseudoToken(".");
                break;
            }
            case 176: {
                this.consumePseudoToken("*");
                break;
            }
            case 177: {
                this.consumePseudoToken("+");
                break;
            }
            case 178: {
                this.consumePseudoToken("&&");
                break;
            }
            case 179: {
                this.consumePseudoToken("||");
                break;
            }
            case 180: {
                this.consumePseudoToken("!");
                break;
            }
            case 181: {
                this.consumePseudoToken(":");
                break;
            }
            case 182: {
                this.consumePseudoToken(",");
                break;
            }
            case 183: {
                this.consumePseudoToken("[");
                break;
            }
            case 184: {
                this.consumePseudoToken("]");
                break;
            }
            case 185: {
                this.consumePseudoToken("@");
                break;
            }
            case 186: {
                this.consumePseudoToken("...");
                break;
            }
            case 187: {
                this.consumePseudoTokenPrimitiveType();
                break;
            }
            case 188: {
                this.consumePseudoTokenModifier();
                break;
            }
            case 189: {
                this.consumePseudoTokenLiteral();
                break;
            }
            case 190: {
                this.consumePseudoToken("this", 1, true);
                break;
            }
            case 191: {
                this.consumePseudoToken("super", 1, true);
                break;
            }
            case 192: {
                this.consumePseudoTokenIf();
                break;
            }
            case 193: {
                this.consumePseudoToken("assert", 1, true);
                break;
            }
            case 194: {
                this.consumePseudoToken("import", 1, true);
                break;
            }
            case 195: {
                this.consumePseudoToken("package", 1, true);
                break;
            }
            case 196: {
                this.consumePseudoToken("throw", 1, true);
                break;
            }
            case 197: {
                this.consumePseudoToken("new", 1, true);
                break;
            }
            case 198: {
                this.consumePseudoToken("do", 1, true);
                break;
            }
            case 199: {
                this.consumePseudoToken("for", 1, true);
                break;
            }
            case 200: {
                this.consumePseudoToken("switch", 1, true);
                break;
            }
            case 201: {
                this.consumePseudoToken("try", 1, true);
                break;
            }
            case 202: {
                this.consumePseudoToken("while", 1, true);
                break;
            }
            case 203: {
                this.consumePseudoToken("break", 1, true);
                break;
            }
            case 204: {
                this.consumePseudoToken("continue", 1, true);
                break;
            }
            case 205: {
                this.consumePseudoToken("return", 1, true);
                break;
            }
            case 206: {
                this.consumePseudoToken("case", 1, true);
                break;
            }
            case 207: {
                this.consumePseudoToken("catch", 0, true);
                break;
            }
            case 208: {
                this.consumePseudoToken("instanceof", 0, true);
                break;
            }
            case 209: {
                this.consumePseudoToken("else", 0, true);
                break;
            }
            case 210: {
                this.consumePseudoToken("extends", 0, true);
                break;
            }
            case 211: {
                this.consumePseudoToken("finally", 0, true);
                break;
            }
            case 212: {
                this.consumePseudoToken("implements", 0, true);
                break;
            }
            case 213: {
                this.consumePseudoToken("throws", 0, true);
                break;
            }
            case 214: {
                this.consumeClassDeclaration();
                break;
            }
            case 215: {
                this.consumeClassHeader();
                break;
            }
            case 216: {
                this.consumeClassHeaderName();
                break;
            }
            case 217: {
                this.consumeClassHeaderExtends();
                break;
            }
            case 218: {
                this.consumeClassHeaderImplements();
                break;
            }
            case 220: {
                this.consumeInterfaceTypeList();
                break;
            }
            case 221: {
                this.consumeInterfaceType();
                break;
            }
            case 224: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 228: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 229: {
                this.consumeDiet();
                break;
            }
            case 230: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 237: {
                this.consumeEmptyClassMemberDeclaration();
                break;
            }
            case 238: {
                this.consumeFieldDeclaration();
                break;
            }
            case 240: {
                this.consumeVariableDeclarators();
                break;
            }
            case 243: {
                this.consumeEnterVariable();
                break;
            }
            case 244: {
                this.consumeExitVariableWithInitialization();
                break;
            }
            case 245: {
                this.consumeExitVariableWithoutInitialization();
                break;
            }
            case 246: {
                this.consumeForceNoDiet();
                break;
            }
            case 247: {
                this.consumeRestoreDiet();
                break;
            }
            case 252: {
                this.consumeMethodDeclaration(true);
                break;
            }
            case 253: {
                this.consumeMethodDeclaration(false);
                break;
            }
            case 254: {
                this.consumeMethodHeader();
                break;
            }
            case 255: {
                this.consumeMethodHeaderName();
                break;
            }
            case 256: {
                this.consumeMethodHeaderParameters();
                break;
            }
            case 257: {
                this.consumeMethodHeaderExtendedDims();
                break;
            }
            case 258: {
                this.consumeMethodHeaderThrowsClause();
                break;
            }
            case 259: {
                this.consumeConstructorHeader();
                break;
            }
            case 260: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 261: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 263: {
                this.consumeFormalParameterList();
                break;
            }
            case 264: {
                this.consumeFormalParameter();
                break;
            }
            case 266: {
                this.consumeClassTypeList();
                break;
            }
            case 267: {
                this.consumeClassTypeElt();
                break;
            }
            case 268: {
                this.consumeMethodBody();
                break;
            }
            case 269: {
                this.consumeNestedMethod();
                break;
            }
            case 270: {
                this.consumeStaticInitializer();
                break;
            }
            case 271: {
                this.consumeStaticOnly();
                break;
            }
            case 272: {
                this.consumeConstructorDeclaration();
                break;
            }
            case 273: {
                this.consumeInvalidConstructorDeclaration();
                break;
            }
            case 274: {
                this.consumeExplicitConstructorInvocation(0, 3);
                break;
            }
            case 275: {
                this.consumeExplicitConstructorInvocation(0, 2);
                break;
            }
            case 276: {
                this.consumeExplicitConstructorInvocation(1, 2);
                break;
            }
            case 277: {
                this.consumeExplicitConstructorInvocation(2, 2);
                break;
            }
            case 278: {
                this.consumeExplicitConstructorInvocation(1, 3);
                break;
            }
            case 279: {
                this.consumeExplicitConstructorInvocation(2, 3);
                break;
            }
            case 280: {
                this.consumeInterfaceDeclaration();
                break;
            }
            case 281: {
                this.consumeInterfaceHeader();
                break;
            }
            case 282: {
                this.consumeInterfaceHeaderName();
                break;
            }
            case 284: {
                this.consumeInterfaceHeaderExtends();
                break;
            }
            case 287: {
                this.consumeInterfaceMemberDeclarations();
                break;
            }
            case 288: {
                this.consumeEmptyInterfaceMemberDeclaration();
                break;
            }
            case 291: {
                this.ignoreMethodBody();
                break;
            }
            case 292: {
                this.ignoreInvalidConstructorDeclaration(true);
                break;
            }
            case 293: {
                this.ignoreInvalidConstructorDeclaration(false);
                break;
            }
            case 299: {
                this.consumeEmptyArrayInitializer();
                break;
            }
            case 300: {
                this.consumeArrayInitializer();
                break;
            }
            case 301: {
                this.consumeArrayInitializer();
                break;
            }
            case 303: {
                this.consumeVariableInitializers();
                break;
            }
            case 304: {
                this.consumeBlock();
                break;
            }
            case 305: {
                this.consumeOpenBlock();
                break;
            }
            case 307: {
                this.consumeBlockStatements();
                break;
            }
            case 311: {
                this.ignoreInterfaceDeclaration();
                break;
            }
            case 312: {
                this.consumeLocalVariableDeclarationStatement();
                break;
            }
            case 313: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 314: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 315: {
                this.consumePushModifiers();
                break;
            }
            case 339: {
                this.consumeEmptyStatement();
                break;
            }
            case 340: {
                this.consumeStatementLabel();
                break;
            }
            case 341: {
                this.consumeStatementLabel();
                break;
            }
            case 342: {
                this.consumeExpressionStatement();
                break;
            }
            case 351: {
                this.consumeStatementIfNoElse();
                break;
            }
            case 352: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 353: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 354: {
                this.consumeStatementSwitch();
                break;
            }
            case 355: {
                this.consumeEmptySwitchBlock();
                break;
            }
            case 358: {
                this.consumeSwitchBlock();
                break;
            }
            case 360: {
                this.consumeSwitchBlockStatements();
                break;
            }
            case 361: {
                this.consumeSwitchBlockStatement();
                break;
            }
            case 363: {
                this.consumeSwitchLabels();
                break;
            }
            case 364: {
                this.consumeCaseLabel();
                break;
            }
            case 365: {
                this.consumeDefaultLabel();
                break;
            }
            case 366: {
                this.consumeStatementWhile();
                break;
            }
            case 367: {
                this.consumeStatementWhile();
                break;
            }
            case 368: {
                this.consumeStatementDo();
                break;
            }
            case 369: {
                this.consumeStatementFor();
                break;
            }
            case 370: {
                this.consumeStatementFor();
                break;
            }
            case 371: {
                this.consumeForInit();
                break;
            }
            case 375: {
                this.consumeStatementExpressionList();
                break;
            }
            case 376: {
                this.consumeSimpleAssertStatement();
                break;
            }
            case 377: {
                this.consumeAssertStatement();
                break;
            }
            case 378: {
                this.consumeStatementBreak();
                break;
            }
            case 379: {
                this.consumeStatementBreakWithLabel();
                break;
            }
            case 380: {
                this.consumeStatementContinue();
                break;
            }
            case 381: {
                this.consumeStatementContinueWithLabel();
                break;
            }
            case 382: {
                this.consumeStatementReturn();
                break;
            }
            case 383: {
                this.consumeStatementThrow();
                break;
            }
            case 384: {
                this.consumeStatementSynchronized();
                break;
            }
            case 385: {
                this.consumeOnlySynchronized();
                break;
            }
            case 386: {
                this.consumeStatementTry(false);
                break;
            }
            case 387: {
                this.consumeStatementTry(true);
                break;
            }
            case 389: {
                this.consumeExitTryBlock();
                break;
            }
            case 391: {
                this.consumeCatches();
                break;
            }
            case 392: {
                this.consumeStatementCatch();
                break;
            }
            case 394: {
                this.consumeLeftParen();
                break;
            }
            case 395: {
                this.consumeRightParen();
                break;
            }
            case 400: {
                this.consumePrimaryNoNewArrayThis();
                break;
            }
            case 401: {
                this.consumePrimaryNoNewArray();
                break;
            }
            case 404: {
                this.consumePrimaryNoNewArrayNameThis();
                break;
            }
            case 405: {
                this.consumePrimaryNoNewArrayNameSuper();
                break;
            }
            case 406: {
                this.consumePrimaryNoNewArrayName();
                break;
            }
            case 407: {
                this.consumePrimaryNoNewArrayArrayType();
                break;
            }
            case 408: {
                this.consumePrimaryNoNewArrayPrimitiveType();
                break;
            }
            case 411: {
                this.consumeAllocationHeader();
                break;
            }
            case 412: {
                this.consumeClassInstanceCreationExpression();
                break;
            }
            case 413: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 414: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 415: {
                this.consumeClassInstanceCreationExpressionName();
                break;
            }
            case 416: {
                this.consumeClassBodyopt();
                break;
            }
            case 418: {
                this.consumeEnterAnonymousClassBody();
                break;
            }
            case 420: {
                this.consumeArgumentList();
                break;
            }
            case 421: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 422: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 423: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 424: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 425: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 426: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 428: {
                this.consumeDimWithOrWithOutExprs();
                break;
            }
            case 430: {
                this.consumeDimWithOrWithOutExpr();
                break;
            }
            case 431: {
                this.consumeDims();
                break;
            }
            case 434: {
                this.consumeOneDimLoop();
                break;
            }
            case 435: {
                this.consumeFieldAccess(false);
                break;
            }
            case 436: {
                this.consumeFieldAccess(true);
                break;
            }
            case 437: {
                this.consumeMethodInvocationName();
                break;
            }
            case 438: {
                this.consumeMethodInvocationPrimary();
                break;
            }
            case 439: {
                this.consumeMethodInvocationSuper();
                break;
            }
            case 440: {
                this.consumeArrayAccess(true);
                break;
            }
            case 441: {
                this.consumeArrayAccess(false);
                break;
            }
            case 442: {
                this.consumeArrayAccess(false);
                break;
            }
            case 444: {
                this.consumePostfixExpression();
                break;
            }
            case 447: {
                this.consumeUnaryExpression(14, true);
                break;
            }
            case 448: {
                this.consumeUnaryExpression(13, true);
                break;
            }
            case 449: {
                this.consumePushPosition();
                break;
            }
            case 452: {
                this.consumeUnaryExpression(14);
                break;
            }
            case 453: {
                this.consumeUnaryExpression(13);
                break;
            }
            case 455: {
                this.consumeUnaryExpression(14, false);
                break;
            }
            case 456: {
                this.consumeUnaryExpression(13, false);
                break;
            }
            case 458: {
                this.consumeUnaryExpression(12);
                break;
            }
            case 459: {
                this.consumeUnaryExpression(11);
                break;
            }
            case 461: {
                this.consumeCastExpression();
                break;
            }
            case 462: {
                this.consumeCastExpression();
                break;
            }
            case 463: {
                this.consumeCastExpressionLL1();
                break;
            }
            case 464: {
                this.consumeInsideCastExpression();
                break;
            }
            case 465: {
                this.consumeInsideCastExpressionLL1();
                break;
            }
            case 467: {
                this.consumeBinaryExpression(15);
                break;
            }
            case 468: {
                this.consumeBinaryExpression(9);
                break;
            }
            case 469: {
                this.consumeBinaryExpression(16);
                break;
            }
            case 471: {
                this.consumeBinaryExpression(14);
                break;
            }
            case 472: {
                this.consumeBinaryExpression(13);
                break;
            }
            case 474: {
                this.consumeBinaryExpression(10);
                break;
            }
            case 475: {
                this.consumeBinaryExpression(17);
                break;
            }
            case 476: {
                this.consumeBinaryExpression(19);
                break;
            }
            case 478: {
                this.consumeBinaryExpression(4);
                break;
            }
            case 479: {
                this.consumeBinaryExpression(6);
                break;
            }
            case 480: {
                this.consumeBinaryExpression(5);
                break;
            }
            case 481: {
                this.consumeBinaryExpression(7);
                break;
            }
            case 482: {
                this.consumeInstanceOfExpression(31);
                break;
            }
            case 484: {
                this.consumeEqualityExpression(18);
                break;
            }
            case 485: {
                this.consumeEqualityExpression(29);
                break;
            }
            case 487: {
                this.consumeBinaryExpression(2);
                break;
            }
            case 489: {
                this.consumeBinaryExpression(8);
                break;
            }
            case 491: {
                this.consumeBinaryExpression(3);
                break;
            }
            case 493: {
                this.consumeBinaryExpression(0);
                break;
            }
            case 495: {
                this.consumeBinaryExpression(1);
                break;
            }
            case 497: {
                this.consumeConditionalExpression(23);
                break;
            }
            case 500: {
                this.consumeAssignment();
                break;
            }
            case 502: {
                this.ignoreExpressionAssignment();
                break;
            }
            case 503: {
                this.consumeAssignmentOperator(30);
                break;
            }
            case 504: {
                this.consumeAssignmentOperator(15);
                break;
            }
            case 505: {
                this.consumeAssignmentOperator(9);
                break;
            }
            case 506: {
                this.consumeAssignmentOperator(16);
                break;
            }
            case 507: {
                this.consumeAssignmentOperator(14);
                break;
            }
            case 508: {
                this.consumeAssignmentOperator(13);
                break;
            }
            case 509: {
                this.consumeAssignmentOperator(10);
                break;
            }
            case 510: {
                this.consumeAssignmentOperator(17);
                break;
            }
            case 511: {
                this.consumeAssignmentOperator(19);
                break;
            }
            case 512: {
                this.consumeAssignmentOperator(2);
                break;
            }
            case 513: {
                this.consumeAssignmentOperator(8);
                break;
            }
            case 514: {
                this.consumeAssignmentOperator(3);
                break;
            }
            case 521: {
                this.consumeEmptyExpression();
                break;
            }
            case 525: {
                this.consumeEmptyImportDeclarationsopt();
                break;
            }
            case 526: {
                this.consumeImportDeclarationsopt();
                break;
            }
            case 527: {
                this.consumeEmptyTypeDeclarationsopt();
                break;
            }
            case 528: {
                this.consumeTypeDeclarationsopt();
                break;
            }
            case 529: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 530: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 531: {
                this.consumeDefaultModifiers();
                break;
            }
            case 532: {
                this.consumeModifiers();
                break;
            }
            case 533: {
                this.consumeEmptyBlockStatementsopt();
                break;
            }
            case 535: {
                this.consumeEmptyDimsopt();
                break;
            }
            case 537: {
                this.consumeEmptyArgumentListopt();
                break;
            }
            case 541: {
                this.consumeFormalParameterListopt();
                break;
            }
            case 545: {
                this.consumeEmptyInterfaceMemberDeclarationsopt();
                break;
            }
            case 546: {
                this.consumeInterfaceMemberDeclarationsopt();
                break;
            }
            case 547: {
                this.consumeNestedType();
                break;
            }
            case 548: {
                this.consumeEmptyForInitopt();
                break;
            }
            case 550: {
                this.consumeEmptyForUpdateopt();
                break;
            }
            case 554: {
                this.consumeEmptyCatchesopt();
            }
        }
    }

    protected void consumeSimpleAssertStatement() {
        super.consumeSimpleAssertStatement();
    }

    public Parser(ProblemReporter problemReporter, boolean optimizeStringLiterals) {
        super(problemReporter, optimizeStringLiterals);
    }

    protected boolean shouldTryToRecover() {
        ASTNode node;
        int index = 0;
        while (index < this.astStack.length && (node = this.astStack[index++]) != null) {
            if (declarationFactory.shouldTryToRecover(node)) continue;
            return false;
        }
        return true;
    }

    public interface IDeclarationFactory {
        public MessageSend createProceed(MessageSend var1);

        public TypeDeclaration createAspect(CompilationResult var1);

        public void setPrivileged(TypeDeclaration var1, boolean var2);

        public void setPerClauseFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public void setDominatesPatternFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public ASTNode createPseudoTokensFrom(ASTNode[] var1, CompilationResult var2);

        public MethodDeclaration createMethodDeclaration(CompilationResult var1);

        public ConstructorDeclaration createConstructorDeclaration(CompilationResult var1);

        public MethodDeclaration createPointcutDeclaration(CompilationResult var1);

        public MethodDeclaration createAroundAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createAfterAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createBeforeAdviceDeclaration(CompilationResult var1);

        public ASTNode createPointcutDesignator(Parser var1, ASTNode var2);

        public void setPointcutDesignatorOnAdvice(MethodDeclaration var1, ASTNode var2);

        public void setPointcutDesignatorOnPointcut(MethodDeclaration var1, ASTNode var2);

        public void setExtraArgument(MethodDeclaration var1, Argument var2);

        public boolean isAfterAdvice(MethodDeclaration var1);

        public void setAfterThrowingAdviceKind(MethodDeclaration var1);

        public void setAfterReturningAdviceKind(MethodDeclaration var1);

        public MethodDeclaration createDeclareDeclaration(CompilationResult var1, ASTNode var2, Parser var3);

        public MethodDeclaration createInterTypeFieldDeclaration(CompilationResult var1, TypeReference var2);

        public MethodDeclaration createInterTypeMethodDeclaration(CompilationResult var1);

        public MethodDeclaration createInterTypeConstructorDeclaration(CompilationResult var1);

        public void setSelector(MethodDeclaration var1, char[] var2);

        public void setDeclaredModifiers(MethodDeclaration var1, int var2);

        public void setInitialization(MethodDeclaration var1, Expression var2);

        public void setOnType(MethodDeclaration var1, TypeReference var2);

        public ASTNode createPseudoToken(Parser var1, String var2, boolean var3);

        public ASTNode createIfPseudoToken(Parser var1, Expression var2);

        public void setLiteralKind(ASTNode var1, String var2);

        public boolean shouldTryToRecover(ASTNode var1);
    }
}

