/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.ExceptionTable;
import org.aspectj.apache.bcel.classfile.LocalVariable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.annotation.Annotation;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.Utility;

final class BcelMethod
extends ResolvedMember {
    private Method method;
    private boolean isAjSynthetic;
    private ShadowMunger associatedShadowMunger;
    private AjAttribute.EffectiveSignatureAttribute effectiveSignature;
    private AjAttribute.MethodDeclarationLineNumberAttribute declarationLineNumber;
    private ResolvedTypeX[] resolvedAnnotations;
    private World world;

    BcelMethod(BcelObjectType declaringType, Method method) {
        super(method.getName().equals("<init>") ? Member.CONSTRUCTOR : (method.getName().equals("<clinit>") ? Member.STATIC_INITIALIZATION : Member.METHOD), declaringType.getResolvedTypeX(), declaringType.isInterface() ? method.getAccessFlags() | 0x200 : method.getAccessFlags(), method.getName(), method.getSignature());
        this.method = method;
        this.world = declaringType.getResolvedTypeX().getWorld();
        this.unpackAjAttributes(this.world);
        this.unpackJavaAttributes();
    }

    private void unpackJavaAttributes() {
        ExceptionTable exnTable = this.method.getExceptionTable();
        this.checkedExceptions = exnTable == null ? TypeX.NONE : TypeX.forNames(exnTable.getExceptionNames());
        LocalVariableTable varTable = this.method.getLocalVariableTable();
        int len = this.getArity();
        if (varTable == null) {
            this.parameterNames = Utility.makeArgNames(len);
        } else {
            TypeX[] paramTypes = this.getParameterTypes();
            String[] paramNames = new String[len];
            int index = this.isStatic() ? 0 : 1;
            for (int i = 0; i < len; ++i) {
                LocalVariable lv = varTable.getLocalVariable(index);
                paramNames[i] = lv == null ? "arg" + i : lv.getName();
                index += paramTypes[i].getSize();
            }
            this.parameterNames = paramNames;
        }
    }

    private void unpackAjAttributes(World world) {
        List as = BcelAttributes.readAjAttributes(this.method.getAttributes(), this.getSourceContext(world), world.getMessageHandler());
        Iterator iter = as.iterator();
        while (iter.hasNext()) {
            AjAttribute a = (AjAttribute)iter.next();
            if (a instanceof AjAttribute.MethodDeclarationLineNumberAttribute) {
                this.declarationLineNumber = (AjAttribute.MethodDeclarationLineNumberAttribute)a;
                continue;
            }
            if (a instanceof AjAttribute.AdviceAttribute) {
                this.associatedShadowMunger = ((AjAttribute.AdviceAttribute)a).reify(this, world);
                return;
            }
            if (a instanceof AjAttribute.AjSynthetic) {
                this.isAjSynthetic = true;
                continue;
            }
            if (a instanceof AjAttribute.EffectiveSignatureAttribute) {
                this.effectiveSignature = (AjAttribute.EffectiveSignatureAttribute)a;
                continue;
            }
            throw new BCException("weird method attribute " + a);
        }
        this.associatedShadowMunger = null;
    }

    public boolean isAjSynthetic() {
        return this.isAjSynthetic;
    }

    public ShadowMunger getAssociatedShadowMunger() {
        return this.associatedShadowMunger;
    }

    public AjAttribute.EffectiveSignatureAttribute getEffectiveSignature() {
        return this.effectiveSignature;
    }

    public boolean hasDeclarationLineNumberInfo() {
        return this.declarationLineNumber != null;
    }

    public int getDeclarationLineNumber() {
        if (this.declarationLineNumber != null) {
            return this.declarationLineNumber.getLineNumber();
        }
        return -1;
    }

    public Member.Kind getKind() {
        if (this.associatedShadowMunger != null) {
            return Member.ADVICE;
        }
        return super.getKind();
    }

    public boolean hasAnnotation(TypeX ofType) {
        Annotation[] anns = this.method.getAnnotations();
        for (int i = 0; i < anns.length; ++i) {
            Annotation annotation = anns[i];
            if (!annotation.getTypeName().equals(ofType.getName())) continue;
            return true;
        }
        return false;
    }

    public ResolvedTypeX[] getAnnotationTypes() {
        if (this.resolvedAnnotations == null) {
            Annotation[] annotations = this.method.getAnnotations();
            this.resolvedAnnotations = new ResolvedTypeX[annotations.length];
            for (int i = 0; i < annotations.length; ++i) {
                ResolvedTypeX rtx;
                Annotation annotation = annotations[i];
                this.resolvedAnnotations[i] = rtx = this.world.resolve(TypeX.forName(annotation.getTypeName()));
            }
        }
        return this.resolvedAnnotations;
    }
}

