/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.aspectj.apache.bcel.Repository;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.generic.ConstantPoolGen;
import org.aspectj.apache.bcel.generic.FieldInstruction;
import org.aspectj.apache.bcel.generic.GETSTATIC;
import org.aspectj.apache.bcel.generic.INVOKEINTERFACE;
import org.aspectj.apache.bcel.generic.INVOKESPECIAL;
import org.aspectj.apache.bcel.generic.INVOKESTATIC;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.PUTSTATIC;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.apache.bcel.util.ClassPath;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ICrossReferenceHandler;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelAdvice;
import org.aspectj.weaver.bcel.BcelCflowCounterFieldAdder;
import org.aspectj.weaver.bcel.BcelCflowStackFieldAdder;
import org.aspectj.weaver.bcel.BcelMethod;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelTypeMunger;
import org.aspectj.weaver.bcel.ClassPathManager;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.SimpleScope;

public class BcelWorld
extends World
implements org.aspectj.apache.bcel.util.Repository {
    private ClassPathManager classPath;
    private static final String[] ZERO_STRINGS = new String[0];

    public BcelWorld() {
        this("");
    }

    public BcelWorld(String cp) {
        this(BcelWorld.makeDefaultClasspath(cp), IMessageHandler.THROW, null);
    }

    private static List makeDefaultClasspath(String cp) {
        ArrayList classPath = new ArrayList();
        classPath.addAll(BcelWorld.getPathEntries(cp));
        classPath.addAll(BcelWorld.getPathEntries(ClassPath.getClassPath()));
        return classPath;
    }

    private static List getPathEntries(String s) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(s, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            ret.add(tok.nextToken());
        }
        return ret;
    }

    public BcelWorld(List classPath, IMessageHandler handler, ICrossReferenceHandler xrefHandler) {
        this.classPath = new ClassPathManager(classPath, handler);
        this.setMessageHandler(handler);
        this.setXRefHandler(xrefHandler);
        Repository.setRepository(this);
    }

    public BcelWorld(ClassPathManager cpm, IMessageHandler handler, ICrossReferenceHandler xrefHandler) {
        this.classPath = cpm;
        this.setMessageHandler(handler);
        this.setXRefHandler(xrefHandler);
        Repository.setRepository(this);
    }

    public void addPath(String name) {
        this.classPath.addPath(name, this.getMessageHandler());
    }

    public Advice shadowMunger(String str, int extraFlag) {
        str = str.trim();
        int start = 0;
        int i = str.indexOf(40);
        AdviceKind kind = AdviceKind.stringToKind(str.substring(start, i));
        start = ++i;
        i = str.indexOf(41, i);
        String[] ids = this.parseIds(str.substring(start, i).trim());
        i = str.indexOf(58, i);
        start = ++i;
        i = str.indexOf("->", i);
        Pointcut pointcut = Pointcut.fromString(str.substring(start, i).trim());
        Member m = Member.methodFromString(str.substring(i + 2, str.length()).trim());
        TypeX[] types = m.getParameterTypes();
        FormalBinding[] bindings = new FormalBinding[ids.length];
        int len = ids.length;
        for (int j = 0; j < len; ++j) {
            bindings[j] = new FormalBinding(types[j], ids[j], j, 0, 0, "fromString");
        }
        Pointcut p = pointcut.resolve(new SimpleScope(this, bindings));
        return new BcelAdvice(kind, p, m, extraFlag, 0, 0, null, null);
    }

    private String[] parseIds(String str) {
        if (str.length() == 0) {
            return ZERO_STRINGS;
        }
        ArrayList<String> l = new ArrayList<String>();
        int start = 0;
        while (true) {
            int i;
            if ((i = str.indexOf(44, start)) == -1) break;
            l.add(str.substring(start, i).trim());
            start = i + 1;
        }
        l.add(str.substring(start).trim());
        return l.toArray(new String[l.size()]);
    }

    public static Type makeBcelType(TypeX type) {
        return Type.getType(type.getSignature());
    }

    static Type[] makeBcelTypes(TypeX[] types) {
        Type[] ret = new Type[types.length];
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = BcelWorld.makeBcelType(types[i]);
        }
        return ret;
    }

    public static TypeX fromBcel(Type t) {
        return TypeX.forSignature(t.getSignature());
    }

    static TypeX[] fromBcel(Type[] ts) {
        TypeX[] ret = new TypeX[ts.length];
        int len = ts.length;
        for (int i = 0; i < len; ++i) {
            ret[i] = BcelWorld.fromBcel(ts[i]);
        }
        return ret;
    }

    public ResolvedTypeX resolve(Type t) {
        return this.resolve(BcelWorld.fromBcel(t));
    }

    protected ResolvedTypeX.ConcreteName resolveObjectType(ResolvedTypeX.Name ty) {
        String name = ty.getName();
        JavaClass jc = null;
        if (jc == null) {
            jc = this.lookupJavaClass(this.classPath, name);
        }
        if (jc == null) {
            return null;
        }
        return this.makeBcelObjectType(ty, jc, false);
    }

    private BcelObjectType makeBcelObjectType(ResolvedTypeX.Name resolvedTypeX, JavaClass jc, boolean exposedToWeaver) {
        BcelObjectType ret = new BcelObjectType(resolvedTypeX, jc, exposedToWeaver);
        resolvedTypeX.setDelegate(ret);
        return ret;
    }

    private JavaClass lookupJavaClass(ClassPathManager classPath, String name) {
        if (classPath == null) {
            return null;
        }
        try {
            ClassPathManager.ClassFile file = classPath.find(TypeX.forName(name));
            if (file == null) {
                return null;
            }
            ClassParser parser = new ClassParser(file.getInputStream(), file.getPath());
            JavaClass jc = parser.parse();
            file.close();
            return jc;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public BcelObjectType addSourceObjectType(JavaClass jc) {
        String signature = TypeX.forName(jc.getClassName()).getSignature();
        ResolvedTypeX.Name nameTypeX = (ResolvedTypeX.Name)this.typeMap.get(signature);
        if (nameTypeX == null) {
            nameTypeX = new ResolvedTypeX.Name(signature, this);
        }
        BcelObjectType ret = this.makeBcelObjectType(nameTypeX, jc, true);
        nameTypeX.setDelegate(ret);
        this.typeMap.put(signature, nameTypeX);
        return ret;
    }

    void deleteSourceObjectType(TypeX ty) {
        this.typeMap.remove(ty.getSignature());
    }

    public static Member makeFieldSignature(LazyClassGen cg, FieldInstruction fi) {
        ConstantPoolGen cpg = cg.getConstantPoolGen();
        return Member.field(fi.getClassName(cpg), fi instanceof GETSTATIC || fi instanceof PUTSTATIC ? 8 : 0, fi.getName(cpg), fi.getSignature(cpg));
    }

    public static Member makeFieldSetSignature(LazyClassGen cg, FieldInstruction fi) {
        ConstantPoolGen cpg = cg.getConstantPoolGen();
        return Member.field(fi.getClassName(cpg), fi instanceof GETSTATIC || fi instanceof PUTSTATIC ? 8 : 0, fi.getName(cpg), "(" + fi.getSignature(cpg) + ")" + fi.getSignature(cpg));
    }

    public Member makeMethodSignature(LazyMethodGen mg) {
        return this.makeMethodSignature(mg, null);
    }

    public Member makeMethodSignature(LazyMethodGen mg, Member.Kind kind) {
        BcelMethod ret = mg.getMemberView();
        if (ret == null) {
            int mods = mg.getAccessFlags();
            if (mg.getEnclosingClass().isInterface()) {
                mods |= 0x200;
            }
            if (kind == null) {
                kind = mg.getName().equals("<init>") ? Member.CONSTRUCTOR : (mg.getName().equals("<clinit>") ? Member.STATIC_INITIALIZATION : Member.METHOD);
            }
            return new ResolvedMember(kind, TypeX.forName(mg.getClassName()), mods, BcelWorld.fromBcel(mg.getReturnType()), mg.getName(), BcelWorld.fromBcel(mg.getArgumentTypes()));
        }
        return ret;
    }

    public static Member makeMethodSignature(LazyClassGen cg, InvokeInstruction ii) {
        ConstantPoolGen cpg = cg.getConstantPoolGen();
        String declaring = ii.getClassName(cpg);
        String name = ii.getName(cpg);
        String signature = ii.getSignature(cpg);
        int modifier = ii instanceof INVOKEINTERFACE ? 512 : (ii instanceof INVOKESTATIC ? 8 : (ii instanceof INVOKESPECIAL && !name.equals("<init>") ? 2 : 0));
        return Member.method(TypeX.forName(declaring), modifier, name, signature);
    }

    public static Member makeMungerMethodSignature(JavaClass javaClass, Method method) {
        int mods = 0;
        if (method.isStatic()) {
            mods = 8;
        } else if (javaClass.isInterface()) {
            mods = 512;
        } else if (method.isPrivate()) {
            mods = 2;
        }
        return Member.method(TypeX.forName(javaClass.getClassName()), mods, method.getName(), method.getSignature());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("BcelWorld(");
        buf.append(")");
        return buf.toString();
    }

    public Advice concreteAdvice(AjAttribute.AdviceAttribute attribute, Pointcut pointcut, Member signature) {
        return new BcelAdvice(attribute, pointcut, signature, null);
    }

    public ConcreteTypeMunger concreteTypeMunger(ResolvedTypeMunger munger, ResolvedTypeX aspectType) {
        return new BcelTypeMunger(munger, aspectType);
    }

    public ConcreteTypeMunger makeCflowStackFieldAdder(ResolvedMember cflowField) {
        return new BcelCflowStackFieldAdder(cflowField);
    }

    public ConcreteTypeMunger makeCflowCounterFieldAdder(ResolvedMember cflowField) {
        return new BcelCflowCounterFieldAdder(cflowField);
    }

    public static BcelObjectType getBcelObjectType(ResolvedTypeX concreteAspect) {
        return (BcelObjectType)((ResolvedTypeX.Name)concreteAspect).getDelegate();
    }

    public void tidyUp() {
        this.classPath.closeArchives();
    }

    public JavaClass findClass(String className) {
        return this.lookupJavaClass(this.classPath, className);
    }

    public JavaClass loadClass(String className) throws ClassNotFoundException {
        return this.lookupJavaClass(this.classPath, className);
    }

    public void storeClass(JavaClass clazz) {
        throw new RuntimeException("Not implemented");
    }

    public void removeClass(JavaClass clazz) {
        throw new RuntimeException("Not implemented");
    }

    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        throw new RuntimeException("Not implemented");
    }

    public void clear() {
        throw new RuntimeException("Not implemented");
    }
}

