/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.BIPUSH;
import org.aspectj.apache.bcel.generic.BasicType;
import org.aspectj.apache.bcel.generic.BranchHandle;
import org.aspectj.apache.bcel.generic.BranchInstruction;
import org.aspectj.apache.bcel.generic.ConstantPushInstruction;
import org.aspectj.apache.bcel.generic.INSTANCEOF;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionFactory;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.InstructionTargeter;
import org.aspectj.apache.bcel.generic.LDC;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.ReferenceType;
import org.aspectj.apache.bcel.generic.SIPUSH;
import org.aspectj.apache.bcel.generic.SWITCH;
import org.aspectj.apache.bcel.generic.Select;
import org.aspectj.apache.bcel.generic.TargetLostException;
import org.aspectj.apache.bcel.generic.Type;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.bcel.BcelVar;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.bcel.LineNumberTag;

public class Utility {
    private static Hashtable validBoxing = new Hashtable();

    private Utility() {
    }

    public static Instruction createSuperInvoke(InstructionFactory fact, BcelWorld world, Member signature) {
        if (signature.isInterface()) {
            throw new RuntimeException("bad");
        }
        if (signature.isPrivate() || signature.getName().equals("<init>")) {
            throw new RuntimeException("unimplemented, possibly bad");
        }
        if (signature.isStatic()) {
            throw new RuntimeException("bad");
        }
        short kind = 183;
        return fact.createInvoke(signature.getDeclaringType().getName(), signature.getName(), BcelWorld.makeBcelType(signature.getReturnType()), BcelWorld.makeBcelTypes(signature.getParameterTypes()), kind);
    }

    public static Instruction createInvoke(InstructionFactory fact, BcelWorld world, Member signature) {
        short kind = signature.isInterface() ? (short)185 : (signature.isStatic() ? (short)184 : (signature.isPrivate() || signature.getName().equals("<init>") ? (short)183 : 182));
        return fact.createInvoke(signature.getDeclaringType().getName(), signature.getName(), BcelWorld.makeBcelType(signature.getReturnType()), BcelWorld.makeBcelTypes(signature.getParameterTypes()), kind);
    }

    public static Instruction createGet(InstructionFactory fact, Member signature) {
        short kind = signature.isStatic() ? (short)178 : 180;
        return fact.createFieldAccess(signature.getDeclaringType().getName(), signature.getName(), BcelWorld.makeBcelType(signature.getReturnType()), kind);
    }

    public static Instruction createSet(InstructionFactory fact, Member signature) {
        short kind = signature.isStatic() ? (short)179 : 181;
        return fact.createFieldAccess(signature.getDeclaringType().getName(), signature.getName(), BcelWorld.makeBcelType(signature.getReturnType()), kind);
    }

    public static Instruction createInvoke(InstructionFactory fact, JavaClass declaringClass, Method newMethod) {
        short kind = newMethod.isInterface() ? (short)185 : (newMethod.isStatic() ? (short)184 : (newMethod.isPrivate() || newMethod.getName().equals("<init>") ? (short)183 : 182));
        return fact.createInvoke(declaringClass.getClassName(), newMethod.getName(), Type.getReturnType(newMethod.getSignature()), Type.getArgumentTypes(newMethod.getSignature()), kind);
    }

    public static byte[] stringToUTF(String s) {
        try {
            ByteArrayOutputStream out0 = new ByteArrayOutputStream();
            DataOutputStream out1 = new DataOutputStream(out0);
            out1.writeUTF(s);
            return out0.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("sanity check");
        }
    }

    public static Instruction createInstanceof(InstructionFactory fact, ReferenceType t) {
        int cpoolEntry = t instanceof ArrayType ? fact.getConstantPool().addArrayClass((ArrayType)t) : fact.getConstantPool().addClass((ObjectType)t);
        return new INSTANCEOF(cpoolEntry);
    }

    public static Instruction createInvoke(InstructionFactory fact, LazyMethodGen m) {
        short kind = m.getEnclosingClass().isInterface() ? (short)185 : (m.isStatic() ? (short)184 : (m.isPrivate() || m.getName().equals("<init>") ? (short)183 : 182));
        return fact.createInvoke(m.getClassName(), m.getName(), m.getReturnType(), m.getArgumentTypes(), kind);
    }

    public static String[] makeArgNames(int n) {
        String[] ret = new String[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = "arg" + i;
        }
        return ret;
    }

    public static void appendConversion(InstructionList il, InstructionFactory fact, ResolvedTypeX fromType, ResolvedTypeX toType) {
        if (!toType.isConvertableFrom(fromType)) {
            throw new BCException("can't convert from " + fromType + " to " + toType);
        }
        if (!toType.getWorld().behaveInJava5Way ? toType.needsNoConversionFrom(fromType) : toType.needsNoConversionFrom(fromType) && !(toType.isPrimitive() ^ fromType.isPrimitive())) {
            return;
        }
        if (toType.equals(ResolvedTypeX.VOID)) {
            il.append(InstructionFactory.createPop(fromType.getSize()));
        } else {
            if (fromType.equals(ResolvedTypeX.VOID)) {
                il.append(InstructionFactory.createNull(Type.OBJECT));
                return;
            }
            if (fromType.equals(TypeX.OBJECT)) {
                Type to = BcelWorld.makeBcelType(toType);
                if (toType.isPrimitive()) {
                    String name = toType.toString() + "Value";
                    il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, to, new Type[]{Type.OBJECT}, (short)184));
                } else {
                    il.append(fact.createCheckCast((ReferenceType)to));
                }
            } else if (toType.equals(TypeX.OBJECT)) {
                Type from = BcelWorld.makeBcelType(fromType);
                String name = fromType.toString() + "Object";
                il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, Type.OBJECT, new Type[]{from}, (short)184));
            } else if (toType.getWorld().behaveInJava5Way && validBoxing.get(toType.getSignature() + fromType.getSignature()) != null) {
                Type from = BcelWorld.makeBcelType(fromType);
                Type to = BcelWorld.makeBcelType(toType);
                String name = (String)validBoxing.get(toType.getSignature() + fromType.getSignature());
                if (toType.isPrimitive()) {
                    il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, to, new Type[]{Type.OBJECT}, (short)184));
                } else {
                    il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, Type.OBJECT, new Type[]{from}, (short)184));
                    il.append(fact.createCheckCast((ReferenceType)to));
                }
            } else if (fromType.isPrimitive()) {
                Type from = BcelWorld.makeBcelType(fromType);
                Type to = BcelWorld.makeBcelType(toType);
                try {
                    il.append(fact.createCast(from, to));
                }
                catch (RuntimeException e) {
                    il.append(fact.createCast(from, Type.INT));
                    il.append(fact.createCast(Type.INT, to));
                }
            } else {
                Type to = BcelWorld.makeBcelType(toType);
                il.append(fact.createCheckCast((ReferenceType)to));
            }
        }
    }

    public static InstructionList createConversion(InstructionFactory fact, Type fromType, Type toType) {
        InstructionList il = new InstructionList();
        if ((fromType.equals(Type.BYTE) || fromType.equals(Type.CHAR) || fromType.equals(Type.SHORT)) && toType.equals(Type.INT)) {
            return il;
        }
        if (fromType.equals(toType)) {
            return il;
        }
        if (toType.equals(Type.VOID)) {
            il.append(InstructionFactory.createPop(fromType.getSize()));
            return il;
        }
        if (fromType.equals(Type.VOID)) {
            if (toType instanceof BasicType) {
                throw new BCException("attempting to cast from void to basic type");
            }
            il.append(InstructionFactory.createNull(Type.OBJECT));
            return il;
        }
        if (fromType.equals(Type.OBJECT) && toType instanceof BasicType) {
            String name = toType.toString() + "Value";
            il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, toType, new Type[]{Type.OBJECT}, (short)184));
            return il;
        }
        if (toType.equals(Type.OBJECT)) {
            if (fromType instanceof BasicType) {
                String name = fromType.toString() + "Object";
                il.append(fact.createInvoke("org.aspectj.runtime.internal.Conversions", name, Type.OBJECT, new Type[]{fromType}, (short)184));
                return il;
            }
            if (fromType instanceof ReferenceType) {
                return il;
            }
            throw new RuntimeException();
        }
        if (fromType instanceof ReferenceType && ((ReferenceType)fromType).isAssignmentCompatibleWith(toType)) {
            return il;
        }
        il.append(fact.createCast(fromType, toType));
        return il;
    }

    public static Instruction createConstant(InstructionFactory fact, int i) {
        Instruction inst;
        switch (i) {
            case -1: {
                inst = InstructionConstants.ICONST_M1;
                break;
            }
            case 0: {
                inst = InstructionConstants.ICONST_0;
                break;
            }
            case 1: {
                inst = InstructionConstants.ICONST_1;
                break;
            }
            case 2: {
                inst = InstructionConstants.ICONST_2;
                break;
            }
            case 3: {
                inst = InstructionConstants.ICONST_3;
                break;
            }
            case 4: {
                inst = InstructionConstants.ICONST_4;
                break;
            }
            case 5: {
                inst = InstructionConstants.ICONST_5;
            }
        }
        inst = i <= 127 && i >= -128 ? new BIPUSH((byte)i) : (i <= Short.MAX_VALUE && i >= Short.MIN_VALUE ? new SIPUSH((short)i) : new LDC(fact.getClassGen().getConstantPool().addInteger(i)));
        return inst;
    }

    public static JavaClass makeJavaClass(String filename, byte[] bytes) {
        try {
            ClassParser parser = new ClassParser(new ByteArrayInputStream(bytes), filename);
            return parser.parse();
        }
        catch (IOException e) {
            throw new BCException("malformed class file");
        }
    }

    public static String arrayToString(int[] a) {
        int len = a.length;
        if (len == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer("[");
        buf.append(a[0]);
        for (int i = 1; i < len; ++i) {
            buf.append(", ");
            buf.append(a[i]);
        }
        buf.append("]");
        return buf.toString();
    }

    public static void replaceInstruction(InstructionHandle ih, BranchInstruction branchInstruction, LazyMethodGen enclosingMethod) {
        InstructionList il = enclosingMethod.getBody();
        BranchHandle fresh = il.append(ih, branchInstruction);
        Utility.deleteInstruction(ih, fresh, enclosingMethod);
    }

    public static void deleteInstruction(InstructionHandle ih, LazyMethodGen enclosingMethod) {
        Utility.deleteInstruction(ih, ih.getNext(), enclosingMethod);
    }

    public static void deleteInstruction(InstructionHandle ih, InstructionHandle retargetTo, LazyMethodGen enclosingMethod) {
        InstructionList il = enclosingMethod.getBody();
        InstructionTargeter[] targeters = ih.getTargeters();
        if (targeters != null) {
            for (int i = targeters.length - 1; i >= 0; --i) {
                InstructionTargeter targeter = targeters[i];
                targeter.updateTarget(ih, retargetTo);
            }
            ih.removeAllTargeters();
        }
        try {
            il.delete(ih);
        }
        catch (TargetLostException e) {
            throw new BCException("this really can't happen");
        }
    }

    public static Instruction copyInstruction(Instruction i) {
        if (i instanceof Select) {
            Select freshSelect = (Select)i;
            InstructionHandle[] targets = new InstructionHandle[freshSelect.getTargets().length];
            for (int ii = 0; ii < targets.length; ++ii) {
                targets[ii] = freshSelect.getTargets()[ii];
            }
            SWITCH switchStatement = new SWITCH(freshSelect.getMatchs(), targets, freshSelect.getTarget());
            return (Select)switchStatement.getInstruction();
        }
        return i.copy();
    }

    public static int getSourceLine(InstructionHandle ih) {
        int lookahead = 0;
        while (lookahead++ < 100) {
            if (ih == null) {
                return -1;
            }
            InstructionTargeter[] ts = ih.getTargeters();
            if (ts != null) {
                for (int j = ts.length - 1; j >= 0; --j) {
                    InstructionTargeter t = ts[j];
                    if (!(t instanceof LineNumberTag)) continue;
                    return ((LineNumberTag)t).getLineNumber();
                }
            }
            ih = ih.getNext();
        }
        return -1;
    }

    public static void setSourceLine(InstructionHandle ih, int lineNumber) {
        ih.addTargeter(new LineNumberTag(lineNumber));
    }

    public static int makePublic(int i) {
        return i & 0xFFFFFFF9 | 1;
    }

    public static int makePrivate(int i) {
        return i & 0xFFFFFFFA | 2;
    }

    public static BcelVar[] pushAndReturnArrayOfVars(ResolvedTypeX[] proceedParamTypes, InstructionList il, InstructionFactory fact, LazyMethodGen enclosingMethod) {
        int len = proceedParamTypes.length;
        BcelVar[] ret = new BcelVar[len];
        for (int i = len - 1; i >= 0; --i) {
            ResolvedTypeX typeX = proceedParamTypes[i];
            Type type = BcelWorld.makeBcelType(typeX);
            int local = enclosingMethod.allocateLocal(type);
            il.append(InstructionFactory.createStore(type, local));
            ret[i] = new BcelVar(typeX, local);
        }
        return ret;
    }

    public static boolean isConstantPushInstruction(Instruction i) {
        return i instanceof ConstantPushInstruction || i instanceof LDC;
    }

    static {
        validBoxing.put("Ljava/lang/Byte;B", "byteObject");
        validBoxing.put("Ljava/lang/Character;C", "charObject");
        validBoxing.put("Ljava/lang/Double;D", "doubleObject");
        validBoxing.put("Ljava/lang/Float;F", "floatObject");
        validBoxing.put("Ljava/lang/Integer;I", "intObject");
        validBoxing.put("Ljava/lang/Long;J", "longObject");
        validBoxing.put("Ljava/lang/Short;S", "shortObject");
        validBoxing.put("Ljava/lang/Boolean;Z", "booleanObject");
        validBoxing.put("BLjava/lang/Byte;", "byteValue");
        validBoxing.put("CLjava/lang/Character;", "charValue");
        validBoxing.put("DLjava/lang/Double;", "doubleValue");
        validBoxing.put("FLjava/lang/Float;", "floatValue");
        validBoxing.put("ILjava/lang/Integer;", "intValue");
        validBoxing.put("JLjava/lang/Long;", "longValue");
        validBoxing.put("SLjava/lang/Short;", "shortValue");
        validBoxing.put("ZLjava/lang/Boolean;", "booleanValue");
    }
}

