/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.TypePattern;

public class AndTypePattern
extends TypePattern {
    private TypePattern left;
    private TypePattern right;

    public AndTypePattern(TypePattern left, TypePattern right) {
        super(false, false);
        this.left = left;
        this.right = right;
        this.setLocation(left.getSourceContext(), left.getStart(), right.getEnd());
    }

    public FuzzyBoolean matchesInstanceof(ResolvedTypeX type) {
        return this.left.matchesInstanceof(type).and(this.right.matchesInstanceof(type));
    }

    protected boolean matchesExactly(ResolvedTypeX type) {
        return this.left.matchesExactly(type) && this.right.matchesExactly(type);
    }

    public boolean matchesStatically(Class type) {
        return this.left.matchesStatically(type) && this.right.matchesStatically(type);
    }

    public FuzzyBoolean matchesInstanceof(Class type) {
        return this.left.matchesInstanceof(type).and(this.right.matchesInstanceof(type));
    }

    protected boolean matchesExactly(Class type) {
        return this.left.matchesExactly(type) && this.right.matchesExactly(type);
    }

    public boolean matchesStatically(ResolvedTypeX type) {
        return this.left.matchesStatically(type) && this.right.matchesStatically(type);
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(8);
        this.left.write(s);
        this.right.write(s);
        this.writeLocation(s);
    }

    public static TypePattern read(DataInputStream s, ISourceContext context) throws IOException {
        AndTypePattern ret = new AndTypePattern(TypePattern.read(s, context), TypePattern.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public TypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding, boolean requireExactType) {
        if (requireExactType) {
            return this.notExactType(scope);
        }
        this.left = this.left.resolveBindings(scope, bindings, false, false);
        this.right = this.right.resolveBindings(scope, bindings, false, false);
        return this;
    }

    public TypePattern resolveBindingsFromRTTI(boolean allowBinding, boolean requireExactType) {
        if (requireExactType) {
            return TypePattern.NO;
        }
        this.left = this.left.resolveBindingsFromRTTI(allowBinding, requireExactType);
        this.right = this.right.resolveBindingsFromRTTI(allowBinding, requireExactType);
        return this;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.annotationPattern != AnnotationTypePattern.ANY) {
            buff.append('(');
            buff.append(this.annotationPattern.toString());
            buff.append(' ');
        }
        buff.append('(');
        buff.append(this.left.toString());
        buff.append(" && ");
        buff.append(this.right.toString());
        buff.append(')');
        if (this.annotationPattern != AnnotationTypePattern.ANY) {
            buff.append(')');
        }
        return buff.toString();
    }
}

