/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.BindingAnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.FormalBinding;
import org.aspectj.weaver.patterns.IScope;

public class ExactAnnotationTypePattern
extends AnnotationTypePattern {
    protected TypeX annotationType;
    protected String formalName;
    protected boolean resolved = false;
    private boolean bindingPattern = false;
    private static byte VERSION = 1;

    public ExactAnnotationTypePattern(TypeX annotationType) {
        this.annotationType = annotationType;
        this.resolved = annotationType instanceof ResolvedTypeX;
    }

    public ExactAnnotationTypePattern(String formalName) {
        this.formalName = formalName;
        this.resolved = false;
        this.bindingPattern = true;
    }

    public FuzzyBoolean fastMatches(AnnotatedElement annotated) {
        if (annotated.hasAnnotation(this.annotationType)) {
            return FuzzyBoolean.YES;
        }
        return FuzzyBoolean.MAYBE;
    }

    public FuzzyBoolean matches(AnnotatedElement annotated) {
        boolean checkSupers = false;
        if (this.annotationType.hasAnnotation(TypeX.AT_INHERITED) && annotated instanceof ResolvedTypeX) {
            checkSupers = true;
        }
        if (annotated.hasAnnotation(this.annotationType)) {
            return FuzzyBoolean.YES;
        }
        if (checkSupers) {
            for (ResolvedTypeX toMatchAgainst = ((ResolvedTypeX)annotated).getSuperclass(); toMatchAgainst != null; toMatchAgainst = toMatchAgainst.getSuperclass()) {
                if (!toMatchAgainst.hasAnnotation(this.annotationType)) continue;
                return FuzzyBoolean.YES;
            }
        }
        return FuzzyBoolean.NO;
    }

    public void resolve(World world) {
        this.annotationType = this.annotationType.resolve(world);
    }

    public AnnotationTypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding) {
        if (this.resolved) {
            return this;
        }
        this.resolved = true;
        if (this.formalName != null) {
            FormalBinding formalBinding = scope.lookupFormal(this.formalName);
            if (formalBinding != null) {
                if (bindings == null) {
                    scope.message(IMessage.ERROR, this, "negation doesn't allow binding");
                    return this;
                }
                if (!allowBinding) {
                    scope.message(IMessage.ERROR, this, "name binding only allowed in @pcds, args, this, and target");
                    return this;
                }
                this.verifyIsAnnotationType(formalBinding.getType(), scope);
                BindingAnnotationTypePattern binding = new BindingAnnotationTypePattern(formalBinding);
                binding.copyLocationFrom(this);
                bindings.register(binding, scope);
                binding.resolveBinding(scope.getWorld());
                return binding;
            }
            scope.message(IMessage.ERROR, this, "unbound formal " + this.formalName);
            return this;
        }
        this.annotationType = this.annotationType.resolve(scope.getWorld());
        this.verifyIsAnnotationType(this.annotationType, scope);
        return this;
    }

    private void verifyIsAnnotationType(TypeX type, IScope scope) {
        if (!type.isAnnotation(scope.getWorld())) {
            IMessage m = MessageUtil.error(WeaverMessages.format("referenceToNonAnnotationType", type.getName()), this.getSourceLocation());
            scope.getWorld().getMessageHandler().handleMessage(m);
            this.resolved = false;
        }
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(1);
        s.writeByte(VERSION);
        s.writeBoolean(this.bindingPattern);
        if (this.bindingPattern) {
            s.writeUTF(this.formalName);
        } else {
            this.annotationType.write(s);
        }
        this.writeLocation(s);
    }

    public static AnnotationTypePattern read(DataInputStream s, ISourceContext context) throws IOException {
        byte version = s.readByte();
        if (version > VERSION) {
            throw new BCException("ExactAnnotationTypePattern was written by a newer version of AspectJ");
        }
        boolean isBindingPattern = s.readBoolean();
        ExactAnnotationTypePattern ret = isBindingPattern ? new ExactAnnotationTypePattern(s.readUTF()) : new ExactAnnotationTypePattern(TypeX.read(s));
        ret.readLocation(context, s);
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExactAnnotationTypePattern)) {
            return false;
        }
        ExactAnnotationTypePattern other = (ExactAnnotationTypePattern)obj;
        return other.annotationType.equals(this.annotationType);
    }

    public int hashCode() {
        return this.annotationType.hashCode();
    }

    public String toString() {
        if (!this.resolved && this.formalName != null) {
            return this.formalName;
        }
        String ret = "@" + this.annotationType.toString();
        if (this.formalName != null) {
            ret = ret + " " + this.formalName;
        }
        return ret;
    }
}

