/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.TypePattern;

public class ExactTypePattern
extends TypePattern {
    protected TypeX type;
    public static final Map primitiveTypesMap = new HashMap();
    public static final Map boxedPrimitivesMap;
    private static final Map boxedTypesMap;
    private static final byte EXACT_VERSION = 1;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;

    public ExactTypePattern(TypeX type, boolean includeSubtypes, boolean isVarArgs) {
        super(includeSubtypes, isVarArgs);
        this.type = type;
    }

    protected boolean matchesExactly(ResolvedTypeX matchType) {
        return this.type.equals(matchType);
    }

    public TypeX getType() {
        return this.type;
    }

    public FuzzyBoolean matchesInstanceof(ResolvedTypeX matchType) {
        if (this.type.equals(TypeX.OBJECT)) {
            return FuzzyBoolean.YES;
        }
        if (this.type.isAssignableFrom(matchType, matchType.getWorld())) {
            return FuzzyBoolean.YES;
        }
        if (this.type.isPrimitive()) {
            return FuzzyBoolean.NO;
        }
        return matchType.isCoerceableFrom(this.type) ? FuzzyBoolean.MAYBE : FuzzyBoolean.NO;
    }

    public boolean matchesExactly(Class matchType) {
        try {
            Class toMatchAgainst = this.getClassFor(this.type.getName());
            return matchType == toMatchAgainst;
        }
        catch (ClassNotFoundException cnfEx) {
            return false;
        }
    }

    public FuzzyBoolean matchesInstanceof(Class matchType) {
        if (matchType.equals(class$java$lang$Object == null ? (class$java$lang$Object = ExactTypePattern.class$("java.lang.Object")) : class$java$lang$Object)) {
            return FuzzyBoolean.YES;
        }
        try {
            String typeName = this.type.getName();
            Class toMatchAgainst = this.getClassFor(typeName);
            FuzzyBoolean ret = FuzzyBoolean.fromBoolean(toMatchAgainst.isAssignableFrom(matchType));
            if (ret == FuzzyBoolean.NO && boxedTypesMap.containsKey(typeName)) {
                toMatchAgainst = (Class)boxedTypesMap.get(typeName);
                ret = FuzzyBoolean.fromBoolean(toMatchAgainst.isAssignableFrom(matchType));
            }
            return ret;
        }
        catch (ClassNotFoundException cnfEx) {
            return FuzzyBoolean.NO;
        }
    }

    public FuzzyBoolean willMatchDynamically(Class staticType) {
        if (this.matchesExactly(staticType)) {
            return FuzzyBoolean.YES;
        }
        if (this.matchesInstanceof(staticType) == FuzzyBoolean.YES) {
            return FuzzyBoolean.YES;
        }
        try {
            String typeName = this.type.getName();
            Class toMatchAgainst = this.getClassFor(typeName);
            if (toMatchAgainst.isInterface()) {
                return FuzzyBoolean.MAYBE;
            }
            if (staticType.isAssignableFrom(toMatchAgainst)) {
                return FuzzyBoolean.MAYBE;
            }
            return FuzzyBoolean.NO;
        }
        catch (ClassNotFoundException cnfEx) {
            return FuzzyBoolean.NO;
        }
    }

    private Class getClassFor(String typeName) throws ClassNotFoundException {
        Class<?> ret = null;
        ret = (Class<?>)primitiveTypesMap.get(typeName);
        if (ret == null) {
            ret = Class.forName(typeName);
        }
        return ret;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ExactTypePattern)) {
            return false;
        }
        ExactTypePattern o = (ExactTypePattern)other;
        return o.type.equals(this.type) && o.annotationPattern.equals(this.annotationPattern);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.type.hashCode();
        result = 37 * result + this.annotationPattern.hashCode();
        return result;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeByte(2);
        out.writeByte(1);
        this.type.write(out);
        out.writeBoolean(this.includeSubtypes);
        out.writeBoolean(this.isVarArgs);
        this.annotationPattern.write(out);
        this.writeLocation(out);
    }

    public static TypePattern read(DataInputStream s, ISourceContext context) throws IOException {
        byte version = s.readByte();
        if (version > 1) {
            throw new BCException("ExactTypePattern was written by a more recent version of AspectJ");
        }
        ExactTypePattern ret = new ExactTypePattern(TypeX.read(s), s.readBoolean(), s.readBoolean());
        ret.setAnnotationTypePattern(AnnotationTypePattern.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.annotationPattern != AnnotationTypePattern.ANY) {
            buff.append('(');
            buff.append(this.annotationPattern.toString());
            buff.append(' ');
        }
        buff.append(this.type.toString());
        if (this.includeSubtypes) {
            buff.append('+');
        }
        if (this.isVarArgs) {
            buff.append("...");
        }
        if (this.annotationPattern != AnnotationTypePattern.ANY) {
            buff.append(')');
        }
        return buff.toString();
    }

    public TypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding, boolean requireExactType) {
        throw new BCException("trying to re-resolve");
    }

    public TypePattern resolveBindingsFromRTTI(boolean allowBinding, boolean requireExactType) {
        throw new IllegalStateException("trying to re-resolve");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        primitiveTypesMap.put("int", Integer.TYPE);
        primitiveTypesMap.put("short", Short.TYPE);
        primitiveTypesMap.put("long", Long.TYPE);
        primitiveTypesMap.put("byte", Byte.TYPE);
        primitiveTypesMap.put("char", Character.TYPE);
        primitiveTypesMap.put("float", Float.TYPE);
        primitiveTypesMap.put("double", Double.TYPE);
        boxedPrimitivesMap = new HashMap();
        boxedPrimitivesMap.put("java.lang.Integer", class$java$lang$Integer == null ? (class$java$lang$Integer = ExactTypePattern.class$("java.lang.Integer")) : class$java$lang$Integer);
        boxedPrimitivesMap.put("java.lang.Short", class$java$lang$Short == null ? (class$java$lang$Short = ExactTypePattern.class$("java.lang.Short")) : class$java$lang$Short);
        boxedPrimitivesMap.put("java.lang.Long", class$java$lang$Long == null ? (class$java$lang$Long = ExactTypePattern.class$("java.lang.Long")) : class$java$lang$Long);
        boxedPrimitivesMap.put("java.lang.Byte", class$java$lang$Byte == null ? (class$java$lang$Byte = ExactTypePattern.class$("java.lang.Byte")) : class$java$lang$Byte);
        boxedPrimitivesMap.put("java.lang.Character", class$java$lang$Character == null ? (class$java$lang$Character = ExactTypePattern.class$("java.lang.Character")) : class$java$lang$Character);
        boxedPrimitivesMap.put("java.lang.Float", class$java$lang$Float == null ? (class$java$lang$Float = ExactTypePattern.class$("java.lang.Float")) : class$java$lang$Float);
        boxedPrimitivesMap.put("java.lang.Double", class$java$lang$Double == null ? (class$java$lang$Double = ExactTypePattern.class$("java.lang.Double")) : class$java$lang$Double);
        boxedTypesMap = new HashMap();
        boxedTypesMap.put("int", class$java$lang$Integer == null ? (class$java$lang$Integer = ExactTypePattern.class$("java.lang.Integer")) : class$java$lang$Integer);
        boxedTypesMap.put("short", class$java$lang$Short == null ? (class$java$lang$Short = ExactTypePattern.class$("java.lang.Short")) : class$java$lang$Short);
        boxedTypesMap.put("long", class$java$lang$Long == null ? (class$java$lang$Long = ExactTypePattern.class$("java.lang.Long")) : class$java$lang$Long);
        boxedTypesMap.put("byte", class$java$lang$Byte == null ? (class$java$lang$Byte = ExactTypePattern.class$("java.lang.Byte")) : class$java$lang$Byte);
        boxedTypesMap.put("char", class$java$lang$Character == null ? (class$java$lang$Character = ExactTypePattern.class$("java.lang.Character")) : class$java$lang$Character);
        boxedTypesMap.put("float", class$java$lang$Float == null ? (class$java$lang$Float = ExactTypePattern.class$("java.lang.Float")) : class$java$lang$Float);
        boxedTypesMap.put("double", class$java$lang$Double == null ? (class$java$lang$Double = ExactTypePattern.class$("java.lang.Double")) : class$java$lang$Double);
    }
}

