/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;

public class NotAnnotationTypePattern
extends AnnotationTypePattern {
    private AnnotationTypePattern negatedPattern;

    public NotAnnotationTypePattern(AnnotationTypePattern pattern) {
        this.negatedPattern = pattern;
        this.setLocation(pattern.getSourceContext(), pattern.getStart(), pattern.getEnd());
    }

    public FuzzyBoolean matches(AnnotatedElement annotated) {
        return this.negatedPattern.matches(annotated).not();
    }

    public void resolve(World world) {
        this.negatedPattern.resolve(world);
    }

    public AnnotationTypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding) {
        this.negatedPattern = this.negatedPattern.resolveBindings(scope, bindings, allowBinding);
        return this;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(3);
        this.negatedPattern.write(s);
        this.writeLocation(s);
    }

    public static AnnotationTypePattern read(DataInputStream s, ISourceContext context) throws IOException {
        NotAnnotationTypePattern ret = new NotAnnotationTypePattern(AnnotationTypePattern.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NotAnnotationTypePattern)) {
            return false;
        }
        NotAnnotationTypePattern other = (NotAnnotationTypePattern)obj;
        return other.negatedPattern.equals(this.negatedPattern);
    }

    public int hashCode() {
        int result = 17 + 37 * this.negatedPattern.hashCode();
        return result;
    }

    public String toString() {
        return "!" + this.negatedPattern.toString();
    }

    public AnnotationTypePattern getNegatedPattern() {
        return this.negatedPattern;
    }
}

