/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.TypePattern;

public class NotTypePattern
extends TypePattern {
    private TypePattern pattern;

    public NotTypePattern(TypePattern pattern) {
        super(false, false);
        this.pattern = pattern;
        this.setLocation(pattern.getSourceContext(), pattern.getStart(), pattern.getEnd());
    }

    public FuzzyBoolean matchesInstanceof(ResolvedTypeX type) {
        return this.pattern.matchesInstanceof(type).not();
    }

    protected boolean matchesExactly(ResolvedTypeX type) {
        return !this.pattern.matchesExactly(type);
    }

    public boolean matchesStatically(Class type) {
        return !this.pattern.matchesStatically(type);
    }

    public FuzzyBoolean matchesInstanceof(Class type) {
        return this.pattern.matchesInstanceof(type).not();
    }

    protected boolean matchesExactly(Class type) {
        return !this.pattern.matchesExactly(type);
    }

    public boolean matchesStatically(ResolvedTypeX type) {
        return !this.pattern.matchesStatically(type);
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(6);
        this.pattern.write(s);
        this.writeLocation(s);
    }

    public static TypePattern read(DataInputStream s, ISourceContext context) throws IOException {
        NotTypePattern ret = new NotTypePattern(TypePattern.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public TypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding, boolean requireExactType) {
        if (requireExactType) {
            return this.notExactType(scope);
        }
        this.pattern = this.pattern.resolveBindings(scope, bindings, false, false);
        return this;
    }

    public TypePattern resolveBindingsFromRTTI(boolean allowBinding, boolean requireExactType) {
        if (requireExactType) {
            return TypePattern.NO;
        }
        this.pattern = this.pattern.resolveBindingsFromRTTI(allowBinding, requireExactType);
        return this;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        if (this.annotationPattern != AnnotationTypePattern.ANY) {
            buff.append('(');
            buff.append(this.annotationPattern.toString());
            buff.append(' ');
        }
        buff.append('!');
        buff.append(this.pattern);
        if (this.annotationPattern != AnnotationTypePattern.ANY) {
            buff.append(')');
        }
        return buff.toString();
    }
}

