/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;

public class OrAnnotationTypePattern
extends AnnotationTypePattern {
    private AnnotationTypePattern left;
    private AnnotationTypePattern right;

    public OrAnnotationTypePattern(AnnotationTypePattern left, AnnotationTypePattern right) {
        this.left = left;
        this.right = right;
        this.setLocation(left.getSourceContext(), left.getStart(), right.getEnd());
    }

    public FuzzyBoolean matches(AnnotatedElement annotated) {
        return this.left.matches(annotated).or(this.right.matches(annotated));
    }

    public void resolve(World world) {
        this.left.resolve(world);
        this.right.resolve(world);
    }

    public AnnotationTypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding) {
        this.left = this.left.resolveBindings(scope, bindings, allowBinding);
        this.right = this.right.resolveBindings(scope, bindings, allowBinding);
        return this;
    }

    public static AnnotationTypePattern read(DataInputStream s, ISourceContext context) throws IOException {
        OrAnnotationTypePattern p = new OrAnnotationTypePattern(AnnotationTypePattern.read(s, context), AnnotationTypePattern.read(s, context));
        p.readLocation(context, s);
        return p;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(4);
        this.left.write(s);
        this.right.write(s);
        this.writeLocation(s);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OrAnnotationTypePattern)) {
            return false;
        }
        OrAnnotationTypePattern other = (OrAnnotationTypePattern)obj;
        return this.left.equals(other.left) && this.right.equals(other.right);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this.left.hashCode();
        result = result * 37 + this.right.hashCode();
        return result;
    }

    public String toString() {
        return "(" + this.left.toString() + " || " + this.right.toString() + ")";
    }

    public AnnotationTypePattern getLeft() {
        return this.left;
    }

    public AnnotationTypePattern getRight() {
        return this.right;
    }
}

