/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.util.ArrayList;
import java.util.List;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.patterns.AndAnnotationTypePattern;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.AndTypePattern;
import org.aspectj.weaver.patterns.AnnotationPatternList;
import org.aspectj.weaver.patterns.AnnotationPointcut;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.ArgsAnnotationPointcut;
import org.aspectj.weaver.patterns.ArgsPointcut;
import org.aspectj.weaver.patterns.BasicTokenSource;
import org.aspectj.weaver.patterns.CflowPointcut;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.DeclareSoft;
import org.aspectj.weaver.patterns.ExactAnnotationTypePattern;
import org.aspectj.weaver.patterns.HandlerPointcut;
import org.aspectj.weaver.patterns.IToken;
import org.aspectj.weaver.patterns.ITokenSource;
import org.aspectj.weaver.patterns.KindedPointcut;
import org.aspectj.weaver.patterns.ModifiersPattern;
import org.aspectj.weaver.patterns.NamePattern;
import org.aspectj.weaver.patterns.NotAnnotationTypePattern;
import org.aspectj.weaver.patterns.NotPointcut;
import org.aspectj.weaver.patterns.NotTypePattern;
import org.aspectj.weaver.patterns.OrPointcut;
import org.aspectj.weaver.patterns.OrTypePattern;
import org.aspectj.weaver.patterns.ParserException;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.PerCflow;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.PerObject;
import org.aspectj.weaver.patterns.PerSingleton;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.ReferencePointcut;
import org.aspectj.weaver.patterns.SignaturePattern;
import org.aspectj.weaver.patterns.ThisOrTargetAnnotationPointcut;
import org.aspectj.weaver.patterns.ThisOrTargetPointcut;
import org.aspectj.weaver.patterns.ThrowsPattern;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;
import org.aspectj.weaver.patterns.WildAnnotationTypePattern;
import org.aspectj.weaver.patterns.WildTypePattern;
import org.aspectj.weaver.patterns.WithinAnnotationPointcut;
import org.aspectj.weaver.patterns.WithinCodeAnnotationPointcut;
import org.aspectj.weaver.patterns.WithinPointcut;
import org.aspectj.weaver.patterns.WithincodePointcut;

public class PatternParser {
    private ITokenSource tokenSource;
    private ISourceContext sourceContext;

    public PatternParser(ITokenSource tokenSource) {
        this.tokenSource = tokenSource;
        this.sourceContext = tokenSource.getSourceContext();
    }

    public PerClause maybeParsePerClause() {
        IToken tok = this.tokenSource.peek();
        if (tok == IToken.EOF) {
            return null;
        }
        if (tok.isIdentifier()) {
            String name = tok.getString();
            if (name.equals("issingleton")) {
                return this.parsePerSingleton();
            }
            if (name.equals("perthis")) {
                return this.parsePerObject(true);
            }
            if (name.equals("pertarget")) {
                return this.parsePerObject(false);
            }
            if (name.equals("percflow")) {
                return this.parsePerCflow(false);
            }
            if (name.equals("percflowbelow")) {
                return this.parsePerCflow(true);
            }
            return null;
        }
        return null;
    }

    private PerClause parsePerCflow(boolean isBelow) {
        this.parseIdentifier();
        this.eat("(");
        Pointcut entry = this.parsePointcut();
        this.eat(")");
        return new PerCflow(entry, isBelow);
    }

    private PerClause parsePerObject(boolean isThis) {
        this.parseIdentifier();
        this.eat("(");
        Pointcut entry = this.parsePointcut();
        this.eat(")");
        return new PerObject(entry, isThis);
    }

    private PerClause parsePerSingleton() {
        this.parseIdentifier();
        this.eat("(");
        this.eat(")");
        return new PerSingleton();
    }

    /*
     * WARNING - void declaration
     */
    public Declare parseDeclare() {
        void var3_3;
        Declare ret;
        int startPos = this.tokenSource.peek().getStart();
        this.eatIdentifier("declare");
        String kind = this.parseIdentifier();
        this.eat(":");
        if (kind.equals("error")) {
            ret = this.parseErrorOrWarning(true);
        } else if (kind.equals("warning")) {
            ret = this.parseErrorOrWarning(false);
        } else if (kind.equals("precedence")) {
            ret = this.parseDominates();
        } else {
            if (kind.equals("dominates")) {
                throw new ParserException("name changed to declare precedence", this.tokenSource.peek(-2));
            }
            if (kind.equals("parents")) {
                ret = this.parseParents();
            } else if (kind.equals("soft")) {
                ret = this.parseSoft();
            } else {
                throw new ParserException("expected one of error, warning, parents, soft, dominates", this.tokenSource.peek(-1));
            }
        }
        int endPos = this.tokenSource.peek(-1).getEnd();
        var3_3.setLocation(this.sourceContext, startPos, endPos);
        return var3_3;
    }

    public DeclarePrecedence parseDominates() {
        ArrayList<TypePattern> l = new ArrayList<TypePattern>();
        do {
            l.add(this.parseTypePattern());
        } while (this.maybeEat(","));
        return new DeclarePrecedence(l);
    }

    private Declare parseParents() {
        TypePattern p = this.parseTypePattern();
        IToken t = this.tokenSource.next();
        if (!t.getString().equals("extends") && !t.getString().equals("implements")) {
            throw new ParserException("extends or implements", t);
        }
        ArrayList<TypePattern> l = new ArrayList<TypePattern>();
        do {
            l.add(this.parseTypePattern());
        } while (this.maybeEat(","));
        return new DeclareParents(p, l);
    }

    private Declare parseSoft() {
        TypePattern p = this.parseTypePattern();
        this.eat(":");
        Pointcut pointcut = this.parsePointcut();
        return new DeclareSoft(p, pointcut);
    }

    private Declare parseErrorOrWarning(boolean isError) {
        Pointcut pointcut = this.parsePointcut();
        this.eat(":");
        String message = this.parsePossibleStringSequence(true);
        return new DeclareErrorOrWarning(isError, pointcut, message);
    }

    public Pointcut parsePointcut() {
        Pointcut p = this.parseAtomicPointcut();
        if (this.maybeEat("&&")) {
            p = new AndPointcut(p, this.parseNotOrPointcut());
        }
        if (this.maybeEat("||")) {
            p = new OrPointcut(p, this.parsePointcut());
        }
        return p;
    }

    private Pointcut parseNotOrPointcut() {
        Pointcut p = this.parseAtomicPointcut();
        if (this.maybeEat("&&")) {
            p = new AndPointcut(p, this.parsePointcut());
        }
        return p;
    }

    private Pointcut parseAtomicPointcut() {
        if (this.maybeEat("!")) {
            int startPos = this.tokenSource.peek(-1).getStart();
            NotPointcut p = new NotPointcut(this.parseAtomicPointcut(), startPos);
            return p;
        }
        if (this.maybeEat("(")) {
            Pointcut p = this.parsePointcut();
            this.eat(")");
            return p;
        }
        if (this.maybeEat("@")) {
            int startPos = this.tokenSource.peek().getStart();
            Pointcut p = this.parseAnnotationPointcut();
            int endPos = this.tokenSource.peek(-1).getEnd();
            p.setLocation(this.sourceContext, startPos, endPos);
            return p;
        }
        int startPos = this.tokenSource.peek().getStart();
        Pointcut p = this.parseSinglePointcut();
        int endPos = this.tokenSource.peek(-1).getEnd();
        p.setLocation(this.sourceContext, startPos, endPos);
        return p;
    }

    public Pointcut parseSinglePointcut() {
        int start = this.tokenSource.getIndex();
        IToken t = this.tokenSource.peek();
        Pointcut p = t.maybeGetParsedPointcut();
        if (p != null) {
            this.tokenSource.next();
            return p;
        }
        String kind = this.parseIdentifier();
        this.tokenSource.setIndex(start);
        if (kind.equals("execution") || kind.equals("call") || kind.equals("get") || kind.equals("set")) {
            return this.parseKindedPointcut();
        }
        if (kind.equals("args")) {
            return this.parseArgsPointcut();
        }
        if (kind.equals("this") || kind.equals("target")) {
            return this.parseThisOrTargetPointcut();
        }
        if (kind.equals("within")) {
            return this.parseWithinPointcut();
        }
        if (kind.equals("withincode")) {
            return this.parseWithinCodePointcut();
        }
        if (kind.equals("cflow")) {
            return this.parseCflowPointcut(false);
        }
        if (kind.equals("cflowbelow")) {
            return this.parseCflowPointcut(true);
        }
        if (kind.equals("adviceexecution")) {
            this.parseIdentifier();
            this.eat("(");
            this.eat(")");
            return new KindedPointcut(Shadow.AdviceExecution, new SignaturePattern(Member.ADVICE, ModifiersPattern.ANY, TypePattern.ANY, TypePattern.ANY, NamePattern.ANY, TypePatternList.ANY, ThrowsPattern.ANY, AnnotationTypePattern.ANY));
        }
        if (kind.equals("handler")) {
            this.parseIdentifier();
            this.eat("(");
            TypePattern typePat = this.parseTypePattern();
            this.eat(")");
            return new HandlerPointcut(typePat);
        }
        if (kind.equals("initialization")) {
            this.parseIdentifier();
            this.eat("(");
            SignaturePattern sig = this.parseConstructorSignaturePattern();
            this.eat(")");
            return new KindedPointcut(Shadow.Initialization, sig);
        }
        if (kind.equals("staticinitialization")) {
            this.parseIdentifier();
            this.eat("(");
            TypePattern typePat = this.parseTypePattern();
            this.eat(")");
            return new KindedPointcut(Shadow.StaticInitialization, new SignaturePattern(Member.STATIC_INITIALIZATION, ModifiersPattern.ANY, TypePattern.ANY, typePat, NamePattern.ANY, TypePatternList.EMPTY, ThrowsPattern.ANY, AnnotationTypePattern.ANY));
        }
        if (kind.equals("preinitialization")) {
            this.parseIdentifier();
            this.eat("(");
            SignaturePattern sig = this.parseConstructorSignaturePattern();
            this.eat(")");
            return new KindedPointcut(Shadow.PreInitialization, sig);
        }
        return this.parseReferencePointcut();
    }

    public Pointcut parseAnnotationPointcut() {
        int start = this.tokenSource.getIndex();
        IToken t = this.tokenSource.peek();
        String kind = this.parseIdentifier();
        this.tokenSource.setIndex(start);
        if (kind.equals("annotation")) {
            return this.parseAtAnnotationPointcut();
        }
        if (kind.equals("args")) {
            return this.parseArgsAnnotationPointcut();
        }
        if (kind.equals("this") || kind.equals("target")) {
            return this.parseThisOrTargetAnnotationPointcut();
        }
        if (kind.equals("within")) {
            return this.parseWithinAnnotationPointcut();
        }
        if (kind.equals("withincode")) {
            return this.parseWithinCodeAnnotationPointcut();
        }
        throw new ParserException("@pointcut name expected, but found " + kind, t);
    }

    private Pointcut parseAtAnnotationPointcut() {
        this.parseIdentifier();
        this.eat("(");
        if (this.maybeEat(")")) {
            throw new ParserException("@AnnotationName or parameter", this.tokenSource.peek());
        }
        ExactAnnotationTypePattern type = this.parseAnnotationNameOrVarTypePattern();
        this.eat(")");
        return new AnnotationPointcut(type);
    }

    private SignaturePattern parseConstructorSignaturePattern() {
        SignaturePattern ret = this.parseMethodOrConstructorSignaturePattern();
        if (ret.getKind() == Member.CONSTRUCTOR) {
            return ret;
        }
        throw new ParserException("constructor pattern required, found method pattern", ret);
    }

    private Pointcut parseWithinCodePointcut() {
        this.parseIdentifier();
        this.eat("(");
        SignaturePattern sig = this.parseMethodOrConstructorSignaturePattern();
        this.eat(")");
        return new WithincodePointcut(sig);
    }

    private Pointcut parseCflowPointcut(boolean isBelow) {
        this.parseIdentifier();
        this.eat("(");
        Pointcut entry = this.parsePointcut();
        this.eat(")");
        return new CflowPointcut(entry, isBelow, null);
    }

    private Pointcut parseWithinPointcut() {
        this.parseIdentifier();
        this.eat("(");
        TypePattern type = this.parseTypePattern();
        this.eat(")");
        return new WithinPointcut(type);
    }

    private Pointcut parseThisOrTargetPointcut() {
        String kind = this.parseIdentifier();
        this.eat("(");
        TypePattern type = this.parseTypePattern();
        this.eat(")");
        return new ThisOrTargetPointcut(kind.equals("this"), type);
    }

    private Pointcut parseThisOrTargetAnnotationPointcut() {
        String kind = this.parseIdentifier();
        this.eat("(");
        if (this.maybeEat(")")) {
            throw new ParserException("expecting @AnnotationName or parameter, but found ')'", this.tokenSource.peek());
        }
        ExactAnnotationTypePattern type = this.parseAnnotationNameOrVarTypePattern();
        this.eat(")");
        return new ThisOrTargetAnnotationPointcut(kind.equals("this"), type);
    }

    private Pointcut parseWithinAnnotationPointcut() {
        String kind = this.parseIdentifier();
        this.eat("(");
        if (this.maybeEat(")")) {
            throw new ParserException("expecting @AnnotationName or parameter, but found ')'", this.tokenSource.peek());
        }
        ExactAnnotationTypePattern type = this.parseAnnotationNameOrVarTypePattern();
        this.eat(")");
        return new WithinAnnotationPointcut(type);
    }

    private Pointcut parseWithinCodeAnnotationPointcut() {
        String kind = this.parseIdentifier();
        this.eat("(");
        if (this.maybeEat(")")) {
            throw new ParserException("expecting @AnnotationName or parameter, but found ')'", this.tokenSource.peek());
        }
        ExactAnnotationTypePattern type = this.parseAnnotationNameOrVarTypePattern();
        this.eat(")");
        return new WithinCodeAnnotationPointcut(type);
    }

    private Pointcut parseArgsPointcut() {
        this.parseIdentifier();
        TypePatternList arguments = this.parseArgumentsPattern();
        return new ArgsPointcut(arguments);
    }

    private Pointcut parseArgsAnnotationPointcut() {
        this.parseIdentifier();
        AnnotationPatternList arguments = this.parseArgumentsAnnotationPattern();
        return new ArgsAnnotationPointcut(arguments);
    }

    private Pointcut parseReferencePointcut() {
        TypePattern onType = this.parseTypePattern();
        NamePattern name = this.tryToExtractName(onType);
        if (name == null) {
            throw new ParserException("name pattern", this.tokenSource.peek());
        }
        if (onType.toString().equals("")) {
            onType = null;
        }
        TypePatternList arguments = this.parseArgumentsPattern();
        return new ReferencePointcut(onType, name.maybeGetSimpleName(), arguments);
    }

    public List parseDottedIdentifier() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(this.parseIdentifier());
        while (this.maybeEat(".")) {
            ret.add(this.parseIdentifier());
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private KindedPointcut parseKindedPointcut() {
        void var2_3;
        SignaturePattern sig;
        String kind = this.parseIdentifier();
        this.eat("(");
        Shadow.Kind shadowKind = null;
        if (kind.equals("execution")) {
            sig = this.parseMethodOrConstructorSignaturePattern();
            if (sig.getKind() == Member.METHOD) {
                shadowKind = Shadow.MethodExecution;
            } else if (sig.getKind() == Member.CONSTRUCTOR) {
                shadowKind = Shadow.ConstructorExecution;
            }
        } else if (kind.equals("call")) {
            sig = this.parseMethodOrConstructorSignaturePattern();
            if (sig.getKind() == Member.METHOD) {
                shadowKind = Shadow.MethodCall;
            } else if (sig.getKind() == Member.CONSTRUCTOR) {
                shadowKind = Shadow.ConstructorCall;
            }
        } else if (kind.equals("get")) {
            sig = this.parseFieldSignaturePattern();
            shadowKind = Shadow.FieldGet;
        } else if (kind.equals("set")) {
            sig = this.parseFieldSignaturePattern();
            shadowKind = Shadow.FieldSet;
        } else {
            throw new ParserException("bad kind: " + kind, this.tokenSource.peek());
        }
        this.eat(")");
        return new KindedPointcut(shadowKind, (SignaturePattern)var2_3);
    }

    public TypePattern parseTypePattern() {
        TypePattern p = this.parseAtomicTypePattern();
        if (this.maybeEat("&&")) {
            p = new AndTypePattern(p, this.parseNotOrTypePattern());
        }
        if (this.maybeEat("||")) {
            p = new OrTypePattern(p, this.parseTypePattern());
        }
        return p;
    }

    private TypePattern parseNotOrTypePattern() {
        TypePattern p = this.parseAtomicTypePattern();
        if (this.maybeEat("&&")) {
            p = new AndTypePattern(p, this.parseTypePattern());
        }
        return p;
    }

    private TypePattern parseAtomicTypePattern() {
        AnnotationTypePattern ap = this.maybeParseAnnotationPattern();
        if (this.maybeEat("!")) {
            TypePattern p = new NotTypePattern(this.parseAtomicTypePattern());
            p = this.setAnnotationPatternForTypePattern(p, ap);
            return p;
        }
        if (this.maybeEat("(")) {
            TypePattern p = this.parseTypePattern();
            p = this.setAnnotationPatternForTypePattern(p, ap);
            this.eat(")");
            return p;
        }
        int startPos = this.tokenSource.peek().getStart();
        TypePattern p = this.parseSingleTypePattern();
        int endPos = this.tokenSource.peek(-1).getEnd();
        p = this.setAnnotationPatternForTypePattern(p, ap);
        p.setLocation(this.sourceContext, startPos, endPos);
        return p;
    }

    private TypePattern setAnnotationPatternForTypePattern(TypePattern t, AnnotationTypePattern ap) {
        TypePattern ret = t;
        if (ap != AnnotationTypePattern.ANY) {
            if (t == TypePattern.ANY) {
                ret = new WildTypePattern(new NamePattern[]{NamePattern.ANY}, false, 0, false);
            }
            if (t.annotationPattern == AnnotationTypePattern.ANY) {
                ret.setAnnotationTypePattern(ap);
            } else {
                ret.setAnnotationTypePattern(new AndAnnotationTypePattern(ap, t.annotationPattern));
            }
        }
        return ret;
    }

    public AnnotationTypePattern maybeParseAnnotationPattern() {
        AnnotationTypePattern ret = AnnotationTypePattern.ANY;
        AnnotationTypePattern nextPattern = null;
        while ((nextPattern = this.maybeParseSingleAnnotationPattern()) != null) {
            if (ret == AnnotationTypePattern.ANY) {
                ret = nextPattern;
                continue;
            }
            ret = new AndAnnotationTypePattern(ret, nextPattern);
        }
        return ret;
    }

    public AnnotationTypePattern maybeParseSingleAnnotationPattern() {
        AnnotationTypePattern ret = null;
        int startIndex = this.tokenSource.getIndex();
        if (this.maybeEat("!")) {
            if (this.maybeEat("@")) {
                if (this.maybeEat("(")) {
                    TypePattern p = this.parseTypePattern();
                    ret = new NotAnnotationTypePattern(new WildAnnotationTypePattern(p));
                    this.eat(")");
                    return ret;
                }
                TypePattern p = this.parseSingleTypePattern();
                ret = new NotAnnotationTypePattern(new WildAnnotationTypePattern(p));
                return ret;
            }
            this.tokenSource.setIndex(startIndex);
            return ret;
        }
        if (this.maybeEat("@")) {
            if (this.maybeEat("(")) {
                TypePattern p = this.parseTypePattern();
                ret = new WildAnnotationTypePattern(p);
                this.eat(")");
                return ret;
            }
            TypePattern p = this.parseSingleTypePattern();
            ret = new WildAnnotationTypePattern(p);
            return ret;
        }
        this.tokenSource.setIndex(startIndex);
        return ret;
    }

    public TypePattern parseSingleTypePattern() {
        List names = this.parseDottedNamePattern();
        int dim = 0;
        while (this.maybeEat("[")) {
            this.eat("]");
            ++dim;
        }
        boolean isVarArgs = this.maybeEat("...");
        boolean includeSubtypes = this.maybeEat("+");
        int endPos = this.tokenSource.peek(-1).getEnd();
        if (names.size() == 1 && ((NamePattern)names.get(0)).isAny() && dim == 0) {
            return TypePattern.ANY;
        }
        return new WildTypePattern(names, includeSubtypes, dim + (isVarArgs ? 1 : 0), endPos, isVarArgs);
    }

    protected ExactAnnotationTypePattern parseAnnotationNameOrVarTypePattern() {
        ExactAnnotationTypePattern p = null;
        int startPos = this.tokenSource.peek().getStart();
        if (this.maybeEat("@")) {
            p = this.parseSimpleAnnotationName();
        } else {
            String formal = this.parseIdentifier();
            p = new ExactAnnotationTypePattern(formal);
        }
        int endPos = this.tokenSource.peek(-1).getEnd();
        p.setLocation(this.sourceContext, startPos, endPos);
        return p;
    }

    private ExactAnnotationTypePattern parseSimpleAnnotationName() {
        StringBuffer annotationName = new StringBuffer();
        annotationName.append(this.parseIdentifier());
        while (this.maybeEat(".")) {
            annotationName.append('.');
            annotationName.append(this.parseIdentifier());
        }
        TypeX type = TypeX.forName(annotationName.toString());
        ExactAnnotationTypePattern p = new ExactAnnotationTypePattern(type);
        return p;
    }

    private boolean isAnnotationPattern(PatternNode p) {
        return p instanceof AnnotationTypePattern;
    }

    public List parseDottedNamePattern() {
        ArrayList<NamePattern> names = new ArrayList<NamePattern>();
        StringBuffer buf = new StringBuffer();
        IToken previous = null;
        boolean justProcessedEllipsis = false;
        boolean justProcessedDot = false;
        boolean onADot = false;
        while (true) {
            IToken tok = null;
            int startPos = this.tokenSource.peek().getStart();
            String afterDot = null;
            while (true) {
                if (previous != null && previous.getString().equals(".")) {
                    justProcessedDot = true;
                }
                tok = this.tokenSource.peek();
                onADot = tok.getString().equals(".");
                if (previous != null && !this.isAdjacent(previous, tok)) break;
                if (tok.getString() == "*" || tok.isIdentifier()) {
                    buf.append(tok.getString());
                } else {
                    if (tok.getLiteralKind() == null) break;
                    String s = tok.getString();
                    int dot = s.indexOf(46);
                    if (dot != -1) {
                        buf.append(s.substring(0, dot));
                        afterDot = s.substring(dot + 1);
                        previous = this.tokenSource.next();
                        break;
                    }
                    buf.append(s);
                }
                previous = this.tokenSource.next();
            }
            int endPos = this.tokenSource.peek(-1).getEnd();
            if (buf.length() == 0 && names.isEmpty()) {
                throw new ParserException("name pattern", tok);
            }
            if (buf.length() == 0 && justProcessedEllipsis) {
                throw new ParserException("name pattern cannot finish with ..", tok);
            }
            if (buf.length() == 0 && justProcessedDot && !onADot) {
                throw new ParserException("name pattern cannot finish with .", tok);
            }
            if (buf.length() == 0) {
                names.add(NamePattern.ELLIPSIS);
                justProcessedEllipsis = true;
            } else {
                this.checkLegalName(buf.toString(), previous);
                NamePattern ret = new NamePattern(buf.toString());
                ret.setLocation(this.sourceContext, startPos, endPos);
                names.add(ret);
                justProcessedEllipsis = false;
            }
            if (afterDot == null) {
                buf.setLength(0);
                if (!this.maybeEat(".")) break;
                previous = this.tokenSource.peek(-1);
                continue;
            }
            buf.setLength(0);
            buf.append(afterDot);
            afterDot = null;
        }
        return names;
    }

    public NamePattern parseNamePattern() {
        IToken tok;
        StringBuffer buf = new StringBuffer();
        IToken previous = null;
        int startPos = this.tokenSource.peek().getStart();
        while (true) {
            tok = this.tokenSource.peek();
            if (previous != null && !this.isAdjacent(previous, tok)) break;
            if (tok.getString() == "*" || tok.isIdentifier()) {
                buf.append(tok.getString());
            } else {
                String s;
                if (tok.getLiteralKind() == null || (s = tok.getString()).indexOf(46) != -1) break;
                buf.append(s);
            }
            previous = this.tokenSource.next();
        }
        int endPos = this.tokenSource.peek(-1).getEnd();
        if (buf.length() == 0) {
            throw new ParserException("name pattern", tok);
        }
        this.checkLegalName(buf.toString(), previous);
        NamePattern ret = new NamePattern(buf.toString());
        ret.setLocation(this.sourceContext, startPos, endPos);
        return ret;
    }

    private void checkLegalName(String s, IToken tok) {
        char ch = s.charAt(0);
        if (ch != '*' && !Character.isJavaIdentifierStart(ch)) {
            throw new ParserException("illegal identifier start (" + ch + ")", tok);
        }
        int len = s.length();
        for (int i = 1; i < len; ++i) {
            ch = s.charAt(i);
            if (ch == '*' || Character.isJavaIdentifierPart(ch)) continue;
            throw new ParserException("illegal identifier character (" + ch + ")", tok);
        }
    }

    private boolean isAdjacent(IToken first, IToken second) {
        return first.getEnd() == second.getStart() - 1;
    }

    public ModifiersPattern parseModifiersPattern() {
        int start;
        int requiredFlags = 0;
        int forbiddenFlags = 0;
        while (true) {
            start = this.tokenSource.getIndex();
            boolean isForbidden = false;
            isForbidden = this.maybeEat("!");
            IToken t = this.tokenSource.next();
            int flag = ModifiersPattern.getModifierFlag(t.getString());
            if (flag == -1) break;
            if (isForbidden) {
                forbiddenFlags |= flag;
                continue;
            }
            requiredFlags |= flag;
        }
        this.tokenSource.setIndex(start);
        if (requiredFlags == 0 && forbiddenFlags == 0) {
            return ModifiersPattern.ANY;
        }
        return new ModifiersPattern(requiredFlags, forbiddenFlags);
    }

    public TypePatternList parseArgumentsPattern() {
        ArrayList<TypePattern> patterns = new ArrayList<TypePattern>();
        this.eat("(");
        if (this.maybeEat(")")) {
            return new TypePatternList();
        }
        do {
            if (this.maybeEat(".")) {
                this.eat(".");
                patterns.add(TypePattern.ELLIPSIS);
                continue;
            }
            patterns.add(this.parseTypePattern());
        } while (this.maybeEat(","));
        this.eat(")");
        return new TypePatternList(patterns);
    }

    public AnnotationPatternList parseArgumentsAnnotationPattern() {
        ArrayList<AnnotationTypePattern> patterns = new ArrayList<AnnotationTypePattern>();
        this.eat("(");
        if (this.maybeEat(")")) {
            return new AnnotationPatternList();
        }
        do {
            if (this.maybeEat(".")) {
                this.eat(".");
                patterns.add(AnnotationTypePattern.ELLIPSIS);
                continue;
            }
            if (this.maybeEat("*")) {
                patterns.add(AnnotationTypePattern.ANY);
                continue;
            }
            patterns.add(this.parseAnnotationNameOrVarTypePattern());
        } while (this.maybeEat(","));
        this.eat(")");
        return new AnnotationPatternList(patterns);
    }

    public ThrowsPattern parseOptionalThrowsPattern() {
        IToken t = this.tokenSource.peek();
        if (t.isIdentifier() && t.getString().equals("throws")) {
            this.tokenSource.next();
            ArrayList<TypePattern> required = new ArrayList<TypePattern>();
            ArrayList<TypePattern> forbidden = new ArrayList<TypePattern>();
            do {
                boolean isForbidden = this.maybeEat("!");
                TypePattern p = this.parseTypePattern();
                if (isForbidden) {
                    forbidden.add(p);
                    continue;
                }
                required.add(p);
            } while (this.maybeEat(","));
            return new ThrowsPattern(new TypePatternList(required), new TypePatternList(forbidden));
        }
        return ThrowsPattern.ANY;
    }

    public SignaturePattern parseMethodOrConstructorSignaturePattern() {
        TypePattern declaringType;
        Member.Kind kind;
        int startPos = this.tokenSource.peek().getStart();
        AnnotationTypePattern annotationPattern = this.maybeParseAnnotationPattern();
        ModifiersPattern modifiers = this.parseModifiersPattern();
        TypePattern returnType = this.parseTypePattern();
        NamePattern name = null;
        if (this.maybeEatNew(returnType)) {
            kind = Member.CONSTRUCTOR;
            declaringType = returnType.toString().length() == 0 ? TypePattern.ANY : returnType;
            returnType = TypePattern.ANY;
            name = NamePattern.ANY;
        } else {
            kind = Member.METHOD;
            declaringType = this.parseTypePattern();
            if (this.maybeEat(".")) {
                name = this.parseNamePattern();
            } else {
                name = this.tryToExtractName(declaringType);
                if (name == null) {
                    throw new ParserException("name pattern", this.tokenSource.peek());
                }
                String simpleName = name.maybeGetSimpleName();
                if (simpleName != null && simpleName.equals("new")) {
                    throw new ParserException("constructor patterns have no return type", this.tokenSource.peek());
                }
                if (declaringType.toString().equals("")) {
                    declaringType = TypePattern.ANY;
                }
            }
        }
        TypePatternList parameterTypes = this.parseArgumentsPattern();
        ThrowsPattern throwsPattern = this.parseOptionalThrowsPattern();
        SignaturePattern ret = new SignaturePattern(kind, modifiers, returnType, declaringType, name, parameterTypes, throwsPattern, annotationPattern);
        int endPos = this.tokenSource.peek(-1).getEnd();
        ret.setLocation(this.sourceContext, startPos, endPos);
        return ret;
    }

    private boolean maybeEatNew(TypePattern returnType) {
        WildTypePattern p;
        if (returnType instanceof WildTypePattern && (p = (WildTypePattern)returnType).maybeExtractName("new")) {
            return true;
        }
        int start = this.tokenSource.getIndex();
        if (this.maybeEat(".")) {
            String id = this.maybeEatIdentifier();
            if (id != null && id.equals("new")) {
                return true;
            }
            this.tokenSource.setIndex(start);
        }
        return false;
    }

    public SignaturePattern parseFieldSignaturePattern() {
        NamePattern name;
        int startPos = this.tokenSource.peek().getStart();
        AnnotationTypePattern annotationPattern = this.maybeParseAnnotationPattern();
        ModifiersPattern modifiers = this.parseModifiersPattern();
        TypePattern returnType = this.parseTypePattern();
        TypePattern declaringType = this.parseTypePattern();
        if (this.maybeEat(".")) {
            name = this.parseNamePattern();
        } else {
            name = this.tryToExtractName(declaringType);
            if (declaringType.toString().equals("")) {
                declaringType = TypePattern.ANY;
            }
        }
        SignaturePattern ret = new SignaturePattern(Member.FIELD, modifiers, returnType, declaringType, name, TypePatternList.ANY, ThrowsPattern.ANY, annotationPattern);
        int endPos = this.tokenSource.peek(-1).getEnd();
        ret.setLocation(this.sourceContext, startPos, endPos);
        return ret;
    }

    private NamePattern tryToExtractName(TypePattern nextType) {
        if (nextType == TypePattern.ANY) {
            return NamePattern.ANY;
        }
        if (nextType instanceof WildTypePattern) {
            WildTypePattern p = (WildTypePattern)nextType;
            return p.extractName();
        }
        return null;
    }

    public String parsePossibleStringSequence(boolean shouldEnd) {
        StringBuffer result = new StringBuffer();
        IToken token = this.tokenSource.next();
        if (token.getLiteralKind() == null) {
            throw new ParserException("string", token);
        }
        while (token.getLiteralKind().equals("string")) {
            result.append(token.getString());
            boolean plus = this.maybeEat("+");
            if (!plus) break;
            token = this.tokenSource.next();
            if (token.getLiteralKind() != null) continue;
            throw new ParserException("string", token);
        }
        this.eatIdentifier(";");
        IToken t = this.tokenSource.next();
        if (shouldEnd && t != IToken.EOF) {
            throw new ParserException("<string>;", token);
        }
        return result.toString();
    }

    public String parseStringLiteral() {
        IToken token = this.tokenSource.next();
        String literalKind = token.getLiteralKind();
        if (literalKind == "string") {
            return token.getString();
        }
        throw new ParserException("string", token);
    }

    public String parseIdentifier() {
        IToken token = this.tokenSource.next();
        if (token.isIdentifier()) {
            return token.getString();
        }
        throw new ParserException("identifier", token);
    }

    public void eatIdentifier(String expectedValue) {
        IToken next = this.tokenSource.next();
        if (!next.getString().equals(expectedValue)) {
            throw new ParserException(expectedValue, next);
        }
    }

    public boolean maybeEatIdentifier(String expectedValue) {
        IToken next = this.tokenSource.peek();
        if (next.getString().equals(expectedValue)) {
            this.tokenSource.next();
            return true;
        }
        return false;
    }

    public void eat(String expectedValue) {
        IToken next = this.tokenSource.next();
        if (next.getString() != expectedValue) {
            throw new ParserException(expectedValue, next);
        }
    }

    public boolean maybeEat(String token) {
        IToken next = this.tokenSource.peek();
        if (next.getString() == token) {
            this.tokenSource.next();
            return true;
        }
        return false;
    }

    public String maybeEatIdentifier() {
        IToken next = this.tokenSource.peek();
        if (next.isIdentifier()) {
            this.tokenSource.next();
            return next.getString();
        }
        return null;
    }

    public boolean peek(String token) {
        IToken next = this.tokenSource.peek();
        return next.getString() == token;
    }

    public PatternParser(String data) {
        this(BasicTokenSource.makeTokenSource(data));
    }
}

