/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.ast.Var;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.BindingAnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExactAnnotationTypePattern;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.NameBindingPointcut;
import org.aspectj.weaver.patterns.Pointcut;

public class ThisOrTargetAnnotationPointcut
extends NameBindingPointcut {
    private boolean isThis;
    private boolean alreadyWarnedAboutDEoW = false;
    private ExactAnnotationTypePattern annotationTypePattern;
    private ShadowMunger munger;

    public ThisOrTargetAnnotationPointcut(boolean isThis, ExactAnnotationTypePattern type) {
        this.isThis = isThis;
        this.annotationTypePattern = type;
    }

    public ThisOrTargetAnnotationPointcut(boolean isThis, ExactAnnotationTypePattern type, ShadowMunger munger) {
        this(isThis, type);
        this.munger = munger;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo info) {
        return FuzzyBoolean.MAYBE;
    }

    public FuzzyBoolean match(Shadow shadow) {
        if (!this.couldMatch(shadow)) {
            return FuzzyBoolean.NO;
        }
        ResolvedTypeX toMatchAgainst = (this.isThis ? shadow.getThisType() : shadow.getTargetType()).resolve(shadow.getIWorld());
        this.annotationTypePattern.resolve(shadow.getIWorld());
        if (this.annotationTypePattern.matches(toMatchAgainst).alwaysTrue()) {
            return FuzzyBoolean.YES;
        }
        return FuzzyBoolean.MAYBE;
    }

    public boolean isThis() {
        return this.isThis;
    }

    protected void resolveBindings(IScope scope, Bindings bindings) {
        this.annotationTypePattern = (ExactAnnotationTypePattern)this.annotationTypePattern.resolveBindings(scope, bindings, true);
        if (this.annotationTypePattern.annotationType == null) {
            return;
        }
        ResolvedTypeX rAnnotationType = (ResolvedTypeX)this.annotationTypePattern.annotationType;
        if (!rAnnotationType.isAnnotationWithRuntimeRetention()) {
            IMessage m = MessageUtil.error(WeaverMessages.format("bindingNonRuntimeRetentionAnnotation", rAnnotationType.getName()), this.getSourceLocation());
            scope.getMessageHandler().handleMessage(m);
        }
    }

    protected void resolveBindingsFromRTTI() {
    }

    protected Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        if (this.isDeclare(bindings.getEnclosingAdvice())) {
            if (!this.alreadyWarnedAboutDEoW) {
                inAspect.getWorld().showMessage(IMessage.ERROR, WeaverMessages.format("thisOrTargetInDeclare", this.isThis ? "this" : "target"), bindings.getEnclosingAdvice().getSourceLocation(), null);
                this.alreadyWarnedAboutDEoW = true;
            }
            return Pointcut.makeMatchesNothing(Pointcut.CONCRETE);
        }
        ExactAnnotationTypePattern newType = (ExactAnnotationTypePattern)this.annotationTypePattern.remapAdviceFormals(bindings);
        ThisOrTargetAnnotationPointcut ret = new ThisOrTargetAnnotationPointcut(this.isThis, newType, bindings.getEnclosingAdvice());
        ret.alreadyWarnedAboutDEoW = this.alreadyWarnedAboutDEoW;
        ret.copyLocationFrom(this);
        return ret;
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        if (!this.couldMatch(shadow)) {
            return Literal.FALSE;
        }
        boolean alwaysMatches = this.match(shadow).alwaysTrue();
        Var var = this.isThis ? shadow.getThisVar() : shadow.getTargetVar();
        Var annVar = null;
        TypeX annotationType = this.annotationTypePattern.annotationType;
        if (this.annotationTypePattern instanceof BindingAnnotationTypePattern) {
            BindingAnnotationTypePattern btp = (BindingAnnotationTypePattern)this.annotationTypePattern;
            annotationType = btp.annotationType;
            Var var2 = annVar = this.isThis ? shadow.getThisAnnotationVar(annotationType) : shadow.getTargetAnnotationVar(annotationType);
            if (annVar == null) {
                return Literal.TRUE;
            }
            if (state.get(btp.getFormalIndex()) != null) {
                ISourceLocation pcdSloc = this.getSourceLocation();
                ISourceLocation shadowSloc = shadow.getSourceLocation();
                Message errorMessage = new Message("Cannot use @pointcut to match at this location and bind a formal to type '" + annVar.getType() + "' - the formal is already bound to type '" + state.get(btp.getFormalIndex()).getType() + "'" + ".  The secondary source location points to the problematic binding.", shadowSloc, true, new ISourceLocation[]{pcdSloc});
                shadow.getIWorld().getMessageHandler().handleMessage(errorMessage);
                state.setErroneousVar(btp.getFormalIndex());
            }
            state.set(btp.getFormalIndex(), annVar);
        }
        if (alwaysMatches && annVar == null) {
            return Literal.TRUE;
        }
        if (annVar != null) {
            return Literal.FALSE;
        }
        ResolvedTypeX rType = annotationType.resolve(shadow.getIWorld());
        return Test.makeHasAnnotation(var, rType);
    }

    private boolean couldMatch(Shadow shadow) {
        return this.isThis ? shadow.hasThis() : shadow.hasTarget();
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(19);
        s.writeBoolean(this.isThis);
        this.annotationTypePattern.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        boolean isThis = s.readBoolean();
        AnnotationTypePattern type = AnnotationTypePattern.read(s, context);
        ThisOrTargetAnnotationPointcut ret = new ThisOrTargetAnnotationPointcut(isThis, (ExactAnnotationTypePattern)type);
        ret.readLocation(context, s);
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ThisOrTargetAnnotationPointcut)) {
            return false;
        }
        ThisOrTargetAnnotationPointcut other = (ThisOrTargetAnnotationPointcut)obj;
        return other.annotationTypePattern.equals(this.annotationTypePattern) && other.isThis == this.isThis;
    }

    public int hashCode() {
        return 17 + 37 * this.annotationTypePattern.hashCode() + (this.isThis ? 49 : 13);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.isThis ? "@this(" : "@target(");
        buf.append(this.annotationTypePattern.toString());
        buf.append(")");
        return buf.toString();
    }
}

