/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;

public class ThrowsPattern
extends PatternNode {
    private TypePatternList required;
    private TypePatternList forbidden;
    public static final ThrowsPattern ANY = new ThrowsPattern(TypePatternList.EMPTY, TypePatternList.EMPTY);

    public ThrowsPattern(TypePatternList required, TypePatternList forbidden) {
        this.required = required;
        this.forbidden = forbidden;
    }

    public String toString() {
        if (this == ANY) {
            return "";
        }
        String ret = "throws " + this.required.toString();
        if (this.forbidden.size() > 0) {
            ret = ret + " !(" + this.forbidden.toString() + ")";
        }
        return ret;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ThrowsPattern)) {
            return false;
        }
        ThrowsPattern o = (ThrowsPattern)other;
        return o.required.equals(this.required) && o.forbidden.equals(this.forbidden);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.required.hashCode();
        result = 37 * result + this.forbidden.hashCode();
        return result;
    }

    public ThrowsPattern resolveBindings(IScope scope, Bindings bindings) {
        if (this == ANY) {
            return this;
        }
        this.required = this.required.resolveBindings(scope, bindings, false, false);
        this.forbidden = this.forbidden.resolveBindings(scope, bindings, false, false);
        return this;
    }

    public ThrowsPattern resolveBindingsFromRTTI() {
        this.required = this.required.resolveBindingsFromRTTI(false, false);
        this.forbidden = this.forbidden.resolveBindingsFromRTTI(false, false);
        return this;
    }

    public boolean matches(TypeX[] tys, World world) {
        int j;
        if (this == ANY) {
            return true;
        }
        ResolvedTypeX[] types = world.resolve(tys);
        int lenj = this.required.size();
        for (j = 0; j < lenj; ++j) {
            if (this.matchesAny(this.required.get(j), types)) continue;
            return false;
        }
        lenj = this.forbidden.size();
        for (j = 0; j < lenj; ++j) {
            if (!this.matchesAny(this.forbidden.get(j), types)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(Class[] onTypes) {
        int j;
        if (this == ANY) {
            return true;
        }
        int lenj = this.required.size();
        for (j = 0; j < lenj; ++j) {
            if (this.matchesAny(this.required.get(j), onTypes)) continue;
            return false;
        }
        lenj = this.forbidden.size();
        for (j = 0; j < lenj; ++j) {
            if (!this.matchesAny(this.forbidden.get(j), onTypes)) continue;
            return false;
        }
        return true;
    }

    private boolean matchesAny(TypePattern typePattern, ResolvedTypeX[] types) {
        for (int i = types.length - 1; i >= 0; --i) {
            if (!typePattern.matchesStatically(types[i])) continue;
            return true;
        }
        return false;
    }

    private boolean matchesAny(TypePattern typePattern, Class[] types) {
        for (int i = types.length - 1; i >= 0; --i) {
            if (!typePattern.matchesStatically(types[i])) continue;
            return true;
        }
        return false;
    }

    public static ThrowsPattern read(DataInputStream s, ISourceContext context) throws IOException {
        TypePatternList required = TypePatternList.read(s, context);
        TypePatternList forbidden = TypePatternList.read(s, context);
        if (required.size() == 0 && forbidden.size() == 0) {
            return ANY;
        }
        ThrowsPattern ret = new ThrowsPattern(required, forbidden);
        return ret;
    }

    public void write(DataOutputStream s) throws IOException {
        this.required.write(s);
        this.forbidden.write(s);
    }
}

