/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExactAnnotationTypePattern;
import org.aspectj.weaver.patterns.ExactTypePattern;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.TypePattern;

public class WildAnnotationTypePattern
extends AnnotationTypePattern {
    private TypePattern typePattern;
    private boolean resolved = false;
    private static final byte VERSION = 1;

    public WildAnnotationTypePattern(TypePattern typePattern) {
        this.typePattern = typePattern;
    }

    public FuzzyBoolean matches(AnnotatedElement annotated) {
        if (!this.resolved) {
            throw new IllegalStateException("Can't match on an unresolved annotation type pattern");
        }
        ResolvedTypeX[] annTypes = annotated.getAnnotationTypes();
        for (int i = 0; i < annTypes.length; ++i) {
            if (!this.typePattern.matches(annTypes[i], TypePattern.STATIC).alwaysTrue()) continue;
            return FuzzyBoolean.YES;
        }
        return FuzzyBoolean.NO;
    }

    public void resolve(World world) {
    }

    public AnnotationTypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding) {
        this.typePattern = this.typePattern.resolveBindings(scope, bindings, false, false);
        this.resolved = true;
        if (this.typePattern instanceof ExactTypePattern) {
            ExactTypePattern et = (ExactTypePattern)this.typePattern;
            if (!et.getExactType().isAnnotation(scope.getWorld())) {
                IMessage m = MessageUtil.error(WeaverMessages.format("referenceToNonAnnotationType", et.getExactType().getName()), this.getSourceLocation());
                scope.getWorld().getMessageHandler().handleMessage(m);
                this.resolved = false;
            }
            return new ExactAnnotationTypePattern(et.getExactType().resolve(scope.getWorld()));
        }
        return this;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(8);
        s.writeByte(1);
        this.typePattern.write(s);
        this.writeLocation(s);
    }

    public static AnnotationTypePattern read(DataInputStream s, ISourceContext context) throws IOException {
        byte version = s.readByte();
        if (version > 1) {
            throw new BCException("ExactAnnotationTypePattern was written by a newer version of AspectJ");
        }
        TypePattern t = TypePattern.read(s, context);
        WildAnnotationTypePattern ret = new WildAnnotationTypePattern(t);
        ret.readLocation(context, s);
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WildAnnotationTypePattern)) {
            return false;
        }
        WildAnnotationTypePattern other = (WildAnnotationTypePattern)obj;
        return other.typePattern.equals(this.typePattern);
    }

    public int hashCode() {
        return 17 + 37 * this.typePattern.hashCode();
    }

    public String toString() {
        return "@(" + this.typePattern.toString() + ")";
    }
}

