/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.ast.Literal;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.ast.Var;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.BindingAnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExactAnnotationTypePattern;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.NameBindingPointcut;
import org.aspectj.weaver.patterns.Pointcut;

public class WithinAnnotationPointcut
extends NameBindingPointcut {
    private AnnotationTypePattern annotationTypePattern;
    private ShadowMunger munger;

    public WithinAnnotationPointcut(AnnotationTypePattern type) {
        this.annotationTypePattern = type;
    }

    public WithinAnnotationPointcut(AnnotationTypePattern type, ShadowMunger munger) {
        this(type);
        this.munger = munger;
    }

    public FuzzyBoolean fastMatch(FastMatchInfo info) {
        return this.annotationTypePattern.fastMatches(info.getType());
    }

    public FuzzyBoolean match(Shadow shadow) {
        ResolvedTypeX enclosingType = shadow.getIWorld().resolve(shadow.getEnclosingType(), true);
        if (enclosingType == ResolvedTypeX.MISSING) {
            Message msg = new Message(WeaverMessages.format("cantFindTypeWithinpcd", shadow.getEnclosingType().getName()), shadow.getSourceLocation(), true, new ISourceLocation[]{this.getSourceLocation()});
            shadow.getIWorld().getMessageHandler().handleMessage(msg);
        }
        this.annotationTypePattern.resolve(shadow.getIWorld());
        return this.annotationTypePattern.matches(enclosingType);
    }

    protected void resolveBindings(IScope scope, Bindings bindings) {
        this.annotationTypePattern = (ExactAnnotationTypePattern)this.annotationTypePattern.resolveBindings(scope, bindings, true);
    }

    protected void resolveBindingsFromRTTI() {
    }

    protected Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        ExactAnnotationTypePattern newType = (ExactAnnotationTypePattern)this.annotationTypePattern.remapAdviceFormals(bindings);
        WithinAnnotationPointcut ret = new WithinAnnotationPointcut(newType, bindings.getEnclosingAdvice());
        ret.copyLocationFrom(this);
        return ret;
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        if (this.annotationTypePattern instanceof BindingAnnotationTypePattern) {
            BindingAnnotationTypePattern btp = (BindingAnnotationTypePattern)this.annotationTypePattern;
            TypeX annotationType = btp.annotationType;
            Var var = shadow.getWithinAnnotationVar(annotationType);
            if (var == null) {
                return Literal.FALSE;
            }
            if (state.get(btp.getFormalIndex()) != null) {
                ISourceLocation pcdSloc = this.getSourceLocation();
                ISourceLocation shadowSloc = shadow.getSourceLocation();
                Message errorMessage = new Message("Cannot use @pointcut to match at this location and bind a formal to type '" + var.getType() + "' - the formal is already bound to type '" + state.get(btp.getFormalIndex()).getType() + "'" + ".  The secondary source location points to the problematic binding.", shadowSloc, true, new ISourceLocation[]{pcdSloc});
                shadow.getIWorld().getMessageHandler().handleMessage(errorMessage);
                state.setErroneousVar(btp.getFormalIndex());
            }
            state.set(btp.getFormalIndex(), var);
        }
        return Literal.TRUE;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(17);
        this.annotationTypePattern.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        AnnotationTypePattern type = AnnotationTypePattern.read(s, context);
        WithinAnnotationPointcut ret = new WithinAnnotationPointcut((ExactAnnotationTypePattern)type);
        ret.readLocation(context, s);
        return ret;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WithinAnnotationPointcut)) {
            return false;
        }
        WithinAnnotationPointcut other = (WithinAnnotationPointcut)obj;
        return other.annotationTypePattern.equals(this.annotationTypePattern);
    }

    public int hashCode() {
        return 17 + 19 * this.annotationTypePattern.hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("@within(");
        buf.append(this.annotationTypePattern.toString());
        buf.append(")");
        return buf.toString();
    }
}

